<?php
	// All script inside these brackets (less than question mark and question mark greater than) is PHP script
	// all other script is VXML
    // ini_set("url_rewriter.tags", "");
    // session_start();
    // error_reporting(0);
    print "<?xml version=\"1.0\" ?>\n";
?>
<!DOCTYPE vxml PUBLIC "SpeechBrowser/2.0/DTD" "ignore" >
<vxml version="2.0">

<?php

// ************************************************
// This file is a template for normal Callback When Free
// it allows a caller to set a callback when the target becomes free
// when the target becomes free then the schedule call is brought forward
// to now and then transfers the original caller back to the target when answered
// THERE IS NO GURANTEE THAT THE USER WILL STILL BE FREE by the time the original caller has picked up the phone
// ALSO this can be used from remote mobile phones, and external callers!
// Press 1 when leaving a voicemail
// or an example Dial Plan Entry would be DialHash !EA:http://127.0.0.1/callbackwf_vxml.php?s=%s&t=%r
// ************************************************

	// ************************************************
	// Change the following to match your CONFIGURATION
	$filename   = "callbackwf_vxml.php";
	$vmportname = "BuiltIn";
	$vmportlocation = "";
	
	// The following can be used if hosted on the actual call server if not proper authentication is required
    $server = "127.0.0.1"; 
    $user_login = "INTERNAL";
    $user_password = "123456";
    
    $failedtelephonenumber="";
    $retrymax = "5";
    $retryinterval = "30";

    $quick = true;
    
	// ************************************************


	// Now pickup the standard always present parameters (source number and command)
	
	if ($_SERVER['SERVER_PORT'])				// We are running from a web server
	{
    	$cmd = $_REQUEST['cmd'];
	    $num = $_REQUEST['s'];
	    $target = $_REQUEST['t'];
	    $orignum = $_REQUEST['o'];
	}
	else										
	{
		$cmd = $argv[1];
		$num = $argv[2];
		$target = $argv[3];
	    $orignum = $argv[4];
		print "cmd=$cmd num=$num target=$target orignum=$orignum\n";
    }
    $organiser = $target.$filename.$num;

	// Now interpet the specific command
    if ($cmd == "")														// DEFAULT Command to Ask what to do - create or cancel 
    {
        // Lets lookup the name of the calling party    
        $ds = LdapConnect($server,$user_login,$user_password);
        $name = LdapGetName($ds,$num);
        $info = LdapGetTargetInfo($ds,$target);
        $vmport = LdapGetVmPort($ds,$vmportname,$vmportlocation);
        $sr=@ldap_search($ds, "guid=$vmport", "(&(objectclass=ScheduledCall)(notes={$info['guid'][0]})(organiser=$organiser))"); 
        if( $sr )
        {
            $o = ldap_get_entries($ds, $sr);
            if ($o['count'] != 0)
            {
                $cbguid = $o[0]['guid'][0];
            }
        }
        if( $quick )
        {
            if( $cbguid )
            {
?>
                <form id="failed">
                    <block>
                        <prompt>You already have a callback set</prompt>
                    </block>
                </form>
<?php
            }
            else if( $name )         // Found in our system
            {
                $orignum = $num;
                do_submit($ds,$vmport,$info,$target,$organiser,$num,$failedtelephonenumber,$retryinterval,$retrymax,$filename,$quick);
            }
            else
            {
?>
                <form id="failed">
                    <block>
                        <prompt>Im a sorry. The number you are calling from cannot be used to call back</prompt>
                    </block>
                </form>
<?php
            }
        }
        LdapClose($ds);
        
        if( !$quick )
        {
?>
            <menu id="menu">
            <property name="inputmodes" value="dtmf"/>
<?php
            if( $name )
            {
                print "<prompt>hello</prompt>\n";
                SpeakName($name,$num);
            }
            if( $cbguid )
            {
                print "<prompt>You have a call back already waiting for</prompt>\n";
                SpeakName($info['cn'][0],$target);
            }
            
            if( $num )
                print "<prompt>Press 1 to be called back on the number you are calling from.</prompt>\n";
            
            print "<prompt>Press 2 to enter the number to call back.</prompt>\n";
            
            if( $cbguid )
                print "<prompt>Press 3 to cancel the call back.</prompt>\n";
            
            if( $num )
                print "<choice dtmf=\"1\" next=\"$filename?cmd=submit&amp;s=$num&amp;t=$target&amp;o=$num\"/>\n";
            
            print "<choice dtmf=\"2\" next=\"$filename?cmd=getnum&amp;s=$num&amp;t=$target&amp;o=$num\"/>\n";
            
            if( $cbguid )
                print "<choice dtmf=\"3\" next=\"$filename?cmd=cancel&amp;s=$num&amp;t=$target&amp;o=$num\"/>\n";
?>
                </menu>
                
                <form id="mydisconnect">
                <block>
                <disconnect/>
                </block>
                </form>
<?php
        }
    }
    else if ($cmd == "getnum")											// getnum and wakeup call prompt in 24hr format
    {
?>
        <form id="setup">
            <catch event="telephone.disconnect.hangup">
                <exit/>
            </catch>
            
            <var name="cmd" expr="'submit'"/>
<?php
            print "<var name=\"t\" expr=\"'$target'\"/>\n";
            print "<var name=\"o\" expr=\"'$num'\"/>\n";
?>
            <field name="s" type="digits">
                <property name="timeout" value="10s"/>
                <property name="bargein" value="true"/>
                <prompt>Enter the number to call back, followed by the hash key</prompt>
                <filled>
<?php
  				print "<submit next=\"$filename\" enctype=\"multipart/form-data\" method=\"post\" namelist=\"cmd s t o\"/>\n";
?>
                </filled>
            </field>
        </form>
        
<?php
    }
    else if ($cmd == "submit")										// SUBMIT this form to the database after user enter correct format
    {
		$ds = LdapConnect($server,$user_login,$user_password);
        $vmport = LdapGetVmPort($ds,$vmportname,$vmportlocation);
        $info = LdapGetTargetInfo($ds,$target);
        do_submit($ds,$vmport,$info,$target,$organiser,$num,$failedtelephonenumber,$retryinterval,$retrymax,$filename,$quick);
        LdapClose($ds);
    }
    else if ($cmd == "cancel")												// CANCEL alarm call on this extension
    {
        // check for existing scheduled call
        // if found, delete it
		$ds = LdapConnect($server,$user_login,$user_password);
        if ($ds)
        {
			$name = LdapGetName($ds,$num);
            $info = LdapGetTargetInfo($ds,$target);
            $vmport = LdapGetVmPort($ds,$vmportname,$vmportlocation);
            $sr=@ldap_search($ds, "guid=$vmport", "(&(objectclass=ScheduledCall)(notes={$info['guid'][0]})(organiser=$organiser))"); 
            $o = @ldap_get_entries($ds, $sr);
            if ($o['count'] != 0)
            {
                $guid = $o[0]['guid'][0];
                ldap_delete($ds, "guid=$guid");
            }
            LdapClose($ds);
        }
?>
        <form id="cancel">
            <block>
                <prompt>call back cancelled for</prompt>
<?php
				SpeakName($name,$num);
?>
            </block>
        </form>
<?php
    }
    else if ($cmd == "callback")												// Callback has worked has gone off
    {
        if( $quick )
        {
            $ds=LdapConnect($server,$user_login,$user_password);
            $name = LdapGetName($ds,$target);
            $info = LdapGetTargetInfo($ds,$target);
            LdapClose($ds);
            ?>
            <form id="callback">
            <block>
                <prompt>Calling</prompt>
<?php
                SpeakName($info['cn'][0],$target);
?>
                </block>
<?php
                print "<transfer name=\"call\" dest=\"$target\">\n</transfer>\n";
?>
                </form>
<?php
        }
        else
        {
            $ds=LdapConnect($server,$user_login,$user_password);
            $name = LdapGetName($ds,$target);
            $info = LdapGetTargetInfo($ds,$target);
            LdapClose($ds);
?>
            <form id="callback">
                <block>
                    <prompt>You requested a call back when</prompt>
<?php
                SpeakName($info['cn'][0],$target);
?>
                    <prompt>became free.  You are now being transfered</prompt>
                </block>
<?php
                print "<transfer name=\"call\" dest=\"$target\">\n</transfer>\n";
?>
            </form>
<?php
        }
    }
    else if ($cmd == "alarm")												// ALARM has gone off
    {
        $ds=LdapConnect($server,$user_login,$user_password);
        $name = LdapGetName($ds,$num);
        $tname = LdapGetName($ds,$target);
        LdapClose($ds);
?>
        <form id="alarm">
            <block>
<?php
            for($i=1; $i < 5; $i++)
            {
                print "<prompt> Call back request failed for </prompt>\n";
                SpeakName($name,$num);
                print "<prompt> to </prompt>\n";
                SpeakName($tname,$target);
            }
?>                
            <prompt>Goodbye</prompt>
            <disconnect/>
            </block>
        </form>
<?php
    }
    else
    {
?>
        <form>
            <block>
                <prompt>I am sorry I do not understand the command</prompt>
<?php
				print "<prompt>$cmd</prompt>"; 
?>
            </block>
        </form>
<?php
    }
?>

</vxml>

<?php
function do_submit($ds,$vmport,$info,$target,$organiser,$num,$failedtelephonenumber,$retryinterval,$retrymax,$filename,$quick)
{
    // check for existing scheduled call
    // if found, delete it
    if ($ds)
    {
        $sr=@ldap_search($ds, "guid=$vmport", "(&(objectclass=ScheduledCall)(notes={$info['guid'][0]})(organiser=$organiser))"); 
        $o =@ldap_get_entries($ds, $sr);
        if ($o['count'] != 0)
        {
            $guid = $o[0]['guid'][0];
            ldap_delete($ds, "guid=$guid");
        }
        
        // add new scheduled call
        $attr['objectclass']            = "ScheduledCall";
        $attr['organiser']              = $organiser;
        $attr['notes']                  = $info['guid'][0];
        $attr['telephonenumber']        = $num;
        $attr['command']                = "!EA:http://127.0.0.1/$filename?cmd=callback&n=$num&t=$target&o=$orignum";
        $attr['failtelephonenumber']    = $failedtelephonenumber;
        $attr['failcommand']            = "!EA:http://127.0.0.1/$filename?cmd=alarm&n=$num&t=$target&o=$orignum";
        $attr['retryinterval']          = $retryinterval;
        $attr['retrymax']               = $retrymax;
        $attr['disabled']               = "1";
        $dn = "datetime=".gmdate("ymdHis").",guid=$vmport";
        ldap_add($ds, $dn, $attr);
    }
?>
        <form id="submit">
        <block>
<?php
        if( $quick )
        {
            print "<prompt>You will be called back when they become free</prompt>\n";
        }
        else
        {
            if( $num != $orignum )
            {
                print "<prompt>You will be called back on</prompt>\n";
                SpeakName("",$num);
                print "<prompt>when</prompt>\n";
            }
            else
            {
                print "<prompt>You will be called back when</prompt>\n";
            }
            SpeakName($info['cn'][0],$target);
            print "<prompt>becomes free. Thank you</prompt>\n";
        }
?>
        </block>
        </form>
<?php
}

// Helpful functions to make the above code easier
function LdapConnect($server,$user_login,$user_password)
{
    $ds=ldap_connect($server.":4000");  // must be a valid LDAP server!
    if ($ds)
    {
        $r=ldap_bind($ds, $user_login, $user_password);
        if (!$r)
        {
            ldap_close($ds);
            $ds = 0;
        }
    }
    return $ds;
}

function LdapClose($ds)
{
    ldap_close($ds);
}

function LdapGetName($ds,$num)
{
	$name = "";
	if ($num != "" && $ds)
	{
		$sr=@ldap_search($ds, "", "(GlobalTelephoneNumber=$num)",array("cn"),0,1); 	// Optimized special key search
		$o = @ldap_get_entries($ds, $sr);
		if ($o['count'] != 0)					// If we have some answers
		{  
			$name = $o[0]['cn'][0];				// Extract the name (common name = cn) attribute
		}
	}
	return $name;
}

function LdapGetTargetInfo($ds,$num)
{
	$info = array();
	if ($num != "" && $ds)
	{
		$sr=@ldap_search($ds, "", "(GlobalTelephoneNumber=$num)",array("cn","guid"),0,1); 	// Optimized special key search
		$o = @ldap_get_entries($ds, $sr);
		if ($o['count'] != 0)					// If we have some answers
		{  
            $info = $o[0];
		}
	}
	return $info;
}

function LdapGetVmPort($ds,$vmportname,$vmportlocation)
{
    if( $vmportlocation )
    {
        $sr=@ldap_read($ds, "cn=$vmportlocation,cn=Modules","(objectclass=Module)",array("guid","cn"),0,1); 
        $o = @ldap_get_entries($ds, $sr);
        if ($o['count'] != 0)
        {
            $location = $o[0]['guid'][0];
        }
    }
    else
    {
        $location = "00000000-0000-0000-0000-000000000000";
    }
    
    if( $location )
    {
		$sr=ldap_list($ds, "cn=VoicemailPorts","(&(location=$location)(cn=$vmportname))",array("guid","cn"),0,0); 
		$o = ldap_get_entries($ds, $sr);
		if ($o['count'] != 0)
		{
			$vmport = $o[0]['guid'][0];
			return $vmport;
		}
	}
    print "<br/>\n";
    print "<b>Warning</b>:  LdapGetVmPort(): port $vmportname @ $vmportlocation not found\n";
	return "notfound";
}

function SpeakName($name,$num)
{
	if( $name!="" )
    {
        print "<prompt>$name</prompt>\n";
    }
    else
    {
        print "<prompt>Number </prompt>\n";
        for ($i=0; $num[$i] != ""; $i++)
        {
            print "<prompt>$num[$i]</prompt>\n";
        }
    }
}

function SpeakTime($t)
{
    if( strlen($t) == 3 )
    {
        $t="0".$t;
    }
    else if( strlen($t) == 2 )
    {
        $t="00".$t;
    }
	$hour = substr($t, -4, 2);
	$min = substr($t, -2, 2);
	if( $min == "00" )
	{
		$min = " hundred hours";
	}
    print "<prompt>$hour</prompt>\n";
    print "<prompt>$min</prompt>\n";
}

?>

