<?php

//	error_reporting(0);
	if (!isset($_SERVER['PHP_AUTH_USER'])) {
		error_log("Not authenticated");
	    header('WWW-Authenticate: Basic realm="SpliceCom"');
	    header('HTTP/1.0 401 Unauthorized');
	    exit;
	}

	$user = $_SERVER['PHP_AUTH_USER'];
	$password   = $_SERVER['PHP_AUTH_PW'];
	$type = $_GET['type'];
	//error_log("get call logs for User $user password $password type $type");
	if ($type === "vm")
		$onlyVm = true;
	else
		$onlyVm = false;

	header('Content-Type: text/xml');

	const NULLGUID = "00000000-0000-0000-0000-000000000000";

	$ldap = ldap_connect("127.0.0.1", 4000);
	if (!$ldap)
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}
	if (!ldap_bind($ldap, "INTERNAL", "112233445566"))
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}

	//Get user info
	$attrs = array('guid','cn','currenthome', 'departmentvoicemail', 'departmentvoicemail2','departmentvoicemail3','departmentvoicemail4','departmentvoicemail5',
		'departmentvoicemail6','departmentvoicemail7','departmentvoicemail8','loginaccesscode');
	$info = ldap_get_entries($ldap, @ldap_search($ldap, "cn=Users", "(&(objectclass=User)(telephoneNumber=".$user."))", $attrs, 0, 1));
	//print_r($info);
	if ($info[0]['loginaccesscode'][0] !== $password)
	{
		error_log("Bad password");
	    header('HTTP/1.1 404 Not Found'); //Could send unauthorised but if they got it wrong, don't want them to try again
	    exit;
	}
	//set dept 0 as user to ease coding
	$deptNumber[0]=$user;
	$deptName[0]=$info[0]['cn'][0];
	$deptHome[0]=$info[0]['currenthome'][0];
	$deptGuid[0]=$info[0]['guid'][0];
	//print_r($userHome);
	$deptGuid[1]=$info[0]['departmentvoicemail'][0];
	$deptGuid[2]=$info[0]['departmentvoicemail2'][0];
	$deptGuid[3]=$info[0]['departmentvoicemail3'][0];
	$deptGuid[4]=$info[0]['departmentvoicemail4'][0];
	$deptGuid[5]=$info[0]['departmentvoicemail5'][0];
	$deptGuid[6]=$info[0]['departmentvoicemail6'][0];
	$deptGuid[7]=$info[0]['departmentvoicemail7'][0];
	$deptGuid[8]=$info[0]['departmentvoicemail8'][0];
	//print_r($deptGuid);
	//Find other home servers
	for ($i=1;$i<9;$i++)
	{
		if ($deptGuid[$i] === NULLGUID)
		{
			$deptNumber[$i]="";
			$deptName[$i]="";
			$deptHome[$i]=NULLGUID;
		}
		else
		{
			$info = ldap_get_entries($ldap, @ldap_read($ldap, "GUID=".$deptGuid[$i], "(objectclass=*)", array('cn','currenthome','telephonenumber'), 0, 1));
			if ($info && $info['count'] > 0)
			{
				$deptNumber[$i]=$info[0]['telephonenumber'][0];
				$deptName[$i]=$info[0]['cn'][0];
				$deptHome[$i]=$info[0]['currenthome'][0];
			}
			else
			{
				//no info returned - x directory?
				$deptNumber[$i]="";
				$deptName[$i]="";
				$deptHome[$i]=NULLGUID;
			}
		}
	}
	//print_r($deptName);
	//print_r($deptHome);

	// Who are we?
	$info = ldap_get_entries($ldap, @ldap_read($ldap, "cn=Self, cn=Modules", "(objectclass=*)", array('location'), 0, 1));
	//print_r($info);
	if ($info && $info['count'] > 0)
		$selfHome = $info[0]['location'][0];
	else	
		$selfHome = NULLGUID; //surely not possible
	//echo "Self is $selfHome\n";

	//Find addresses of LDAP servers
	$serverCount=1;
	$serverHome[1] = $selfHome;
	$serverAddress[1] = "Self";
	for ($i=0;$i<9;$i++)
	{
		$deptServer[$i] = 0; //0 for no server
		if (isset($deptName[$i]) && strlen($deptName[$i])!=0)
		{
			//if the current home guid is missing, assume self
			if (!isset($deptHome[$i]) || $deptHome[$i] === NULLGUID)
				$deptServer[$i] = 1;
			else
			{
				for ($j=0;$j<$serverCount;)
				{
					$j++;
					if ($serverHome[$j] === $deptHome[$i])
					{
						$deptServer[$i] = $j;
						break;
					}
				}
				if ($deptServer[$i] == 0)
				{
					$serverCount++;
					$deptServer[$i] = $serverCount;
					$serverHome[$serverCount] = $deptHome[$i];
					$serverAddress[$serverCount]="";
					$info = ldap_get_entries($ldap, @ldap_search($ldap, "cn=Modules", "(GUID=".$serverHome[$serverCount].")", array('ipaddress'), 0, 1));
					if ($info && $info['count'] > 0)
						$serverAddress[$serverCount]=$info[0]['ipaddress'][0];
				}
			}
		}
	}
	//echo "$serverCount \n";
	//print_r($serverHome);
	//print_r($deptServer);
	//print_r($serverAddress);
	//Get messages
	class Message
	{
		public $name;
		public $number;
		public $time;
		public $code;
		public $played;
		function __construct($Aname, $AnewName, $AcalledName, $Anumber, $Atime, $Aid, $Anew, $AcalledNumber)
		{
			if ($AnewName !== "")
				$this->name = $AnewName." (".$AcalledName.")";
			else
				$this->name = $Aname." (".$AcalledName.")";
			$this->number = $Anumber;
			//<time>2010-03-26T11:45:46.138+05:30</time> 
			//20180504104036003
			$this->time = substr($Atime,0,4).'-'.substr($Atime,4,2).'-'.substr($Atime,6,2).'T'
						 .substr($Atime,8,2).':'.substr($Atime,10,2).':'.substr($Atime,12,2);
			$this->code = '!SC_'.$AcalledNumber.'_!CollectMsg%2d'.$Aid; // '-' gets garbled by Yealink so protect it
			if ($Anew === "Old")
				$this->played = 1;
			else
				$this->played = 0;
		}
	}
	$placed = array();
	$received = array();
	$missed = array();
	$vm = array();
	//$attrs=array("name","telephoneNumber","messageId","messageState","url","answered","GUID","messageType","datetime","datetime2","datetimeUTC","@telephoneNumber");
	$attrs=array("name","telephoneNumber","messageId","messageState","answered","messageType","datetime2","@telephoneNumber");
	for ($s=0;$s<$serverCount;)
	{
		$s++;
		if ($s > 1)
		{
			//connect to new server
			if ($serverAddress[$s] == "")
				continue; //missing IP address
			$ldap = ldap_connect($serverAddress[$s], 4000);
			if (!$ldap)
			{
				error_log("No LDAP server $addr");
				continue;
			}
			if (!ldap_bind($ldap, $user, $password))
			{
				error_log("Failed to bind $addr");
				continue;
			}
		}
		for ($i=0;$i<9;$i++)
		{
			if ($deptServer[$i] == $s)
			{
				//fetch call log
				$info = ldap_get_entries($ldap, @ldap_search($ldap, "GUID=".$deptGuid[$i], "(objectClass=Message)", $attrs, 0, 50));
				//print_r($info);
				if ($info && $info['count'] > 0)
				{
					$count = $info['count'];
					for ($j=0; $j<$count; $j++)
					{
						//Voicemails without message ID are treated as incoming calls - see phoneapp.cpp code
						//if ($info[$j]['messagetype'][0] === "voiceMail")
						if ($info[$j]['messageid'][0] !== "")
						{
							$vm[$deptName[$i]][] = new Message($info[$j]['name'][0], $info[$j]['@telephonenumber'][0], $deptName[$i],
													$info[$j]['telephonenumber'][0], $info[$j]['datetime2'][0],
													$info[$j]['messageid'][0], $info[$j]['messagestate'][0],$deptNumber[$i]);
						}
						else if (!$onlyVm)
						{
							if ($info[$j]['messagetype'][0] === "voiceOut")
							{
								$placed[] = new Message($info[$j]['name'][0], $info[$j]['@telephonenumber'][0], $deptName[$i],
														$info[$j]['telephonenumber'][0], $info[$j]['datetime2'][0], "", "","");
							}
							else // voicemail without id also counts.   if ($info[$j]['messagetype'][0] === "voice")
							{
								if ($info[$j]['answered'][0] == 0)
								{
									$missed[] = new Message($info[$j]['name'][0], $info[$j]['@telephonenumber'][0], $deptName[$i],
															$info[$j]['telephonenumber'][0], $info[$j]['datetime2'][0], "", "","");
								}
								else
								{
									$received[] = new Message($info[$j]['name'][0], $info[$j]['@telephonenumber'][0], $deptName[$i],
															$info[$j]['telephonenumber'][0], $info[$j]['datetime2'][0], "", "","");
								}
							}
						}
					}
				}
			}
		}
	}
	//print_r($placed);
	//print_r($received);
	//print_r($missed);
	//print_r($vm);

	//generate XML
	$xmlheader = '<?xml version="1.0" encoding="UTF-8"?><CallLogs xmlns="http://schema.broadsoft.com/xsi">'; 
	$xmlfooter = '</CallLogs>';

	if (!$onlyVm)
	{
		$xmlplaced = "<placed>";
		foreach ($placed as $message)
		{
			$xmlplaced .= AddXmlCall($message);
		}
		$xmlplaced .= "</placed>";
		$xmlreceived = "<received>";
		foreach ($received as $message)
		{
			$xmlreceived .= AddXmlCall($message);
		}
		$xmlreceived .= "</received>";
		$xmlmissed = "<missed>";
		foreach ($missed as $message)
		{
			$xmlmissed .= AddXmlCall($message);
		}
		$xmlmissed .= "</missed>";
	}
	$xmlvoicemessaged = "<voicemessaged>";
	foreach ($vm as $dept => $messages)
	{
		$xmlvoicemessaged .= "<mailbox>";
		$xmlvoicemessaged .= '<groupname>'.$dept.'</groupname>';
		foreach ($messages as $message)
		{
			$xmlvoicemessaged .= AddXmlVM($message);
		}
		$xmlvoicemessaged .= "</mailbox>";
	}
	$xmlvoicemessaged .= "</voicemessaged>";

	if (!$onlyVm)
		$xmlout = $xmlheader.$xmlplaced.$xmlreceived.$xmlmissed.$xmlvoicemessaged.$xmlfooter;
	else
		$xmlout = $xmlheader.$xmlvoicemessaged.$xmlfooter;
	print($xmlout);

function AddXmlCall($message)
{
	$out  = '<callLogsEntry>';
	$out .= '<phoneNumber>'.$message->number.'</phoneNumber>';
	$out .= '<name>'.$message->name.'</name>';
	$out .= '<time>'.$message->time.'</time>';
	$out .= '</callLogsEntry>';
	return $out;
}

function AddXmlVM($message)
{
	$out  = '<callLogsEntry>';
	$out .= '<phoneNumber>'.$message->number.'</phoneNumber>';
	$out .= '<name>'.$message->name.'</name>';
	$out .= '<time>'.$message->time.'</time>';
	$out .= '<played>'.$message->played.'</played>';
	$out .= '<code>'.$message->code.'</code>';
	$out .= '</callLogsEntry>';
	return $out;
}

?>
