<?php

//	error_reporting(0);

	$mac = $_GET['mac'];

	$ldap = ldap_connect("127.0.0.1", 4000);
	if (!$ldap)
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}
	if (!ldap_bind($ldap, "INTERNAL", "112233445566"))
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}

//	print "search (PhoneSerialNumber=".$mac.")\n";
	$phoneAttr = array('objectclass','ipaddress','pnpvendor','pnpmodel','pnpversion','usestun', 'stunaddr', 'stunport', 'password', 'siplicense', 'filename', 'requiredversion');
	$result = ldap_get_entries($ldap, ldap_search($ldap, "", "(PhoneSerialNumber=".$mac.")", $phoneAttr, 0, 1));
	if (!$result || $result[0]['objectclass'][0] != "GenericIPPhone")
	{
	    header('HTTP/1.1 404 Not Found');
	    exit;
	}
//	print_r($result);
	$phonepassword = $result[0]['password'][0];
	if (strlen($phonepassword)==0)
		$phonepassword = "7388";
	
	$ipaddress  = $result[0]['ipaddress'][0];
	
	$pnpvendor  = $result[0]['pnpvendor'][0];
	$pnpmodel   = $result[0]['pnpmodel'][0];
	$pnpversion = $result[0]['pnpversion'][0];

	$usestun  = $result[0]['usestun'][0];
	$stunaddr = $result[0]['stunaddr'][0];
	$stunport = $result[0]['stunport'][0];
	
	$sipLicence = $result[0]['siplicense'][0];
	$phone_fw   = $result[0]['filename'][0];
	$phone_rqdv = $result[0]['requiredversion'][0];

	$phone_1_dn = $result[0]['dn'];
	$dna = ldap_explode_dn($phone_1_dn, 0);
//	print "dn ".$phone_1_dn."\n";
//	print_r($dna);

	$phone_dn = $dna[1];
	for ($i=2; $i<$dna['count']; $i++)
		$phone_dn .= ",".$dna[$i];

	$module_dn = $dna[2];
	for ($i=3; $i<$dna['count']; $i++)
		$module_dn .= ",".$dna[$i];

	$result = ldap_get_entries($ldap, ldap_read($ldap, "cn=1,".$module_dn, "(objectclass=*)", array('publicIPAddress', 'dontValidateIPAddress'), 0, 1));
	if (!$result)
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}
	$dontvalidateipaddress = $result[0]['dontvalidateipaddress'][0];
	if ($usestun)
	{
		$serveraddr = $result[0]['publicipaddress'][0];
		$ldaps_server   = "ldaps-$serveraddr";
		if (!file_exists($ldaps_server))
		{
			//generate a key for this server if it's our home
			$info = ldap_get_entries($ldap, ldap_read($ldap, "cn=Self, cn=Modules", "(objectclass=*)", array('location'), 0, 1));
			$result = ldap_get_entries($ldap, ldap_read($ldap, $module_dn, "(objectclass=*)", array('location'), 0, 1));
			if (!$result || !$info)
			{
				header('HTTP/1.1 500 Internal Server Error');
				exit;
			}
			$self=$info[0]['location'][0];
			$home=$result[0]['location'][0];
			if ($home==$self)
				setLdapsServerKey($ldaps_server, $serveraddr);
			else
				error_log("LDAP key generation skipped as this module is not the phone's home");
		}
	}
	else
	{
		$result = ldap_get_entries($ldap, ldap_read($ldap, $module_dn, "(objectclass=*)", array('ipaddress'), 0, 1));
		if (!$result)
		{
		    header('HTTP/1.1 500 Internal Server Error');
		    exit;
		}
		$module = $result[0];
		$serveraddr = $module['ipaddress'][0];
	}
	$serverport = 5060;

	if (!$dontvalidateipaddress && $_SERVER['REMOTE_ADDR'] != $ipaddress)
	{
	    header('HTTP/1.1 404 Not Found');
	    exit;
	}

//	print "search dn=".$phone_dn."\n";
	$result = ldap_get_entries($ldap, ldap_read($ldap, $phone_dn, "(objectclass=*)", array('guid', 'productversion'), 0, 1));
	if (!$result)
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}
	$phone = $result[0];
	$phone_guid = $phone['guid'][0];
	$phone_version = $phone['productversion'][0];

	$ok = false;	
	$output ="";
	if (strcasecmp($pnpvendor, "yealink") == 0)
	{
		$model = strtoupper($pnpmodel);
		if (strncmp($model, "SIP-T", 5) == 0)
			$model = substr($model, 4); //loose leading SIP-
		$fullModel = $model; //will need to know exact model for firmware
		if ($model[0] === "T")
			$model = substr($model, 0, 3); //loose trailing letters
		$numusers = 1; //set up one account by default
		$havelinekeys = false;
		$supportexpmodule = false;
		$supportLDAP  = false;
		$is530 = false;
		$supportpaging = false;
		$isDect = false;
		$supportDect = false;
		switch ($model)
		{
			case "IP 530":
				$is530 = true;
				break;
			case "VP59":
			case "T57":
			case "T54":
			case "T53":
				$supportDect = true;
				$numusers = 5;// main phone and 4 handsets
				//and fall through
			case "T58":
			case "T56":
			case "T52":
			case "T48":
			case "T46":
			case "T29":
			case "T27":
				$supportexpmodule = true;
				//and fall through
			case "SIP-CP960":
			case "SIP VP-T49G":
			case "T42":
			case "T41":
			case "T40":
			case "T23":
			case "T21":
				$havelinekeys = true;
				//and fall through
			case "CP920":
			case "CP860":
			case "T19":
				$supportLDAP  = true;
				$supportpaging = true;
				break;
			case "W52P":
			case "W56P":
				$isDect = true;
				$numusers = 5;// this number of handsets on the base
				$supportLDAP  = true;
				break;
			case "SIP-W60B":
				$isDect = true;
				$numusers = 8;// this number of handsets on the base
				$supportLDAP  = true;
				$supportpaging = true;
				break;
		}

		$haveuser = false;
		$user_guid = "";
		$userIsRestricted = false;
		$users = ldap_get_entries($ldap, @ldap_search($ldap, "cn=Users", "(initialPhone=".$phone_guid.")", array('guid','cn','telephonenumber','loginaccesscode', 'siplicense', 'userclass'), 0, $numusers));
		if ($users && $users['count'] > 0)
		{
			//print_r($users);
			$haveuser = true;
			$user = $users[0];
			
			$user_guid            = $user['guid'][0];
			$user_cn              = $user['cn'][0];
			$user_telephoneNumber = $user['telephonenumber'][0];
			$user_loginAccessCode = $user['loginaccesscode'][0];
			if (!$sipLicence)
				$sipLicence = $user['siplicense'][0];
			if ($user['userclass'][0] > 0)
				$userIsRestricted = true;
		}

		if (!$sipLicence)
		{
			$havelinekeys = false;
			$supportexpmodule = false;
			$supportLDAP  = false;
			$supportpaging = false;
		}

		if ($is530)
		{
			// IP530
			print "[ account ]\n";
			print "path = /config/voip/sipAccount0.cfg\n";
			print "Enable = 1\n";
			if ($haveuser)
			{
				print "Label = ".$user_telephoneNumber." - ".$user_cn."\n";
				print "DisplayName = ".$user_cn."\n";
				print "UserName = ".$user_telephoneNumber."\n";
				print "AuthName = ".$user_telephoneNumber."\n";
				print "password = ".$user_loginAccessCode."\n";
			}
			print "SIPServerHost = ".$serveraddr."\n";
			print "SIPServerPort = ".$serverport."\n";
			print "SubscribeMWI = 1\n";

			$ok = true;
		}
		else
		{
			// Yealink T41P, etc
			$output = "#!version:1.0.0.1\n";

			// Read in any customer supplied code
			$webServerAddr = $serveraddr;
			$custom = "custom_yealink.php";
			$customParam = "";
			if (file_exists($custom))
			{
				include $custom;
				if (isset($httpPort))
					$webServerAddr .= ":$httpPort"; //Some customers hate opening port 80
			}

			//--------------------------
			//Common Setup for all lines
			//--------------------------
			$screensize = "";
			$expscreensize = "";
			switch ($model)
			{
				case "SIP-CP960":
					$screensize = "720x1280";
					break;
				case "VP59":
					$expscreensize = "272x480";
					$screensize = "1280x800";
					break;
				case "T57":
					$expscreensize = "272x480";
					$screensize = "800x480";
					break;
				case "T56":
				case "T58":
					$expscreensize = "272x480";
					$screensize = "1024x600";
					break;
				case "T53":
					$expscreensize = "272x480";
					break;
				case "T52":
					$expscreensize = "272x480";
					$screensize = "320x240";
					break;
				case "T48":
					$screensize = "800x480";
					break;
				case "T54":
					$expscreensize = "272x480";
					//And deliberate drop through
				case "T46":
				case "T29":
					$screensize = "480x272";
					break;
				case "SIP VP-T49G":
					$screensize = "1280x800";
					break;
			}
			if ($screensize)
			{
				$imagedir = "SIPimages";
				$wallpaperfile = "wallpaper$screensize.jpg";
				if (file_exists("$imagedir/$wallpaperfile"))
				{
					$output .= "phone_setting.backgrounds = Config:$wallpaperfile\n";
					$output .= "wallpaper_upload.url = http://".$webServerAddr."/prov/$imagedir/$wallpaperfile\n";
				}
				$screensaverfile = "saver$screensize-1.jpg";
				if (file_exists("$imagedir/$screensaverfile"))
				{
					$output .= "screensaver.wait_time = 600\n";
					$output .= "screensaver.type = 1\n";
					$output .= "screensaver.picture_change_interval = 300\n";
					$inum=1;
					do
					{
						$output .= "screensaver.upload_url = http://".$webServerAddr."/prov/$imagedir/$screensaverfile\n";
						$inum++;
						$screensaverfile = "saver$screensize-$inum.jpg";
					}
					while (file_exists("$imagedir/$screensaverfile"));
				}
			}
			if ($expscreensize)
			{
				$imagedir = "SIPimages";
				$wallpaperfile = "wallpaper$expscreensize.jpg";
				if (file_exists("$imagedir/$wallpaperfile"))
				{
					$output .= "expansion_module.backgrounds = Config:$wallpaperfile\n";
					$output .= "wallpaper_upload.url = http://".$webServerAddr."/prov/$imagedir/$wallpaperfile\n";
				}
			}
/* No longer needed
			$logosize = "";
			switch ($model)
			{
				case "T27":
					$logosize = "240x120";
					break;
				case "T42":
				case "T41":
				case "CP860":
					$logosize = "192x64";
					break;
				case "T40":
				case "T23":
				case "T21":
				case "T19":
					$logosize = "132x64";
					break;
			}
			if ($logosize)
			{
				$output .= "phone_setting.lcd_logo.mode = 2\n";
				$output .= "lcd_logo.url = http://".$webServerAddr."/SIPimages/logo".$logosize.".dob\n";
			}
*/

			// Ensure the phone displays the display names in the SIP call control messages and not LDAP etc for calls. Avoids Busy-username on pickup
			$output .= "phone_setting.call_display_name.mode=1\n";

			// Add LDAP directory scanning - uses first configured user for authentication
			if ($supportLDAP)
			{
				$output .= "directory_setting.url = http://".$webServerAddr."/prov/favorite_setting.xml\n";
				$output .= "super_search.recent_call = 0\n";
				$output .= "super_search.url = http://".$webServerAddr."/prov/super_search.xml\n";

				$output .= "ldap.name_filter = (GlobalKeyword=%)\n";
				$output .= "ldap.number_filter = (GlobalKeyword=%)\n";
				$output .= "ldap.host = ".$serveraddr."\n";
				if ($usestun == 1)
				{
					$output .= "ldap.tls_mode = 2\n";  //LDAPS
					$output .= "ldap.port = 4100\n";
					$output .= "trusted_certificates.url = http://$webServerAddr/prov/ldaps.cer\n";
				}
				else
				{
					$output .= "ldap.tls_mode = 0\n";  //LDAP
					$output .= "ldap.port = 4000\n";
				}
				if ($haveuser)
				{
					$output .= "ldap.enable = 1\n";
					$output .= "ldap.user = ".$user_telephoneNumber."\n";
					$output .= "ldap.password = ".$user_loginAccessCode."\n";
				}
				else
				{
					$output .= "ldap.enable = 0\n";
					$output .= "ldap.user = -\n";
					$output .= "ldap.password = -\n";
				}
				$output .= "ldap.name_attr = DNDcn ignorenullvalues\n";
				$output .= "ldap.numb_attr = telephonenumber mobileTelephoneNumber homeTelephoneNumber spare2TelephoneNumber pager\n"; //pager used due to Yealink limited field length
				$output .= "ldap.display_name = %DNDcn\n";
				$output .= "ldap.version = 2\n";
				$output .= "ldap.ldap_sort = 0\n";
				$output .= "ldap.max_hits = 10\n";
			}
			else
				$output .= "ldap.enable = 0\n"; //to be sure

			$timeZoneFile = "timeZone.php";
			$timeZones = "timeZones.csv";
			if (file_exists($timeZoneFile) && !file_exists($timeZones))
			{
				include $timeZoneFile;
			}
			else
				setTimeZone($timeZoneFile, $timeZones);

			$output .= "features.missed_call_popup.enable = 0\n"; //disable missed call popup

			$output .= "features.play_hold_tone.enable = 0\n";    // disable hold beep until Yealink fix the call selection
			$output .= "features.play_hold_tone.delay = 3\n";     // hold beep every x seconds

			if ($sipLicence)
			{
				$output .= "bw.feature_key_sync = 1\n";					//sync DND and call forwarding
				$output .= "phone_setting.ring_type = Resource:Ring2.wav\n"; //default ring type matches SpliceCom external
				//Set up distinctive ringing
				$output .= "distinctive_ring_tones.alert_info.1.ringer = 1\n";
				$output .= "distinctive_ring_tones.alert_info.1.text = Internal\n";
				$output .= "distinctive_ring_tones.alert_info.2.ringer = 2\n";
				$output .= "distinctive_ring_tones.alert_info.2.text = External\n";
				$output .= "distinctive_ring_tones.alert_info.3.ringer = 3\n";
				$output .= "distinctive_ring_tones.alert_info.3.text = RingTune3\n";
				$output .= "distinctive_ring_tones.alert_info.4.ringer = 4\n";
				$output .= "distinctive_ring_tones.alert_info.4.text = RingTune4\n";
				$output .= "distinctive_ring_tones.alert_info.5.ringer = 5\n";
				$output .= "distinctive_ring_tones.alert_info.5.text = RingTune5\n";
				$output .= "distinctive_ring_tones.alert_info.6.ringer = 6\n";
				$output .= "distinctive_ring_tones.alert_info.6.text = RingTune6\n";
				$output .= "distinctive_ring_tones.alert_info.7.ringer = 7\n";
				$output .= "distinctive_ring_tones.alert_info.7.text = RingTune7\n";
				$output .= "distinctive_ring_tones.alert_info.8.ringer = 8\n";
				$output .= "distinctive_ring_tones.alert_info.8.text = RingTune8\n";
				$output .= "distinctive_ring_tones.alert_info.9.ringer = 10\n";
				$output .= "distinctive_ring_tones.alert_info.9.text = RingTune9\n";
				$output .= "distinctive_ring_tones.alert_info.10.ringer = 4\n";
				$output .= "distinctive_ring_tones.alert_info.10.text = System\n";
			}
			$output .= "phone_setting.ringing_timeout = 3600\n"; //Keep ringing for up to an hour - the maximum allowed

			$output .= "trusted_certificates.url = http://".$webServerAddr."/prov/SpliceComCA.cer\n";
			$output .= "push_xml.sip_notify = 1\n"; //*****
			$output .= "features.direct_ip_call_enable = 0\n";
			$output .= "features.key_as_send = 0\n"; //only use # key as # and ignore the word SEND on it
			$output .= "sip.trust_ctrl = 1\n";
			if ($havelinekeys)
			{
				$output .= "features.blf_led_mode = 0\n";
				$output .= "blf.enhanced.dnd.enable = 1\n";
				$output .= 'blf.enhanced.dnd.led = $LEDg1000o500$'."\n"; //green for 1s and off for 0.5s. repeating
				if ($supportexpmodule)
				{
					//set to 0 to load BLFs onto the phone before loading expansion modules 
					//set to 1 to load BLFs onto expansion modules before loading the phone
					$output .= "phone_setting.blf_list_sequence_type = 1\n";
				}
				$output .= "phone_setting.page_tip = 1\n";
				$output .= "transfer.dsskey_deal_type = 1\n";
				$output .= "features.auto_linekeys.enable = 1\n";
				//Set hot desking if we have no user
				if (!$haveuser)
				{
					$output .= "linekey.1.type = 27\n"; //set XML browser
					$output .= "linekey.1.label = Login/out\n";
					$output .= "linekey.1.value = http://$webServerAddr/prov/login.php?mac=$mac&phase=clear\n";
					$output .= "default_input_method.xml_browser_input_screen=123\n";
					// OLD clear call history on logout
					//{
						//$output .= "features.action_uri.enable = 1\n";    // Enable remote control of phone
						//$output .= "features.action_uri_limit_ip = 127.0.0.1\n"; //from the phone
						//$output .= "action_url.registered = http://admin:$phonepassword@127.0.0.1/servlet?key=CANCEL;F1;F3;DOWN;DOWN;DOWN;OK;OK;F1\n"; //delete call history on logon
						//$output .= "action_url.unregistered = http://admin:$phonepassword@127.0.0.1/servlet?key=CANCEL;F1;F3;DOWN;DOWN;DOWN;OK;OK;F1\n"; //delete call history on logoff
					//}

				}
			}
			if ($usestun == 1)
			{
				$output .= "sip.nat_stun.enable = 1\n";
				$output .= "sip.nat_stun.server = ".$stunaddr."\n";
				$output .= "sip.nat_stun.port = ".$stunport."\n";
			}
			else
			{
				$output .= "sip.nat_stun.enable = 0\n";
			}
			
			if ($supportpaging)
			{
				loadMulticastPaging($ldap, $phone_guid, $user_guid);
				$output .= "multicast.receive.use_speaker = 1\n"; //Always play out through speaker not earpiece
			}

			// After Yealink RPS, phone will need to know where to get it's config from
			//  Location priority is SIP PnP -> DHCP -> this config URL
			//  RPS is only consulted if all the above fail and the phone is coming up from a factory reset
			// Set the URL so we don't do a firmware upgrade after the first provision
			//  and disable pnp & dhcp provisioning for the same reason
			$output .= "auto_provision.pnp_enable = 0\n";
			$output .= "auto_provision.dhcp_option.enable = 0\n";
			$output .= "auto_provision.server.url = http://".$webServerAddr."/prov/reload/\n";
			// ********* Provisioning will re-assert logins to initial phones so don't do this automatically
			$output .= "auto_provision.weekly.enable = 0\n";
			// and keep up to date each night
			//$output .= "auto_provision.weekly.enable = 1\n";
			//$output .= "auto_provision.weekly.begin_time = 02:00\n";
			//$output .= "auto_provision.weekly.end_time = 03:00\n";
			$output .= "auto_provision.custom.protect = 1\n"; //local changes are not lost

			//Change phone passwords
			$output .= "security.user_password = user:$phonepassword\n";
			$output .= "security.user_password = admin:$phonepassword\n";
			$output .= "security.user_password = var:$phonepassword\n";

			//Load required firmware
			//Check for upgrade of phone firmware
			if ($sipLicence && strlen($phone_rqdv)!=0 && strlen($phone_fw)!=0 && strlen($phone_version)!=0)
			{
				//See if we are already at the required level
				if (strpos($phone_version,$phone_rqdv)===false)
				{
					//get upgrade URL
					$result = ldap_get_entries($ldap, @ldap_read($ldap, "cn=YL, cn=System", "(objectclass=*)", array('url'), 0, 1));
					$fw_url = trim($result[0]['url'][0]);
					if (strlen($fw_url)==0)
						$fw_url = "http://max.splicecom.com/Yealink/firmware/";
					else if (substr($fw_url, -1) != '/')
						$fw_url .= '/';
					$fw_url .= $phone_fw;
					//error_log("Using url $fw_url");
					$output .= "firmware.url = $fw_url\n";
				}
			}
			else if (!isset($_GET["reload"]))
				setFirmware($fullModel, $webServerAddr);

			// Fix number of users for W60B unit
			if (strcasecmp($model, "SIP-W60B")==0 && $numusers == 8)
				$output .= "phone_setting.max_number_of_handset = 8\n";

			//Configure call logging
			$LDAPCallLogging = false;
			if ($supportLDAP)
			{
				switch ($fullModel)
				{
					case "VP59":
					case "T58":
					case "T56A":
					case "T57W":
					case "T54W":
					case "T53W":
					case "T53":
					case "T48S":
					case "T46S":
					case "T42S":
					case "T41S":
					case "T40G":
					case "T19P_E2":
						$LDAPCallLogging = true;
						break;
				}
			}
			if ($LDAPCallLogging)
			{
				$output .= "custom.multi_voice_mail.enable=1\n";
				$output .= "custom.multi_voice_mail.history_url= https://$webServerAddr/prov/getcalllog.php?type=all\n";
				$output .= "custom.multi_voice_mail.vm_url= https://$webServerAddr/prov/getcalllog.php?type=vm\n";
				$output .= "voice_mail.message_key.mode=1\n";
				$output .= "security.var_enable = 1\n";
				$output .= "security.default_access_level = 2\n";
				$output .= "web_item_level.url=https://$webServerAddr/prov/WebItemsLevel.cfg\n";
			}
			//phone call history must be on for the missed call indicator to work.
			if ($haveuser) //Ensure local phone call logging is switched on if we have a user.
				$output .= "features.save_call_history = 1\n";

			//Restricted users have no DND key
			if ($userIsRestricted === true)
				$output .= "features.dnd.allow = 0\n"; // disable key
			else
				$output .= "features.dnd.allow = 1\n"; // enable key

			//------------------------
			//set up one line per user
			//------------------------
			for ($i=0; $i < $numusers;)
			{
				$i++;
				if ($haveuser)
				{
					$output .= "account.$i.enable = 1\n";
					$output .= "account.$i.sip_server.1.address = ".$serveraddr."\n";
					$output .= "account.$i.label = ".$user_telephoneNumber."\n";
					$output .= "account.$i.display_name = ".$user_cn."\n";
					$output .= "account.$i.user_name = ".$user_telephoneNumber."\n";
					$output .= "account.$i.auth_name = ".$user_telephoneNumber."\n";
					$output .= "account.$i.password = ".$user_loginAccessCode."\n";
					if ($isDect || $supportDect)
						$output .= "handset.$i.name = $user_cn\n";
				}
				else if ($sipLicence)
				{
					$output .= "account.$i.enable = 1\n";
					$output .= "account.$i.sip_server.1.address = ".$serveraddr."\n";
					$output .= "account.$i.label = offline\n";
					$output .= "account.$i.display_name = offline\n";
					$output .= "account.$i.user_name = OFFLINE".$i."-".$mac."\n";
					$output .= "account.$i.auth_name = OFFLINE".$i."-".$mac."\n";
					$output .= "account.$i.password = $mac\n";
					if ($isDect || $supportDect)
						$output .= "handset.$i.name = offline\n";
				}
				else
				{
					$output .= "account.$i.enable = 0\n";
					$output .= "account.$i.sip_server.1.address = 0\n";
					$output .= "account.$i.label = noUser\n";
					$output .= "account.$i.display_name = noUser\n";
					$output .= "account.$i.user_name = noUser\n";
					$output .= "account.$i.auth_name = noUser\n";
					$output .= "account.$i.password = noUser\n";
					if ($isDect || $supportDect)
						$output .= "handset.$i.name = noUser\n";
				}
				if ($havelinekeys)
				{
					$output .= "account.$i.blf.blf_list_uri = SpeedDials\n";
					$output .= "account.$i.blf_list_retrieve_call_parked_code = **\n";
					$output .= "account.$i.number_of_linekey = 1\n";
				}

				if ($sipLicence)
				{
					$output .= "account.$i.direct_pickup_code = **\n";
					$output .= "account.$i.subscribe_mwi = 1\n";
					if ($LDAPCallLogging)
						$output .= "voice_mail.number.$i = %NULL%\n";
					else
						$output .= "voice_mail.number.$i = 1571\n";
				}

				$output .= "account.$i.codec.1.priority = 3\n";
				$output .= "account.$i.codec.2.priority = 2\n";
				$output .= "account.$i.alert_info_url_enable = 0\n";
				//$output .= "account.$i.shared_line_one_touch_bargein.enable = 1\n";
				$output .= "account.$i.dtmf.info_type = 1\n";
				$output .= "account.$i.ringtone.ring_type = Default\n";
				$output .= "account.$i.register_mac = 1\n";
				$output .= "account.$i.register_line = 1\n";

				if ($usestun == 1)
				{
					$output .= "account.$i.nat.nat_traversal = 1\n";
					$output .= "account.$i.sip_server.1.transport_type = 2\n"; //TLS
					$output .= "account.$i.sip_server.1.port = 5061\n";
					$output .= "account.$i.srtp_encryption = 1\n"; //SRTP mode (1 is optional, 2 is compulsory)
				}
				else
				{
					$output .= "account.$i.nat.nat_traversal = 0\n";
					$output .= "account.$i.sip_server.1.transport_type = 1\n"; //TCP=1, UDP=0
					$output .= "account.$i.sip_server.1.port = 5060\n";
					$output .= "account.$i.srtp_encryption = 0\n"; //NOT SRTP
				}
				if ($i < $users['count'])
				{
					$haveuser = true;
					$user = $users[$i];
					
					$user_cn              = $user['cn'][0];
					$user_telephoneNumber = $user['telephonenumber'][0];
					$user_loginAccessCode = $user['loginaccesscode'][0];
				}
				else if ($supportDect)
					break; //don't add hotdesk accounts for missing users/handsets
				else
					$haveuser = false;
			}

			// Apply any customer supplied code
			if (isset($customParam))
				$output .= $customParam;

			//Add random string so phone does not ignore this because it thinks it's seen it before
			$output .="# ".time();

			//Encrypt
			// System or AdminModule start up has generated the key files or we're in trouble
			$fplainkey = "/SpliceCom/Yealink/Aeskey.txt";
			$fenckey   = "yealink_Security.enc";
			if (!file_exists($fenckey) || !file_exists($fplainkey))
			{
				header('HTTP/1.1 500 Internal Server Error');
				exit;
			}
			$bytes2write = strlen($output);
			$descriptorspec = array(
				0 => array("pipe", "r"), // stdin
				1 => array("pipe", "w"), // stdout
				2 => array("pipe", "a") // stderr
			);
			$process = proc_open("/SpliceCom/Yealink/yenc $fplainkey $bytes2write", $descriptorspec, $pipes);
			if (is_resource($process))
			{
				for ($written = 0; $written < $bytes2write; $written += $wrote)
				{
					$wrote = fwrite($pipes[0], substr($output, $written));
					if ($wrote === false)
					{
						header('HTTP/1.1 500 Internal Server Error');
						exit;
					}
				}
				fclose($pipes[0]);
				if (fpassthru($pipes[1]) === false)
				{
					header('HTTP/1.1 500 Internal Server Error');
					exit;
				}
				fclose($pipes[1]);
				fclose($pipes[2]);
				proc_close($process);
			}
			else
			{
				header('HTTP/1.1 500 Internal Server Error');
				exit;
			}

			//print $output; //plain text version
			$ok = true;
		}
	}
	
	if (!$ok)
	{
		// unknown vendor/model
	    header('HTTP/1.1 404 Not Found');
	    exit;
	}

function loadMulticastPaging($ldap, $phoneGuid, $userGuid)
{
	global $output;

	//check for sanity and set up search string
	if (strlen($phoneGuid)==0)
		return;
	$search = "(member=".$phoneGuid.")";
	if (strlen($userGuid)!=0)
		$search = "(|(member=".$userGuid.")".$search.")";
	//print "Looking for ".$search."\n";

	$pchans = ldap_get_entries($ldap, ldap_search($ldap, "cn=PagingChannels", "(objectclass=PagingChannel)", array('cn','distributionGroup','multicastAddress','multicastPort'), 0, 0));
	if (!$pchans)
	{
	    //header('HTTP/1.1 500 Internal Server Error');
	    //exit;
		return; //soft fail for systems with databases missing these fields.
	}
	//print_r($pchans);
	
	//Adjust error reporting to avoid those ldap partial search result warnings
	$errlvl=error_reporting();
	error_reporting($errlvl & ~E_WARNING);

	$index = 1;
	for ($i=0; $i<$pchans['count']; $i++)
	{
		$dist_group_guid = $pchans[$i]['distributiongroup'][0];
		//print_r($dist_group_guid);
		if (strlen($dist_group_guid)==0)
			continue;
		$group = ldap_get_entries($ldap, ldap_search($ldap, "cn=Groups", "(guid=".$dist_group_guid.")", array('cn'),0,1));
		if ($group['count'] > 0)
		{
			//print_r($group);
			//$phones = ldap_get_entries($ldap, ldap_search($ldap, $group[0]['dn'], "(id=*)", array('member'),0,0));
			//print_r($phones);
			$phone = ldap_get_entries($ldap, ldap_search($ldap, $group[0]['dn'], $search, array('member'),0,1));
			//print_r($phone);
			if ($phone['count'] > 0)
			{
				if ($index == 1)
				{
					//SpliceCom phones don't allow pages to interrupt calls or other pages
					//Do the same here
					$output .= "multicast.receive_priority.enable = 0\n";
					$output .= "multicast.receive_priority.priority = 0\n";
				}
				//print "Phone is a member of Paging Channel '".$pchans[$i]['cn'][0]."'\n";
				$output .= "multicast.listen_address.".$index.".label = ".$pchans[$i]['cn'][0]."\n";
				//Note to oneself - ldap_get_entries translates attribute names to lowercase!
				$output .= "multicast.listen_address.".$index.".ip_address = ".$pchans[$i]['multicastaddress'][0].":".$pchans[$i]['multicastport'][0]."\n";
				$index++;
				if ($index > 10)
				{
					break; //phones don't support more than 10 channels.
				}
			}
		}
	}
	error_reporting($errlvl);
}

function setLdapsServerKey($ldaps_server, $serveraddr)
{
	if (file_exists($ldaps_server))
		return;
	if (!touch($ldaps_server)) //create file asap to hold off other parties
		return;
	//attempt locking
	$fp = fopen($ldaps_server, "r+");
	if ($fp === false)
		return;
	if (flock($fp, LOCK_EX | LOCK_NB))
	{
		//Got lock - we are good to go
		// move away old files that might be in use
		rename("ldaps.key", "ldaps-old.key");
		rename("ldaps.cer", "ldaps-old.cer");
		// tidy up old public IP address locks - vary rare and any old files not in use
		foreach (glob("ldaps-*") as $filename)
		{
			if (strcmp($filename, $ldaps_server)!=0)
				unlink($filename);
		}
		// generate new certificate and key
		$rc=0;
		$outp;
		exec("openssl req -x509 -newkey rsa:4096 -keyout ldaps.key -out ldaps.cer -days 3650 -nodes -subj \"/C=UK/ST=Herts/L=Chorleywood/O=SpliceCom Ltd/OU=Org/CN=".$serveraddr."\"",$outp,$rc);
		flock($fp, LOCK_UN);
		fclose($fp);
		if ($rc != 0)
		{
			unlink($ldaps_server); //remove lock if we failed to generate key - give some-one else a go
		}
	}
	else
		fclose($fp);
}

function setFirmware($fullModel, $webServerAddr)
{
	global $output;

	$firmwareDir = "firmware";
	//Custom index takes precedence
	$files = array("customIndex.txt", "webIndex.txt", "index.txt");

	foreach ($files as $index)
	{
		if (file_exists("$firmwareDir/$index") && (($file = fopen("$firmwareDir/$index", "r")) !== FALSE))
		{
			//search file for model
			while (($data = fgetcsv($file, 500, ",")) !== FALSE)
			{
				if (count($data) > 1)
				{
					if (strcmp(trim($data[0]), $fullModel) == 0)
					{
						$filename=trim($data[1]);
						if (count($data) > 2 && strncmp(ltrim($data[2]), "#", 1)!=0)
						{
							$url=trim($data[2]);
							$output .= "firmware.url = http://$url/$filename\n";
							fclose($file);
							return;
						}
						else if (file_exists("$firmwareDir/$filename"))
						{
							$output .= "firmware.url = http://$webServerAddr/prov/$firmwareDir/$filename\n";
							fclose($file);
							return;
						}
					}
				}
			}
			fclose($file);
		}
	}
}

function setTimeZone($timeZoneFile, $timeZones)
{
	global $output;

	if (file_exists($timeZones))
	{
		//find timezone
		//look it up in file
		//if it exists write out timeZoneFile instructions
		//move the csv file so we don't do this again.
		$ok = false;
		if (file_exists($timeZoneFile))
			unlink($timeZoneFile);

		$tz = exec("timedatectl | awk '/Time zone:/{print $3}'");
		if (strlen($tz)==0)
			$tz = exec("timedatectl | awk '/Timezone:/{print $2}'"); //Don't you just love people who change the output format
		if (strlen($tz)==0) //fallback to dodgy date method which can return ambiguous answers
			$tz = exec("date +%Z");
		if (strlen($tz)!=0)
		{
			if (($file = fopen("$timeZones", "r")) !== FALSE)
			{
				//search file for TZ
				while (($data = fgetcsv($file, 500, ",")) !== FALSE)
				{
					if (count($data) > 2)
					{
						if (strcmp(trim($data[0]), $tz) == 0)
						{
							$offset=trim($data[1]);
							$name=trim($data[2]);
							$tzOutput  = '$output .= "local_time.time_zone = '.$offset.'\n";'."\n";
							$tzOutput .= '$output .= "local_time.time_zone_name = '.$name.'\n";'."\n";
							$tzOutput .= '$output .= "local_time.summer_time = 2\n";'."\n";
							$wdata = "<?php\n".$tzOutput."?>\n";
							if (file_put_contents($timeZoneFile, $wdata, LOCK_EX) !== false)
							{
								include $timeZoneFile;
								$ok = true;
							}
							break;
						}
					}
				}
				fclose($file);
			}
		}
		rename($timeZones, $timeZones.".done");
		if ($ok)
			return;
	}

//**** The Old way ******
	//set time zone 
	// This is set in php.ini for php5 systems. (callserver is 4.3.10)
	// It is not adjusted from UTC when manager utilities sets the timezone
	//  therefore we must avoid php calls as they always return UTC
	//$tz = date("O");
	$tz = exec("date +%z");
	//$output .= "local_time.time_zone = ".substr($tz,0,3).":".substr($tz,3)."\n";
	// and handle phone foibles
	$output .= "local_time.time_zone = ";
	if ($tz === "+0000")
		$output .="0\n";
	else
	{
		$output .= substr($tz,0,1); //add sign
		if ($tz[1] == '0') //delete leading zero
			$output .= substr($tz,2,1);
		else
			$output .= substr($tz,1,2);
		$mins = substr($tz,3);
		if ($mins !== "00") //only add non zero minutes
			$output .= ":".$mins;
		$output .= "\n";
	}
	//Date gives the current GMT offset and takes daylight savings into account
	//The phone can do automatic DST but needs a valid country string in local_time.time_zone_name
	// for it to work and this would require a huge table of allowed strings against time zone
	//We'll turn it off for now
	$output .= "local_time.summer_time = 0\n";
}

?>
