<?php

//	error_reporting(0);

	$mac = $_GET['mac'];

	$ldap = ldap_connect("127.0.0.1", 4000);
	if (!$ldap)
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}
	if (!ldap_bind($ldap, "INTERNAL", "112233445566"))
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}

	//System knows this phone?
	$result = ldap_get_entries($ldap, ldap_search($ldap, "", "(PhoneSerialNumber=".$mac.")", array('objectclass','usestun'), 0, 1));
	if (!$result || $result[0]['objectclass'][0] != "GenericIPPhone")
	{
		header('HTTP/1.1 404 Not Found');
	    exit;
	}

	//OK so we have an allowed MAC address.
	$phone_1_dn = $result[0]['dn'];
	$dna = ldap_explode_dn($phone_1_dn, 0);
	$module_dn = $dna[2];
	for ($i=3; $i<$dna['count']; $i++)
		$module_dn .= ",".$dna[$i];

	$usestun  = $result[0]['usestun'][0];
	if ($usestun)
	{
		$result = ldap_get_entries($ldap, ldap_read($ldap, "cn=1,".$module_dn, "(objectclass=*)", array('publicIPAddress'), 0, 1));
		if (!$result)
		{
			header('HTTP/1.1 500 Internal Server Error');
			exit;
		}
		$serveraddr = $result[0]['publicipaddress'][0];
	}
	else
	{
		$result = ldap_get_entries($ldap, ldap_read($ldap, $module_dn, "(objectclass=*)", array('ipaddress'), 0, 1));
		if (!$result)
		{
		    header('HTTP/1.1 500 Internal Server Error');
		    exit;
		}
		$serveraddr = $result[0]['ipaddress'][0];
	}

	// Read in any customer supplied code
	$webServerAddr = $serveraddr;
	$webServerAddrSecure = $serveraddr;
	$custom = "custom_yealink.php";
	$customParam = "";
	if (file_exists($custom))
	{
		include $custom;
		if (isset($httpPort))
			$webServerAddr .= ":$httpPort"; //Some customers hate opening port 80
		if (isset($httpsPort))
			$webServerAddrSecure .= ":$httpsPort";
	}

	//login occurs in 3 phases: Clear history, get user info, update user info
	$phase = $_GET['phase'];

	$xml  ="<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
	switch($phase)
	{
		case "clear":
			$xml .="<YealinkIPPhoneExecute Beep=\"no\">\n";
			$xml .="<ExecuteItem URI=\"Command: ClearCallersList\" />\n";
			$xml .="<ExecuteItem URI=\"Command: ClearDirectory\" />\n";
			$xml .="<ExecuteItem URI=\"Command: ClearRedialList\" />\n";
			$xml .="<ExecuteItem URI=\"http://$webServerAddr/prov/login.php?mac=$mac&phase=getuser\" />\n";
			$xml .="</YealinkIPPhoneExecute>\n";
			break;
		case "getuser":
			$xml .="<YealinkIPPhoneInputScreen destroyOnExit=\"yes\" Beep=\"no\" displayMode=\"condensed\">\n";
			$xml .="<Title>Login Info</Title>\n";
			$xml .="<URL>https://$webServerAddrSecure/prov/login.php?mac=$mac&phase=updateuser</URL>\n";
			$xml .="<cancelAction>http://$webServerAddr/prov/login.php?mac=$mac&phase=updateuser</cancelAction>\n";

			$xml .="<InputField type=\"string\" password=\"no\" editable=\"yes\">\n";
			$xml .="<Prompt>User:</Prompt>\n";
			$xml .="<Parameter>user</Parameter>\n";
			$xml .="<Default></Default>\n";
			$xml .="</InputField>\n";

			$xml .="<InputField type=\"string\" password=\"yes\" editable=\"yes\">\n";
			$xml .="<Prompt>Password:</Prompt>\n";
			$xml .="<Parameter>pw</Parameter>\n";
			$xml .="<Default></Default>\n";
			$xml .="</InputField>\n";

			$xml .="</YealinkIPPhoneInputScreen>\n";
			break;
		case "updateuser":
			$user = $_GET['user'];
			$pw = $_GET['pw'];
			$xml .="<YealinkIPPhoneConfiguration Beep=\"no\">\n";

			$xml .="<Item>account.1.enable = 1</Item>\n";
			if (strlen($user)==0)
			{
				$xml .="<Item>account.1.label = offline</Item>\n";
				$xml .="<Item>account.1.display_name = offline</Item>\n";
				$xml .="<Item>account.1.user_name = OFFLINE1-$mac</Item>\n";
				$xml .="<Item>account.1.auth_name = OFFLINE1-$mac</Item>\n";
				$xml .="<Item>account.1.password = $mac</Item>\n";

				$xml .="<Item>ldap.enable = 0</Item>\n";
				$xml .="<Item>ldap.user = -</Item>\n"; //Note: blank entries do not delete current data; so use a '-'
				$xml .="<Item>ldap.password = -</Item>\n";

				//disable call history so that login information is not stored
				$xml .="<Item>features.save_call_history = 0</Item>\n";
			}
			else
			{
				//The displayname is taken from the user cn, so let's find it.
				$users = ldap_get_entries($ldap, @ldap_search($ldap, "cn=Users", "(&(objectclass=User)(telephoneNumber=".$user."))", array('cn'), 0, 1));
				$user_cn = $users[0]['cn'][0];
				if (strlen($user_cn)==0)
					$user_cn = $user;
				$xml .="<Item>account.1.label = $user</Item>\n";
				$xml .="<Item>account.1.display_name = $user_cn</Item>\n";
				$xml .="<Item>account.1.user_name = $user</Item>\n";
				$xml .="<Item>account.1.auth_name = $user</Item>\n";
				$xml .="<Item>account.1.password = $pw</Item>\n";

				$xml .="<Item>ldap.enable = 1</Item>\n";
				$xml .="<Item>ldap.user = $user</Item>\n";
				$xml .="<Item>ldap.password = $pw</Item>\n";

				//re-enable call history
				$xml .="<Item>features.save_call_history = 1</Item>\n";
			}

			$xml .="</YealinkIPPhoneConfiguration>\n";
			break;
		default:
			header('HTTP/1.1 404 Not Found');
			exit;
	}
	print $xml;

?>
