<html>
<body>
<?php
	// ************************************************
	// Change the following to match your CONFIGURATION
	$filename   = "wakeup_user.php";
    $exec_filename   = "wakeup_vxml.php";
	$vmportname = "BuiltIn";
	$vmportlocation = "";
	
	// The following can be used if hosted on the actual call server if not proper authentication is required
    $server = "127.0.0.1";
    $user_login = "INTERNAL";
    $user_password = "123456";
    
    $failedtelephonenumber="300";
    $retrymax = "1";
    $retryinterval = "30";

	session_start();

    $command = $_GET['command'];
    if ($command == "")
        $command = $_POST['command'];

	$ds=ldap_connect($server.":4000");  // must be a valid LDAP server!
	if ($ds)
	{
		$r=ldap_bind($ds,$user_login, $user_password);
		if (!$r)
		{
			echo "<h4>Unable to bind to LDAP server as ".$user_login."</h4>";
			ldap_close($ds);
			$ds = 0;
		}
	}
	else
	{
		echo "<h4>Unable to connect to LDAP server</h4>";
	}
	
	if ($ds)
	{
		if( !isset($_SESSION['vmport']) )
		{
			$_SESSION['vmport'] = LdapGetVmPort( $ds , $vmportname, $vmportlocation);
		}
		$vmport = $_SESSION['vmport'];
        
        if( !isset($_SESSION['source']) )
        {
            $_SESSION['source']=$_REQUEST['n'];
        }
        $num=$_SESSION['source'];
        
        if( !isset($_SESSION['name']) )
        {
            $_SESSION['name']= LdapGetName($ds,$num);
        }
        $name=$_SESSION['name'];
        
		printf("<h1>Wake Up Calls for %s (%s)</h1>\n",$name,$num);
        
		$message = $_GET['m'];
		if ($message == "")
			$message = $_POST['m'];
		
		if ($message != "")
		{
			if ($command == "change")
			{
                $starttime = $_POST['starttime'];
                if( strlen(starttime == 3 ) )
                {
                    $starttime = "0".$starttime;
                }
                else if( strlen(starttime == 2 ) )
                {
                    $starttime = "00".$starttime;
                }
                $start_hour = substr($starttime, -4, 2);
                $start_min  = substr($starttime, -2, 2);
				
				$date = getdate();
				$cur_hour = $date['hours'];
				$cur_min  = $date['minutes'];
                
                $startdate = "";
				
				if( $start_hour < $cur_hour || ( $start_hour == $cur_hour && $start_min < $cur_min ) )  // Before now
				{
					$tomorrow = 1;
					$date = getdate( time() + (60*60*24) );  // Get now + 24 hours
					$cur_mday = $date['mday'];
					$cur_month= $date['mon'];
					$cur_year = substr($date['year'],-2,2);
					
					$startdate = sprintf("%02d%02d%02d",$cur_mday,$cur_month,$cur_year);
				}
				// ldap modify
				$attr['starttime'] = $_POST['starttime'];
				$attr['startdate'] = $startdate;
				ldap_modify($ds, "guid=".$message, $attr);
				$message = "";
			}
			else if ($command == "delete")
			{
				ldap_delete($ds, "guid=".$message);
				$message = "";
			}
			else if ($command == "list")
			{
				$message = "";
			}
		}
		else
		{
			if ($command == "change")
			{
                $starttime = $_POST['starttime'];
                if( strlen(starttime == 3 ) )
                {
                    $starttime = "0".$starttime;
                }
                else if( strlen(starttime == 2 ) )
                {
                    $starttime = "00".$starttime;
                }
                $start_hour = substr($starttime, -4, 2);
                $start_min  = substr($starttime, -2, 2);
				
				$date = getdate();
				$cur_hour = $date['hours'];
				$cur_min  = $date['minutes'];
                
                $startdate = "";
				
				if( $start_hour < $cur_hour || ( $start_hour == $cur_hour && $start_min < $cur_min ) )  // Before now
				{
					$date = getdate( time() + (60*60*24) );  // Get now + 24 hours
					$cur_mday = $date['mday'];
					$cur_month= $date['mon'];
					$cur_year = substr($date['year'],-2,2);
					$startdate = sprintf("%02d%02d%02d",$cur_mday,$cur_month,$cur_year);
				}
                
				// ldap add
				$attr['objectclass']            = "ScheduledCall";
				$attr['organiser']              = $num;
				$attr['startdate']              = $startdate;
				$attr['starttime']              = $_POST['starttime'];
				$attr['telephonenumber']        = $num;
				$attr['command']                = "!EA:http://127.0.0.1/".$exec_filename."?cmd=alarm&n=".$num."&success=1";
				$attr['failtelephonenumber']    = $failedtelephonenumber;
				$attr['failcommand']            = "!EA:http://127.0.0.1/".$exec_filename."?cmd=alarm&n=".$num."&success=0";
				$attr['retryinterval']          = $retryinterval;
				$attr['retrymax']               = $retrymax;
				$dn = "datetime=".gmdate("ymdHis").",guid=".$vmport;
				ldap_add($ds, $dn, $attr);
				$message = "";
			}
		}            
		
		if ($message == "" && $command != "add")
		{
			// display list of ScheduledCalls
            $sr=ldap_search($ds, "guid=".$vmport, "(&(objectclass=ScheduledCall)(telephoneNumber=".$num."))",array(),0,0); 
			$o = ldap_get_entries($ds, $sr);

			print "<table>\n";
			print "<tr><bold>\n";
			print "<td></td>\n";
			print "<td>Start Time</td>\n";
			print "</bold></tr>\n";
			
            $date = getdate(time() + (60*60*24));                       // Check if set for tomorrow
            $tom_mday = $date['mday'];
            $tom_month= $date['mon'];
            $tom_year = substr($date['year'],-2,2);
            $tom_startdate = sprintf("%02d%02d%02d",$tom_mday,$tom_month,$tom_year);
            
			$n = 1;
			for ($i=0; $i<$o['count']; $i++)
			{
				print "<tr>\n";
				print "<td><a href=\"".$filename."?m=".$o[$i]['guid'][0]."\">".$n."</a></td>";
                $tomorrow=0;
                if( $o[$i]['startdate'][0] == $tom_startdate )
                {
                    print "<td>".$o[$i]['starttime'][0]." tomorrow</td>";
                }
                else
                {
                    print "<td>".$o[$i]['starttime'][0]."</td>";
                }
				print "</tr>\n";
				$n++;
			}
			print "</table>\n";

			print "<br><form action=\"".$filename."\" method=\"post\" enctype=\"multipart/form-data\">\n";
			print "<button name=\"command\" value=\"refresh\" type=\"submit\">Refresh</button>\n";
			print "<button name=\"command\" value=\"add\" type=\"submit\">Add</button>\n";
			print "</form>\n";
		}
		else                
		{
			// display ScheduledCall
			if ($message != "")
			{
				$sr=ldap_read($ds, "guid=".$message, "objectclass=*");
				$o = ldap_get_entries($ds, $sr);
			}
			print "<form action=\"".$filename."\" method=\"get\" enctype=\"multipart/form-data\">\n";
			print "<input type=\"hidden\" name=\"m\" value=\"".$message."\"/>\n";
			print "<button name=\"command\" value=\"list\" type=\"submit\"/>List</button>\n";
			print "</form>\n";
			

			print "<form action=\"".$filename."\" method=\"post\" enctype=\"multipart/form-data\">\n";
			print "<input type=\"hidden\" name=\"m\" value=\"".$message."\"/>\n";
			
			print "<table>\n";
			print "<tr><td>Start Time</td><td><input name=\"starttime\" value=\"".$o[0]['starttime'][0]."\" type=\"string\"/></td></tr>\n";
			print "</table>";
			print "<button name=\"command\" value=\"change\" type=\"submit\">Submit</button>\n";
			print "<button name=\"command\" value=\"delete\" type=\"submit\">Delete</button>\n";
			print "</form>\n";
		}
		ldap_close($ds);
	}

    
// Helpful functions to make the above code easier
function LdapGetName($ds,$num)
{
	$name = "";
	if ($num != "" && $ds)
	{
		$myAttr = array("cn");		// The specific attributes we need - this will increase performance since a user can have a lot of attributes
		$sr=ldap_search($ds, "", "(GlobalExtnNumber=".$num.")",$myAttr,0,1); 	// Optimized special key search
		$o = ldap_get_entries($ds, $sr);
		if ($o['count'] != 0)					// If we have some answers
		{  
			$name = $o[0]['cn'][0];				// Extract the name (common name = cn) attribute
		}
	}
	return $name;
}

function LdapGetVmPort($ds,$vmportname,$vmportlocation)
{
    if( $vmportlocation )
    {
        $sr=ldap_read($ds, "cn=$vmportlocation,cn=Modules","(objectclass=Module)",array("guid","cn"),0,1); 
        $o = ldap_get_entries($ds, $sr);
        if ($o['count'] != 0)
        {
            $location = $o[0]['guid'][0];
        }
    }
    else
    {
        $location = "00000000-0000-0000-0000-000000000000";
    }
    
    if( $location )
    {
		$sr=ldap_list($ds, "cn=VoicemailPorts","(&(location=$location)(cn=$vmportname))",array("guid","cn"),0,0); 
		$o = ldap_get_entries($ds, $sr);
		if ($o['count'] != 0)
		{
			$vmport = $o[0]['guid'][0];
			return $vmport;
		}
	}
	return "notfound";
}
    
?>

</body>
</html>

