<?php
	// All script inside these brackets (less than question mark and question mark greater than) is PHP script
	// all other script is VXML
    // ini_set("url_rewriter.tags", "");
    // session_start();
    // error_reporting(0);
    print "<?xml version=\"1.0\" ?>\n";
?>
<!DOCTYPE vxml PUBLIC "SpeechBrowser/2.0/DTD" "ignore" >
<vxml version="2.0">

<?php
	// ************************************************
	// Change the following to match your CONFIGURATION
	$filename   = "wakeup_vxml.php";
	$vmportname = "BuiltIn";
	$vmportlocation = "";
	
	// The following can be used if hosted on the actual call server if not proper authentication is required
    $server = "127.0.0.1"; 
    $user_login = "INTERNAL";
    $user_password = "123456";
    
    $failedtelephonenumber="300";
    $retrymax = "1";
    $retryinterval = "30";
    
	// ************************************************


	// Now pickup the standard always present parameters (source number and command)
	
	if ($_SERVER['SERVER_PORT'])				// We are running from a web server
	{
    	$cmd = $_REQUEST['cmd'];
	    $num = $_REQUEST['n'];
	}
	else										
	{
        // We are running from a command line (e.g. crontab)
        // Example use:  php /Web/wakeup_vxml.php submit 307 0700
        // Example use:  php /Web/wakeup_vxml.php cancel 307
		$cmd = $argv[1];
		$num = $argv[2];
		$starttime = $argv[3];
		print "cmd=$cmd num=$num starttime=$starttime\n";
    }


	// Now interpet the specific command
    if ($cmd == "")														// DEFAULT Command to Ask what to do - create or cancel 
    {
		// Lets lookup the name of the calling party    
		$ds = LdapConnect($server,$user_login,$user_password);
		$name = LdapGetName($ds,$num);
        $vmport = LdapGetVmPort($ds,$vmportname,$vmportlocation);
        $sr=ldap_search($ds, "guid=".$vmport, "(&(objectclass=ScheduledCall)(telephoneNumber=".$num."))"); 
        $o = ldap_get_entries($ds, $sr);
        if ($o['count'] != 0)
        {
            $cur_starttime = $o[0]['starttime'][0];
            $cur_startdate = $o[0]['startdate'][0];
            
            $date = getdate(time() + (60*60*24));                       // Check if set for tomorrow
            $cur_mday = $date['mday'];
            $cur_month= $date['mon'];
            $cur_year = substr($date['year'],-2,2);
            $startdate = sprintf("%02d%02d%02d",$cur_mday,$cur_month,$cur_year);
            $tomorrow=0;
            if( $startdate == $cur_startdate )
            {
                $tomorrow=1;
            }
        }
		LdapClose($ds);
?>
        <menu id="menu">
            <property name="inputmodes" value="dtmf"/>
            <prompt>hello</prompt>
<?php
            SpeakRoom($name,$num);
?>
            <prompt>Welcome to the Splice com maximiser system.</prompt>
<?php
            if( $cur_starttime )
            {
                print "<prompt>You have an alarm set for</prompt>\n";
                SpeakTime($cur_starttime);
                if( $tomorrow )
                {
                    print "<prompt>tomorrow</prompt>\n";
                }
            }
            print "<prompt>Press one to setup an alarm call, or two to cancel.</prompt>\n";
            print "<choice dtmf=\"1\" next=\"".$filename."?cmd=create&amp;n=".$num."\"/>\n";
            print "<choice dtmf=\"2\" next=\"".$filename."?cmd=cancel&amp;n=".$num."\"/>\n";
            print "<choice dtmf=\"0\" next=\"#mydisconnect\"/>\n";
?>
        </menu>
            
        <form id="mydisconnect">
            <block>
                <disconnect/>
            </block>
        </form>

<?php
    }
    else if ($cmd == "create")											// CREATE and wakeup call prompt in 24hr format
    {
?>
        <form id="setup">
            <catch event="telephone.disconnect.hangup">
                <exit/>
            </catch>
            
            <var name="cmd" expr="'submit'"/>
<?php
            print "<var name=\"n\" expr=\"'".$num."'\"/>\n";
?>
            <field name="starttime" type="digits?length=4">
                <property name="timeout" value="10s"/>
                <property name="bargein" value="true"/>
                <prompt>Enter the time in 24 hour format</prompt>
                <filled>
<?php
  				print '<submit next="'.$filename.'" enctype="multipart/form-data" method="post" namelist="cmd n starttime"/>\n';
?>
                </filled>
            </field>
        </form>
        
<?php
    }
    else if ($cmd == "submit")										// SUBMIT this form to the database after user enter correct format
    {
        // check for existing scheduled call
        // if found, delete it
        if( !isset($starttime) )
	        $starttime = $_REQUEST['starttime'];
		$startdate="";
		
		$start_hour = substr($starttime, -4, 2);
		$start_min  = substr($starttime, -2, 2);
			
		if( $start_hour < 0 || $start_hour > 23 || $start_min < 0 || $start_min > 59 )
		{
?>
			<form id="submitfailed">
				<block>
                    <prompt>I am sorry.  That is not a valid time</prompt>
<?php
                    print "<goto next=\"$filename?cmd=create&amp;n=$num\"/>\n";
?>
				</block>
			</form>
<?php
		}
		else
		{
			$ds = LdapConnect($server,$user_login,$user_password);
			if ($ds)
			{
				$vmport = LdapGetVmPort($ds,$vmportname,$vmportlocation);
				$sr=ldap_search($ds, "guid=".$vmport, "(&(objectclass=ScheduledCall)(telephoneNumber=".$num."))"); 
				$o = ldap_get_entries($ds, $sr);
				if ($o['count'] != 0)
				{
					$guid = $o[0]['guid'][0];
					ldap_delete($ds, "guid=".$guid);
				}
				
				// add new scheduled call
				
				$date = getdate();
				
				$cur_hour = $date['hours'];
				$cur_min  = $date['minutes'];
				
				if( $start_hour < $cur_hour || ( $start_hour == $cur_hour && $start_min < $cur_min ) )  // Before now
				{
					$tomorrow = 1;
					$date = getdate( time() + (60*60*24) );  // Get now + 24 hours
					$cur_mday = $date['mday'];
					$cur_month= $date['mon'];
					$cur_year = substr($date['year'],-2,2);
					
					$startdate = sprintf("%02d%02d%02d",$cur_mday,$cur_month,$cur_year);
				}
	
				$attr['objectclass']            = "ScheduledCall";
				$attr['organiser']              = $num;
				$attr['startdate']              = $startdate;
				$attr['starttime']              = $starttime;
				$attr['telephonenumber']        = $num;
				$attr['command']                = "!EA:http://127.0.0.1/".$filename."?cmd=alarm&n=".$num."&success=1";
				$attr['failtelephonenumber']    = $failedtelephonenumber;
				$attr['failcommand']            = "!EA:http://127.0.0.1/".$filename."?cmd=alarm&n=".$num."&success=0";
				$attr['retryinterval']          = $retryinterval;
				$attr['retrymax']               = $retrymax;
				$dn = "datetime=".gmdate("ymdHis").",guid=$vmport";
				ldap_add($ds, $dn, $attr);
				LdapClose($ds);
			}
	?>
	  
			<form id="submit">
				<block>
					<prompt>alarm set for</prompt>
	<?php
					SpeakTime($starttime);
					if( $tomorrow )
					{
						print "<prompt>tomorrow</prompt>\n";
					}
					print "<prompt>thank you</prompt>\n";
	?>
				</block>
			</form>
	<?php
		}
    }
    else if ($cmd == "cancel")												// CANCEL alarm call on this extension
    {
        // check for existing scheduled call
        // if found, delete it
		$ds = LdapConnect($server,$user_login,$user_password);
        if ($ds)
        {
			$name = LdapGetName($ds,$num);
		    $vmport = LdapGetVmPort($ds,$vmportname,$vmportlocation);
            $sr=ldap_search($ds, "guid=".$vmport, "(&(objectclass=ScheduledCall)(telephoneNumber=$num))"); 
            $o = ldap_get_entries($ds, $sr);
            if ($o['count'] != 0)
            {
                $guid = $o[0]['guid'][0];
                ldap_delete($ds, "guid=$guid");
            }
            LdapClose($ds);
        }
?>
        <form id="cancel">
            <block>
                <prompt>alarm cancelled for</prompt>
<?php
				SpeakRoom($name,$num);
?>
            </block>
        </form>
        
<?php
    }
    else if ($cmd == "alarm")												// ALARM has gone off
    {
        $status = $_REQUEST['success'];		// check if good or bad
		$ds=LdapConnect($server,$user_login,$user_password);
		$name = LdapGetName($ds,$num);
		LdapClose($ds);
        if ( $status == "1")
        {
?>
            <form id="alarm">
                <block>
<?php
				for($i=1; $i < 5; $i++)
				{
					print "<prompt> this is your requested alarm call for </prompt>\n";
					SpeakRoom($name,$num);
				}
?>                
				<prompt>Goodbye</prompt>
				<disconnect/>
                </block>
            </form>
<?php
        }
        else
        {
?>
            <form id="alarmfail">
                <block>
<?php
                    for($i=1; $i < 5; $i++)
                    {
                    	print "<prompt> alarm call for </prompt>\n";
						SpeakRoom($name,$num);
						SpeakRoom("",$num);
                    	print "<prompt> has not answered </prompt>\n";
                    }
?>
				<prompt>Goodbye</prompt>
                <disconnect/>
                </block>
            </form>
<?php
        }
    }
    else
    {
?>
        <form>
            <block>
                <prompt>I am sorry I do not understand the command</prompt>
<?php
				print "<prompt>$cmd</prompt>"; 
?>
            </block>
        </form>
<?php
    }
?>

</vxml>

<?php
// The following code is pure PHP and and does not contain any VXML
// Helpful functions to make the above code easier
function LdapConnect($server,$user_login,$user_password)
{
    $ds=ldap_connect($server.":4000");  // must be a valid LDAP server!
    if ($ds)
    {
        $r=ldap_bind($ds, $user_login, $user_password);
        if (!$r)
        {
            ldap_close($ds);
            $ds = 0;
        }
    }
    return $ds;
}

function LdapClose($ds)
{
    ldap_close($ds);
}

function LdapGetName($ds,$num)
{
	$name = "";
	if ($num != "" && $ds)
	{
		$myAttr = array("cn");		// The specific attributes we need - this will increase performance since a user can have a lot of attributes
		$sr=ldap_search($ds, "", "(GlobalExtnNumber=".$num.")",$myAttr,0,1); 	// Optimized special key search
		$o = ldap_get_entries($ds, $sr);
		if ($o['count'] != 0)					// If we have some answers
		{  
			$name = $o[0]['cn'][0];				// Extract the name (common name = cn) attribute
		}
	}
	return $name;
}

function LdapGetVmPort($ds,$vmportname,$vmportlocation)
{
    if( $vmportlocation )
    {
        $sr=ldap_read($ds, "cn=$vmportlocation,cn=Modules","(objectclass=Module)",array("guid","cn"),0,1); 
        $o = ldap_get_entries($ds, $sr);
        if ($o['count'] != 0)
        {
            $location = $o[0]['guid'][0];
        }
    }
    else
    {
        $location = "00000000-0000-0000-0000-000000000000";
    }
    
    if( $location )
    {
		$sr=ldap_list($ds, "cn=VoicemailPorts","(&(location=$location)(cn=$vmportname))",array("guid","cn"),0,0); 
		$o = ldap_get_entries($ds, $sr);
		if ($o['count'] != 0)
		{
			$vmport = $o[0]['guid'][0];
			return $vmport;
		}
	}
	return "notfound";
}

function SpeakRoom($name,$num)
{
	if( $name!="" )
    {
        print "<prompt>$name</prompt>\n";
    }
    else
    {
        print "<prompt>Room number </prompt>\n";
        for ($i=0; $num[$i] != ""; $i++)
        {
            print "<prompt>".$num[$i]."</prompt>\n";
        }
    }
}

function SpeakTime($t)
{
    if( strlen($t) == 3 )
    {
        $t="0".$t;
    }
    else if( strlen($t) == 2 )
    {
        $t="00".$t;
    }
	$hour = substr($t, -4, 2);
	$min = substr($t, -2, 2);
	if( $min == "00" )
	{
		$min = " hundred hours";
	}
    print "<prompt>$hour</prompt>\n";
    print "<prompt>$min</prompt>\n";
}

?>

