$(document).ready(function() {
	
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});
	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
	
	originalFormData = $(".alternate, .drEnable ").serialize();
	
	// autocomplete dropdown function
    $.widget( "custom.catcomplete", $.ui.autocomplete, {
      _create: function() {
        this._super();
        this.widget().menu( "option", "items", "> :not(.ui-autocomplete-category)" );
      },
      _renderMenu: function( ul, items ) {
        var that = this,
          currentCategory = "";
        $.each( items, function( index, item ) {
          var li;
          if ( item.category != currentCategory ) {
            ul.append( "<li class='ui-autocomplete-category'>" + item.category + "</li>" );
            currentCategory = item.category;
          }
          li = that._renderItemData( ul, item );
          if ( item.category ) {
            li.attr( "aria-label", item.category + " : " + item.label );
          }
        });
      }
    });
     
	// autocomplete
    $( ".alternate" ).catcomplete({
		source: 'search.php',
		autoFocus: true, 
		minLength: 2,
		delay: 0
    });
	
	// bind to .alternate & .drEnable
	$("#results").on('change', '.alternate, .drEnable', function(e) {
		if (this.className != 'drEnable') {
			var reg = new RegExp('^[a-zA-Z0-9#?!:.\\\\\/ ]+$');
			if (reg.test($(this).val()) == false && $(this).val().trim() != '') {
				var n = noty({ type: 'error', layout: 'center', text: 'Error: Alternate Number Contains Invalid Characters<br><br><i>Click to Close</i>', dismissQueue: true, theme: 'relax', modal: true,  maxVisible: 1 });
				return false;
			}
		}
		var thisID = this.id.match(/\d+/);
		var numbermatch = $('#numbermatch' +thisID).val()
		numbermatch = (numbermatch.length >=1) ? numbermatch : 'Blank Number Match';
		var currentTranslateTo = $('#translateto' + thisID).val();
		var currentAlternate = $('#alternateNumber' + thisID).val();
		
		// drEnabled and checked ?
		if ( $(this).attr('class') === 'drEnable' && $(this).is(':checked') ) {
			
			// check for blank entries.
			if (currentTranslateTo.length < 1 || currentAlternate.length < 1) {
				$(this).prop('checked', false);
				var n = noty({ type: 'error', layout: 'center', text: 'Error: DDI Entry Translate To and Alternate Number Must Be Set<br><br><i>Click to Close</i>', dismissQueue: true, theme: 'relax', modal: true,  maxVisible: 1 });
				return false;
			}
			
			// checked apply settings
			$('#translateto' + thisID).val(currentAlternate);
			$('#alternateNumber' + thisID).val(currentTranslateTo);
			var n = noty({ type: 'warning', layout: 'topRight', text: 'Alternate Number Routing Enabled: <br><span class="GreyBold">' + numbermatch + '</span> to <span class="GreyBold">' + currentAlternate + '</span><br><i>settings need to be saved</i>', dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 1200 });
			
		// drEnabled and unchecked ?	
		} else if ( $(this).attr('class') === 'drEnable' && !$(this).is(':checked') ) {
		
			// unchecked apply settings
			$('#translateto' + thisID).val(currentAlternate);
			$('#alternateNumber' + thisID).val(currentTranslateTo);
			var n = noty({ type: 'information', layout: 'topRight', text: 'Alternate Number Routing Disabled: <br><span class="GreyBold">' + numbermatch + '</span> to <span class="GreyBold">' + currentAlternate + '</span><br><i>settings need to be saved</i>', dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 1200 });
		}
		
		// check for changes
		if (originalFormData !== $('.alternate, .drEnable').serialize()) {
			showBanner();
		} else {
			hideBanner();
		}
	});	
	
	// Save Entries
	$(".buttonSave").click(function(e) {
		
		var n = noty({
        type: 'warning', layout: 'center', text: 'Save Visible Alternate Number Entries ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons : [ 
		{ addClass: 'btn btn-primary', text: 'Save Visible', onClick: function ($noty) {
			
		var ddiPlan = $('#ddiplan option:selected').text();
		$('#changeBanner').remove();
		originalFormData = $('.alternate, .drEnable').serialize();
		
		submitFormData = $('#routes').serialize();
		$.ajax({ 
			type: "POST",
			cache: false,
			data: submitFormData,
			url: "drActions.php?mode=save&ddiPlan=" + encodeURIComponent(ddiPlan),   
			async: true,
			success : function(data) {
				var banner =$("<div id='changeBanner' class='banner saved'>DDI Alternate Number Settings Have Been Saved</div>");
				$('body').prepend(banner);
				banner.delay(2000).slideUp(500, function () { $('#changeBanner').remove(); });	
				$('.buttonSave').css('display', 'none');
			}
			});
		
			$noty.close(); 
			}
        },
		{ addClass: 'btn btn-warning', text: 'Cancel', onClick: function ($noty) {
            $noty.close(); 
			}
		}		
		] 
		});
	});
		
	
	
	
	var duplicateReset = clearReset = '';
	
	$(".toggleAll").click(function(e) {
		var checkedBoxes = $(":checkbox:checked").length;
		
		if (checkedBoxes < 1) {
			var n = noty({
				type: 'warning', layout: 'center', text: 'Set Alternate Mode For Visible Alternate Number Entries ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
				buttons : [ 
				{ addClass: 'btn btn-primary', text: 'Enable Visible', onClick: function ($noty) {
					$('input:checkbox').each(function () {
					var thisID = $(this).attr('id').replace('drMode', '');
					var currentTranslateTo = $('#translateto' + thisID).val();
					var currentAlternate = $('#alternateNumber' + thisID).val();
					
					if ( !$(this).is(':checked') ) {
						if (currentTranslateTo.length >= 1 && currentAlternate.length >= 1) {
							$(this).prop('checked', true);
							$('#translateto' + thisID).val(currentAlternate);
							$('#alternateNumber' + thisID).val(currentTranslateTo);
						}
					}
					});
					updateBanner();
					$noty.close(); 
					}
				},
				{ addClass: 'btn btn-warning', text: 'Cancel', onClick: function ($noty) {
					$noty.close(); 
					}
				}		
				] 
			});
		} else {
			var n = noty({
				type: 'warning', layout: 'center', text: 'Set Alternate Mode For Visible Alternate Number Entries ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
				buttons : [ 
				{ addClass: 'btn btn-danger', text: 'Disable Visible', onClick: function ($noty) {
					$('input:checkbox').each(function () {
					var thisID = $(this).attr('id').replace('drMode', '');
					var currentTranslateTo = $('#translateto' + thisID).val();
					var currentAlternate = $('#alternateNumber' + thisID).val();
					
					if ( $(this).is(':checked') ) {
						if (currentTranslateTo.length >= 1 && currentAlternate.length >= 1) {
							$(this).prop('checked', false);
							$('#translateto' + thisID).val(currentAlternate);
							$('#alternateNumber' + thisID).val(currentTranslateTo);
						}
					}
					});
					updateBanner();
					$noty.close(); 
					}
				},
				{ addClass: 'btn btn-warning', text: 'Cancel', onClick: function ($noty) {
					$noty.close(); 
					}
				}		
				] 
			});
		}
	});
	
	$(".duplicateAll").click(function(e) {
		var checkedBoxes = $(":checkbox:checked").length;
		if (checkedBoxes > 0) {
			var n = noty({ type: 'error', layout: 'center', text: 'Feature Unavailable as Alternate Mode is Enabled', dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 1500 });
			return false;
		}

		if (duplicateReset != 1) {
			duplicateMsg = 'Duplicate First Alternate Number To Visible Entries ?'
			duplicateBtn = 'Duplicate To Visible Entries';
		} else {
			duplicateMsg = 'Reset Visible Entries ?';
			duplicateBtn = 'Reset Visible Entries';
		}  
		
		var n = noty({
        type: 'warning', layout: 'center', text: duplicateMsg, dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons : [ 
		{ addClass: 'btn btn-primary', text: duplicateBtn, onClick: function ($noty) {
			
		if (duplicateReset !== 1) { 
			var val = $('#alternateNumber0').val();

			if (val.length <1) {
				var n = noty({ type: 'error', layout: 'center', text: 'Error: The First Alternate Number Is Not Set', dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 3000 });
				return false
			}
		
			originalDData = $("input[name^='alternateNumber']").serializeArray();
			var n = noty({ type: 'warning', layout: 'topRight', text: 'Duplicating First Alternate Number To Visible Alternate Number Fields', dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 3000 });
			$("input[name^='alternateNumber']").val(val);
			showBanner();
			duplicateReset = 1
		} else {
			var n = noty({ type: 'information', layout: 'topRight', text: 'Resetting Visible Alternate Number Fields To Original Values', dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 3000 });
			$(originalDData).each(function(i, field) {
				$('#alternateNumber' + i).val(field.value)
			});
			showBanner();
			duplicateReset = 0
		}
			
		$noty.close(); 
		}
        },
		{ addClass: 'btn btn-warning', text: 'Cancel', onClick: function ($noty) {
            $noty.close(); 
			}
		}		
		] 
	});

	});
	
	$(".clearAll").click(function(e) {
		var checkedBoxes = $(":checkbox:checked").length;
		if (checkedBoxes > 0) {
			var n = noty({ type: 'error', layout: 'center', text: 'Feature Unavailable as Alternate Mode is Enabled', dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 1500 });
			return false;
		}
		
		clearMsg = 'Clear Visible Alternate Number Entries ?'
		clearBtn = 'Clear Visible Entries';
				
		var n = noty({
        type: 'warning', layout: 'center', text: clearMsg, dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons : [ 
		{ addClass: 'btn btn-primary', text: clearBtn, onClick: function ($noty) {
		
			var n = noty({
			type: 'information', layout: 'center', text: 'Are you sure you want to clear these entries ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
			buttons : [ 
			{ addClass: 'btn btn-primary', text: 'Yes', onClick: function ($noty) {
				var n = noty({ type: 'warning', layout: 'topRight', text: 'Removing Visible Alternate Number Values', dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 3000 });
				$( "input[name^='alternateNumber']" ).val('');
	
				updateBanner();
				$noty.close(); 
				}
			},
			{ addClass: 'btn btn-warning', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); 
				}
			}		
			] 
			});
			$noty.close(); 
			}
        },
		{ addClass: 'btn btn-warning', text: 'Cancel', onClick: function ($noty) {
            $noty.close(); 
			}
		}		
		] 
	});
	});
	
	$("#topFirst, #topPrev, #topNext, #topLast, #searchSbmt, #btmFirst, #btmPrev, #btmNext, #btmLast").click(function(e) {
		if ($('#changeBanner').is(':visible')) {
			if ($('#changeBanner').attr('class') === 'banner changed') {
				var n = noty({ type: 'error', layout: 'center', text: 'Changed Settings Haven\'t Been Saved', dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 1500 });
				return false;
			}
		}
	});

function showBanner() {
	if ($('.banner').length < 1) {
		var banner =$("<div id='changeBanner' class='banner changed'>Visible DDI Alternate Number Changes Need To Be Saved</div>");
		$('body').prepend(banner);
		banner.slideDown(2000);	
		$('.buttonSave').css('display', 'inline-block');
	}
}	
	
function hideBanner() {
	$('#changeBanner').remove();
	$('.buttonSave').css('display', 'none');
}	

function updateBanner() {
	if (originalFormData !== $('.alternate, .drEnable').serialize()) {
		showBanner();
	} else {
		hideBanner();
	}
}	
	
});

function searchAlert() {
	var n = noty({ type: 'information', layout: 'center', text: "<span style='color:#000000; font-weight:600;'><br>No DDI Search Results Found<br><br></span>", dismissQueue: true, theme: 'relax', modal: true, maxVisible: 5, timeout: 2500 });
}


function t2tAlert() {
	var n = noty({ type: 'error', layout: 'center', text: "<br>Warning.<br>This page requires a Trunk2Trunk LCPlan with a blank number match. Please contact your reseller to have this functionality enabled.<br><br><i>Click to Close</i><br><br>", dismissQueue: true, theme: 'relax', modal: true, maxVisible: 5 });
	return false;
}