$(window).on('load', function() {
	
	originalFormData = $('#autoattendant').serialize();
	
	$(window).bind('beforeunload', function(){ 
	if (originalFormData !== $('#autoattendant').serialize()) {
	  return 'Are you sure you want to leave?';
	}
	});

	// name check //
	$('body').on('keyup', 'input', function(){
		var aaValue = $(this).val(); 
		var reg = new RegExp('^[a-zA-Z0-9*#?!]+$');
		if (reg.test(aaValue) == false && aaValue.trim() != '') {
			$('#msg').html('Invalid Entry'); 
			$("#msg").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			$(this).css({ 'border': '2pt solid #D00', 'color': '#D00'});
		    $("#save").prop("disabled",true);
		} else {
			$('#msg').html(''); 
			$("#msg").css({ 'border': '0pt solid #EBEBEB', 'color': '#222'});
			$(this).css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
			$("#save").prop("disabled",false);
		 }
	});
	
	// Apply //
	$('body').on('click', '.apply', function(){
		wavFile = $(this).closest('span').attr('data-id');
		aaPath = $(this).closest('div').attr('data-path');
		
		var activeAA = '';
		$.ajax({ url : 'AAActions.php?mode=aaCheck&aaPath=' + encodeURIComponent(aaPath),
			success: function(data) { 
				activeAA = (data == 1) ? '1' : '0';
				if (activeAA === '1') {
					backupWav()
				} else {
					var backupname = '';
					applyWav(backupname,wavFile,aaPath);
				}
			}
		});
	});
	
	$("body").on('change', '.select', function(){
		var selected = $(this).val();
		var thisID = $(this).attr('id').replace('aa', '');
		var currentCompany = $('#company').val();
		
		if (selected == 'clear') {
			$('#' + thisID).replaceWith('<input name="' + thisID + '" id="' + thisID + '" class="smallFields" value="delete entry" readonly="readonly" >');
			return false
		}
				
		if (selected === 'other') {	
			$('#' + thisID).replaceWith('<input name="' + thisID + '" id="' + thisID + '" class="smallFields" value="" >');
			return false;
			
		} else {
			$('#' + thisID).replaceWith('<select id=' + thisID + ' name=' + thisID + '><option></option></select>');
			$.ajax({
				type: "POST", cache: false,
				url: "AAActions.php?mode=search&selected=" + encodeURIComponent(selected) + '&currentCompany=' + encodeURIComponent(currentCompany), 	
				success: function(data) {
					var $el = $("#" + thisID); $el.empty();
					var values = data.split(',');
						$el.append($("<option></option>").attr("value", '').text('') );
					$.each(values, function(key, value) {
						var select = value.split(':')
						if ( select[1].toLowerCase().indexOf("inboundrecordings") >= 0 || select[1].toLowerCase().indexOf("outboundrecordings") >= 0 ) return true;
						$el.append($("<option></option>").attr("value", select[0]).text(select[1]) );
					});
				}
			});
		}
	});
	
	
	function backupWav() {
	var MyDate = new Date(); var MyDateString;
			MyDate.setDate(MyDate.getDate());
			MyDateString = ('0' + MyDate.getDate()).slice(-2) + ('0' + (MyDate.getMonth()+1)).slice(-2) + MyDate.getFullYear() + '-' + ('0' + (MyDate.getHours()+1)).slice(-2) + ('0' + (MyDate.getMinutes()+1)).slice(-2) + ('0' + (MyDate.getSeconds()+1)).slice(-2);
				
		var backupname = "AAGreeting_" + MyDateString + '.wav';
		
		var n = noty({
        type: 'warning', layout: 'center', text: "The existing Auto Attendant Greeting will be backed up to:<br/><b>" + backupname + "</b><br/><br/>Do you want to rename this file ?", dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            { addClass: 'btn btn-primary', text: 'YES', onClick: function ($noty) {
				
				var backupname = prompt("Please Enter The Backup Name", "AAGreeting_" + MyDateString + ".wav");
				var ext = backupname.split('.').pop();
				backupname = (ext === 'wav') ? backupname : backupname + '.wav';
		
				var currentWavs = new Array();
				$('[data-id]').each(function (e) {
	                currentWavs.push($(this).data('id'));
				});

				backupname = (backupname === 'AAGreeting.wav') ? "AAGreeting_" + MyDateString + ".wav" : backupname;
				backupname = (jQuery.inArray(backupname, currentWavs) != -1) ? "AAGreeting_" + MyDateString + ".wav" : backupname;
				
				applyWav(backupname,wavFile,aaPath);
				$noty.close(); }
			},
			{ addClass: 'btn btn-danger', text: 'NO', onClick: function ($noty) {
				applyWav(backupname,wavFile,aaPath);
				$noty.close(); }
			}
            ]
        });	
	}
	
	function applyWav(backupFile,applyWavFile,aaPath) {
	var backupMsg = '';
	if (backupFile.length >= 1 ) 
		var backupMsg = '<br/><br/><i>Current Auto Attendant Greeting will be backed up to <b>' + backupFile + '</b></i>';
	var n = noty({
        type: 'warning', layout: 'center', text: 'Apply: <b>' + applyWavFile + '</b> ?' + backupMsg, dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({ url : 'AAActions.php?mode=applyWav&aaPath=' + aaPath + '&wavFile=' + encodeURIComponent(applyWavFile) + '&backupWav=' + encodeURIComponent(backupFile),
				success: function(data) { 
					if (data > 0) {
						var n = noty({ type: 'error', layout: 'center', text: 'Action Cancelled<br/><br/>' + data + '<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
						$noty.close();
					} else {
						
						backupMsg = (backupFile.length >= 1 ) ? 'Old wav file backed up to: <b>' + backupFile + '</b><br/><br/>' : '';
						var n = noty({ type: 'warning', layout: 'center', text: 'New AutoAttendant Greeting has been applied.<br/><br/>' + backupMsg + '<i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout: 5000 });
						$('#activeAAMsg').css('display', 'inline');
						$('.wav span').each(function() {
							if ($(this).attr("data-id") === applyWavFile) {
								$(this).css('color', '#d90036');
							} else {
								$(this).css('color', '#000000');
							}
						})
					
					if (backupFile.length >= 1 ) {
						displayname = backupFile;
						if (backupFile.length > 40) displayname = displayname.substring(0,39) + '---.wav';
						var span = "<span style='line-height:25px' data-id='" + backupFile + "'><img class='apply' title='Apply Wav' alt='Apply Wav' src='../assets/images/apply.png' />&nbsp;&nbsp;&nbsp;<a href='AAActions.php?download_file=" + encodeURIComponent(backupFile) + "'><img class='download' title='Download Wav' alt='Download Wav' src='../assets/images/download.png' /></a>&nbsp;&nbsp;&nbsp;<img class='delete' title='Delete Wav' alt='Delete Wav' src='../assets/images/deletewav.png' />&nbsp;&nbsp;" + displayname + "<br/></span>";
						$('#infoSpan').before(span)
					}
					}
				}
				
				});
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
					var n = noty({ type: 'error', layout: 'center', text: 'Action Cancelled', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout: 1500 });
                    $noty.close(); }
                }
            ]
        });	
	}
	

	// Delete //
	$('body').on('click', '.delete', function(){
		var wavFile = decodeURIComponent($(this).closest('span').attr('data-id'));
		var aaPath = $(this).closest('div').attr('data-path');
		var n = noty({
        type: 'error', layout: 'center', text: 'Delete: <b>' + wavFile + '</b> ?<br/><i>This file will be deleted from the system</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({ url : 'AAActions.php?mode=deleteWav&aaPath=' + encodeURIComponent(aaPath) + '&wavFile=' + encodeURIComponent(wavFile), 
					success: function(data) { 
					if (data == 1) {
						$('span[data-id="' + wavFile + '"]').remove();
					} else {
						var n = noty({ type: 'error', layout: 'center', text: 'Error Removing File<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout: 1500 });
					}

					}  
					});
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });	
	});
	
		
	// save updates //
	$("body").on('click', '#save', function(){
		var n = noty({
        type: 'information', layout: 'center', text: 'Save AutoAttendant: ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({
					type: "POST", 
					cache: false,
					data: $('#autoattendant').serializeArray(),
					url: "saveAutoattendant.php", 	
				success: function(data) {
					var n = noty({ type: 'success', layout: 'center', text: 'AutoAttendant settings saved', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout: 1500 })
					originalFormData = $('#autoattendant').serialize();
				}
				});
				$noty.close();
				return false; 
			}
            },
			{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); }
			}
            ]
        });
	});
	
	$("input:file").change(function (){
       var filename = $('#myfile').val().replace(/C:\\fakepath\\/i, '');
	   var ext = filename.split('.').pop();

       if (ext != 'wav') {
		   var n = noty({ type: 'error', layout: 'center', text: 'Only wav files are supported<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout: 2500 });
		   $('#myfile').val('')
	   }

     });
	
});
function startUpload(){
    document.getElementById('f1_upload_process').innerHTML = "Uploading...&nbsp;<img src='../assets/images/save_banner.gif' /><br/>";
    return true;
}
function stopUpload(success,filename) {
	var result = '';
	var filename = filename;
	
	if (success == 1){
		var aaPath =  document.getElementById("wavUpload").elements["aaPath"].value;
		var fullFile = aaPath + '/' + filename
	
				$.ajax({ url : 'AAActions.php?mode=wavCheck&wavFile=' + encodeURIComponent(fullFile),
					success: function(data) { 
						if (data == 1) {
							document.getElementById('f1_upload_process').innerHTML = "<p class='f1_ok'>File Upload Done</p>";
							var span = "<span style='line-height:25px' data-id='" + filename + "'><img class='apply' title='Apply Wav' alt='Apply Wav' src='../assets/images/apply.png' />&nbsp;&nbsp;&nbsp;<a href='AAActions.php?download_file=" + encodeURIComponent(filename) + "'><img class='download' title='Download Wav' alt='Download Wav' src='../assets/images/download.png' /></a>&nbsp;&nbsp;&nbsp;<img class='delete' title='Delete Wav' alt='Delete Wav' src='../assets/images/deletewav.png' />&nbsp;&nbsp;" + filename + "<br/></span>";
							$('#infoSpan').before(span);
						} else {
							document.getElementById('f1_upload_process').innerHTML = "<div class='f1_error'>Wrong Wav File Type</div><div class='f1_msg'> - Only A-LAW 8000Hz 8bit Mono files are supported</div>";
							$.ajax({ url : 'AAActions.php?mode=deleteWav&aaPath=' + encodeURIComponent(aaPath) + '&wavFile=' + encodeURIComponent(filename) })
						}
					}
				});
	} else {
		document.getElementById('f1_upload_process').innerHTML = "<p class='f1_error'>File Upload Error</p>";
	}
	return true;   
}