$(function() {
	
$("#searchInput").keyup(function() {
    var rows = $(".fbody").find('td').hide();
    var data = this.value.split("/");
    $.each(data, function(i, v) {
        rows.filter(":Contains('" + v + "')").show();
    });

});

$.expr[":"].Contains = jQuery.expr.createPseudo(function(arg) {
    return function(elem) {
		//console.log(elem)
        return $(elem).filter(function() {
            return $(this).text().toUpperCase().indexOf(arg.toUpperCase()) >= 0;
        }).length;
    };
});


	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});
	
    $(".cell").hover(function(){
		$(this).attr('title', $(this).text());
	})
	

	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
	
	id = members = caps_count = caps = 0;
	
	$('#group_name').change(function() {
		id = members = caps_count = caps = 0;
		$(".cell").css("background-color", "#FFFFFF");
		$("[name$='_span']").css('display', 'none'); 
		$('#group_new').val('');
		$('#status_msg').html('');
		$('#capabilities').html('');
		$('#members').text('0');
		$("#memberList").empty();
		$('#msg_span').css('display', 'block');
		$('#delete_span').css('display', 'block');	
		$('#rename_span').css('display', 'block');
		$('#rename_form').css('display', 'none');
		$('#rename').prop('checked', false);

				
		if ($(this).val() == "0") {
			$('#msg_span').css('display', 'none');
			$('#rename_span').css('display', 'none');
			$('#delete_span').css('display', 'none');	
			return false;
		}
		if ($(this).val() == "creategroup") {
			$('#new_span').css('display', 'block');
			$('#rename_span').css('display', 'none');
			$('#delete_span').css('display', 'none');	
			return false;
		}
		console.log ( $("#group_name").val() )
		console.log (encodeURIComponent($("#group_name").val()))
        var link = 'groups_do.php?groupList=' + encodeURIComponent($("#group_name").val());
		$.ajax({
	    	url: link, timeout: 10000,
        	success: function(data, textStatus, xhr) {
				if (data.length <1) return false;
				var vals = data.split(';');
				members_count = vals[0]; var members = vals[1]; caps_count = vals[2]; caps = vals[3]; companyGuid = vals[4]; 
				phoneMembers = vals[5].split(',');
			    $("#company").val(companyGuid);

				if (caps_count >= 1) {
					$('#delete_span').css('display', 'none');
					$('#rename_span').css('display', 'none');
					$('#capabilities').html('<h5>Group: ' + $('#group_name').val() + '</h5>is managed using capabilities and can\'t be edited using this page')
					$('#capabilities').append('<br/><br/><h5>Assigned Capabilities:</h5>')
					$.each($.unique(caps.split(',')), function(index, value) { 
						$('#capabilities').append(value + '<br/>')
					});
					$('#capabilities').append('<br/>')
				}
				$('#members').text(members_count);
				if (members.length >=1) {
					var displayed = false;
					$.each($.unique(members.split(',')), function(index, guid) { 
						$('#' + guid).css("background-color", "#BFDFFF");
						var member =  $('#' + guid).text();
						if (member.length < 1) {
							if($.inArray(guid, phoneMembers) != -1) {
								var phoneMember = true;
							} else {
								var any = true;
							}
						}
						$("#msg_span ul").append('<li>' + member + '</li>');
					if ($('#msg_span').text().indexOf('Any members') ==-1)
						if (any) $("#msg_span ul").prepend('<li>Group contains Any members</li>');
						if (displayed === false && phoneMember) {
							$("#msg_span ul").prepend('<li>Group contains Phone members</li>');
							displayed = true;
						}
					});
				}
			} 
		});
    });
	
	
	$('#rename').click(function() {
		if ($(this).is(":checked")) {
			$('#rename_form').css('display', 'block');
		} else {
			$('#rename_form').css('display', 'none');
		}
	});
	
	$('#rename_submit').click(function(e) {
		var status_msg = $('#status_msg').text();
		if (status_msg.toLowerCase().indexOf("invalid") >= 0 || caps_count >=1) {
			return false;
		}
		var group_name = $('#group_name :selected').text();
		var rename_new = $('#rename_new').val();
		var n = noty({
        type: 'warning', layout: 'center', text: 'Rename Group: <b>' + group_name + '</b> to <b>' + rename_new + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({ url : 'groups_do.php?group_name=' + encodeURIComponent(group_name) + '&groupRename=' + encodeURIComponent(rename_new) });
                    $noty.close(); 
					var option = $("#group_name :selected");
					option.val(rename_new);
					option.html(rename_new);
					$('#rename').prop('checked', false);
					$('#rename_form').css('display', 'none');
					$('#rename_new').val('');
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });
	    e.preventDefault();
	});
	
	
	$('#delete_span').click(function() {
		var group_name = $('#group_name').val();
		var n = noty({
        type: 'warning', layout: 'center', text: 'Delete Group: <b>' + group_name + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'YES', onClick: function ($noty) {
				$.ajax({ url : 'groups_do.php?delete=' + group_name });
                    $noty.close(); 
					$("#group_name option[value='" + group_name + "']").remove();
					$("[name^='group_']").val('');
					$("[name$='_span']").css('display', 'none'); 
					$(".cell").css("background-color", "#FFFFFF");
					$('#company').val('');
			}
                },
			{addClass: 'btn btn-danger', text: 'NO', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });
	});
	
	
	$('.cell').click(function() {
		var status_msg = $('#status_msg').text();
		if (status_msg.toLowerCase().indexOf("invalid") >= 0 || caps_count >=1) {
			return false;
		}
		
		var group_name = $('#group_name option:selected').text();
		var group_val = $('#group_name option:selected').val();
		var group_new = $('#group_new').val();
		
		if (group_val == 'creategroup' && group_new.length <= 0) {
			var n = noty({ type: 'error', layout: 'center', text: 'New group name needs to be set', dismissQueue: true, theme: 'relax', modal: true, timeout: 1500 });
			return false;
		} 
		
		if (group_val == 'creategroup' && group_new.length > 0) {
			group_name = group_new
		}
		
		var member_count = parseInt($('#members').text());
		if (member_count >=1 && group_new.length >= 1) group_new = '';
		
		if (group_name.length > 0) {
		var div_id = $(this).attr('id');
		var div_name = $(this).text();

		if ($(this).css('background-color') === 'rgb(191, 223, 255)') {
				var link = 'groups_do.php?groupDelete=' + encodeURIComponent(group_name) + '&member=' + encodeURIComponent(div_id);
				$.ajax({  	url: link, timeout: 10000,
							success: function(data, textStatus, xhr) {
								$('#' + div_id).css("background-color", "#FFFFFF");
								var member =  $('#' + div_id).text();
								$('li').filter(function() { return $.text([this]) === member; }).remove();
							}				 
				});
				var n = noty({ type: 'warning', layout: 'topRight', text: '<b>Group: ' + group_name + '<br/>Removing Member: ' + div_name + '</b>', dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 1000 });
				$('#members').text(member_count - 1);
				
				// check if group is empty
				var member_count = parseInt($('#members').text());
				if (member_count == 0) {
					var n = noty({
					type: 'warning', layout: 'center', text: 'Delete Empty Group: <b>' + group_name + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
					buttons     : [
						{addClass: 'btn btn-primary', text: 'YES', onClick: function ($noty) {
							$.ajax({ url : 'groups_do.php?delete=' + encodeURIComponent(group_name) });
							$noty.close(); 
							$("#group_name option[value='" + group_name + "']").remove();
							$("[name^='group_']").val('');
							$("[name$='_span']").css('display', 'none'); 
						}
						},
						{addClass: 'btn btn-danger', text: 'NO', onClick: function ($noty) {
							$noty.close(); }
						}
					]
					});
				}
				
				
			} else {
				var company = $('#company :selected').val();
				var link = 'groups_do.php?groupAdd=' + encodeURIComponent(group_name) + '&member=' + encodeURIComponent(div_id) + '&newGroup=' + encodeURIComponent(group_new) + '&id=' + encodeURIComponent(id) + '&company=' + encodeURIComponent(company);
				$.ajax({  	url: link, timeout: 10000,
					success: function(data, textStatus, xhr) {
						console.log (data)
						$('#' + div_id).css("background-color", "#BFDFFF");
						var member =  $('#' + div_id).text();
						$("#msg_span ul").append('<li>' + member + '</li>');
					}				 
				});
				var n = noty({ type: 'success', layout: 'topRight', text: 'Group: ' + group_name + '<br/>Adding Member: ' + div_name, dismissQueue: true, theme: 'relax', modal: false, maxVisible: 5, timeout: 1000 });
				$('#members').text(member_count + 1);

				// if new group and member count >=1 add to dropdown
				var member_count = parseInt($('#members').text());
				if (group_val == 'creategroup' && group_new.length > 0 && member_count >=1) {
					$("#group_name").append("<option value='" + group_new + "'>" + group_new + "</option>");
					$('#group_name option[value='+ group_name +']').attr('selected','selected');
					$('#new_span').css('display', 'none');
				}
				
			}
		}
	});
	
	
	$('#company').change(function() {
	     $("#group").submit();
	});
	
});



// Group Lookup
function group(source) {
str = source.value
if (str.length==0)   {
	return;
}

if (window.XMLHttpRequest) { // code for IE7+, Firefox, Chrome, Opera, Safari
	xmlhttp=new XMLHttpRequest();
} else {  // code for IE6, IE5
	xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
}

xmlhttp.onreadystatechange=function() {
    if (xmlhttp.readyState==4 && xmlhttp.status==200) {
        if (xmlhttp.responseText.indexOf("ok") != -1) {
        	var style = '';
	    	source.setAttribute("style", style);
	    	document.getElementById("status_msg").innerHTML = "";
        } else {
	    	 var style = 'border-color: #D00; color: #D00; background: #FFFFFE;  border: 2pt solid #D00;';
	    	 source.setAttribute("style", style);
	    	 document.getElementById("status_msg").innerHTML = "Invalid or Duplicate Entry";
        }
    }
}
str = str.replace(/#/g, '%23');
xmlhttp.open("GET","../assets/inc/names.php?group="+encodeURIComponent(str),true);
xmlhttp.send();
}
// Group Lookup