<?php 
// PJC .00002

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$members = (isset($_REQUEST['p']) && count($_REQUEST['p']) >= 1) ? $_REQUEST['p'] : NULL;
$group = (isset($_REQUEST['group_name']) && strlen($_REQUEST['group_name']) >= 1) ? $_REQUEST['group_name'] : NULL;
$groupNew = (isset($_REQUEST['group_new']) && strlen($_REQUEST['group_new']) >= 1) ? $_REQUEST['group_new'] : NULL;
$groupList = (isset($_REQUEST['groupList']) && strlen($_REQUEST['groupList']) >= 1) ? $_REQUEST['groupList'] : NULL;
$groupRename = (isset($_REQUEST['groupRename']) && strlen($_REQUEST['groupRename']) >= 1) ? $_REQUEST['groupRename'] : NULL;

require('../assets/inc/ldapConnect.php');

// list groups
if ($groupList) {
	$members = $caps = $phones = NULL; $id = array('0');
	
	$sr = ldap_read($ds,"cn=$groupList,cn=groups","objectclass=group",array('company')); 
	$info = ldap_get_entries($ds,$sr);	$companyGuid = $info[0]['company'][0];
	
	$sr=ldap_list($ds,"cn=$groupList, cn=groups","(objectclass=member)", array("member"));
	$info = ldap_get_entries($ds, $sr); 
	for ($i=0; $i<$info["count"]; $i++) {
		$members .= $info[$i]['member'][0].",";
		//$id[] = $info[$i]['id'][0];
	}	
	$members = trim($members, ",");
	$count = $info['count'];

	$sr=ldap_search($ds,"cn=$groupList, cn=groups","(objectclass=capability)",array("capability"));
	$info = ldap_get_entries($ds, $sr); 
		for ($m=0; $m<$info['count']; $m++) {				
		$caps .= $info[$m]['capability'][0].",";
	}
	$caps = trim($caps, ",");
	$capsCount = $info['count'];
	
	$sr=ldap_search($ds,"cn=Modules","(objectclass=phone)",array("guid"));
	$info = ldap_get_entries($ds, $sr); 
		for ($m=0; $m<$info['count']; $m++) {				
		$phones .= $info[$m]['guid'][0].",";
	}
	$phones = trim($phones, ",");

	

	echo $count. ";" . $members .";". $capsCount .";". $caps .";". $companyGuid .";". $phones;
exit;	
}

// new group
if ($group == "creategroup" && isset($groupNew) && strlen($groupNew) >1) {
	$sr=ldap_list($ds,"cn=groups","(&(objectclass=group)(cn=$groupNew))");
	$info = ldap_get_entries($ds, $sr); $i='1';

	if ( $info['count'] == 0 && isset($groupNew)) {
	
	echo "New Group: $groupNew<br/><br/>";
	$new = array('objectclass'=>'group', 'description'=>'NewGroup');
	ldap_add($ds,"cn=$groupNew,cn=groups",$new); $new = "";
	audit ("[Groups] [NewGroup] $groupNew");

	foreach($members as $key => $val) {
		$parts = explode (":",$val);
		$new = array('objectclass'=>'member', 'priority'=>'0','member'=>$parts[0]);
		ldap_add($ds,"id=$i,cn=$groupNew,cn=groups",$new);
		echo "Added user: $parts[1]<br/>"; $i++;
		audit ("[Groups] [AddMember] $groupNew / $parts[1]");
	}
  } 
}

// rename group
if (isset($group) && strlen($group)>= 1 && isset($groupRename) && strlen($groupRename)>= 1) {
		$group_dn = "cn=$group,cn=groups";
		ldap_rename($ds,$group_dn,"cn=$groupRename","cn=groups",true);
		echo "<br/>Group Renamed to: $groupRename<br/>";
		audit ("[Groups] [RenameGroup] $group to $groupRename");
	}

// delete group
if (isset($_REQUEST['delete']) && strlen($_REQUEST['delete']) >1) {
	$group_delete = $_REQUEST['delete'];
	ldap_delete($ds,"cn=$group_delete,cn=Groups");
	audit ("[Groups] [Delete] $group_delete");
	echo "Done..";
}


// add member
if (isset($_REQUEST['groupAdd']) && strlen($_REQUEST['groupAdd']) >1 && isset($_REQUEST['member']) && strlen($_REQUEST['member']) >1 ) {
	$groupAdd = $_REQUEST['groupAdd'];
	$newGroup = $_REQUEST['newGroup'];
	$member = $_REQUEST['member'];
	$company = ($adminCompany === '00000000-0000-0000-0000-000000000000') ? $_REQUEST['company'] : $adminCompany;
	
	if (isset($newGroup) && strlen($newGroup) > 1 ) { 
	
		$new = array('objectclass'=>'group', 'description'=>'NewGroup', 'company' => $company);
		ldap_add($ds,"cn=$newGroup,cn=groups",$new); $new = "";
		audit ("[Groups] [NewGroup] $newGroup");
		$new = array('objectclass'=>'member', 'priority'=>'0', 'member'=>$member);
		ldap_add($ds,"id=1,cn=$newGroup, cn=groups",$new);
		audit ("[Groups] [AddMember] $newGroup / $member");
		
	} else {
		
		$sr = ldap_read($ds,"cn=$groupAdd, cn=groups","objectclass=group",array('company')); 
		$info = ldap_get_entries($ds,$sr);	$currentCompany = $info[0]['company'][0];
		if ($company != $currentCompany) {
			$ent['company'] = $company;
			ldap_modify($ds, "cn=$groupAdd, cn=groups", $ent);
		}
		
		$ids = array(); $id = NULL;
		$sr = ldap_list($ds,"cn=$groupAdd, cn=groups","(objectclass=member)", array("id"));
		$info = ldap_get_entries($ds, $sr); 
		for ($i=0; $i<$info["count"]; $i++) {
			$ids[] = $info[$i]['id'][0];
		}	
		
		$id = (count($ids) > 0) ? intval(trim(max($ids)))+1 : '1';
		
		$new = array('objectclass'=>'member', 'priority'=>'0', 'member'=>$member,);
		ldap_add($ds,"id=$id,cn=$groupAdd, cn=groups",$new);
		audit ("[Groups] [AddMember] $groupAdd / $member");
	}
}

//delete member
if (isset($_REQUEST['groupDelete']) && strlen($_REQUEST['groupDelete']) >1 && isset($_REQUEST['member']) && strlen($_REQUEST['member']) >1 ) {
	$groupDelete = $_REQUEST['groupDelete'];
	$member = $_REQUEST['member'];
	
		$sr=ldap_search($ds, "cn=$groupDelete,cn=Groups", "(&(objectclass=member)(member=$member))");
		$info = ldap_get_entries($ds, $sr);
		for ($i=0; $i<$info["count"]; $i++) {
			$dn = ($info[$i]["dn"]);
			ldap_delete($ds, $dn);
			audit ("[Groups] [Delete] $groupDelete");
		}
	
}
?>