<?php
//v1.6 Fix issue with mac address string length check
//v1.5 Add mac address string length check
//v1.4 Added 'auto_detect_line_endings' to support MAC CR linefeeds
//v1.3 Added trim
//v1.2 Fixed ignore #
//v1.1 Updated for Yealink Models
ini_set('auto_detect_line_endings',true); 
$script=$_SERVER['SCRIPT_NAME'];
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>IMPORT PHONES</title>
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="../assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="../assets/css/tabForm.css" rel="stylesheet" type="text/css" media="screen" />
<link href="../assets/css/menu.css" media="screen" rel="stylesheet" type="text/css" />
<link href="../assets/css/buttons.css" rel="stylesheet" type="text/css">
<link href="index.css" rel="stylesheet" type="text/css">

<script src="../assets/js/jquery-min.js" type="text/javascript"></script>
<script src="../assets/js/jquery.noty.packaged.js" type="text/javascript"></script>

</head>
<body>

<div id="content">

<div class="logo">
<a href="#"><img src='../assets/images/logo.png'></img></a>
</div>

<div id="wrap">


<!-- header begins -->
<div class="menu-wrap">
<?php
	require('../assets/inc/header.php');
	//require('load.php');
?>	
</div>
<!-- header ends -->



<div id="main">
<div class="wrapper">
<!-- content begins -->
<h3><span class="icon-file-text2 greyicon"></span> Import Phones</h3><br>
This page allows you to upload a CSV file for the bulk importation of Phones.<br>
The imported phones will appear in Unassigned Phones where you can make the phone a member of the system.<br><br><br>

<form method='post' enctype='multipart/form-data' action='<?php echo $script ?>' >
<label for='file'>Filename: </label>
<input type='file' style='font-size: 10pt; font-family: Tahoma' name='file' id='file' accept='.csv, text/plain, application/txt, text/csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel' size='50'/> <input type='submit' name='upload' value='Upload' />&nbsp;<a href='#' class='tooltip' title='Select The CSV File To Be Uploaded'><img src='../assets/images/tooltip.png'></a></form><br>
</form>

<?php
if (isset($_REQUEST["upload"])) {

if ($_FILES["file"]["error"] > 0) {
	$file_errors = array("There is no error, the file uploaded with success","The uploaded file exceeds the upload_max_filesize directive in php.ini","The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form","The uploaded file was only partially uploaded","No file was uploaded","Missing a temporary folder","Failed to write file to disk","A PHP extension stopped the file upload");
	echo "Sorry there has been an error.<br />";
	echo "Return Code: <b>" . $file_errors[$_FILES["file"]["error"]] . "</b><br />";
exit; 
}

// open file if it exists
$file = fopen($_FILES["file"]["tmp_name"], 'r');
if (!$file) exit("<b>No File Found</b>");

// create arrays from csv values
$macs = $type = array();
$line = trim(fgets($file));
while (($line = fgetcsv($file,1024)) !== FALSE) {
  if (strpos($line[0],'#') !== false) continue;
  list($macs[], $type[]) = $line;
}
fclose($file);
?>


<h3>Import Phones</h3>
The following phones will be imported, please click 'Import Phones' to import the phones.<br>
Any invalid MAC addresses will be shown and not imported.<br><br>

<div class='statictable' id='statictable'>
<form id='import' method='post' >

<table border='1' class='statictable'>
<thead><tr><th>Serial Number</th><th>Model</th><th></th></tr></thead>

<?php

foreach ($macs as $key => $mac) {
	
	$mac = preg_replace("/[^a-zA-Z0-9]/", "", $mac);
	//$mac = substr($mac, 0, 12);
	$status =  (strlen($mac) != '12') ? 'fail.png' : 'blank.png';

 	if (substr($type[$key], 0, 3) === 'PCS') {
		$mac = chunk_split($mac, 2, '-');
		$mac = rtrim($mac, "-");
	} else if ((substr($type[$key], 0, 1) === 'T') || (substr($type[$key], 0, 2) === 'W6')) {
		$type[$key] = 'SIP-' . $type[$key];
	}
	
	
	
	echo "<tr><td><input type='text' name='macaddress[]' id='macaddress$key' value='$mac' readonly/></td><td><input type='text' name='model[]' id='model$key' value='".$type[$key]."' readonly/></td><td><img src='../assets/images/$status'/></td></tr>";
}

?>

</table>
</div>


<div class='submit'><br>
	<input type='hidden' name='import' value='import'/>
	<input type='submit' name='submit' id='submit' value='Import Phones' />
</div>
</form>


<?php 

} // file upload

?>


<?php
if (isset($_REQUEST['import']) && $_REQUEST['import'] === 'import') {
	

$macaddresses = (isset($_REQUEST['macaddress']) && count($_REQUEST['macaddress'] >= 1)) ? $_REQUEST['macaddress'] : NULL;
$model = (isset($_REQUEST['model']) && count($_REQUEST['model'] >= 1)) ? $_REQUEST['model'] : NULL;
$error = 0;

if ($macaddresses && $model) {
	
echo "<h3>Phones Added </h3><br>";

echo "<div class='statictable'>";
echo "<table border='1' class='statictable'>";
echo "<thead><tr><th>Serial Number</th><th>Model</th><th></th></tr></thead>";

	
// find self
$sr = ldap_read($ds,"cn=Self,cn=Modules","objectclass=*");
$info = ldap_get_entries($ds,$sr); 
$self = $info[0]['location'][0];	

	foreach ($macaddresses as $key => $macaddress) {
		
		$macaddressFormatted = preg_replace("/[^A-Fa-f0-9 ]/", '', $macaddress);
		if (strlen($macaddressFormatted) != '12') continue;
		
		if (strpos($model[$key], 'PCS') !== false) {
			$typeofPhone = '2'; // 2=PCS
			$macaddressFormatted = chunk_split($macaddressFormatted, 2, '-');
			$macaddressFormatted = rtrim($macaddressFormatted, "-");
			$name = "PCS $macaddressFormatted-" . trim($model[$key]);
			$dn = $macaddressFormatted;
			$pnpvendor = "";
			$pnpversion = "";
			$pnpmodel = trim($model[$key]);
		} else {
			$typeofPhone = '3'; // 3=Yealink
			$name = "SIP ". strtolower($macaddressFormatted);
			$dn = strtolower($macaddressFormatted);
			$pnpvendor = "yealink";
			$pnpversion = "";
			$pnpmodel = (substr($model[$key], 0, 1) === 'T') ? "SIP-" . trim($model[$key]) : trim($model[$key]);
		} 
		
		$count = 0;
		$sr = @ldap_read($ds,"serialnumber=$dn, cn=UnassignedPhones","objectclass=unassignedphone"); 
		if ($sr) { $info = ldap_get_entries($ds,$sr); $count = $info['count']; }
		
		$sr = ldap_search($ds,"cn=Modules","(&(objectclass=*)(serialnumber=$dn))", array('serialnumber')); 
		if ($sr) { $info = ldap_get_entries($ds,$sr); $count = $count + $info['count']; }

		if ($count < 1) {
			$att=array('objectclass'=> 'unassignedphone', 'status'=>'1', 'GUID'=>'00000000-0000-0000-0000-000000000000', 'location'=> $self, 'cn'=>$name, 'typeofphone'=>$typeofPhone, 'pnpvendor'=>$pnpvendor, 'pnpversion'=>$pnpversion, 'pnpmodel'=>$pnpmodel );
			$dn = "serialnumber=$dn, cn=unassignedphones";
			$res = @ldap_add($ds, "$dn",$att);
			if ($res === false) $error++;
			
			if ($res) echo "<tr><td><input class='serial' type='text' value='$name' readonly/></td><td><input class='model' type='text' value='".$model[$key]."' readonly/></td><td><img src='../assets/images/success.png'/></td></tr>";
		} else {
			echo "<tr><td><input class='serial' type='text' value='$name' readonly/></td><td><input class='model' type='text' value='".$model[$key]."' readonly/></td><td><img title='Failed To Import Phone. Device Already Exists In The System Configuration' src='../assets/images/fail.png'/></td></tr>";

		}		
		
	}
	echo "</table></div><br><br>";
	echo "The phones have been imported and can be assigned to users using the <b><a href='../unassigned/'>Unassigned Phones page</a></b><br>";
	audit ("[ImportPhones] [Import] Done");

  }
}

?>
<!--content ends -->
</div>
</div>	


<!--footer begins -->
<?php
	require('../assets/inc/footer.php');
?>
<!-- footer ends-->
</div>

</div>
</body>
</html>