<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Licence Status</title>
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="../assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="../assets/css/menu.css" media="screen" rel="stylesheet" type="text/css" />
<link href="../assets/css/bPopup.css" media="screen" rel="stylesheet" type="text/css" />
<link href="licences.css" rel="stylesheet" type="text/css" media="screen" />
<script src="../assets/js/jquery-min.js" type="text/javascript"></script>
<script src="../assets/js/bPopup.js" type="text/javascript"></script>
<script src="licences.js" type="text/javascript"></script>
</head>
<body>
<?php
//require('../assets/inc/ldapConnect.php');
?>
<div id="content">

<div class="logo">
<a href="#"><img src='../assets/images/logo.png'></img></a>
</div>

<div id="wrap">


<!-- header begins -->
<div class="menu-wrap">
<?php
	require('../assets/inc/header.php');
	if ($adminCompany != '00000000-0000-0000-0000-000000000000') {  header("Location: ../"); exit(); }
?>	
</div>
<!-- header ends -->



<div id="main">
<div class="wrapper">
<!-- content begins -->
<h3><span class="icon-key2 greyicon"></span> Licence Status</h3><br/>

<?php

// find master details as licence count stored there
$sr=ldap_search($ds,"cn=Modules","(&(objectclass=AdministrationModule)(administrationmode=1))");
$info=ldap_get_entries($ds,$sr);
$sa = explode(",",$info[0]['dn']);
$s = substr($sa[1],3);
$publicipaddress=$info[0]['publicipaddress'][0];
$dn="cn=$s,cn=Modules";
$sr=ldap_read($ds,$dn,"objectclass=*");
$info=ldap_get_entries($ds,$sr);
$ipaddress = $info[0]['ipaddress'][0];
$guid=$info[0]['guid'][0];
// find self
$sr = ldap_read($ds,"cn=Self,cn=Modules","objectclass=*");
$info = ldap_get_entries($ds,$sr);
$self = $info[0]['location'][0];
if ($guid == $self) {
   $dsm=$ds;
} else {
   if(!$publicipaddress) $ip=$ipaddress;
   else {
      $sr=ldap_list($ds,"cn=Modules","(&(objectclass=Module)(guid=$self))");
      $info = ldap_get_entries($ds,$sr);
      $dn=$info[0]['dn'];
      $sr=ldap_search($ds,$dn,"(&(objectclass=IntraModuleTrunk)(ipaddress=$ipaddress))");
      $info = ldap_get_entries($ds,$sr);
      if ($info[0]['count']) $ip=$ipaddress;
      else $ip= $publicipaddress;
   }
   $dsm = @ldap_connect($ip,4000) or exit("<p>EXIT: Primary System LDAP connect failure</p>");
   @ldap_bind($dsm,"INTERNAL","001122334455") or exit("<p>EXIT: Primary System LDAP bind failure</p>");
}

$dummy = "A Dummy Licence - Please Ignore";
$dummyatt=array('objectclass'=>'License','qty'=>'0','License'=>$dummy);
ldap_add($ds,"key=$dummy, cn=System",$dummyatt); ldap_delete($ds,"key=$dummy, cn=System");

$licencearray = array('ConferenceControl', 'IPUser', 'iPCS', 'IPVirtualUser', 'ManagedUser' , 'ManagedAgent', 'MessageBox', 'NavigateOutlook', 'NavigateSoftphone','NavigateSFB', 
'OperatorConsole', 'POTS', 'SIPPhone', 'S716', 'S8', 'Trunk', 'VisionAgent', 'VisionMobility', 'VoicemailPort', 'AnalogueUser');

$licenceText = array('Conference Control', 'IPUser', 'iPCS', 'IPVirtual User', 'Managed User' , 'Managed Agent', 'MessageBox', 'Navigate Outlook', 'Navigate Softphone','Navigate Skype for Business', 
'Operator Console', 'POTS', 'SIP Phone', 'S716', 'S8', 'Trunk', 'Vision Agent', 'Vision Mobility', 'Voicemail Port', 'Analogue User');



$sr=@ldap_list($dsm,"cn=System","objectclass=licenserecord");
$info=ldap_get_entries($dsm,$sr);
print "<div style='width: 50%; margin: 0 auto;'><p>Licence Count:<p><br/>";
print "<table border=1 id='tbl'><tr><th width='250px'>Licence Type</th><th width='100px'>Available</th><th width='100px'>Used *</th></tr>";
for($n=0; $n<$info['count'];$n++) {
	
    $title=substr($info[$n]['license'][0],1);
	
if (in_array($title, $licencearray)) {
	
	$licenceindex = array_search($title, $licencearray);
	
    if ($title=="TotalControl") $title="VisionMobility";
	
	if (strtolower($title) == "manageduser") continue;
	if (strtolower($title) == "ipuser") { 
		print "<tr id='ipusers'><td><img src='../assets/images/expand.gif' alt='Users' title='Users' border='0' />&nbsp;Total Users</td><td>".$info[$n]['qty'][0]."</td><td>".$info[$n]['used'][0]."</td></tr>";
	} else if (strtolower($title) == "sipphone") { 
		print "<tr id='sipphone'><td><img src='../assets/images/expand.gif' alt='SIPPhone' title='SIPPhone' border='0' />&nbsp;$title</td><td>".$info[$n]['qty'][0]."</td><td>".$info[$n]['used'][0]."</td></tr>";
	} else if (strtolower($title) == "voicemailport") { 
		print "<tr id='vmports'><td><img src='../assets/images/expand.gif' alt='Voicemail Port' title='Voicemail Port' border='0' />&nbsp;$title</td><td>".$info[$n]['qty'][0]."</td><td>".$info[$n]['used'][0]."</td></tr>";
	} else {
		print "<tr><td>$licenceText[$licenceindex]</td><td>".$info[$n]['qty'][0]."</td><td>".$info[$n]['used'][0]."</td></tr>";
	}
}
	
}
print "</table><p>* The Primary counts the licences used.<br/><br/></div>";


print "<b>Please note:</b><br/>When calculating the number of IPUser licences that are in use you need to include all active POTS ports that are available on system modules.<br/><br/>
Although POTS ports do not have an IPUser licence assigned to them they are included in the count and therefore will be added to the number of actual IPUser licences you have allocated to users with IP Phones.<br/><br/>
If you have Managed IPUser licences within your system these will add to the total number of IPUser Licences available but are not included in the count of licences in use.<br/>";
print "<br/><b>Note:</b><br/>This script added a dummy licence to trigger a recount.<br/>Your warnings will show : <b>$dummy</b> REJECTED</p>";

// build array of nodes
$sr=@ldap_list($ds,"cn=Modules","(&(objectclass=Module)(modulestatus=0))");
$info=ldap_get_entries($ds,$sr);
//		print "Module count = ".$info['count']."<br/>";
for($n=0; $n<$info['count'];$n++) {
    $n2 = @count($modules['cn']);
    if ($info[$n]['moduletype'][0]==1) $modules['type'][$n2]="4100";
    if ($info[$n]['moduletype'][0]==1 and substr($info[$n]['serialnumber'][0],0,8)!="00-07-d9") $modules['type'][$n2]="XS";
    if ($info[$n]['moduletype'][0]==2) continue; //$modules['type'][$n2]="4200";
    if ($info[$n]['moduletype'][0]==3) $modules['type'][$n2]="4315";
    if ($info[$n]['moduletype'][0]==4) $modules['type'][$n2]="4330";
    if ($info[$n]['moduletype'][0]==7) continue; //$modules['type'][$n2]="VoIP";
    if ($info[$n]['moduletype'][0]==8) continue; //$modules['type'][$n2]="4400";
    if ($info[$n]['moduletype'][0]==10) $modules['type'][$n2]="4140";
    if ($info[$n]['moduletype'][0]==11) $modules['type'][$n2]="5100";
    if ($info[$n]['moduletype'][0]==12) $modules['type'][$n2]="5108";
    if ($info[$n]['moduletype'][0]==13) $modules['type'][$n2]="5330";
    if ($info[$n]['moduletype'][0]==14) $modules['type'][$n2]="5315";
    if ($info[$n]['moduletype'][0]==17) $modules['type'][$n2]="SV1000 Linux";
    if ($info[$n]['moduletype'][0]==18) $modules['type'][$n2]="S8000 Apple";
    if ($info[$n]['moduletype'][0]==19) $modules['type'][$n2]="NSG";
    if ($info[$n]['moduletype'][0]==20) continue; //$modules['type'][$n2]="Vision";
    if (!isset($modules['type'][$n2])) $modules['type'][$n2] = $info[$n]['moduletype'][0];

    $modules['cn'][$n2] = $info[$n]['cn'][0];
    $modules['guid'][$n2] = $info[$n]['guid'][0];
    $modules['version'][$n2] = $info[$n]['productversion'][0];
	$modules['ipaddress'][$n2] = $info[$n]['ipaddress'][0];
    $days=floor((time()-$info[$n]['lastseen'][0])/(24*60*60))." days ago @ ";
    $days .=date(" H:i:s l, jS F Y",$info[$n]['lastseen'][0]);
    $modules['lastseen'][$n2] = $days;
}

print "<div style='width: 80%; margin: 0 auto;'><p><br/>Modules affecting licence count in system:</p><br/><table border=1 id='tbl2'><tr><th>#</th><th>IP Address</th><th>Name</th><th>Type</th><th>Version</th><th>Last Seen</th></tr>";
foreach ($modules['ipaddress'] as $key => $value) {
    print "<tr><td>".($key+1)."</td><td>".$modules['ipaddress'][$key]."</td><td>".$modules['cn'][$key]."</td><td>".$modules['type'][$key]."</td><td>".$modules['version'][$key];
    print "</td><td>".$modules['lastseen'][$key]."</td></tr>";
}

print "</table>";

print "<br/><p>".date(" H:i:s l, jS F Y")."</p><br/></div>";
?>

<div id="element_to_pop_up">
</div>

<!--content ends -->
</div>
</div>	


<!--footer begins -->
<?php
	require('../assets/inc/footer.php');
?>
<!-- footer ends-->
</div>

</div>
</body>
</html>
