<?php
//PJC 09/01/2019 - Only count member modules
//PJC 05/10/2018 - Updated SV1000

header('Content-type: text/html; charset=UTF-8') ;
require('../assets/inc/ldapConnect.php');
?>
<html>
<title>IP User Licences</title>
<head>
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />
<link href="../assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="licences.css" rel="stylesheet" type="text/css" media="screen" />
</head>
<body>
<div id="wrapper" class='popup'>    
<h2>User Licences</h2>
<?php
	
	$port_count = $licence_count = $callserver = 0;
	$modules_cn = array('3'=>'Phone Module 4315','4'=>'Phone Module 4330','10'=>'Remote CallServer 4140','11'=>'CallServer 5100','12'=>'CallServer 5108','13'=>'Phone Module 5330','14'=>'Phone Module 5315','17'=>'SoftPBX','18'=>'SoftPBX','19'=>'Network Service Gateway','21'=>'Intelligent Gateway Module P302','22'=>'Intelligent Gateway Module P308');
	$modules_ports = array('3'=>'15','4'=>'30','10'=>'8','11'=>'8','12'=>'8','13'=>'30','14'=>'15','17'=>'0','18'=>'0','19'=>'4','21'=>'2','22'=>'8');
	$sv = array('001'=>'0', 'SC'=>'0','MAPS'=>'5','VMAP'=>'0','NSG'=>'0','OFF01'=>'0','020'=>'20');

	$sr = ldap_list($ds,"cn=modules","(&(objectclass=module)(modulestatus=0)(|(moduletype=3)(moduletype=4)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=13)(moduletype=14)(moduletype=17)(moduletype=18)(moduletype=19)(moduletype=21)(moduletype=22)))",array('status','cn','guid','moduletype'));
		$info = ldap_get_entries($ds, $sr);  
		
	echo "<table border ='1' style='border-collapse: collapse; width: 500px'>";
	echo "<thead><th>Name</th><th>Module</th><th>Ports</th></thead>";
	
		for ($m=0; $m<$info['count']; $m++) {
			$module_ports = $modules_ports[$info[$m]['moduletype'][0]];
			$module_type = $modules_cn[$info[$m]['moduletype'][0]];
			$module_cn = $info[$m]['cn'][0];
			$port_count += $module_ports;
			 echo "<tr><td>$module_cn</td><td><i>$module_type</i></td><td>$module_ports</td></tr>";
		}
	
	echo "<tr><td colspan='2'>Total Ports:</td><td><b>$port_count</b></td></tr>";

	echo "<tr><td colspan='3'>&nbsp;</td></tr>";
	
	
	$sr = ldap_list($ds,"cn=system","(&(objectclass=license)(|(license=IPUser)(license=POTS)(license=ManagedUser))(valid=1))",array('license','valid','qty'));
		$info = ldap_get_entries($ds, $sr);
		

	$sr = ldap_list($ds,"cn=system","(&(objectclass=licenserecord)(license=_SV1000*))",array('license','qty'));
		$info2 = ldap_get_entries($ds, $sr); 


		
	echo "<thead><th colspan='2'>Licence</th><th>Quantity</th></thead>";
		for ($m=0; $m<$info['count']; $m++) {
			$licence = str_replace('_','',$info2[$m]['license'][0]);
				if (strpos($licence, 'SV1000') !== false) {
					$type = explode('-', $licence);
					$quantity = $sv[$type[1]];
					$licence_count += $quantity;
					if ($quantity >0) echo "<tr><td colspan='2'>$licence</td><td>$quantity</td></tr>";
				}

		}
	
	
		for ($m=0; $m<$info['count']; $m++) {
			$licence = $info[$m]['license'][0];
			$quantity = $info[$m]['qty'][0];
			$licence_count += $quantity;
			echo "<tr><td colspan='2'>$licence</td><td>$quantity</td></tr>";
		}
	echo "<tr><td colspan='2'>Total:</td><td><b>$licence_count</b></td></tr>";
	echo "<tr><td colspan='3'>&nbsp;</td></tr>";		
	$total =  $licence_count + $port_count;
	echo "<tr><td colspan='3'>&nbsp;</td></tr>";
	echo "<tr><td colspan='2'>Total Licences:</td><td><b>$total</b></td></tr>";
	echo "</table>";	

?>
</div>
</body>
</html>