<?php
//PJC 05/10/2018 - Updated SV1000

header('Content-type: text/html; charset=UTF-8') ;
require('../assets/inc/ldapConnect.php');
?>
<html>
<head>
<title>Voicemail Port Licences</title>
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />
<link href="../assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="licences.css" rel="stylesheet" type="text/css" media="screen" />
</head>
<body>
<div id="wrapper" class='popup'>    
<h2>SIP Phone Licences</h2><br>
<?php
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}
	
	$user_siplicense = $phone_siplicense = NULL;
	
	$sr = ldap_list($ds,"cn=users","(&(objectclass=*)(siplicense=1)(disabled=0))",array('cn','guid'));
		$info = ldap_get_entries($ds, $sr);  $user_siplicense = $info['count'];
		
	$sr = ldap_search($ds,"cn=modules","(&(objectclass=*)(siplicense=1))",array('cn','guid'));
		$info = ldap_get_entries($ds, $sr);  $phone_siplicense = $info['count'];
	
	echo "<p align='left'><b>Please Note:</b><br>The licence count only shows enabled users. Any user disabled due to 'lack of licence' will not appear in the count below.</p><br>";
	echo "<table border ='1' style='border-collapse: collapse; width: 400px';";
	echo "<thead><th>Licence Type</th><th>Count</th></thead>";
	
	if ($user_siplicense) {
		echo "<tr><td>User SIP Licences:</td><td><b>$user_siplicense</b></td></tr>";
	}
	
	if ($phone_siplicense) {
		echo "<tr><td>Phone SIP Licences:</td><td><b>$phone_siplicense</b></td></tr>";
	}
	
	$total =  $user_siplicense + $phone_siplicense;
	echo "<tr><td colspan='2'>&nbsp;</td></tr>";
	echo "<tr><td>Total Licences:</td><td><b>$total</b></td></tr>";
	echo "</table>";			
?>
</div>
</div>
</body>
</html>