<?php

	require('../assets/inc/ldapConnect.php');
	$url = $_SERVER['SERVER_ADDR'];
	$mode = (isset($_REQUEST['mode']) && strlen($_REQUEST['mode']) >=1 ) ? $_REQUEST['mode'] : NULL; // search, add, delete, save
	
	
	
if ($mode === 'search') {
	$selectedcompany = ($_GET['company'] === '0') ? '0' : $_GET['company'];
	$query = strtolower($_GET['search']);
	
	if ($selectedcompany === '0') {
		$dn = "cn=Contacts";
	} else {
		$dn = "cn=contacts, cn=$selectedcompany, cn=Companies";
	}
	
	$filter="(&(objectclass=contact)(|(|(|(|(|(|(|(cn=*$query*)(telephonenumber=*$query*)(hometelephonenumber=*$query*)(mobiletelephonenumber=*$query*)(spare1telephonenumber=*$query*)(spare2telephonenumber=*$query*)(description=*$query*)(o=*$query*)))))))))";
	$att = array("cn","telephonenumber","hometelephonenumber", "mobiletelephonenumber", "spare1telephonenumber", "spare2telephonenumber","guid","o","description");
	$sr = @ldap_search($ds, $dn, $filter, $att,0,25,5);
	$info = @ldap_get_entries($ds, $sr);
	
	$rec_count = (isset($info["count"]) && $info["count"] >= 1) ? $info["count"] : '0';
	
	if ($rec_count > '0' && $query != '') {

	for ($i=0; $i<$info["count"]; $i++) {
		$guid[] = $info[$i]["guid"][0];
		$cn[] = $info[$i]["cn"][0];
		$company[] = $info[$i]["o"][0];
		$telephonenumber[] = $info[$i]["telephonenumber"][0];
		$description[] = $info[$i]["description"][0];
	}
	
	array_multisort($cn, $guid, $company, $telephonenumber, $description);
	
	foreach ($guid as $key => $value) {
	echo "<tr id=$guid[$key]>
			<td>$cn[$key]</td>
			<td>$company[$key]</td>
			<td>$telephonenumber[$key]</td>
			<td>$description[$key]</td>
	    </tr>";
		}
	} 
}


if ($mode === 'deleteContact') {
	
	$contactGuid = (isset($_REQUEST['contactGuid']) && strlen($_REQUEST['contactGuid']) >=1 ) ? $_REQUEST['contactGuid'] : NULL;
	ldap_delete($ds, "guid=$contactGuid, cn=Contacts");
	audit ("[CONTACTS] [Delete] $contactGuid");
	
}


if ($mode === 'saveContact') {
	$contactMode		= (isset($_REQUEST['contactMode']) 			&& strlen($_REQUEST['contactMode']) >=1 ) 			? $_REQUEST['contactMode'] 			: NULL; // add or edit
	$currentContactGuid = (isset($_REQUEST['currentContactGuid']) 	&& strlen($_REQUEST['currentContactGuid']) >=1 ) 	? $_REQUEST['currentContactGuid'] 	: NULL;
	$selectedCompany 	= (isset($_REQUEST['selectedCompany']) 		&& strlen($_REQUEST['selectedCompany']) >=1 ) 		? $_REQUEST['selectedCompany'] 	: '0';
	
	
	foreach($_REQUEST as $key => $value){
		if (strpos($key, '_') === false) $ent[$key] = $value;
	}
	
	if ($contactMode) {
		
		$cn	= $ent['cn'];
		$o  = $ent['o'];
		$telephonenumber = $ent['telephonenumber'];
		$description = $ent['description'];
		$ent["objectclass"]= "contact";
		
		unset ($ent['mode']);
		unset ($ent['contactMode']);
		unset ($ent['selectedCompany']);
		unset ($ent['currentContactGuid']);
		unset ($ent['cn']);


		if ($contactMode === "addContact") {
			$dn = ($selectedCompany === '0') ? "cn=$cn, cn=Contacts" : "cn=$cn, cn=Contacts, cn=$selectedCompany, cn=Companies" ;
			ldap_add($ds, $dn, $ent);
			$sr = ldap_read($ds,$dn,"objectclass=contact",array('guid')); 
			$info = ldap_get_entries($ds,$sr);	$currentContactGuid = $info[0]['guid'][0]; 
		} else {
			unset ($ent['objectclass']);
			$dn = ($selectedCompany === '0') ? "guid=$currentContactGuid, cn=Contacts" : "guid=$currentContactGuid, cn=Contacts, cn=$selectedCompany, cn=Companies" ;
			//$dn = "guid=$currentContactGuid, cn=Contacts";
			ldap_modify($ds, $dn, $ent);
			$sr = ldap_read($ds,$dn,"objectclass=contact",array('cn')); 
			$info = ldap_get_entries($ds,$sr);	 $currentName = $info[0]['cn'][0];
			
			if ($currentName != $cn) {
				$base = ($selectedCompany === '0') ? "cn=Contacts" : "cn=Contacts, cn=$selectedCompany, cn=Companies";
				ldap_rename($ds, $dn, "cn=$cn",$base,true);
			}
			
		}
	
		echo "$contactMode,$currentContactGuid,$cn,$o,$telephonenumber, $description";
		audit ("[Contact] [$contactMode] $cn / $o / $telephonenumber");
	}
}

?>