<?php 
	require('../assets/inc/ldapConnect.php');
	$actionMode = (isset($_REQUEST['actionMode']) && strlen($_REQUEST['actionMode']) >=1 ) ? $_REQUEST['actionMode'] : NULL;
	
if ($actionMode === 'save') {
	$loadMode = (isset($_REQUEST['loadMode']) && strlen($_REQUEST['loadMode']) >=1 ) ? $_REQUEST['loadMode'] : NULL; // add or edit
	$ent = array();
	
	foreach($_REQUEST as $key => $value){
		if (strpos($key, '_') === false) $ent[$key] = $value;
	}
	
	if ($loadMode) {
		
		$date = $ent['date'];
		$date = str_replace('/', '', $date);
		$day =  substr($date,0,2);
		$month =  substr($date, 2, 2);
		$year = substr($date, -2);
		$date = $year.$month.$day;
		$ent['date'] = $date;
		
		
		$cn 			= $ent['cn'];
		$organiser 		= $ent['organiser'];
		$selectedName 	= $ent['selectedName'];
		$selectedGuid   = $ent['guid'];
		$company   		= (isset($ent['company']) && strlen($ent['company']) > 0) ? $ent['company'] : $adminCompany;
		
		
		
		$ent['starttime'] =  preg_replace("~\D~",'', $ent['starttime']);
		$ent['endtime'] =  preg_replace("~\D~",'', $ent['endtime']);

		unset ($ent['cn']);	
		unset ($ent['actionMode']);					
		unset ($ent['loadMode']);
		unset ($ent['selectedName']);
		unset ($ent['guid']);
		unset ($ent['company']);
		
		if ($loadMode === "add") {
			$ent['objectclass']	= 'meetmeconference';
			
			if ($company === '0') {
				ldap_add($ds,"cn=$cn,cn=meetmeconferences",$ent); 
				$sr = ldap_read($ds,"cn=$cn,cn=meetmeconferences","objectclass=meetmeconference",array('guid')); 
			} else {
				ldap_add($ds,"cn=$cn,cn=meetmeconferences,guid=$company,cn=companies",$ent); 
				$sr = ldap_read($ds,"cn=$cn,cn=meetmeconferences,guid=$company,cn=companies","objectclass=meetmeconference",array('guid')); 
			}
			
			$info = ldap_get_entries($ds,$sr);	$selectedGuid = $info[0]['guid'][0];
			 
		} else {
			unset ($ent['cn']);
			$ent['objectclass'] = "meetmeconference";
			
			ldap_delete($ds, "guid=$selectedGuid");
			
			if ($company === '0') {
				ldap_add($ds,"cn=$cn,cn=meetmeconferences",$ent); 
				$sr = ldap_read($ds,"cn=$cn,cn=meetmeconferences","objectclass=meetmeconference",array('guid')); 
			} else {
				ldap_add($ds,"cn=$cn,cn=meetmeconferences,guid=$company,cn=companies",$ent); 
				$sr = ldap_read($ds,"cn=$cn,cn=meetmeconferences,guid=$company,cn=companies","objectclass=meetmeconference",array('guid')); 
			}
		}
	
		echo "$loadMode:$selectedGuid:$cn:$organiser:$date";
		audit ("[MeetMeConference] [$loadMode] $cn");
	}
}



if ($actionMode === 'delete') {
	$selectedName = (isset($_REQUEST['selectedName']) && strlen($_REQUEST['selectedName']) >=1 ) ? $_REQUEST['selectedName'] : NULL;
	$selectedGuid = (isset($_REQUEST['selectedGuid']) && strlen($_REQUEST['selectedGuid']) >=1 ) ? $_REQUEST['selectedGuid'] : NULL;
	ldap_delete($ds, "guid=$selectedGuid");
	audit ("[MeetMeConference] [Delete] $selectedName");
}


?>