<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>SIPWizard</title>
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="../assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="../assets/css/buttons.css" rel="stylesheet" type="text/css">
<link href="sipwizard.css" rel="stylesheet" type="text/css">

<script src="../assets/js/jquery-min.js" type="text/javascript"></script>
<script src="../assets/js/jquery.smartWizard.js" type="text/javascript"></script>
<script src="../assets/js/jquery.noty.packaged.js" type="text/javascript"></script>
<script src="sipwizard.js" type="text/javascript"></script>
</head>
<body>
<?php
// PJC 14/08/2019 - NSG Update
// PJC 17MAY2019 Added DTMF mode (RFC 2833 / SIP INFO). Updated RTP Range to 8899
$script=$_SERVER['SCRIPT_NAME']; 	$url = $_SERVER['SERVER_ADDR'];
$action = (isset ($_REQUEST['action'] )) ? $_REQUEST['action'] : "0";

require('../assets/inc/ldapConnect.php');
	//WAN IP ADDRESS
	function is_connected() {
	set_time_limit(2);
	$connected = @fsockopen("www.example.com", 80, $errorNo, $errorString, 2);
		if ($connected){
			fclose($connected);       
			return true;
		}
		return false;
	}
		
	$statusCheck = is_connected();
	if ($statusCheck === True) {
		$wanIP = (@file_get_contents("https://splicepbx.uk/ip.php")) ? @file_get_contents("https://splicepbx.uk/ip.php") : "";
	} else {
		$wanIP = '';
	}
	
	// LINUX VERSION
	$cmd = "cat /proc/version";
	exec($cmd,$a);	$a = $a[0];
	$sip_rtp_ports = (preg_match('~\b(suse|centos|redhat)\b~i',$a)) ? "6900 - 8899" : "6300 - 6699";
	
	//SELF
	$sr = ldap_read($ds,"cn=self,cn=Modules","objectclass=*"); $info = ldap_get_entries($ds,$sr);
    $sr = ldap_search($ds,"cn=Modules","(&(objectclass=*)(guid=".$info[0]['location'][0]."))"); $info = ldap_get_entries($ds,$sr);
	$self = $info[0]['guid'][0];
	
	$sr = ldap_read($ds,"guid=$self,cn=Modules","objectclass=Module",array('productversion')); $info = ldap_get_entries($ds,$sr);
	$productversion = $info[0]['productversion'][0];
	$productversion = substr(str_replace('SV ','', $productversion), 0, 3);

	//SoftPBX Licence
	$sr = ldap_list($ds,"guid=$self,cn=Modules","objectclass=AdministrationModule",array('modulelicenseguid')); $info = ldap_get_entries($ds,$sr);
	$modulelicenseguid = $info[0]['modulelicenseguid'][0];
	
	$sr = ldap_list($ds,"cn=system","(&(objectclass=license)(guid=$modulelicenseguid))",array('license')); $info = ldap_get_entries($ds,$sr);
	if (isset($info[0]['license'][0]) && strlen($info[0]['license'][0]) >= 1) {
		$softPBXVer = str_replace('-','',$info[0]['license'][0]);
	
		$SV1000001 = array('Trunk'=>'240');
		$SV1000SC = array('Trunk'=>'30');
		$SV1000MAP = array('Trunk'=>'90');
		$SV1000MAPS = array('Trunk'=>'15');
		$SV1000VMAP = array('Trunk'=>'90');
		$SV1000NSG = array('Trunk'=>'90');
		$SV1000OFF01 = array('Trunk'=>'90');
		$SV1000020 = array('Trunk'=>'15');
		
		$maxTrunks = (strpos($softPBXVer, 'SV1000') !== false) ? intval(${$softPBXVer}['Trunk']) : '0';
		
	} else {
		$maxTrunks = intval(68);
	}
	
	$sr = ldap_list($ds,"cn=system","(&(objectclass=licenserecord)(|(license=_IPTrunk)(license=_Trunk)))",array('used','qty'));
	$info = ldap_get_entries($ds, $sr);  
	$quantity=$used=0;
	for ($m=0; $m<$info['count']; $m++) {
		$quantity += $info[$m]['qty'][0];
		$used += intval($info[$m]['used'][0]);
	}
	$available = intval($quantity - $used);
	
	if ($available < $maxTrunks) {
		$trunkCaps = $available;
	} else if ($used >= $maxTrunks) {
		$trunkCaps = '0';
	} else if ($available >= $maxTrunks) {
		$trunkCaps = ($maxTrunks - $used);
	} else {
		$trunkCaps = '';
	}
	
	$sr = ldap_list($ds,"cn=system","(&(objectclass=license)(license=CompressionChannel)(valid=1))",array('used','qty'));
	$info = ldap_get_entries($ds, $sr);  $compressionLicences = $info['count'];
?>
<div id="content">

<div class="logo">
<a href="#"><img src='../assets/images/logo.png'></img></a>
</div>

<div id="wrap">

<!-- content begins -->
<div id="main">
<div class="wrapper">

<table align="center" border="0" cellpadding="0" cellspacing="0">
<tr><td> 
<form action="saveSIP.php" method="post" name="SIPTrunk" id="SIPTrunk">
<!-- Tabs -->
  		<div id="wizard" class="swMain">
  			<ul>
  			<li><a href="#step-1">
                <label class="stepNumber">1</label>
                <span class="stepDesc">
                   SIP Module<br />
                   <small>Module Configuration</small>
                </span>
            </a></li>
  			<li><a href="#step-2">
                <label class="stepNumber">2</label>
                <span class="stepDesc">
                   SIP Trunk<br />
                   <small>Trunk Configuration</small>
                </span>
            </a></li>
  			<li><a href="#step-3">
                <label class="stepNumber">3</label>
                <span class="stepDesc">
                   SIP Settings<br />
                   <small>Trunk Settings</small>
                </span>                   
             </a></li>
			<li><a href="#step-4">
                <label class="stepNumber">4</label>
                <span class="stepDesc">
                   DialPlan - LCRPlan<br />
                   <small>Dial & LCR Plans</small>
                </span>                   
            </a></li>
  			<li><a href="#step-5">
                <label class="stepNumber">5</label>
                <span class="stepDesc">
                   SIP Overview<br />
                   <small>SIP Trunk Overview</small>
                </span>                   
            </a></li>
  			</ul>

			<div id="step-1">	
				<h2 class="StepTitle">SIP Module Configuration</h2><br/>
				
				<div class="colLeft">
				
				<div class='field' title="New Trunk Module Name">
					<label for="sip_name">Module / Trunk Name</label>
					<input type='text' value='TalkTalkSIP' id='sip_name' name='sip_name' maxlength="16" autocomplete="off" tabindex='1'>
					<span class='information'>SIP TRUNK NAME</span>
				</div>
				
				<div class='field' title="New Trunk Module Description">
					<label for="sip_desc">Module / Trunk Description</label>
					<input type='text' value='TalkTalk SIP Trunk' id='sip_desc' name='sip_desc' maxlength="64" autocomplete="off" tabindex='2'>
					<span class='information'>SIP TRUNK DESCRIPTION</span>
				</div>
				
				<div class='field' title="Select Trunk Authentication Type. IP Address Authentication Or Username & Password">
					<label for="sip_type">Authentication Type</label>
					<select name="sip_type" id="sip_type" tabindex='3'><option value="0"></option><option value="1">Username & Password</option><option value="2" selected="selected">IP Authentication</option></select>
					<span class='information'>SIP AUTHENTICATION</span>
				</div>
				
				<div class='field' title="Enter SIP Carriers DNS/IP Address">
					<label for="sip_dnsip">DNS/IP Address</label>
					<input type='text' value='91.146.112.10' id='sip_dnsip' name='sip_dnsip' maxlength="64" autocomplete="off" tabindex='4'>
					<span class='information'>SIP DNS / IP ADDRESS</span>
				</div>
				
				<div class='field' title="Select System To Register This Trunk To">
					<label for="sip_cs">SoftPBX</label>
					<select name="sip_cs" id="sip_cs" tabindex='5'>
					<option value="0"></option>
					<?php
					$dn = "cn=Modules";
					$filter="(&(objectclass=module)(|(|(|(|(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=19)))))))";
					$sr=ldap_list($ds, $dn, $filter); $info = ldap_get_entries($ds, $sr);
						for ($m=0; $m<$info['count']; $m++) {
						$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
						$selected = ($self == $guid || $info['count'] == 1) ? "selected=selected":"";
						echo "<option value='$guid' $selected >$cn</option>";
					}
					?>
					</select>
					<span class='information'>SoftPBX TO REGISTER THIS SIP MODULE TO</span>
				</div>
				
				</div>  <!-- left -->
				
				<div class="colRight">
				
				<div class='field' title="Enter Trunk Capacity">
					<label for="sip_caps">Capacity</label>
					<input type='text' value='<?php echo $trunkCaps ?>' id='sip_caps' name='sip_caps' maxlength="3" autocomplete="off" tabindex='6'>
					<span class='information'>SIP TRUNK CAPACITY</span>
				</div>
				
				<div class='field' title="Enter Trunk Presentation Number">
					<label for="sip_pres">Trunk Presentation Number</label>
					<input type='text' value='' id='sip_pres' name='sip_pres' maxlength="16" autocomplete="off" tabindex='7'>
					<span class='information'>SIP TRUNK PRESENTATION NUMBER</span>
				</div>
				
				<div class='field' title="Enter SIP Carriers Registrar DNS/IP Address (only enabled if using Username & Password Authentication)">
					<label for="sip_dnsip_user">Registrar DNS/IP Address</label>
					<input type='text' value='' id='sip_dnsip_user' name='sip_dnsip_user' maxlength="64" autocomplete="off" tabindex='8' readonly>
					<span class='information'>SIP TRUNK REGISTRAR IP ADDRESS</span>
				</div>

				<div class='field' title="Enter SIP Registration Username (only enabled if using Username & Password Authentication)">
					<label for="sip_username">Registration User Name</label>
					<input type='text' value='' id='sip_username' name='sip_username' maxlength="64" autocomplete="off" tabindex='9' readonly>
					<span class='information'>SIP TRUNK REGISTRATION USERNAME</span>
				</div>

				<div class='field' title="Enter SIP Registration Password (only enabled if using Username & Password Authentication)">
					<label for="sip_password">Registration Password</label>
					<input type='text' value='' id='sip_password' name='sip_password' maxlength="64" autocomplete="off" tabindex='10' readonly>
					<span class='information'>SIP TRUNK REGISTRATION PASSWORD</span>
				</div>		

				</div> <!-- right -->

			</div>

		
		  	<div id="step-2">
				<h2 class="StepTitle">SIP Trunk Configuration</h2><br/>
				
				<div class="colLeft">
				
				<div class='field' title="Enter SIP Trunks Packet Time">
					<label for="sip_ptime">Packet Time (ptime)</label>
					<select name="sip_ptime" id="sip_ptime" tabindex='11'><option value="30">30ms</option><option value="20">20ms</option><option value="10">10ms</option></select>
					<span class='information'>SIP PACKET TIME (PTIME)</span>
				</div>
				
				<div class='field' title="Enter SIP Trunk Source Port. Default 5060">
					<label for="sip_source">SIP Source Port</label>
					<input type='text' value='5060' id='sip_source' name='sip_source' maxlength="64" autocomplete="off" tabindex='12'>
					<span class='information'>SIP SOURCE PORT - DEFAULT 5060</span>
				</div>				
				
				<div class='field' title="Enter SIP Trunk Compression Type. Normally G711(Relay) Unless Compression Licences Have Been Purchased">
					<label for="sip_comp">Compression Type</label>
					<select name="sip_comp" id="sip_comp" tabindex='13'><option value="0">None</option>
					<?php
					if (isset($compressionLicences) && $compressionLicences >=1)  
						echo "<option value=\"11\">G729a 8K</option>";
					?>
					
					<option value="12" selected="selected">G711 (Relay)</option></select>
					<span class='information'>SIP COMPRESSION TYPE</span>
				</div>		
				
				<div class='field' title="Enter SIP Receive On Port. Default 5060">
					<label for="sip_rec_port">Receive On Port</label>
					<input type="text" name="sip_rec_port" id="sip_rec_port" value="5060" maxlength="16" tabindex='14'/>
					<span class='information'>NAT RECEIVE PORT - DEFAULT 5060</span>
				</div>
				
				<div class='field' title="Select SIP DTMF Mode. RFC 2833 (default) or SIP INFO">
					<label for="sip_dtmf">DTMF Mode	</label>
					<select name="sip_dtmf" id="sip_dtmf" tabindex='15'>
						<option value="0">RFC 2833</option>
						<option value="1">SIP INFO</option>
					</select>
					<span class='information'>SIP DTMF MODE</span>
				</div>	

				</div> <!-- left -->
				
				
				<div class="colRight">
				
				<div class='field' title="Enter SIP Trunk NAT Mode. Normally Static or STUN">
					<label for="sip_nat_mode">NAT MODE</label>
					<select name="sip_nat_mode" id="sip_nat_mode" tabindex='16'><option value="0">None</option><option value="1" <?php echo (strlen($wanIP)>1) ? "selected=selected" : ""?> >Static</option><option value="2">STUN</option></select>
					<span class='information'>NAT MODE - STATUS, NONE, STUN</span>
				</div>
				
				<div class='field' title="Enter SIP Trunk NAT/STUN Port. Normally 5060(NAT) Or 3478(STUN) ">
					<label for="sip_nat_port">NAT / Stun Port</label>
					<input type='text' value='5060' id='sip_nat_port' name='sip_nat_port' maxlength="16" autocomplete="off" tabindex='17'>
					<span class='information'>NAT / STUN PORT - DEFAULT 5060</span>
				</div>
				
				<div class='field sipNatServer' id='natDiv' title="Enter NAT Server Or Select STUN Server">
					<label for="sip_nat_server">NAT Server</label>
					<input type="text" name="sip_nat_server" id="sip_nat_server" value="<?php echo $wanIP ?>" maxlength="32" tabindex='18'/>
					<input type="text" name="sipnatserver" id="sipnatserver" style="display: none;" placeholder="other..."/>
					<span class='information'>PUBLIC IP ADDRESS OR STUN SERVER ADDRESS</span>
				</div>
				
				<?php if ($productversion > '1.1') { ?>

					<div class='field sipDialPlan' title="Enable SIP DNS SRV. Used By BT">
						<label for="dnssrv">SIP DNS SRV</label>
						<div class='checkbox'><label for="dnssrv">&nbsp;<div class="switch"><input type="checkbox" name='dnssrv' id='dnssrv' value="1" tabindex='19'/><div class="slider"></div></div></label></div>
						<span class='information'>SIP DNS SRV</span>
					</div>
					
					<div class='field' title="Enter SIP Registration Contact.">
						<label for="sip_regcontact">Registration Contact</label>
						<input type="text" name="sip_regcontact" id="sip_regcontact" value="" maxlength="64" tabindex='20' disabled/>
						<span class='information'>SIP REGISTRATION CONTACT</span>
					</div>
					
					<div class='field' title="Enter SIP Registration Domain.">
						<label for="sip_regdomain">Registration Domain</label>
						<input type="text" name="sip_regdomain" id="sip_regdomain" value="" maxlength="64" tabindex='21' disabled/>
						<span class='information'>SIP REGISTRATION DOMAIN</span>
					</div>
			  <?php } ?>
			
				</div> <!-- right -->
			</div> 
		
		
  		<div id="step-3">
            <h2 class="StepTitle">SIP Trunk Settings</h2><br/>
			
			<div class="colLeft">
			
				<div class='field' title="Enter New Trunk Group Name">
					<label for="sip_trunkgrp">Trunk Group Name</label>
					<input type='text' name='sip_trunkgrp' id='sip_trunkgrp' value='TalkTalkTrkGrp' maxlength='16' tabindex='22'/>
					<span class='information'>TRUNK GROUP NAME</span>
				</div>

				<div class='field' title="Enter New LCRPlan Name">
					<label for="sip_lcrplan">LCRPlan Name</label>
					<input type='text' name='sip_lcrplan' id='sip_lcrplan' value='TalkTalkLCRPlan' maxlength='16' tabindex='23'/>
					<span class='information'>LCRPLAN NAME</span>
				</div>
				
			</div> <!-- left -->
			
			<div class="colRight">
			
			The following number matches will be added to the LCRPlan to allow calls to emergency services: <b>999, 911, 112, 101</b><br><br>
			<div class='field sipDialPlan' title="Don't Add Emergency Service Number Match Entries">
				<label>Don't Add Emergency Services</label>
				<div class='checkbox'><label for="sip_noemerg_lcrplan">&nbsp;<div class="switch"><input type="checkbox" name='sip_noemerg_lcrplan' id='sip_noemerg_lcrplan' value="1" /><div class="slider"></div></div></label></div>
				<span class='information'>DON'T ADD EMERGENCY SERVICE NUMBERS</span>
			</div>
			
			<div class='field' title="Add Additional Emergency Service Number Match Entries">
				<label>Additional Emergency Entry</label>
				<input type='text' name='sip_emerg_lcrplan' id='sip_emerg_lcrplan' value='' maxlength='16' tabindex='25' />
				<span class='information'>ADDITIONAL EMERGENCY SERVICE NUMBER</span>
			</div>
						
		</div> <!-- right -->
			
			<div class='colFull'>
			<br/>Sites firewall will need to be configured to allow access from the SIP Registration DNS/IP Address: <b><span id='summaryDNSIP'></span></b> on Port <b>5060</b> and for UDP RTP Port Range: <b><?php echo $sip_rtp_ports ?></b><br/><br/>

			Splicecom recommends that the firewall be configured to only allow access to the SelectVoice system from recognised external IP addresses for the ports required. For example, the address of the SIP provider, as stated above and your own IP address for remote access to complete diagnostic and configuration work.<br/><br/>
	
			Please refer to the Protocols and Ports document for port information. All other access should be blocked to minimise the risk of access from undesirable sources.<br/><br/>
			</div>
        </div>
		
		<!--  4  -->
		
		<div id="step-4">
            <h2 class="StepTitle">DialPlan - LCRPlan</h2><br/>
			<div class="colLeft">
			
			<div class='field sipDialPlan' title="Update DialPlan To Use This SIP Trunk">
				<label>Update DialPlan</label>
				<div class='checkbox'><label for="sip_update_dialplan">&nbsp;<div class="switch"><input type="checkbox" name='sip_update_dialplan' id='sip_update_dialplan' value="1" /><div class="slider"></div></div></label></div>
				<span class='information'>UPDATE DIALPLAN</span>
			</div>		
		
			
			<div class='field' title="Select DialPlan To Update">
				<label>Select DialPlan</label>
				<select name="sip_dialplan" id="sip_dialplan" disabled="disabled">
					<option value="0"></option>
					<?php
						$dn = "cn=dialplans";
						$filter="(objectclass=dialplan)";
						$sr=ldap_list($ds, $dn, $filter); $info = ldap_get_entries($ds, $sr);
						for ($m=0; $m<$info['count']; $m++) {
							$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
							$selected = ($cn === 'Standard') ? 'selected' : '';
							echo "<option value='$guid' $selected>$cn</option>";
							}
					?>
					</select>
				<span class='information'>SELECT DIALPLAN TO UPDATE</span>
			</div>
			
			
			<div class='field sipDialPlan' title="Update Blank Number Match To Use the New LCR Plan For This Trunk">
				<label>Update Blank Number Match</label>
				<div class='checkbox'><label for="sip_dialplan_blank">&nbsp;<div class="switch"><input type="checkbox" name='sip_dialplan_blank' id='sip_dialplan_blank' value="1" disabled="disabled" /><div class="slider"></div></div></label></div>
				<span class='information'>UPDATE DIALPLAN BLANK NUMBER MATCH ENTRY</span>
			</div>			
			
			<div class='field sipDialPlan' title="Add Additional DialPlan Number Match Entries To Match 9,141,9112,112,999,12809,1280141,1280112">
				<label>Update Additional Number Matches</label>
				<div class='checkbox'><label for="sip_dialplan_additional">&nbsp;<div class="switch"><input type="checkbox" name='sip_dialplan_additional' id='sip_dialplan_additional' value="1" disabled="disabled"/><div class="slider"></div></div></label></div>
				<span class='information'>UPDATE ADDITIONAL DIALPLAN NUMBER MATCH ENTRIES</span>
			</div>
			
			<div class='field' title="Create New DialPlan ShortCode to Route Calls Via This Trunk. Eg: *7">
				<label>Add DialPlan ShortCode</label>
				<input type="text" name="sip_dialplan_code" id="sip_dialplan_code" size="10" disabled="disabled" maxlength="16" />
				<span class='information'>ADD NEW SHORTCODE TO DIALPLAN</span>
			</div>
			
				
		</div> <!-- left -->
			
			<div class="colRight">
			
			<div class='field' title="Add Default LCRPlan Entry To New LCR Plan For This Trunk">
					<label for="sip_trunkgrp">Default LCRPlan Entry</label>
					<select name="sip_lcr_default" id="sip_lcr_default" tabindex='19'><option value="0">No</option><option value="1">Yes</option></select>
					<span class='information'>DEFAULT LCRPLAN ENTRY MATCHING 10 DIGITS OR MORE</span>
				</div>
	
				<div class='field sipsmall' title="Add Local STD Number Match Entries To The LCR Plan">
					<label for="sip_lcrplan">Local Number Matches</label>
					<select name="sip_local" id="sip_local" tabindex='21' disabled="disabled"><option value="0">No</option><option value="1">Yes</option></select>
					<input type='text' name='sip_lcrstd' id='sip_lcrstd' value='' maxlength='16' placeholder='STD Code' tabindex='22' disabled/>
					<span class='information'>SELECT LCRPLAN NAME AND ADD LOCAL STD CODE</span>
				</div>
				
				<div class='field std' title="Local Numbers Start With 'x' And Are 'y' Digits in Length">
					<label for="sip_lcrplan">Number Matches</label>
					
					<table id="cloneTable" >
						<thead>
							<th>Starts With</th>
							<th>x Digits</th>
							<th>Delete</th>
						</thead>
				
						<tr id="TemplateRow">
						<td>
							<select name="local[]" id="local" tabindex='23' disabled="disabled">
								<option value="1">1</option>
								<option value="2">2</option>
								<option value="3">3</option>
								<option value="4">4</option>
								<option value="5">5</option>
								<option value="6">6</option>
								<option value="7">7</option>
								<option value="8">8</option>
								<option value="9">9</option>
							</select>
						</td>
					
						<td>
							<select name="digits[]" id="digits" tabindex='24' disabled="disabled">
								<option value="5">5</option>
								<option value="6" selected>6</option>
								<option value="7">7</option>
								<option value="8">8</option>
							</select>
						</td>
					
						</tr>
					</table>
					<span class='information'>ADD NUMBER MATCHES STARTING 'X' AND 'Y' DIGITS LONG</span>
				</div>
				
				<div>
					<input type="submit" name="addRow" value="Add Row" id="addRow" disabled="disabled" />
				</div>
			
		</div> <!-- right -->
			
        </div>
		
		<!--  4  -->
  		
		<div id="step-5">
            <h2 class="StepTitle">SIP Summary: Overview of New SIP Trunk</h2><br/>
			
			
			<h5>SIP Summary</h5>
			<div class='colFull' id='colFull'>
			<div class='colLeft'>
				
				<div class='field sipSummary'>
					<label>Trunk Name</label>
					<span class='summary' id='summaryTrunk'></span>
				</div>
				
				<div class='field sipSummary'>
					<label>Trunk Description</label>
					<span class='summary' id='summaryTrunkDesc'></span>
				</div>
				
				<div class='field sipSummary'>
					<label>Authentication</label>
					<span class='summary' id='summaryAuthentication'></span>
				</div>
				
				<div class='field sipSummary'>
					<label>DNS/IP Address</label>
					<span class='summary' id='summaryRegDNSIP'></span>
				</div>
				
				<div class='field sipSummary sipsmall'>
					<label>Trunk Capacity / Presentation</label>
					<span class='summary' id='summaryCapacity'></span>
					<span class='summary' id='summaryPresentation'></span>
				</div>
				
				<?php if ($productversion > '1.1') { ?>

					<div class='field sipSummary'>
						<label>SIP DNS SRV</label>
						<span class='summary' id='summaryDNSSRV'></span>
					</div>
	
					<div class='field sipSummary sipsmall'>
						<label>Registration Contact / Domain</label>
						<span class='summary' id='summaryRegContact'></span>
						<span class='summary' id='summaryRegDomain'></span>
					</div>
					
				<?php } ?>
				
				
			</div>
			<div class='colRight'>
				
				<div class='field sipSummary'>
					<label>NAT Server</label>
					<span class='summary' id='summaryNATServer'></span>
				</div>
				
				<div class='field sipSummary'>
					<label>NAT Mode</label>
					<span class='summary' id='summaryNATMode'></span>
				</div>
				
				<div class='field sipSummary'>
					<label>NAT Port</label>
					<span class='summary' id='summaryNATPort'></span>
				</div>
				
				<div class='field sipSummary'>
					<label>Trunk Group</label>
					<span class='summary' id='summaryTrunkGroup'></span>
				</div>
				
				<div class='field sipSummary'>
					<label>LCRPlan</label>
					<span class='summary' id='summaryLCRPlan'></span>
				</div>
				
				<div class='field sipSummary'>
					<label>Update DialPlan</label>
					<span class='summary' id='summaryDialPlan'></span>
				</div>
				
				<div class='field sipSummary sipsmall'>
					<label>Compression Type / DTMF Mode</label>
					<span class='summary' id='summaryCompression'></span>
					<span class='summary' id='summaryDTMF'></span>
				</div>
				
			</div>
        </div>                      
  		
		</div>
  		
<!-- End SmartWizard Content -->  		
  		</form>
</td></tr>
</table>  

</div>
	
</div>	

<!--content ends -->


<!--footer begins -->
<?php
	require('../assets/inc/footer.php');
?>
<!-- footer ends-->
</div>

</div>

<div id='sipDone' style='display: none'>
	<div class='field sipSummary'>
		<label>New SIP Trunk Name</label>
		<span class='summary' id='newTrunk'></span>
	</div>
	
	<div class='field sipSummary'>
		<label>New Trunk Group Name</label>
		<span class='summary' id='newTrunkGroup'></span>
	</div>
	
	<div class='field sipSummary'>
		<label>New LCRPlan Name</label>
		<span class='summary' id='newLCRPlan'></span>
	</div>

	<br/>
	<br/>
	The SIP Trunks status can be viewed in <a href='../sipstatus'><b>SIPStatus</b></a><br>
	<b>Please Note:</b> This link will take you to the SIPStatus page in the Admin Portal.<br>
</div>

</body>
</html>
