	$(document).ready(function(){
		$('#wizard').smartWizard({transitionEffect:'slideleft',keyNavigation:false,onShowStep:getStepNum,onLeaveStep:leaveAStepCallback,onFinish:onFinishCallback,enableFinishButton:false});
				
		$(function() {
		sipName = $('#sip_name').val();
		var response = '';
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?sip=" + encodeURIComponent(sipName),   
         async: true,
         success : function(text) {
             response = text;
			 if (response.toLowerCase().indexOf("error") >= 0) {
				sipNameError = 1
			 } else {
				sipNameError = 0
			 }
         }
		});
		});

		wanIP = '';
		wanIPURL = 'http://jsonip.com?callback=?';
		$.ajax({
			dataType: "json",
			timeout: 2000,
			url: wanIPURL,
			success : function(data) {
				wanIP = data.ip;
			}
		});
		
		
		function alert(type, layout, text) {
			var n = noty({
				type: type, layout: layout, text: text + '<br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true,
			});
		}	
		
		function getStepNum() {
			stepNum = $('#wizard').smartWizard('currentStep');
			
			if (stepNum > 1) {
				$('.buttonSkip').remove();	
			} else {
				showSkip();
			}
		
			if (stepNum == '4') {
				sipRegDNSIP = $('#sip_dnsip').val();
				summaryTrunk = $('#sip_name').val();
				summaryTrunkDesc = $('#sip_desc').val();
				summaryAuthentication = $('#sip_type').val();
				summaryRegDNSIP = ($('#sip_dnsip').val().length >1) ? $('#sip_dnsip').val() : 'Not Set';
				summaryCapacity = $('#sip_caps').val();
				summaryPresentation = $('#sip_pres').val();
				summaryCompression = $('#sip_comp').val();
				summaryDTMF = $('#sip_dtmf').val();
				summaryNATServer = $('#sip_nat_server').val();
				summaryNATMode = $('#sip_nat_mode').val();
				summaryNATPort = $('#sip_nat_port').val();
				summaryTrunkGroup = $('#sip_trunkgrp').val();
				summaryDDIPlan = $('#sip_ddiplan option:selected').text();
				summaryLCRPlan = $('#sip_lcrplan').val();
				
				if ($('#dnssrv').length && $('#sip_regcontact').length && $('#sip_regdomain').length) {
					summaryDNSSRV = $('#dnssrv').is(':checked') ? 'Enabled' : 'Disabled';
					summaryRegContact = ($('#sip_regcontact').val().length >0) ? $('#sip_regcontact').val() : 'Not Set';
					summaryRegDomain = ($('#sip_regdomain').val().length >0) ? $('#sip_regdomain').val() : 'Not Set';
				}
				
				summaryDTMF = (summaryDTMF == 0) ? 'RFC 2833' : 'SIP INFO';
				
				switch (summaryAuthentication) {
					case '0':
						summaryAuthentication = "None";
						break;
					case '1':
						summaryAuthentication = "Username & Password";
						break;
					case '2':
						summaryAuthentication = "IP Authentication";
					break;
				}
					
				switch (summaryCompression) {
					case '0':
						summaryCompression = "None";
						break;
					case '11':
						summaryCompression = "G729a 8k";
						break;
					case '12':
						summaryCompression = "G711 (Relay)";
					break;
				}
				
				switch (summaryNATMode) {
					case '0':
						summaryNATMode = "None";
						break;
					case '1':
						summaryNATMode = "Static";
						break;
					case '2':
						summaryNATMode = "STUN";
					break;
				}
				
				$('#summaryDNSIP').html(sipRegDNSIP);
				$('#summaryTrunk').html(summaryTrunk);
				$('#summaryTrunkDesc').html(summaryTrunkDesc);
				$('#summaryAuthentication').html(summaryAuthentication);
				$('#summaryRegDNSIP').html(summaryRegDNSIP);
				$('#summaryCapacity').html(summaryCapacity);
				$('#summaryPresentation').html(summaryPresentation);
				$('#summaryCompression').html(summaryCompression);
				$('#summaryDTMF').html(summaryDTMF);
				$('#summaryNATServer').html(summaryNATServer);
				$('#summaryNATMode').html(summaryNATMode);
				$('#summaryNATPort').html(summaryNATPort);
				$('#summaryTrunkGroup').html(summaryTrunkGroup);
				$('#summaryDDIPlan').html(summaryDDIPlan);
				$('#summaryLCRPlan').html(summaryLCRPlan);
				
				if ($('#dnssrv').length && $('#sip_regcontact').length && $('#sip_regdomain').length) {
					$('#summaryDNSSRV').html(summaryDNSSRV);
					$('#summaryRegContact').html(summaryRegContact);
					$('#summaryRegDomain').html(summaryRegDomain);
				}
				
			}
		}
		
		// user authentication
		$('#sip_type').change(function(){
				$('#sip_dnsip_user').val('').prop('readonly', true);
				$('#sip_username').val('').prop('readonly', true);
				$('#sip_password').val('').prop('readonly', true);
			if  ($(this).val() == '0') {	
				alert('warning', 'center', '<b>Authentication Type</b><br/><br/>No Authentication type has been set<br/>');
			} else if ($(this).val() == '1') {	
				$('#sip_dnsip_user').prop('readonly', false);
				$('#sip_username').prop('readonly', false);
				$('#sip_password').prop('readonly', false);
			}
		});
		
		$('#dnssrv').change(function() {
			if ( $('#dnssrv').is(':checked') ) {
				$('#sip_regcontact, #sip_regdomain').prop('disabled', '');
			} else {
				$('#sip_regcontact, #sip_regdomain').prop('disabled', 'disabled');
			}
		})
	
		//Gamma ptime
		$('#sip_dnsip').blur(function() {
			$('#wizard').smartWizard('hideMessage');
			sip_dnsip = $('#sip_dnsip').val();
			if (/gamma|88.215/i.test(sip_dnsip)) {
				$('#sip_ptime').val('20');
			}
			if ($('#sip_dnsip').val() == "91.146.112.10" || $('#sip_dnsip').val() == "91.146.114.10") {
			alert('warning', 'center', '<b>SIP Presentaion Number</b><br/><br/>TalkTalk require a presentation number to be set<br/>');
			}
		});
		
		
		$('#sip_nat_mode').change(function(){
			$('#natDiv').css("height","38px");
		if ($(this).val()=="0") {
			$('#sip_nat_server').replaceWith('<input name="sip_nat_server" id="sip_nat_server" value="None">');
			$('#sip_nat_port').val('0'); $('#sipnatserver').hide().val('');
			$('#sip_nat_server').attr('disabled', 'disabled');  
			$('#sip_nat_port').attr('disabled', 'disabled');
		}
		if ($(this).val()=="1") {
			$('#sip_nat_server').replaceWith('<input name="sip_nat_server" id="sip_nat_server" value="' + wanIP + '">');
			$('#sip_nat_port').val('5060'); 
			$('#sipnatserver').hide().val('');
			$('#sip_nat_server').removeAttr('disabled'); 
			$('#sip_nat_port').removeAttr('disabled');
		}
		if ($(this).val()=="2") {
			$('#sip_nat_server').replaceWith('<select name="sip_nat_server" id="sip_nat_server"><option value="stunserver.org">stunserver.org</option><option value="stun.l.google.com">stun.l.google.com</option><option value="stun.sipgate.net">stun.sipgate.net</option><option value="stun.stunprotocol.org">stun.stunprotocol.org</option><option value="other">Other...</option></select>');
			$('#sip_nat_port').val('3478');
			$('#sip_nat_server').removeAttr('disabled'); 
			$('#sip_nat_port').removeAttr('disabled');
		}
		});
	
		$('form').on('change', 'select[name="sip_nat_server"]', function (event) {
			$('#natDiv').css("height","38px");
		if ($(this).val()=="stun.l.google.com") {
			$('#sip_nat_port').val('19203'); 
			$('#sipnatserver').hide().val('');
		}
		else if ($(this).val()=="stun.sipgate.net") {
			$('#sip_nat_port').val('10000'); 
			$('#sipnatserver').hide().val('');
		}
		else if ($(this).val()=="other") {
			$('#natDiv').css("height","67px");
			$('#sipnatserver').show(); 
			$('#sip_nat_port').val('3478');
		}
		else {
			$('#sip_nat_port').val('3478');  
			$('#sipnatserver').hide().val('');
			}
		});
	
		//NAT Server Address
		$('input[id="sip_nat_server"]').blur(function () {
			var sip_nat = $(this).val();
			var sip_nat_octets = sip_nat.split('.');
			var sip_first_octet = sip_nat_octets[0];
			if (sip_first_octet == '10' || sip_first_octet == '172' || sip_first_octet == '192') {
				alert('error', 'center', '<b>SIP NAT Server</b><br/>The IP Address entered appears to be a Local Network IP Address.<br/>Please confirn this is correct.<br/>');
			}
		});
		
		//SIP Compression
		$('#sip_comp').on('change', function() {
			if ($(this).val()=='0') {
				alert('warning', 'center', '<b>Compression Type: None</b><br/><br/>The only time you should use this compression type on a trunk, is if the trunk is going to connect to a device on the same network or LAN<br/>');
			}
		});
	
		//SIP Description, TrunkGroup & LCRPlan names
		$('#sip_name').on('keyup', function() {
		sipName = $(this).val();
			
		var response = '';
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?sip=" + encodeURIComponent(sipName),   
         async: true,
         success : function(text) {
             response = text;
			 if (response.toLowerCase().indexOf("error") >= 0) {
				$('#wizard').smartWizard('showMessage','Invalid or Duplicate Entry'); 
				$("#sip_name").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				sipNameError = 1
			 } else {
				$('#wizard').smartWizard('hideMessage'); 
				$("#sip_name").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
				$('#sip_desc').val(sipName + ' SIP Trunk')
				$('#sip_trunkgrp').val(sipName + 'TrkGrp')
				$('#sip_lcrplan').val(sipName + 'LCRPlan')
				sipNameError = 0
			 }
         }
		});
		});
		
	
	// validation
	function leaveAStepCallback(obj){
		var step_num= obj.attr('rel');
        return validateSteps(step_num);
	}
      
	function validateAllSteps(){
		var isStepValid = true;
       
		if(validateStep1() == false){
			isStepValid = false;
			$('#wizard').smartWizard('setError',{stepnum:1,iserror:true});         
		}else{
			$('#wizard').smartWizard('setError',{stepnum:1,iserror:false});
		}
       
		if(validateStep3() == false){
			isStepValid = false;
			$('#wizard').smartWizard('setError',{stepnum:3,iserror:true});         
		}else{
			$('#wizard').smartWizard('setError',{stepnum:3,iserror:false});
		}
       
       if(!isStepValid){
          $('#wizard').smartWizard('showMessage','Please correct the errors in the steps and continue');
       }
              
       return isStepValid;
    } 	
		
		
	function validateSteps(step){
		var isStepValid = true;
			
		// validate step 1
		if (step == 1){
			if (validateStep1() == false ){
			isStepValid = false; 
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:true});         
		} else {
			$('#wizard').smartWizard('hideMessage');
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:false});
			}
		}
		
		
		// validate step2
		if (step == 2){
			if (validateStep2() == false ){
			isStepValid = false; 
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:true});         
		} else {
			$('#wizard').smartWizard('hideMessage');
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:false});
			}
		}
      
		// validate step3
		if (step == 3){
			if (validateStep3() == false ){
			isStepValid = false; 
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:true});         
		} else {
			$('#wizard').smartWizard('hideMessage');
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:false});
			}
		}
      
		return isStepValid;
    }
		
	function validateStep1(){
		var isValid = true; 
		var trunkName = $('#sip_name').val();
		var sipcaps = $('#sip_caps').val();
		var presenationNumber = $('#sip_pres').val();
		
		var sipType = $('#sip_type').val();
		if (sipType == '1') {
			sipDNSIPUser = $('#sip_dnsip_user').val();
			sipUsername =  $('#sip_username').val();
			sipPassword = $('#sip_password').val();
			
			if (!sipDNSIPUser && sipDNSIPUser.length <= 0) {			
				$('#wizard').smartWizard('showMessage','SIP Registrar DNS/IP Address must be set');
				$("#sip_dnsip_user").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				isValid = false; return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#sip_dnsip_user").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			if (!sipUsername && sipUsername.length <= 0) {			
				$('#wizard').smartWizard('showMessage','SIP Username must be set');
				$("#sip_username").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				isValid = false; return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#sip_username").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			if (!sipPassword && sipPassword.length <= 0) {			
				$('#wizard').smartWizard('showMessage','SIP Password must be set');
				$("#sip_password").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				isValid = false; return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#sip_password").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
		}
		
		if (sipNameError == '1') {
			$('#wizard').smartWizard('showMessage','Invalid or Duplicate Entry'); 
			$("#sip_name").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;
			return false;
		}
		
		if (!trunkName && trunkName.length <= 0) {
			$('#wizard').smartWizard('showMessage','SIP Trunk Name must be set.');
			$("#sip_name").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;    
			return false;
		} else {
			$('#wizard').smartWizard('hideMessage');
			$("#sip_name").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
		}
		
		if (!sipcaps && sipcaps.length <= 0 || !$.isNumeric(sipcaps)) {
			$('#wizard').smartWizard('showMessage','SIP Capacity Name must be set (numeric value)');
			$("#sip_caps").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;    
			return false;
		} else {
			$('#wizard').smartWizard('hideMessage');
			$("#sip_caps").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
		}
		
		
		if (!presenationNumber && presenationNumber.length <= 0 || !$.isNumeric(presenationNumber)) {
			$('#wizard').smartWizard('showMessage','SIP Presentation Number must be set (numeric value)');
			$("#sip_pres").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;    
			return false;
		} else {
			$('#wizard').smartWizard('hideMessage');
			$("#sip_pres").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
		}
			
		return isValid;
	}
	
	
	function validateStep2(){
		var isValid = true; 
		var sip_nat_server = $('#sip_nat_server').val();
				
		if (!sip_nat_server && sip_nat_server.length <= 0) {
			$('#wizard').smartWizard('showMessage','SIP NAT Server must be set.');
			$("#sip_nat_server").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;    
			return false;
		} else {
			$('#wizard').smartWizard('hideMessage');
			$("#sip_nat_server").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
		}
		
		return isValid;
	}
    
	function validateStep3(){
		var isValid = true;  
		return isValid;
	}
	
	// finish
    function onFinishCallback(){
		if (validateAllSteps()){
		var sipName = $('#sip_name').val();
		var n = noty({
        type: 'warning', layout: 'center', text: 'Create SIPTrunk <b>' + sipName + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
			$noty.close();
				
				$.ajax({
					type: "POST", 
					cache: false,
					async: true,
					data: $('#SIPTrunk').serializeArray(),
					url: "saveSIP.php", 	
					success: function(data) {
						n.close();
						$('#newTrunk').html(summaryTrunk);
						$('#newTrunkGroup').html(summaryTrunkGroup);
						$('#newLCRPlan').html(summaryLCRPlan);
						$('#colFull').replaceWith($('#sipDone').html());
						$(".buttonFinish").addClass('buttonDisabled');
						$(".buttonPrevious").addClass('buttonDisabled');
						$('.actionBar').prepend('<a href="#" class="buttonPortal">Portal</a>');
						$('.buttonPortal').click(function() {
							$("body").fadeOut(500,function(){
								$(location).attr('href','/manager/admin');
							});
						});
						return false;
					},
					error: function(data) {
						n.close();
						return false;
					}
				});
			}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); 
					}
                }
            ]
        });
       }
      }
	  
	$('#sip_update_dialplan').change(function(e) {	    
		sip_update_dialplan = $('#sip_update_dialplan').is(':checked') ? 1 : 0;
		console.log ('DialPlan = ' + sip_update_dialplan)
		
		if (sip_update_dialplan === 1) {
			$('#sip_dialplan, #sip_dialplan_blank, #sip_dialplan_additional, #sip_dialplan_code').prop('disabled', false);
			$('#summaryDialPlan').html('Yes');
		} else {
			$('#sip_dialplan, #sip_dialplan_blank, #sip_dialplan_additional, #sip_dialplan_code').prop('disabled', true);			
			$('#sip_dialplan_blank, #sip_dialplan_additional').prop('checked', false);
			$('#summaryDialPlan').html('No');
		}
	});
	
	$('#sip_lcr_default').change(function(e) {	    
		sip_lcr_default = $(this).val();
		console.log ('SIPLCR = ' + sip_lcr_default)
		if (sip_lcr_default === '1') {
			$('#sip_local').prop('disabled', false);
		} else {
			$('#sip_local').prop('disabled', true);			
		}
	});
	
	$('#sip_local').change(function(e) {	    
		sip_local = $(this).val();
		if (sip_local === '1') {
			$('#sip_lcrstd, #local, #digits, #addRow').prop('disabled', false);
			$('#addRow').css("color", "#000000");
		} else {
			$('#sip_lcrstd, #local, #digits, #addRow').prop('disabled', true);
			$('#addRow').css("color", "#A0A0A0");
		}
	});
	
	
	//$('#sip_dialplan_additional').change(function(e) {	    
	//	sip_dialplan_additional = $('#sip_dialplan_additional').is(':checked') ? 1 : 0;
	//	if (sip_dialplan_additional === 1) {
	//		$('#sip_dialplan_code').prop('disabled', false);
	//	} else {
	//		$('#sip_dialplan_code').prop('disabled', true);
	//	}
	//});
 
 	$("#sip_noemerg_lcrplan").click( function(){
		if( $(this).is(':checked') ) alert('error', 'center', '<b>Emergency Services</b><br/>Removing these entries may result in you not being able to call emergency services.<br/>');
	});	

    $('#addRow').click(function(e) {
		console.log('add')
		e.preventDefault();
        var $newRow = $('#TemplateRow').clone(true).removeAttr('id').append("<td class='delete'><img src='../assets/images/delete.png' class='deleteRow' name='deleteRow' title='Delete Row'/></td>");
		$('#cloneTable tr:last').after($newRow);
		$(".stepContainer").scrollTop($(".stepContainer")[0].scrollHeight);
        return false;
    });
    
    $('#cloneTable').delegate('.deleteRow:not(#TemplateRow .deleteRow)', 'click', function() {
            $(this).closest('tr').remove();
    });

	  
	  
	  function showSkip() {
	  if ($(".actionBar").find(".buttonSkip").length < 1) { 
		$('.actionBar').append('<a href="#" class="buttonSkip">Skip Wizard</a>');
		$('.buttonSkip').click(function() {
		var n = noty({ type: 'warning', layout: 'center', text: 'Leave SIP Wizard ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$noty.close();
				$("body").fadeOut(500,function(){
					$(location).attr('href','/manager/admin');
				});
			} },
				{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); 
					}
                } ]
			});
		});
	  }
	  }
	
});