<?php 
	require('../assets/inc/ldapConnect.php');
	$actionMode = (isset($_REQUEST['actionMode']) && strlen($_REQUEST['actionMode']) >=1 ) ? $_REQUEST['actionMode'] : NULL;
	
if ($actionMode === 'save') {
	$loadMode = (isset($_REQUEST['loadMode']) && strlen($_REQUEST['loadMode']) >=1 ) ? $_REQUEST['loadMode'] : NULL; // add or edit
	$ent = array();
	
	foreach($_REQUEST as $key => $value){
		if (strpos($key, '_') === false) $ent[$key] = $value;
	}
	
	if ($loadMode) {
		
		$cn 				= $ent['cn'];
		$description 		= $ent['description'];
		$mode 				= $ent['mode'];
		$selectedName 		= $ent['selectedName'];
		$timeplanguid		= $ent['guid'];
		
		unset ($ent['actionMode']);	
		unset ($ent['loadMode']);			
		unset ($ent['selectedName']);
		unset ($ent['guid']);		
	
		$ent['company'] = (isset($_REQUEST['company'])) ? $_REQUEST['company'] : $adminCompany;
	
		if ($loadMode === "add") {
			$ent['objectclass']	= 'timeplan';
			ldap_add($ds,"cn=$cn,cn=timeplans",$ent); 
			$sr = ldap_read($ds,"cn=$cn,cn=timeplans","objectclass=timeplan",array('guid')); 
			$info = ldap_get_entries($ds,$sr);	$timeplanguid = $info[0]['guid'][0];
			 
		} else {
			unset ($ent['cn']);
			ldap_modify($ds, "cn=$selectedName, cn=timeplans", $ent);
			if ($selectedName != $cn)
				ldap_rename($ds,"cn=$selectedName,cn=timeplans","cn=$cn","cn=timeplans",true);
		}
	
		echo "$loadMode:$timeplanguid:$cn:$description:$mode";
		audit ("[TimePlans] [$loadMode] $cn");
	}
}


if ($actionMode === 'delete') {
	$selectedName = (isset($_REQUEST['selectedName']) && strlen($_REQUEST['selectedName']) >=1 ) ? $_REQUEST['selectedName'] : NULL;
	ldap_delete($ds, "cn=$selectedName, cn=timeplans");
	audit ("[TimePlans] [Delete] $selectedName");
}


if ($actionMode === 'entries') {
	$selectedGuid = (isset($_REQUEST['selectedGuid']) && count($_REQUEST['selectedGuid']) >=1 ) ? $_REQUEST['selectedGuid'] : NULL;
	$timeBands = (isset($_REQUEST['timeBands']) && count($_REQUEST['timeBands']) >=1 ) ? $_REQUEST['timeBands'] : NULL;
	$dateExceptions = (isset($_REQUEST['dateExceptions']) && count($_REQUEST['dateExceptions']) >=1 ) ? $_REQUEST['dateExceptions'] : NULL;
	
	if ($selectedGuid && $timeBands) {
		foreach ($timeBands as $k => $v) {
			$sections = explode(":",$v);
			$action = $sections[0];
			$guid = (strlen($sections[1]) < 36) ?  $selectedGuid : $sections[1];
			$startday = $sections[2];
			$starttime = $sections[3];
			$endday = $sections[4];
			$endtime = $sections[5];
			
			$ent = array();
			$ent["startTime"] = $starttime;
			$ent["endDayofWeek"] = $endday;
			$ent["endTime"] = $endtime;
			
			if ($action === 'add') {
				if (strlen($starttime) < 1 || strlen($endtime) < 1) continue;
				$sr = ldap_read($ds,"guid=$guid,cn=timeplans","objectclass=timeplan",array('cn')); 
				$info = ldap_get_entries($ds,$sr);	$cn = $info[0]['cn'][0];
				
				$ent["objectclass"] = "timeband";
				$dn = "startDayofWeek=$startday,cn=$cn, cn=timeplans";
				ldap_add($ds, $dn, $ent);
				
			} else if ($action === 'edit') {
				$ent["startDayofWeek"] = $startday;
				$dn = "guid=$guid, cn=timeplans";
				ldap_modify($ds, $dn, $ent);
				
			} else if ($action === 'del') {
     			$dn = "guid=$guid, cn=timeplans";
				ldap_delete($ds, "$dn");
			}
			
			
		}
	}
	
	if ($selectedGuid && $dateExceptions) {
		foreach ($dateExceptions as $k => $v) {
			$sections = explode(":",$v);
			$action = $sections[0];
			$guid = (strlen($sections[1]) < 36) ?  $selectedGuid : $sections[1];
			$dayofmonth = $sections[2];
			$month = $sections[3];

			$ent = array();
			$ent["dayofMonth"] = $dayofmonth;
			
			if ($action === 'add') {
				if (strlen($dayofmonth) < 1 || strlen($month) < 1) continue;
				$sr = ldap_read($ds,"guid=$guid,cn=timeplans","objectclass=timeplan",array('cn')); 
				$info = ldap_get_entries($ds,$sr);	$cn = $info[0]['cn'][0];

				$ent["objectclass"] = "dateException"; 
				$dn = "month=$month,cn=$cn, cn=timeplans";
				ldap_add($ds, $dn, $ent);
				
			} else if ($action === 'edit') {
				$ent["month"] = $month;
				$dn = "guid=$guid, cn=timeplans";
				ldap_modify($ds, $dn, $ent);
				
			} else if ($action === 'del') {
     			$dn = "guid=$guid, cn=timeplans";
				ldap_delete($ds, "$dn");
			}
			
		}
	}
}

if ($actionMode === 'timebandSummary') {
	
	$days = array ( 0 => 'Sunday', 1 => 'Monday', 2 => 'Tuesday', 3 => 'Wednesday', 4 => 'Thursday', 5 => 'Friday', 6 => 'Saturday' );
	$arrayData = json_decode($_POST['arrayData'], true);

	foreach ($arrayData as $arr => $val) {
		if ($arr === 0) $startdayofweek = $val;
		if ($arr === 1) $enddayofweek = $val;
		if ($arr === 2) $starttime = $val;
		if ($arr === 3) $endtime = $val;
	}

	$daysinfo = array( 
		"Sunday" => array ( "start" => '0', "end" => '0' ),
		"Monday" => array ( "start" => '0', "end" => '0' ),
		"Tuesday" => array ( "start" => '0', "end" => '0' ),
		"Wednesday" => array ( "start" => '0', "end" => '0' ),
		"Thursday" => array ( "start" => '0', "end" => '0' ),
		"Friday" => array ( "start" => '0', "end" => '0' ),
		"Saturday" => array ( "start" => '0', "end" => '0' )
	);
	
	foreach ($startdayofweek as $dk => $dv) {
		
		$st = intval(preg_replace('~\D~','',$starttime[$dk])); 
		$en = intval(preg_replace('~\D~','',$endtime[$dk])); 
		
		for ($m=$dv; $m<=$enddayofweek[$dk]; $m++) {
        
			$astart = intval(preg_replace('~\D~','',$daysinfo[$days[$m]]['start']));
			$aend = intval(preg_replace('~\D~','',$daysinfo[$days[$m]]['end']));
			if ($astart === 0 || $st < $astart) {
				$daysinfo[$days[$m]]['start'] = $starttime[$dk];
			}
        
			if ($aend === 0 || $en > $aend) {
				$daysinfo[$days[$m]]['end'] = $endtime[$dk];			
			}
		}
	}

	$summary ='';
	echo "<table><th colspan='2'>TimeBands Active</th>";
	foreach ($daysinfo as $set => $range) {
		if ($range['start'] != '0' && $range['end'] != '0') 
			echo "<tr><td><b>$set</b></td><td>{$range['start']}  - {$range['end']}</td></tr>";
	}
	echo "</table>";

}

?>