$(document).ready(function() {
	
	// load table //
	 oTable = $('#results').dataTable({
		"bJQueryUI": true, "sPaginationType": "full_numbers",
		"aLengthMenu": [[15, 25, 50, 100, 250, 500], [15, 25, 50, 100, 250, 500]]
	});
	
	// highlight table entries //
	$('#results').on( 'click', 'tr', function () {
	if ( $(this).hasClass('odd') || $(this).hasClass('even') || $(this).hasClass('new') ) {
		thisName = $(this).find('td:first').text();
		if (thisName == 'Standard' || thisName == 'EMPTY') return false;
        if ( $(this).hasClass('selected') ) {
            $(this).removeClass('selected');
			selectedGuid = selectedName = '';
        }
        else {
            oTable.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
			selectedGuid = $('#results tr.selected').attr('id');
			selectedName = $('#results tr.selected').find('td:first').text();
        }
	}
    });
	
	// change tabs //
	$("body").on('click', '#element_to_pop_up ul#tabs li', function(){
		$("ul#tabs li").removeClass("active");
		$(this).addClass("active");
	
		var i = $(this).index();
		$("ul#tab li.active").removeClass("active");
		$("ul#tab li").eq(i).addClass("active");

		// reset form and arrays
		$('#datepicker').val('');
		$('#saveTimeband').val( 'Save Timeband' );
		$('#saveDateexception').val( 'Save Date Exception' );
		tp_id = de_id = '';
		
		$("#startdayofweek option:contains('Sunday')").prop('selected', 'selected');
		$("#enddayofweek option:contains('Saturday')").prop('selected', 'selected');

		$("#starttime").replaceWith("<input type='text' class='smallFields timepicker' id='starttime' name='starttime' value='' >");
		$("#starttime").wickedpicker({twentyFour: true, now: '00:00'});
		
		$("#endtime").replaceWith("<input type='text' class='smallFields timepicker' id='endtime' name='endtime' value='' >");
		$("#endtime").wickedpicker({twentyFour: true, now: '23:59'});
	});
	
	// add //
		$('#btn_add').bind('click', function(e) {
			e.preventDefault();
			selectedGuid = selectedName = '';
			timeBands = [];
			dateExceptions = [];
			$('#element_to_pop_up').bPopup({
				loadUrl: 'popupForm.php?loadMode=add',
			loadCallback: function(){ 	    
				originalFormData = $('#popup').serialize();
			}
			});
		});

		
		
		$("body").on('mouseover', '#timebandinfo', function(e){
			e.preventDefault();			
			var days = {'Sunday': 0, 'Monday': 1, 'Tuesday' : 2, 'Wednesday' : 3, 'Thursday' : 4, 'Friday' : 5, 'Saturday' : 6}
			var startDay = []; var endDay = [];
			var startTime = []; var endTime = [];
			 
			$("#timebands tr td:nth-child(1)").each(function(){
				startDay.push(days[$(this).text()]);
			});
			 
			$("#timebands tr td:nth-child(2)").each(function(){
				endDay.push(days[$(this).text()]);
			});
			 
			$("#timebands tr td:nth-child(3)").each(function(){
				startTime.push($(this).text());
			});
			 
			$("#timebands tr td:nth-child(4)").each(function(){
				endTime.push($(this).text());
			});
			
			var arrayData = [startDay, endDay, startTime, endTime]
			var arrayData = JSON.stringify(arrayData)

			$.ajax({
				type: "POST", 
				cache: false,
				url: "actions.php?actionMode=timebandSummary", 	
				data : {arrayData: arrayData},
				success: function(res) {
					$('#timebandsummary').html(res).show();
				}
			});
			
		});
		
		$("body").on('mouseout', '#timebandinfo', function(e){
			$('#timebandsummary').hide()
		});
	
	// delete //
	$("#btn_delete").click(function() {
		if (typeof selectedGuid != "undefined" && selectedGuid.length > 3)
		var n = noty({
        type: 'warning', layout: 'center', text: 'Delete TimePlan: <b>' + selectedName + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({ url : 'actions.php?actionMode=delete&selectedName=' + encodeURIComponent(selectedName)});
					oTable.fnDeleteRow( oTable.$('#' + selectedGuid)[0] );
					selectedGuid = selectedName = '';
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });	
	});

	
	// edit //
	$("#btn_edit").click(function(e) {
		e.preventDefault();
		selectedName = $('#results tr.selected').find('td:first').text();
		if (typeof selectedGuid == "undefined" || selectedGuid.length < 1 ) return false;
		$.ajaxSetup({ cache: false });							
		$('#loadMode').val('edit');
		$('#guid').val(selectedGuid);
		timeBands = [];
		dateExceptions = [];
		
        $('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
            loadUrl: 'popupForm.php?loadMode=edit&selectedName=' + encodeURIComponent(selectedName),
			loadCallback: function(){ 	    
				originalFormData = $('#popup').serialize();
		        $('#timebands, #dateexceptions').find('tr').each(function(){
					originalFormData += '&' + this.id + '=' + encodeURIComponent($(this).text());
				});
			}
        });
	});
	
	
	// close //
	$("body").on('click', '#close', function(){
		closeFormData = $('#popup').serialize()
		$('#timebands, #dateexceptions').find('tr').each(function(){
			closeFormData += '&' + this.id + '=' + encodeURIComponent($(this).text());
		});
		
		var msg = (originalFormData !== closeFormData) ? '<b>Changes haven\'t been saved.</b><br/>' : ''
		console.log(closeFormData)
		var n = noty({
        type: 'warning', layout: 'center', text: msg + 'Close TimePlan: <b>' + selectedName + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
					parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });
	});
	
	// save updates //
	$("body").on('click', '#save', function(){
	var saveTimePlan = $('#cn').val();
	var loadMode = $('#loadMode').val();
	
	console.log( $('#datepicker').val() )
	
	
	if ($('#startdayofweek').val() != '0' || $('#starttime').val() != '00 : 00' || $('#enddayofweek').val() != '6' || $('#endtime').val() != '23 : 59') {
		var n = noty({ type: 'warning', layout: 'center', text: 'Time Band Values Have Been Changed And Not Saved', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
	}
	
	if ($('#datepicker').val().length > 0 ) {
		var n = noty({ type: 'warning', layout: 'center', text: 'Date Exception Has Been Changed And Not Saved', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
	}
	
	if (saveTimePlan < 1) {
		var n = noty({ type: 'error', layout: 'center', text: 'TimePlan Name must be set', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
		return false;
	}
		var n = noty({
        type: 'information', layout: 'center', text: 'Save TimePlan: <b>' + saveTimePlan + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				var alternateplan = $('#alternateplan').val();
				var data = $('#popup').serializeArray()
				data.push({name: 'alternateplan', value: alternateplan});

				$.ajax({
					type: "POST", 
					cache: false,
					data: data,
					url: "actions.php?actionMode=save", 	
				success: function(data) {
					res = data.split(":");
					var loadMode = res[0];
					guid = (loadMode == 'edit') ? selectedGuid : res[1];
					var name = res[2]; var desc = res[3]; var mode = res[4];
					var ret = loadMode + ':' + guid + ':' + name + ':' + desc + ':' + mode;
					parent.UpdateCode(ret);
					// timeband & dateexceptions //
					console.log (timeBands)
					$.ajax({
						type: "POST", 
						cache: false,
						data: {
							timeBands: timeBands,
							dateExceptions: dateExceptions
						},
						url: "actions.php?actionMode=entries&selectedGuid=" + encodeURIComponent(guid), 	
						success: function(data) {
							console.log (data)
						}
					});
					// timeband & dateexceptions //
				}
				});

				parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
				$noty.close();
				return false; 
			}
            },
			{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); }
			}
            ]
        });
	});

	
	// timebands //
	// edit timeband
	$("body").on('click', '.editTimeband', function(){
		tp_id = $(this).closest('tr').attr('id');
		var $row = $(this).closest("tr");
		var tds = $row.find("td");
		
		$("#tab1").removeClass("active");	
		$("#tab2").addClass("active");
		
		$("ul#tab li.active").removeClass("active");	
		$("ul#tab li").eq(1).addClass("active");
		$('#saveTimeband').val( 'Update Timeband' );
		
		starttime = $(tds[2]).text();
		$("#starttime").replaceWith("<input type='text' class='smallFields timepicker' id='starttime' name='starttime' value='' >");
		$("#starttime").wickedpicker({twentyFour: true, now: starttime});
		
		endtime = $(tds[3]).text();
		$("#endtime").replaceWith("<input type='text' class='smallFields timepicker' id='endtime' name='endtime' value='' >");
		$("#endtime").wickedpicker({twentyFour: true, now: endtime});
		
		$("#startdayofweek option:contains(" + $(tds[0]).text() + ")").prop('selected', 'selected');
		$("#enddayofweek option:contains(" + $(tds[1]).text() + ")").prop('selected', 'selected');
	});
	
	
	// add/update timeband
	$("body").on('click', '#saveTimeband', function() {
		var mode = ($('#saveTimeband').val().toLowerCase().indexOf("save") >= 0) ? 'add' : 'edit';
		var days = ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
		var startday = parseInt($("#startdayofweek").val());	var endday = parseInt($("#enddayofweek").val());	
		var starttime = $('#starttime').val();
		var endtime = $('#endtime').val();
		
		var new_id = (mode == 'add') ? (new Date).getTime() : tp_id; 
		var tpMode = ( tp_id.length < 32) ? 'add' : 'edit';
		var row = "<tr id='" + new_id + "'><td>" + days[startday] + "</td><td>" +  days[endday] + "</td><td>" + starttime + "</td><td>" + endtime + "</td><td><img class='deleteTimeband' src='../assets/images/delete.png'>&nbsp;&nbsp;&nbsp;<img class='editTimeband' src='../assets/images/edit.png'></td></tr>";
	
		var starttime = parseInt(starttime.replace(/\D/g,''));
		var endtime = parseInt(endtime.replace(/\D/g,''));
		
		// error checking
		if (startday.length < 1 || starttime.length < 1 || endday.length < 1 ||  endtime.length < 1 ) return false;
		
		if (startday > endday) {
			var n = noty({ type: 'warning', layout: 'center', text: 'The Start day must be before the End day', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout:1500 });
			return false;
		} else if (endday > startday && starttime > endtime) {
			return false;
		} else if (starttime > endtime) {
			var n = noty({ type: 'warning', layout: 'center', text: 'The Start time must be before the End time', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout:1500 });
			return false;
		}
		
		
		
		
		
		
	// error checking	
		var res = ':' + new_id + ':' + startday + ':' + starttime + ':' + endday + ':' + endtime;					
		timeBands = $.map(timeBands, function(value) {
		if( value.indexOf(new_id) > -1 ) {
			return (value.indexOf('add') === 0 ? 'add' : 'edit') + res;
		}
			return value;
		});
			
		if ( ($.inArray('edit' + res, timeBands) == -1  && $.inArray('add' + res, timeBands) == -1)   ) {
			timeBands.push(tpMode + res)
		} 
		
		if (mode == 'add') {
			$('#timebands > tbody:last-child').append(row);
		} else {
	        $('#' + tp_id).replaceWith(row);
		}
		
		$("#tab2").removeClass("active");
		$("#tab1").addClass("active");
		$("ul#tab li.active").removeClass("active");
		$("ul#tab li").eq(0).addClass("active");
		
		$("#startdayofweek option:contains('Sunday')").prop('selected', 'selected');
		$("#enddayofweek option:contains('Saturday')").prop('selected', 'selected');

		$("#starttime").replaceWith("<input type='text' class='smallFields timepicker' id='starttime' name='starttime' value='' >");
		$("#starttime").wickedpicker({twentyFour: true, now: '00:00'});
		
		$("#endtime").replaceWith("<input type='text' class='smallFields timepicker' id='endtime' name='endtime' value='' >");
		$("#endtime").wickedpicker({twentyFour: true, now: '23:59'});
		
	});
	
	// delete timeband
	$("body").on('click', '.deleteTimeband', function(){
		tp_id = $(this).closest('tr').attr('id');
		timeBands = $.map(timeBands, function(value) {
		if( value.indexOf(tp_id) > -1 ) {
			return undefined;
		}
		return value;
		});
		
		timeBands.push('del:' + tp_id + ':0:0:0:0');
		$('table#timebands tr#' + tp_id).remove();
		console.log(timeBands)
	});
	// timebands //
	
	
	
	
	
	
	
	// dateExceptions //
	// date picker
	$("body").on('focus', '#datepicker', function(){
		$( this ).datepicker({ dateFormat: "d MM", minDate: 0, maxDate: "+1Y -1D"
		});		
	});
	
	// edit dateexceptions
	$("body").on('click', '.editDateException', function(){
		de_id = $(this).closest('tr').attr('id');
		var $row = $(this).closest("tr");
		var tds = $row.find("td");
		$('#datepicker').val( $(tds[1]).text() + ' ' + $(tds[0]).text() );
		
		$("#tab1").removeClass("active");	$("#tab2").addClass("active");
		$("ul#tab li.active").removeClass("active");	$("ul#tab li").eq(1).addClass("active");
		$('#saveDateexception').val( 'Update Date Exception' );
	});
	
	// add/update dateexceptions
	$("body").on('click', '#saveDateexception', function() {
		var mode = ($('#saveDateexception').val().toLowerCase().indexOf("save") >= 0) ? 'add' : 'edit';
		var months = ['','January','February','March','April','May','June','July','August','September','October','November','December'];
		var dayofmonth = ($('#datepicker').val().split(' ')[0]);
		var month = ($('#datepicker').val().split(' ')[1]);
		var month_num = months.indexOf(month);
		
		if ( !month || !month_num || month.length < 1 || month_num.length < 1 ) return false;
		
		var new_id = (mode == 'add') ? (new Date).getTime() : de_id; 
		var deMode = ( de_id.length < 32) ? 'add' : 'edit';
		var row = "<tr id='" + new_id + "'><td>" + month + "</td><td>" + dayofmonth + "</td><td><img class='deleteDateException' src='../assets/images/delete.png'>&nbsp;&nbsp;&nbsp;<img class='editDateException' src='../assets/images/edit.png'></td></tr>";
		var res = ':' + new_id + ':' + dayofmonth + ':' + month_num;					

		dateExceptions = $.map(dateExceptions, function(value) {
		if( value.indexOf(new_id) > -1 ) {
			console.log(value)
			return (value.indexOf('add') === 0 ? 'add' : 'edit') + res;
		}
			return value;
		});
			
		if ( ($.inArray('edit' + res, dateExceptions) == -1  && $.inArray('add' + res, dateExceptions) == -1)   ) {
			dateExceptions.push(deMode + res)
		} 
		console.log (dateExceptions)
		
		if (mode == 'add') {
			$('#dateexceptions > tbody:last-child').append(row);
		} else {
	        $('#' + de_id).replaceWith(row);
		}
		
		$("#tab2").removeClass("active");
		$("#tab1").addClass("active");
		$("ul#tab li.active").removeClass("active");
		$("ul#tab li").eq(0).addClass("active");
		
		if ($('#datepicker').val().length >=1) {
			if ($('#alternateplan :selected').text().length == 0) {
				$('#alternateplan option').filter(function() { return $.trim( $(this).text() ) == 'EMPTY'; }).attr('selected',true);
				var n = noty({ type: 'warning', layout: 'center', text: 'Date Exception Added. Alternate TimePlan set to EMPTY<br><br><i>(click to close)</i><br>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
			}
		}
		
		$('#datepicker').val('');
		$('#saveDateexception').val( 'Save Date Exception' );

	});
	
	
	// delete dateexceptions
	$("body").on('click', '.deleteDateException', function(){
		de_id = $(this).closest('tr').attr('id');
		dateExceptions = $.map(dateExceptions, function(value) {
		if( value.indexOf(de_id) > -1 ) {
			return undefined;
		}
		return value;
		});
		
		dateExceptions.push('del:' + de_id + ':0:0');
		$('table#dateexceptions tr#' + de_id).remove();
		console.log(dateExceptions)
	});
	// dateExceptions //
	
	
	// name check //
	$('body').on('keyup', '#popup input[name=cn]', function(){
		var origName = (selectedName.length > 0) ? encodeURIComponent( $('#results tr.selected').find('td:first').text() ) : '';
		var tpCN = $(this).val(); 

		var response = '';
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?timeplan=" + encodeURIComponent(tpCN),   
         async: true,
         success : function(text) {
             response = text;
			 if (encodeURIComponent(tpCN) === origName) return false;
			 if (response.toLowerCase().indexOf("error") >= 0) {
				$('#msg').html('Invalid or Duplicate Entry'); 
				$("#msg_wrap").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#cn").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			    $("#save").prop("disabled",true);

			 } else {
				$('#msg').html(''); 
				$("#msg_wrap").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
				$("#cn").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
				$("#save").prop("disabled",false);
			 }
         }
		});
	});
	
	
	
});

	// save and/or edit return values to update table
	function UpdateCode(ret) {  
		var ret = ret.split(':');
		modes = ['Timed','Out Of Hours', 'In Hours'];
		var loadMode = ret[0]; 	
		var guid = ret[1]; var name = ret[2];
		var desc = ret[3]; var mode = modes[ret[4]];
		
	
	if (ret[0] == 'edit') {
		$('#results').dataTable().fnUpdate([name] ,$('tr#' + guid)[0], 0, false );
		$('#results').dataTable().fnUpdate([desc] ,$('tr#' + guid)[0], 1, false );
		$('#results').dataTable().fnUpdate([mode] ,$('tr#' + guid)[0], 2, false );
	} else if (ret[0] == 'add') {
		var addRow = $('#results').dataTable().fnAddData( [name, desc, mode ]);
		var newRow = $('#results').dataTable().fnSettings().aoData[addRow[0]].nTr;
		$('#results tr').removeClass("selected");
		newRow.setAttribute('id',guid);
		newRow.setAttribute('class','new selected');
		}
		
	selectedName = name;
	selectedGuid = guid;	
	}
