<?php 
	require('../assets/inc/ldapConnect.php');
	$mode = (isset($_REQUEST['mode']) && strlen($_REQUEST['mode']) >=1 ) ? $_REQUEST['mode'] : NULL; // saveUser, speedDials, deleteUser, moduleList

	
if ($mode === 'saveUser') {
	$userMode = (isset($_REQUEST['userMode']) && strlen($_REQUEST['userMode']) >=1 ) ? $_REQUEST['userMode'] : NULL; // addUser or editUser
	$ent = array();
	
	foreach($_REQUEST as $key => $value){
		if (strpos($key, '_') === false) $ent[$key] = $value;
	}
	
	if ($userMode) {
		
		$cn 				= $ent['cn'];
		$telephonenumber 	= $ent['telephonenumber'];
		$description 		= $ent['description'];
		$userName 			= $ent['userName'];
		$initialphonemodule = $ent['initialphonemodule'];
		$userguid 			= "";		
		
		unset ($ent['mode']);					
		unset ($ent['cn']);	
		unset ($ent['userMode']);
		unset ($ent['userName']);
		unset ($ent['guid']);
		unset ($ent['initialphonemodule']);
		unset ($ent['initialphonedevice']);
		unset ($ent['followmetoselect']);
		unset ($ent['forwardonbusytoselect']);
		unset ($ent['forwardonnoanswertoselect']);
		
		if (!isset($_REQUEST['restrictgroups'])) 			$ent['restrictgroups'] = '0';
		if (!isset($_REQUEST['navigatesoftphonelicense'])) 	$ent['navigatesoftphonelicense'] = '0';
		if (!isset($_REQUEST['navigatesfblicense'])) 		$ent['navigatesfblicense'] = '0';
		if (!isset($_REQUEST['totalcontrollicense'])) 		$ent['totalcontrollicense'] = '0';
		if (!isset($_REQUEST['ipcslicense'])) 	$ent['ipcslicense'] = '0';
		if (!isset($_REQUEST['siplicense'])) 	$ent['siplicense'] = '0';
		if (!isset($_REQUEST['disabled'])) 		$ent['disabled'] = '0';
		if (!isset($_REQUEST['exdirectory'])) 	$ent['exdirectory'] = '0';
		
		if (isset($_REQUEST['messageboxlicense'])) {
			$ent['voicemailEnabled'] = '1';
		} else {
			$ent['voicemailEnabled'] = '0';
			$ent['messageboxlicense'] = '0';
		}	

		$ent['company'] = (isset($_REQUEST['company'])) ? $_REQUEST['company'] : $adminCompany;
		
		
		// unassigned phone ?
		$initialphone = (isset($ent["initialphone"]) && strlen($ent["initialphone"])>1) ? trim($ent["initialphone"]) : NULL;    
		$currenthome = (isset($ent["currenthome"]) && strlen($ent["currenthome"])>1) ? trim($ent["currenthome"]) : NULL;  
  
		$sr=ldap_list($ds,"cn=unassignedphones","(&(objectclass=unassignedphone)(guid={$initialphone}))", array('serialnumber','location','pnpmodel'));
		$info = ldap_get_entries($ds, $sr);  $unassigned = $info['count']; $serial = '';
		for ($n=0; $n<$info['count']; $n++) {				
			$serial = $info[$n]['serialnumber'][0];
			$location = $info[$n]['location'][0];
			$pnpmodel = $info[$n]['pnpmodel'][0];
		}
  
		if ($unassigned == '1') {  
		// Delete unassigned
			$dn = "serialnumber=$serial, cn=unassignedphones";
			ldap_delete($ds, $dn);
					
		// Create Phone Object
			$att=array('objectclass'=>'Phone','typeOfPhone'=>'2','description'=>'Proactive Communication Station','location'=>$currenthome);
			$dn = "cn=PCS $serial,guid=$location, cn=modules";
			ldap_add($ds, $dn,$att);
		
		// Add cn=1 to phone object
			$att=array('objectclass'=>'SplicePhone','serialnumber'=>$serial, 'pnpmodel'=>$pnpmodel);
			$dn = "cn=1,cn=PCS $serial,guid=$location, cn=modules";
			ldap_add($ds, $dn,$att);
			
		// find phones GUID.
			$sr = ldap_read($ds,"cn=PCS $serial, guid=$location,cn=modules","objectclass=Phone"); $info = ldap_get_entries($ds,$sr);
			$ent['initialphone'] = $info[0]['guid'][0];
		}
					
		if ($userMode === "addUser") {
			$ent['objectclass']	= 'user'; // set objectclass
			ldap_add($ds,"cn=$cn,cn=users",$ent); 
			$sr = ldap_read($ds,"cn=$cn,cn=users","objectclass=user",array('guid','disabled')); 
			$info = ldap_get_entries($ds,$sr);	$userguid = $info[0]['guid'][0];  
			$disabledState = (isset($info[0]['disabled'][0])) ? $info[0]['disabled'][0] : '0';
			 
		} else {
			
			if ($initialphonemodule === "clear") $ent['initialphone'] = "00000000-0000-0000-0000-000000000000";
			ldap_modify($ds, "cn=$userName, cn=users", $ent);
			if ($userName != $cn)
				ldap_rename($ds,"cn=$userName,cn=users","cn=$cn","cn=users",true);
			
			// check disabled status	
			$sr = ldap_read($ds,"cn=$userName,cn=users","objectclass=user"); $info = ldap_get_entries($ds,$sr); 
			$disabledState = (isset($info[0]['disabled'][0])) ? $info[0]['disabled'][0] : '0';
		}
		
		$pnpmodel = '';
		if (isset($ent['initialphone']) && strlen($ent['initialphone']) >1) {
			$initPhone = $ent['initialphone'];
			@$sr = ldap_read($ds,"cn=1, guid=$initPhone","objectclass=*"); 
			@$info = ldap_get_entries($ds,$sr); 
			if (isset($info[0]['pnpmodel'][0])) $pnpmodel = str_replace('SIP-', '', $info[0]['pnpmodel'][0]);
			$pnpmodel = (file_exists("../assets/images/phones/$pnpmodel.jpg")) ? $pnpmodel.".jpg" : $pnpmodel;
		}
		
		echo "$userMode,$userguid,$cn,$telephonenumber,$description,$disabledState,$pnpmodel";
		audit ("[User] [$userMode] $cn");

	}
}

if ($mode === 'speedDials') {
	$speedDials = (isset($_REQUEST['speedDials']) && count($_REQUEST['speedDials']) >=1 ) ? $_REQUEST['speedDials'] : NULL; // set speedDials Array
	$speedGroupHeaders = (isset($_REQUEST['speedGroupHeaders']) && count($_REQUEST['speedGroupHeaders']) >=1 ) ? $_REQUEST['speedGroupHeaders'] : NULL; // set speedGroupHeaders Array
	$userName = (isset($_REQUEST['userName']) && strlen($_REQUEST['userName']) >=1 ) ? $_REQUEST['userName'] : NULL; // get Username

	echo "USER<br/>";
	print_r($userName);
	
	echo "<br/>SpeedDials<br/>";
	print_r($speedDials);
	
	echo "<br/>GroupHeaders<br/>";
	print_r($speedGroupHeaders);
	
	if ( $speedGroupHeaders ) {
	foreach ($speedGroupHeaders as $k => $v) {
		$hdrSections = explode(",",$v);
		$hdrMode = $hdrSections[0];
		$hdrGuid = $hdrSections[1];
		$hdrShortcode = str_replace('-',',',$hdrSections[2]);
		$hdrDescription = $hdrSections[3];
					
		if ($hdrMode === 'add') {
			echo "add header..";
			if ($hdrShortcode == '0' && $description == '0') continue;
			$ent["objectclass"] = "speeddial";
			$ent["shortcode"] = $hdrShortcode;
			$dn = "description=$hdrDescription,cn=$userName, cn=Users";
			@ldap_add($ds, $dn, $ent);
			
		} else if ($hdrMode === 'edit') {
			echo "edit";
			$ent["shortcode"][0] = $hdrShortcode;
			$ent["description"][0] = $hdrDescription;
			$dn = "guid=$hdrGuid, cn=Users";
			@ldap_modify($ds, $dn, $ent);
			
		} else if ($hdrMode === 'del') {
			echo "delete..";
			$dn = "guid=$hdrGuid, cn=$userName, cn=Users";
			@ldap_delete($ds, "$dn");
		}
	}
	}
	
	if ( $speedDials ) {
	foreach ($speedDials as $k => $v) {
		echo "add speeddial..";
		$sections = explode(",",$v);
		$action = $sections[0];
		$guid = $sections[1];
		$telephonenumber = $sections[2];
		$description = $sections[3];
		$shortcode = (isset($sections[4])) ? str_replace('-',',',$sections[4]) : '';
		$shortcode = (strpos($shortcode, 'G:996699') !== false) ? str_replace('G:996699,', 'PRI:', $shortcode) : $shortcode;

		$ent["description"] = $description;
		$ent["shortcode"] = $shortcode;
		
		if ($action === 'add') {
			if ($telephonenumber == '0' && $description == '0') continue;
			$ent["objectclass"] = "speeddial";
			$dn = "telephonenumber=$telephonenumber,cn=$userName, cn=Users";
			echo $dn;
			@ldap_add($ds, $dn, $ent);
			var_dump($ent);
			
		} else if ($action === 'edit') {
			$ent["telephonenumber"][0] = $telephonenumber;
			$dn = "guid=$guid, cn=Users";
			echo $dn;
			@ldap_modify($ds, $dn, $ent);
			
		} else if ($action === 'del') {
     		$dn = "guid=$guid, cn=$userName, cn=Users";
			echo $dn;
			@ldap_delete($ds, "$dn");
		}
	}
	}
	audit ("[User] [SpeedDials] $userName");
}

if ($mode === 'deleteUser') {
	$userName = (isset($_REQUEST['userName']) && strlen($_REQUEST['userName']) >=1 ) ? $_REQUEST['userName'] : NULL;
	ldap_delete($ds, "cn=$userName, cn=Users");
	audit ("[User] [Delete] $userName");
}


if ($mode === 'moduleList') {
	
	if (isset($_REQUEST['module']) && strlen($_REQUEST['module']) >1) {
	
	$module	= $_REQUEST['module'];
	$initialOption = $_REQUEST['initialOption'];
	
	$sr=ldap_list($ds,"cn=users","(&(objectclass=user)(!(initialphone=00000000-0000-0000-0000-000000000000)))", array('initialphone'));
	$info = ldap_get_entries($ds, $sr);	$setinitialphones = array();
	for ($m=0; $m<$info['count']; $m++) {				
		$setinitialphones[] = $info[$m]['initialphone'][0];
	}
	$tmp = array_count_values($setinitialphones);
	
	$sr=ldap_list($ds,"guid=$module,cn=modules","(objectclass=phone)", array('cn','guid'));
	$info = ldap_get_entries($ds, $sr);  $modules ='';
	for ($m=0; $m<$info['count']; $m++) {				
		$guid = $info[$m]['guid'][0]; 
		
		$sr2 = ldap_read($ds,"cn=1,guid=$guid","objectclass=*",array('guid','pnpmodel')); 
		$info2 = ldap_get_entries($ds,$sr2);	
		$pnpmodel = (isset($info2[0]['pnpmodel'][0])) ? $info2[0]['pnpmodel'][0] : '';

		if (($guid == $initialOption) || (stripos($pnpmodel, 'W5') !== false) || (stripos($pnpmodel, 'W6') !== false) || (stripos($pnpmodel, 'T53') !== false) || (stripos($pnpmodel, 'T54') !== false)  || (stripos($pnpmodel, 'T57') !== false)  || (stripos($pnpmodel, 'VP59') !== false) || !in_array($guid, $setinitialphones)) {
			
			if (in_array($guid, $setinitialphones)) {
				if ((stripos($pnpmodel, 'W5') !== false && $tmp[$guid] >=5) || (stripos($pnpmodel, 'W6') !== false && $tmp[$guid] >=8) || (stripos($pnpmodel, 'T53') !== false && $tmp[$guid] >=5) || (stripos($pnpmodel, 'T54') !== false && $tmp[$guid] >=5) || (stripos($pnpmodel, 'T57') !== false && $tmp[$guid] >=5) || (stripos($pnpmodel, 'VP59') !== false && $tmp[$guid] >=5)) continue;
			}
			
			$cn =  (substr($info[$m]['cn'][0],0,4)=='port') ?  chunk_split(ucfirst($info[$m]['cn'][0]), 4, ' ') : $info[$m]['cn'][0];
			$modules .= $cn."::".$guid.",";	
		}
		
	}
    //echo $modules;    
	$sr=ldap_list($ds, "cn=UnassignedPhones", "(&(&(objectclass=UnassignedPhone)(typeofphone=2)(location=$module)))", array("cn","guid","typeOfPhone","location"));
	$info2 = ldap_get_entries($ds, $sr); $devices =''; $guid = '';
	
	for ($n=0; $n<$info2['count']; $n++) {				
		$guid = $info2[$n]['guid'][0]; 
		$cn = $info2[$n]['cn'][0];
		$devices .= $cn."::".$guid.",";	
	}
	$devices = rtrim($devices, ',');
              
    if (strlen($devices) >= 1) $modules .= "Unassigned,";
    echo $modules;    
	if (strlen($devices) >= 1) echo $devices; 
	
	}  
}



if ($mode === 'licenceCount') {
	$sr = ldap_list($ds,"cn=system","(&(objectclass=licenserecord)(license=_IPUser))",array('qty','used')); 
	$info = ldap_get_entries($ds,$sr);
	for ($m=0; $m<$info['count']; $m++) {				
		$qty = $info[$m]['qty'][0];
		$used = $info[$m]['used'][0];
	}
	
	echo trim($qty - $used);
}


if ($mode === 'licenceCheck') {
	$licenceCheck = (isset($_REQUEST['licence']) && strlen($_REQUEST['licence']) >= 1) ? $_REQUEST['licence'] : NULL;
	$qty = $used = '';
	
	
	if (stripos($licenceCheck, 'license') !== false) $licenceCheck = str_replace('license','', $licenceCheck);
	
	if ($licenceCheck === 'sip') $licenceCheck = 'SIPPhone';
	if ($licenceCheck === 'IP') $licenceCheck = 'IPUser';
	if ($licenceCheck === 'iPCS') $licenceCheck = 'iPCS';
	if ($licenceCheck === 'Analogue')$licenceCheck = 'AnalogueUser';
	if ($licenceCheck === 'Virtual') $licenceCheck = 'IPVirtualUser';
	if ($licenceCheck === 'totalcontrol') $licenceCheck = 'VisionMobility';

	if ($licenceCheck) {
		$sr = ldap_list($ds,"cn=system","(&(objectclass=licenserecord)(license=_$licenceCheck))",array('qty','used')); 
		$info = ldap_get_entries($ds,$sr);
		for ($m=0; $m<$info['count']; $m++) {				
			$qty = $info[$m]['qty'][0];
			$used = $info[$m]['used'][0];
		}
	
	echo trim($qty - $used);
	}	
}

if ($mode === 'forwarding') {
	$selected = (isset($_REQUEST['selected']) && strlen($_REQUEST['selected']) >=1 ) ? $_REQUEST['selected'] : NULL;
	$currentTele = (isset($_REQUEST['currentTele']) && strlen($_REQUEST['currentTele']) >=1 ) ? $_REQUEST['currentTele'] : NULL;
	$values = '';
	
	if ($selected) {
		switch ($selected) {
		case 'users':
			$queryCn = ($adminCompany === '00000000-0000-0000-0000-000000000000') ? "cn=Users" : "cn=Users, cn=$adminCompany, cn=Companies";

			$objectclass = "user";
			$filter = array('cn','telephonenumber');
			break;
		case 'departments':
			$queryCn = ($adminCompany === '00000000-0000-0000-0000-000000000000') ? "cn=departments" : "cn=departments, cn=$adminCompany, cn=Companies";
			$objectclass = "department";
			$filter = array('cn','telephonenumber');
			break;		
		}
		
		$sr=ldap_list($ds, $queryCn,"(objectclass=$objectclass)", $filter);
		$info = ldap_get_entries($ds, $sr);	$selectedEntries = array();
		for ($m=0; $m<$info['count']; $m++) {				
			
			if ($info[$m]['telephonenumber'][0] === $currentTele || $info[$m]['cn'][0] === "InboundRecordings" || $info[$m]['cn'][0] === "OutboundRecordings") continue;
			
			if ($selected === 'conference') {
				$values .= $info[$m]['cn'][0] . ":" . $info[$m]['cn'][0] . ",";
			} else {
				$values .= $info[$m]['telephonenumber'][0] . ":" . $info[$m]['cn'][0] . " (" . $info[$m]['telephonenumber'][0]. ")" . ",";
			}
		}
			$values = rtrim($values, ',');
			echo $values;
	}
}

ldap_close($ds);
?>