	$(document).ready(function(){
		
		$('#wizard').smartWizard({transitionEffect:'none', enableFinishButton:false, enableAllSteps: false, hideButtonsOnDisabled: true, onFinish: onFinishCallback, keyNavigation:false});
		$('#wizard').smartWizard('enableFinish',false);
		
		var state = {};
		var title = 'Help';
		var url   = '/manager/admin';
		history.pushState(state, title, url);
		
		masterIP = 0;
		$("body").on('blur', '#ask_master', function(){
			var ipcheck = /^([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])$/;
			if ($(this).val() != "" && !$(this).val().match(ipcheck)) { 
				var n_error = noty({type:'error', layout:'center', modal: 'true', closeWith: [], theme: 'relax', text: "Error: Invalid Master IP Address", timeout: 1500}); 
				masterIP = 1;
			} else {
				masterIP = 0;
				}
			});
		
		
		$('#get_licences').click(function() {
						
			system_name = $('#system_name').val();
			if (!system_name && system_name.length <=0) {
				$('#wizard').smartWizard('showMessage','No System Name Configured');
				$("#system_name").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#system_name").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			supplier = $('#system_supplier').val();
			if (!supplier && supplier.length <=0) {
				$('#wizard').smartWizard('showMessage','No Supplier Configured');
				$("#system_supplier").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#system_supplier").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			registered_email = $('#uemail').val();
			if (!registered_email && registered_email.length <=0) {
				$('#wizard').smartWizard('showMessage','No Forum Username Configured');
				$("#uemail").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#uemail").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			registered_password = $('#upassword').val();
			if (!registered_password && registered_password.length <=0) {
				$('#wizard').smartWizard('showMessage','No Forum Password Configured');
				$("#upassword").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#upassword").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			
		
		$('#licence_msg').html("");
		$('#licence_status').html("<img src='admin/assets/images/loading.gif'/>");

		var credentials = '&uemail=' + encodeURIComponent($("#uemail").val()) + '&upassword=' + encodeURIComponent($("#upassword").val()) + '&supplier=' + encodeURIComponent($("#system_supplier").val()) + '&system=' + encodeURIComponent($("#system_name").val());
		
		$.ajax({
			url: 'admin/utilities/askmasterhelper.php?mode=licences' + credentials,
			dataType: 'json',
			success: function(data) {
				if (data[0].toLowerCase().indexOf("error") >= 0) {
					$('#licence_msg').html("An Error has Occurred: " + data[0]).css('color', '#bf0000');
					$('#licence_status').html("<img src='admin/assets/images/fail.png'/>");
				} else {
					$('#wizard').smartWizard('showMessage','Licences Successfully Retrieved');
					$('#licence_status').html("<img src='admin/assets/images/success.png'/>");

					if (data[1].length >=1) {
						$('#licence_select').empty()
						$('#softpbx_multiple_licences').show();
						jQuery.each(data[1], function(index, item) {
							licence = item.split(',');
							var o = new Option(licence[1] + " (" + licence[2] + ")", item);
							$(o).html(licence[1] + " (" + licence[2] + ")");
							$('#licence_select').append(o);
						});
					} else {
						$('#wizard').smartWizard('showMessage','No SV Licence Retrieved');
					}
				}
			},
			error: function(data){
				$('#licence_msg').html("An Error has Occurred: ").css('color', '#bf0000');
				$('#licence_status').html("<img src='admin/assets/images/fail.png'/>");
			},
		});
	});		
	
	
     function onFinishCallback() {
		
		system_name = $("#system_name").val()
		system_supplier = $("#system_supplier").val()
		ask_master = $("#ask_master").val()
		licence_select = ( $("#licence_select").val() ) ? $("#licence_select").val() : '0';
		
		if (masterIP == '1') {
			var n_error = noty({type:'error', layout:'center', modal: 'true', closeWith: [], theme: 'relax', text: "Error: Invalid Master IP Address", timeout: 1500}); 
			return false
		}
		
		if (licence_select == '0') {
			$('#wizard').smartWizard('showMessage','Please Download Licences');
			var n_error = noty({type:'error', layout:'center', modal: 'true', closeWith: [], theme: 'relax', text: "Error: Please Download Licences", timeout: 1500}); 
			return false;
		}
		
		if  ( system_name.length < 1 || system_supplier.length < 1 || ask_master.length < 1 || licence_select < 1) {
			$('#wizard').smartWizard('showMessage','Required Fields Not Completed');
			var n_error = noty({type:'error', layout:'center', modal: 'true', closeWith: [], theme: 'relax', text: "Error: Required Fields Not Completed", timeout: 1500}); 
			return false;
		}	
   
		var n = noty({
        type: 'information', layout: 'center', text: 'Perform Ask Master to <span style="color:#000000; font-weight:700">' + ask_master + '</span> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [{ addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
			$noty.close();

				var credentials = '&system_name=' + encodeURIComponent(system_name) + '&system_supplier=' + encodeURIComponent(system_supplier) + '&ask_master=' + encodeURIComponent(ask_master) + '&licence_select=' + encodeURIComponent(licence_select);
		
				$.ajax({
					type: "POST",
					url: "admin/utilities/askmasterhelper.php?mode=askmaster",
					data: credentials,
					dataType: "text",
					success: function(data) {
						console.log(data)
						if (data.indexOf("error") >= 0) {
							var n_error = noty({type:'error', layout:'center', modal: 'true', closeWith: [], theme: 'relax', text: "Error detected. Please check your setting and try again."}); 
						} else {
							var n_success = noty({type:'information', layout:'center', modal: 'true', closeWith: [], theme: 'relax', text: 'Ask Master submitted to <span style="color:#000000; font-weight:700">' + ask_master + '</span><br><br>Manager will reload in <span id="reload" style="color:#000000; font-weight:700">05:00</span> minutes'}); 
							
							function startTimer(duration, display) {
								var timer = duration, minutes, seconds;
								var end =setInterval(function () {
									minutes = parseInt(timer / 60, 10)
									seconds = parseInt(timer % 60, 10);
						
									minutes = minutes < 10 ? "0" + minutes : minutes;
									seconds = seconds < 10 ? "0" + seconds : seconds;
						
									display.textContent = minutes + ":" + seconds;
						
									if (--timer < 0) {
										window.location = "/manager/manager.cgi";
										clearInterval(end);
									}
								}, 1000);
							}
						
							var fiveMinutes = 300;
							display = document.querySelector('#reload');
							startTimer(fiveMinutes, display);
							
						}	
						return false;
					},
					error: function(data) {
						$noty.close();
					}
				});
			}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); 
					}
                }]
        });
      }
	
});