<?php
// v1.6 08 July 2015 - Added POTS Module to Initial Phone Select

session_start();

$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","00112233445566");
		ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
	}
}

if (isset($_REQUEST['module']) && strlen($_REQUEST['module']) >1) {
	
$sr=ldap_list($ds,"cn=users","(&(objectclass=user)(!(initialphone=00000000-0000-0000-0000-000000000000)))", array('initialphone'));
$info = ldap_get_entries($ds, $sr);	$setinitialphones = array();
for ($m=0; $m<$info['count']; $m++) {				
	$setinitialphones[] = $info[$m]['initialphone'][0];
}

$sr=ldap_list($ds,"guid={$_REQUEST['module']},cn=modules","(objectclass=phone)", array('cn','guid'));
$info = ldap_get_entries($ds, $sr);  $modules ='';
for ($m=0; $m<$info['count']; $m++) {				
	$guid = $info[$m]['guid'][0]; 
	if (($guid == $_SESSION['user_inital_guid']) || !in_array($guid, $setinitialphones)) {
		$cn =  (substr($info[$m]['cn'][0],0,4)=='port') ?  chunk_split(ucfirst($info[$m]['cn'][0]), 4, ' ') : $info[$m]['cn'][0];
		$modules .= $cn."::".$guid.",";	
	}
}
	//$modules = rtrim($modules, ',');

    
$sr=ldap_list($ds, "cn=UnassignedPhones", "(&(&(objectclass=UnassignedPhone)(typeofphone=2)(location={$_REQUEST['module']})))", array("serialNumber","guid","typeOfPhone","location"));
$info2 = ldap_get_entries($ds, $sr); $devices =''; $guid = '';
 	   	
for ($n=0; $n<$info2['count']; $n++) {				
	$guid = $info2[$n]['guid'][0]; 
	$serial = $info2[$n]['serialnumber'][0];
	$devices .= $serial."::".$guid.",";	
}
	$devices = rtrim($devices, ',');
              
    if (strlen($devices) >= 1) $modules .= "Unassigned,";
    echo $modules;    
	if (strlen($devices) >= 1) echo $devices;    
}    
              
						
if (isset($_REQUEST['adduser']) && $_REQUEST['adduser'] == '1' ) {
	
  	$initialphonedevice = (isset($_REQUEST["initialphonedevice"]) && strlen($_REQUEST["initialphonedevice"])>1) ? trim($_REQUEST["initialphonedevice"]) : NULL;    
  	$currenthome = (isset($_REQUEST["currenthome"]) && strlen($_REQUEST["currenthome"])>1) ? trim($_REQUEST["currenthome"]) : NULL;  
  
  	$sr=ldap_list($ds,"cn=unassignedphones","(&(objectclass=unassignedphone)(guid={$initialphonedevice}))", array('serialnumber','location'));
  	$info = ldap_get_entries($ds, $sr);  $unassigned = $info['count']; $serial = '';
  	for ($n=0; $n<$info['count']; $n++) {				
		$serial = $info[$n]['serialnumber'][0];
		$location = $info[$n]['location'][0];
  	}
  
  $sr = ldap_search($ds,"cn=Modules","(&(objectclass=*)(guid=$currenthome))"); $info = ldap_get_entries($ds,$sr); $homeip = $info[0]['ipaddress'][0];
  
if ($unassigned == '1') {  
// Delete unassigned
	$dn = "serialnumber=$serial, cn=unassignedphones";
    ldap_delete($ds, $dn);
        	
// Create Phone Object
	$att=array('objectclass'=>'Phone','typeOfPhone'=>'2','description'=>'Proactive Communication Station','location'=>$currenthome);
	$dn = "cn=PCS $serial,guid=$location, cn=modules";
	ldap_add($ds, $dn,$att);

// Add cn=1 to phone object
	$att=array('objectclass'=>'SplicePhone','serialnumber'=>$serial);
	$dn = "cn=1,cn=PCS $serial,guid=$location, cn=modules";
	ldap_add($ds, $dn,$att);
	
// find phones GUID.
	$sr = ldap_read($ds,"cn=PCS $serial, guid=$location,cn=modules","objectclass=Phone"); $info = ldap_get_entries($ds,$sr);
	$initialphonedevice = $info[0]['guid'][0];
}

   	$username = (isset($_REQUEST["user_name"]) && strlen($_REQUEST["user_name"])>1) ? trim($_REQUEST["user_name"]) : NULL;
  	$firstname = (isset($_REQUEST["firstname"]) && strlen($_REQUEST["firstname"])>1) ? trim($_REQUEST["firstname"]) : NULL;
  	$lastname = (isset($_REQUEST["lastname"]) && strlen($_REQUEST["lastname"])>1) ? trim($_REQUEST["lastname"]) : NULL;
  	$description = (isset($_REQUEST["description"]) && strlen($_REQUEST["description"])>1) ? trim($_REQUEST["description"]) : '';
  	$user_ext = (isset($_REQUEST["user_ext"]) && strlen($_REQUEST["user_ext"])>1) ? trim($_REQUEST["user_ext"]) : NULL;  
  	$company = (isset($_REQUEST["company"]) && strlen($_REQUEST["company"])>1) ? trim($_REQUEST["company"]) : NULL;    
  	$homephone = (isset($_REQUEST["homephone"]) && strlen($_REQUEST["homephone"])>1) ? trim($_REQUEST["homephone"]) : NULL;        
  	$mobilephone = (isset($_REQUEST["mobilephone"]) && strlen($_REQUEST["mobilephone"])>1) ? trim($_REQUEST["mobilephone"]) : NULL;        
  	$spare1phone = (isset($_REQUEST["spare1phone"]) && strlen($_REQUEST["spare1phone"])>1) ? trim($_REQUEST["spare1phone"]) : NULL;        
  	$spare2phone = (isset($_REQUEST["spare2phone"]) && strlen($_REQUEST["spare2phone"])>1) ? trim($_REQUEST["spare2phone"]) : NULL;        
  	$dialplan = (isset($_REQUEST["dialplan"]) && strlen($_REQUEST["dialplan"])>1) ? trim($_REQUEST["dialplan"]) : NULL;        
  	$noanswertime = (isset($_REQUEST["noanswertime"]) && strlen($_REQUEST["noanswertime"])>=1) ? $_REQUEST["noanswertime"] : '20';        
  	$voicemail = (isset($_REQUEST["voicemail"]) && ($_REQUEST["voicemail"])=='on') ? '1' : '0';   
  	$voicemailaccesscode = (isset($_REQUEST["voicemailaccesscode"]) && strlen($_REQUEST["voicemailaccesscode"])>1) ? trim($_REQUEST["voicemailaccesscode"]) : NULL;        
  	$opsconsolelicence = (isset($_REQUEST["opsconsolelicence"]) && strlen($_REQUEST["opsconsolelicence"])>=1) ? trim($_REQUEST["opsconsolelicence"]) : NULL;      
  	$virtualuserlicence = (isset($_REQUEST["virtualuserlicence"]) && ($_REQUEST["virtualuserlicence"])=='on') ? '1' : '0';        
  	$messageboxlicence = (isset($_REQUEST["messageboxlicence"]) && ($_REQUEST["messageboxlicence"])=='on') ? '1' : '0';        
  	$visionmobilitylicence = (isset($_REQUEST["visionmobilitylicence"]) && ($_REQUEST["visionmobilitylicence"])=='on') ? '1' : '0';        
  	$visionagentlicence = (isset($_REQUEST["visionagentlicence"]) && ($_REQUEST["visionagentlicence"])=='on') ? '1' : '0';        
  	$ocslicence = (isset($_REQUEST["ocslicence"]) && ($_REQUEST["ocslicence"])=='on') ? '1' : '0';       
  	$ipcslicence = (isset($_REQUEST["ipcslicence"]) && ($_REQUEST["ipcslicence"])=='on') ? '1' : '0';        
  	$navigatesoftphonelicence = (isset($_REQUEST["navigatesoftphonelicence"]) && ($_REQUEST["navigatesoftphonelicence"])=='on') ? '1' : '0';        
  	$navigateoutlooklicence = (isset($_REQUEST["navigateoutlooklicence"]) && strlen($_REQUEST["navigateoutlooklicence"])>=1) ? trim($_REQUEST["navigateoutlooklicence"]) : NULL;        
  
	$caps1 = (isset($_REQUEST["caps1"]) && strlen($_REQUEST["caps1"])>1) ? trim($_REQUEST["caps1"]) : NULL;
  	$caps1value = (isset($_REQUEST["caps1value"]) && strlen($_REQUEST["caps1value"])>=1) ? trim($_REQUEST["caps1value"]) : NULL;
  	$caps2 = (isset($_REQUEST["caps2"]) && strlen($_REQUEST["caps2"])>1) ? trim($_REQUEST["caps2"]) : NULL;
  	$caps2value = (isset($_REQUEST["caps2value"]) && strlen($_REQUEST["caps2value"])>=1) ? trim($_REQUEST["caps2value"]) : NULL;
  	$caps3 = (isset($_REQUEST["caps3"]) && strlen($_REQUEST["caps3"])>1) ? trim($_REQUEST["caps3"]) : NULL;
  	$caps3value = (isset($_REQUEST["caps3value"]) && strlen($_REQUEST["caps3value"])>=1) ? trim($_REQUEST["caps3value"]) : NULL;
   	$groups = (isset($_REQUEST["groups"]) && strlen($_REQUEST["groups"])>1) ? $_REQUEST["groups"] : NULL;


	$newuser = array('objectclass'=>'user','noanswertime'=>$noanswertime,'loginidletime'=>'18000','description'=>$description,
					 'company'=>$company,'telephonenumber'=>$user_ext,'initialphone'=>$initialphonedevice,'dialplan'=>$dialplan,
					 'homepage'=>"http://{$homeip}/index.php?u=%u&e=%e&p=%p",'currenthome'=>$currenthome, 'givenname'=>$firstname,
					 'sn'=>$lastname, 'hometelephonenumber'=>$homephone, 'mobiletelephonenumber'=>$mobilephone, 'spare1telephonenumber'=>$spare1phone,
					 'spare2telephonenumber'=>$spare2phone, 'voicemailenabled'=>$voicemail, 'voicemailaccesscode'=>$voicemailaccesscode,
					 'ocslicense'=>$ocslicence, 'messageboxlicense'=>$messageboxlicence, 'totalcontrollicense'=>$visionmobilitylicence,
					 'operatorconsolelicense'=>$opsconsolelicence, 'agentlicense'=>$visionagentlicence, 'ipcslicense'=>$ipcslicence, 
					 'navigatesoftphonelicense'=>$navigatesoftphonelicence, 'navigateoutlooklicense'=>$navigateoutlooklicence
					 );
					 
	$result = ldap_add($ds,"cn=$username,cn=users",$newuser); 

	if (isset($caps1) && isset($caps1value)) {
		$ent = array(); $ent["capabilitypercent"] = $caps1value; $ent["objectclass"] = "capability";
		$dn = "capability=$caps1,cn=$username, cn=Users";
		ldap_add($ds, $dn, $ent);
	}
	
	if (isset($caps2) && isset($caps2value)) {
		$ent = array(); $ent["capabilitypercent"] = $caps2value; $ent["objectclass"] = "capability";
		$dn = "capability=$caps2,cn=$username, cn=Users";
		ldap_add($ds, $dn, $ent);
	}
	
	if (isset($caps3) && isset($caps3value)) {
		$ent = array(); $ent["capabilitypercent"] = $caps3value; $ent["objectclass"] = "capability";
		$dn = "capability=$caps3,cn=$username, cn=Users";
		ldap_add($ds, $dn, $ent);
	}
	
	
	if (isset($groups)) {
		$sr = ldap_read($ds,"cn=$username,cn=users","objectclass=user"); $info = ldap_get_entries($ds,$sr);
		$userguid = $info[0]['guid'][0];

		foreach ($groups as $grpkey => $grpvalue) {
			$sr = ldap_list($ds,"cn=$grpvalue,cn=Groups","objectclass=*");
 			$info = ldap_get_entries($ds,$sr); $exisingmembers = array();
 				for ($n=0; $n<$info['count']; $n++) {
	   				$exisingmembers[] = $info[$n]['member'][0];
   				}
	
 		$pid = ($info['count']) ? $info[0]['id'][0] : '0';

 		if (in_array($userguid, $exisingmembers)) break;
		$pid++;
        $att=array('objectclass'=>'Member','GUID'=>'00000000-0000-0000-0000-000000000000','priority'=>'0','member'=>$userguid);
  	    ldap_add($ds,"id=$pid, cn=$grpvalue, cn=Groups",$att);
		}
  }
	
	unset($newuser);
	echo $result;
}


if (isset($_REQUEST['edituser']) && $_REQUEST['edituser'] == '1' ) {
	$users_guid = $_REQUEST['users_guid'];
	
	$sr = ldap_list($ds,"cn=users","(&(objectclass=user)(guid=$users_guid))"); $info = ldap_get_entries($ds,$sr);
	$user_dn = $info[0]['dn']; $user_cn = $info[0]['cn'][0];
	
  	$initialphonedevice = (isset($_REQUEST["initialphonedevice"]) && strlen($_REQUEST["initialphonedevice"])>1) ? trim($_REQUEST["initialphonedevice"]) : NULL;    
  	$currenthome = (isset($_REQUEST["currenthome"]) && strlen($_REQUEST["currenthome"])>1) ? trim($_REQUEST["currenthome"]) : NULL;  
  
  	$sr=ldap_list($ds,"cn=unassignedphones","(&(objectclass=unassignedphone)(guid={$initialphonedevice}))", array('serialnumber','location'));
  	$info = ldap_get_entries($ds, $sr);  $unassigned = $info['count']; $serial = '';
  	for ($n=0; $n<$info['count']; $n++) {				
		$serial = $info[$n]['serialnumber'][0];
		$location = $info[$n]['location'][0];
  	}
  
  $sr = ldap_search($ds,"cn=Modules","(&(objectclass=*)(guid=$currenthome))"); $info = ldap_get_entries($ds,$sr); $homeip = $info[0]['ipaddress'][0];
  
if ($unassigned == '1') {  
// Delete unassigned
	$dn = "serialnumber=$serial, cn=unassignedphones";
    ldap_delete($ds, $dn);
        	
// Create Phone Object
	$att=array('objectclass'=>'Phone','typeOfPhone'=>'2','description'=>'Proactive Communication Station','location'=>$currenthome);
	$dn = "cn=PCS $serial,guid=$location, cn=modules";
	ldap_add($ds, $dn,$att);

// Add cn=1 to phone object
	$att=array('objectclass'=>'SplicePhone','serialnumber'=>$serial);
	$dn = "cn=1,cn=PCS $serial,guid=$location, cn=modules";
	ldap_add($ds, $dn,$att);
	
// find phones GUID.
	$sr = ldap_read($ds,"cn=PCS $serial, guid=$location,cn=modules","objectclass=Phone"); $info = ldap_get_entries($ds,$sr);
	$initialphonedevice = $info[0]['guid'][0];
}

   	$username = (isset($_REQUEST["user_name"]) && strlen($_REQUEST["user_name"])>1) ? trim($_REQUEST["user_name"]) : NULL;
  	$firstname = (isset($_REQUEST["firstname"]) && strlen($_REQUEST["firstname"])>1) ? trim($_REQUEST["firstname"]) : NULL;
  	$lastname = (isset($_REQUEST["lastname"]) && strlen($_REQUEST["lastname"])>1) ? trim($_REQUEST["lastname"]) : NULL;
  	$description = (isset($_REQUEST["description"]) && strlen($_REQUEST["description"])>1) ? trim($_REQUEST["description"]) : '';
  	$user_ext = (isset($_REQUEST["user_ext"]) && strlen($_REQUEST["user_ext"])>1) ? trim($_REQUEST["user_ext"]) : NULL;  
  	$company = (isset($_REQUEST["company"]) && strlen($_REQUEST["company"])>1) ? trim($_REQUEST["company"]) : NULL;    
  	$homephone = (isset($_REQUEST["homephone"]) && strlen($_REQUEST["homephone"])>1) ? trim($_REQUEST["homephone"]) : NULL;        
  	$mobilephone = (isset($_REQUEST["mobilephone"]) && strlen($_REQUEST["mobilephone"])>1) ? trim($_REQUEST["mobilephone"]) : NULL;        
  	$spare1phone = (isset($_REQUEST["spare1phone"]) && strlen($_REQUEST["spare1phone"])>1) ? trim($_REQUEST["spare1phone"]) : NULL;        
  	$spare2phone = (isset($_REQUEST["spare2phone"]) && strlen($_REQUEST["spare2phone"])>1) ? trim($_REQUEST["spare2phone"]) : NULL;        
  	$dialplan = (isset($_REQUEST["dialplan"]) && strlen($_REQUEST["dialplan"])>1) ? trim($_REQUEST["dialplan"]) : NULL;        
  	$noanswertime = (isset($_REQUEST["noanswertime"]) && strlen($_REQUEST["noanswertime"])>=1) ? $_REQUEST["noanswertime"] : '20';        
  	$voicemail = (isset($_REQUEST["voicemail"]) && ($_REQUEST["voicemail"])=='on') ? '1' : '0';   
  	$voicemailaccesscode = (isset($_REQUEST["voicemailaccesscode"]) && strlen($_REQUEST["voicemailaccesscode"])>1) ? trim($_REQUEST["voicemailaccesscode"]) : NULL;        
  	$opsconsolelicence = (isset($_REQUEST["opsconsolelicence"]) && strlen($_REQUEST["opsconsolelicence"])>=1) ? trim($_REQUEST["opsconsolelicence"]) : NULL;      
  	$virtualuserlicence = (isset($_REQUEST["virtualuserlicence"]) && ($_REQUEST["virtualuserlicence"])=='on') ? '1' : '0';        
  	$messageboxlicence = (isset($_REQUEST["messageboxlicence"]) && ($_REQUEST["messageboxlicence"])=='on') ? '1' : '0';        
  	$visionmobilitylicence = (isset($_REQUEST["visionmobilitylicence"]) && ($_REQUEST["visionmobilitylicence"])=='on') ? '1' : '0';        
  	$visionagentlicence = (isset($_REQUEST["visionagentlicence"]) && ($_REQUEST["visionagentlicence"])=='on') ? '1' : '0';        
  	$ocslicence = (isset($_REQUEST["ocslicence"]) && ($_REQUEST["ocslicence"])=='on') ? '1' : '0';       
  	$ipcslicence = (isset($_REQUEST["ipcslicence"]) && ($_REQUEST["ipcslicence"])=='on') ? '1' : '0';        
  	$navigatesoftphonelicence = (isset($_REQUEST["navigatesoftphonelicence"]) && ($_REQUEST["navigatesoftphonelicence"])=='on') ? '1' : '0';        
  	$navigateoutlooklicence = (isset($_REQUEST["navigateoutlooklicence"]) && strlen($_REQUEST["navigateoutlooklicence"])>=1) ? trim($_REQUEST["navigateoutlooklicence"]) : NULL;        
  
	$groups = (isset($_REQUEST["groups"]) && count($_REQUEST["groups"])>=1) ? $_REQUEST["groups"] : NULL;
	
	$newuser = array('noanswertime'=>$noanswertime,'loginidletime'=>'18000','description'=>$description,
					 'company'=>$company,'telephonenumber'=>$user_ext,'initialphone'=>$initialphonedevice,'dialplan'=>$dialplan,
					 'homepage'=>"http://{$homeip}/index.php?u=%u&e=%e&p=%p",'currenthome'=>$currenthome, 'givenname'=>$firstname,
					 'sn'=>$lastname, 'hometelephonenumber'=>$homephone, 'mobiletelephonenumber'=>$mobilephone, 'spare1telephonenumber'=>$spare1phone,
					 'spare2telephonenumber'=>$spare2phone, 'voicemailenabled'=>$voicemail, 'voicemailaccesscode'=>$voicemailaccesscode,
					 'ocslicense'=>$ocslicence, 'messageboxlicense'=>$messageboxlicence, 'totalcontrollicense'=>$visionmobilitylicence,
					 'operatorconsolelicense'=>$opsconsolelicence, 'agentlicense'=>$visionagentlicence, 'ipcslicense'=>$ipcslicence, 
					 'navigatesoftphonelicense'=>$navigatesoftphonelicence, 'navigateoutlooklicense'=>$navigateoutlooklicence
					 );

	if ($user_cn != $username) {
		$user_dn = "GUID=$users_guid,cn=Users";
		ldap_rename($ds,$user_dn,"cn=$username","cn=Users",true);
	}
					 
	$result = ldap_modify($ds,$user_dn,$newuser); 
	
	$caps = $capsvalue = array(); 
	if (isset($_REQUEST['caps']) && count ($_REQUEST['caps']) >=1) {
	$caps = $_REQUEST['caps']; $capsvalue = $_REQUEST['capsvalue'];
		
	$sr = ldap_search($ds,"cn=$username,cn=users","(objectclass=Capability)",array('dn','guid'));
	$info = ldap_get_entries($ds, $sr);
	for ($m=0; $m<$info['count']; $m++) {
		$existing_guid = $info[$m]['guid'][0];
		$dp = "cn=$existing_guid,cn=$username,cn=Users";
		ldap_delete($ds, $dp);
	}
			
	
	foreach ($caps as $capsk => $capsv) {		
		$ent = array(); $ent["capabilitypercent"] = $capsvalue[$capsk]; $ent["objectclass"] = "capability";
		$dn = "capability=$capsv,cn=$username, cn=Users";
		if (strlen($capsv) >= '1') ldap_add($ds, $dn, $ent);
		}
	}
		

	if (isset($groups)) {
		$sr = ldap_read($ds,"cn=$username,cn=users","objectclass=user"); $info = ldap_get_entries($ds,$sr);
		$userguid = $info[0]['guid'][0];
		
		$sr = ldap_search($ds,"cn=groups","(&(objectclass=member)(member=$users_guid))",array('guid'));
		$info = ldap_get_entries($ds, $sr);
		for ($m=0; $m<$info['count']; $m++) {
			$existing_guid= $info[$m]['guid'][0];
			$dp = "cn=$existing_guid,cn=$username,cn=Users";
			ldap_delete($ds, $dp);
		}
	
   			
		foreach ($groups as $grpkey => $grpvalue) {
			$sr = ldap_list($ds,"cn=$grpvalue,cn=Groups","objectclass=*");
 			$info = ldap_get_entries($ds,$sr); $exisingmembers = array();
 				for ($n=0; $n<$info['count']; $n++) {
					$exisingmembers[] = $info[$n]['member'][0];
   				}
   			
 		$pid = ($info['count']) ? $info[0]['id'][0] : '0';

 		if (in_array($userguid, $exisingmembers)) break;
		$pid++;
        $att=array('objectclass'=>'Member','GUID'=>'00000000-0000-0000-0000-000000000000','priority'=>'0','member'=>$userguid);
  	    ldap_add($ds,"id=$pid, cn=$grpvalue, cn=Groups",$att);
		}
	}
	unset($newuser);
	echo $result;
}

?>