<?php
session_start;

// v3.03
// PJC 21SEP2018 - Only show Paging Channels on softPBX
// PJC 07NOV2017 - Added Paging Channels and Relays
// PJC 10AUG2017 - Updated GUID for Default Company
// PJC 31MAY2017 - Updated to use Wizard
// PJC 31OCT2015 - Wording Update
// PJC 15JUL2015 - Updated Default Admin Rights & System Container
// PJC 04Feb2015 - Updated permissions for show assist / show update servers
// PJC 21Jan2015 - Default ACL based on manager permissions
// PJC 18Dec2014 - Default MA permissions added
// PJC 05June2014 - update licenses attribute spelling
// PJC 16Jan2013

$page_id = "074";
include ".access.php";
include "tzone.php"; // include timezone

$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
    echo "LDAP connect failure<br>";
} else {
    $r = @ldap_bind($ds,"INTERNAL","0123456");
	if ( ! $r) {
	    echo "LDAP bind failure<br>";
		$ds = false;
	}
}

$model = (file_exists('/SpliceCom/model')) ? trim(file_get_contents('/SpliceCom/model')) : 'softPBX';

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>Administrator Wizard</title>
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="css/Styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="css/buttons.css" rel="stylesheet" type="text/css">
<link href="css/wiz/smart_wizard.css" rel="stylesheet" type="text/css">

<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/wiz/jquery.smartWizard.js" type="text/javascript"></script>
<script src="js/jquery.noty.packaged.js" type="text/javascript"></script>
<script src="js/wiz/admin.js" type="text/javascript"></script>
</head>

<body>

<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_administrators.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<div id = "contain">
<div id="content">

<div id="wrap">

<!-- content begins -->
<div id="main">
<div class="wrapper">


<table align="center" border="0" cellpadding="0" cellspacing="0">
<tr><td> 
<form action="administrator_do.php" method="post" name="config" id="config">
<!-- Tabs -->
  		<div id="wizard" class="swMain">
  			<ul>
			<li><a href="#step-1">
                <label class="stepNumber">1</label>
                <span class="stepDesc">
                   Administrator<br />
				   <small>Administrator Configuration</small>
                </span>
            </a></li>
			<li><a href="#step-2">
                <label class="stepNumber">2</label>
                <span class="stepDesc">
                   View Access<br />
				   <small>Select Areas To View</small>
                </span>                   
             </a></li>
  			<li><a href="#step-3">
                <label class="stepNumber">3</label>
                <span class="stepDesc">
                   Rights Configuration<br />
				   <small>Configure Access Rights</small>
                </span>
            </a></li>
  			<li><a href="#step-4">
                <label class="stepNumber">4</label>
                <span class="stepDesc">
                   Overview<br />
				   <small>Administrator Overview</small>
                   
                </span>
            </a></li>
  			</ul>


		<div id="step-1">	
		<div class="stepOne">
            <span class="StepTitle">Step 1: Administrator Configuration</span>
		</div>
		<div style='padding-left:100px; padding-right:100px;'>
		<h3>Administrator</h3>
			This script will guide you through the configuration of an new System Administrator.<br><br>

			<div class='block'><label><b>Administrator Name:</b></label><input type="text" name="admin_name" id="admin_name" size="30" maxlength="16" onkeyup="AdminshowHint(this.value)" autocomplete="off" tabindex="1"/><a href='#' class="tooltip" title="The Name To Be Applied To The New Administrator. max 16 chars"><img src="images/tooltip.gif"></a>&nbsp;<span id="txtHint"></span></div>
			<br><div class='block'><label><b>Administrator Description:</b></label><input type="text" name="admin_desc" id="admin_desc" size="30" maxlength="64" autocomplete="off"/ tabindex="2"><a href='#' class="tooltip" title="The Description To Be Applied To The New Administrator. max 64 chars"><img src="images/tooltip.gif"></a></div>
			<br><div class='block'><label><b>Administrator Password:</b></label><input type="text" name="admin_password" id="admin_password" size="30" maxlength="16" onkeyup="AdminPassHint(this.value)" autocomplete="off" tabindex="3"/><a href='#' class="tooltip" title="The New Administrators Password. max 16 chars"><img src="images/tooltip.gif"></a>&nbsp;<span id="txtpass"></span></div><br>

			<br><div class='block' id='div_admin_comp'><label><b>Company:</b></label><select name="admin_comp" id="admin_comp" tabindex="6">
			<option value="00000000-0000-0000-0000-000000000000"></option>
			<?php
				$dn = "cn=companies";
				$filter="(objectclass=company)";
				$sr=ldap_list($ds, $dn, $filter); $info = ldap_get_entries($ds, $sr);
				for ($m=0; $m<$info['count']; $m++) {
					$cn = $info[$m]['cn'][0];$guid = $info[$m]['guid'][0];
					echo "<option value='$guid'>$cn</option>";
					}
			?>
			</select><a href='#' class="tooltip" title="Restrict Administrators Access To A Specific Company"><img src="images/tooltip.gif"></a></div><br>
			
			
			<br><div class='block' id='div_admin_show_enabled'><label><b>Show Enabled Values:</b></label><input type="checkbox" name="admin_show_enabled" id="admin_show_enabled" value="1" checked="checked" tabindex="5"><a href='#' class="tooltip" title="Show Only Enabled Locations"><img src="images/tooltip.gif"></a></div>
			
			
			<br><div class='block' id='div_admin_default'><label><b>Default Page:</b></label><select name="admin_default" id="admin_default" tabindex="7"><option value="0" ></option><option selected value="users">Users</option><option value="depts">Departments</option><option value="groups">Groups</option><option value="contacts">Contacts</option><option value="companies">Companies</option>
			<option value="dialplans">Dial Plans</option><option value="timeplans">Time Plans</option><option value="trunks">Trunks</option><option value="trunkgroups">Trunk Groups</option><option value="directdialinplans">DDI Plans</option><option value="lcrplans">LCR Plans</option>
			<option value="mmc">Meet Me Conferences</option><option value="modules">Modules</option><option value="phones">Phones</option><option value="uphones">Unassigned Phones</option><option value="umodules">Unassigned Modules</option><option value="system">System</option>
			<option value="administrators">Administrators</option><option value="licenses">Licenses</option><option  value="voicemailports">Voicemail Ports</option><option value="musicchannels">Music Channels</option>
			<?php 
				if ($model == "softPBX") {
					echo '<option value="pagingchannels">Paging Channels</option>';
				}
			?>
			<option value="vxmlunits">VXML Scripts</option><option value="events">Events</option>
			
			<option value="relays">Relays</option>
			
			<option value="areacodes">Area Codes</option><option value="updateservers">Update Servers</option><option value="wanlinks">WAN Links</option><option value="assist">Manager Assist</option><option value="aa">Auto Attendant</option></select><a href='#' class="tooltip" title="If You Wish The Administrator To Be Shown A Specifc Page From The Database On Opening The Manager, Select The Page Required"><img src="images/tooltip.gif"></a></div><br>
			
			<br><div class='block'><label><b>End User Administrator:</b></label><select name="enduser_admin" id="enduser_admin" tabindex="4"><option value="0">No</option><option value="1">Yes</option></select>
			<a href='#' class="tooltip" title="Restrict End User Access To Admin Portal"><img src="images/tooltip.gif"></a></div>
			
        </div>
		</div>
		
		<div id="step-2">
            <h2 class="StepTitle">Step 2: Network Overview</h2>
								
			<div style='padding-left:100px; padding-right:100px;'>
				<h3>Administrator View</h3>
				Select the relevant sections of the database to which this administrator is to have
				access eg: Show Users, Show Departments etc.<br><br>
				If you wish this Administrator to be able to create and/or delete entries within the section of the
				database selected, set Add/Delete to Yes.  eg: Add/Delete Users, Add/Delete Departments.<br><b>note.</b> add/delete access is subject to the relevant rights being set.<br><br>
				If this Administrator is to have Manager Assist Access, Manager Assist must be selected. Manager Assist permissions can be assign once the administrator has been created.<br><br>

				<div class='block'><label><b>Administrator View:</b></label></div>
				<div class='block'><br><table border="1" id="tbl_admin_show">
				<tr id='header'>
					<th colspan="1"  align="center">Show : <a href='#' class="tooltip" title="Sections Of The Database To Which This Administrator Is To Have Access"><img src="images/tooltip.gif"></a></th>
					<th colspan="1"  align="center">Add / Delete <a href='#' class="tooltip" title="Create And/Or Delete Entries Within This Section"><img src="images/tooltip.gif"></a></th>
					<th width='15px'></th>
				</tr>
				<tr id='adminView0'>
					<td>
					<select name="admin_show[]" class="adminshow" id='adminshow0' tabindex="1">
					<option value="0"></option>
					<option value="users">Users</option>
					<option value="departments">Departments</option>
					<option value="groups">Groups</option>
					<option value="contacts">Contacts</option>
					<option value="companies">Companies</option>
					<option value="dialplans">Dial Plans</option>
					<option value="timeplans">Time Plans</option>
					<option value="trunks">Trunks</option>
					<option value="trunkgroups">Trunk Groups</option>
					<option value="ddiplans">DDI Plans</option>
					<option value="lcrplans">LCR Plans</option>
					<option value="mmc">Meet Me Conferences</option>
					<option value="modules">Modules</option>
					<option value="phones">Phones</option>
					<option value="uphones">Unassigned Phones</option>
					<option value="umodules">Unassigned Modules</option>
					<option value="system">System</option>
					<option value="licenses">Licences</option>
					<option value="voicemailports">Voicemail Ports</option>
					<option value="musicchannels">Music Channels</option>
					
					<?php 
					if ($model == "softPBX") {
						echo '<option value="pagingchannels">Paging Channels</option>';
					}
					?>
					
					<option value="events">Events</option>
					<option value="relays">Relays</option>
					<option value="areacodes">Area Codes</option>
					<option value="updateservers">Update Servers</option>
					<option value="wanlinks">Wan Links</option>
					<option value="assist">Manager Assist</option>
					<option value="administrators">Administrators</option>
					<option value="vxml">VXML</option>
					</select>
					</td>
					<td>
					<select name="admin_update[]" id="update0" class='update'>
					<option  value="1">Yes</option>
					<option  value="0">No</option>
					</td>
					<td></td>

				</tr>
				<td colspan="3" id='buttons'>
				<input type="button" value="Add Row" id="addRow"/>
				</td>
				</table>
				</div>
			</div> 
        </div>
		
		
		<div id="step-3">	
            <h2 class="StepTitle">Step 3: System & Licence Configuration</h2>
			
			<div style='padding-left:100px; padding-right:100px;'>
			<h3>Administrator Rights</h3>
			<div class='block'><label><b>Add Default Rights:</b></label><select name="admin_default_rights" id="admin_default_rights" tabindex="1"><option value="0"></option><option value="1">Yes</option><option value="2">No</option></select><a href='#' class="tooltip" title="Create The Standard Default Rights For A New Administartor Or Create Specific Permissions"><img src="images/tooltip.gif"></a></div>
			<div id='admin_default_rights_msg'></div>
			<div class='block'><label><b>Custom Admin Rights: </b><a href='#' class="tooltip" title="Only Enabled If Add Default Rights Is Set To No"><img src="images/tooltip.gif"></a></label></div>
			<div class='block'><br>
			<table border="1" id="tbl_admin_rights">
			<tr>
				<th colspan="1"  align="center">Location: <a href='#' class="tooltip" title="What Locations Can The Administrator View"><img src="images/tooltip.gif"></a></th>
				<th colspan="1"  align="center">Read: <a href='#' class="tooltip" title="Allow Read Permissions"><img src="images/tooltip.gif"></a></th>
				<th colspan="1"  align="center">Write: <a href='#' class="tooltip" title="Allow Write Permissions"><img src="images/tooltip.gif"></a></th>
				<th colspan="1"  align="center">Create: <a href='#' class="tooltip" title="Allow Create Permissions"><img src="images/tooltip.gif"></a></th>
				<th colspan="1"  align="center">Delete: <a href='#' class="tooltip" title="Allow Delete Permissions"><img src="images/tooltip.gif"></a></th>
			
			</tr>
			<tbody>
			</tbody>
			

			</table></div>
			</div>
			
			
        </div>
  		
		<div id="step-4">
            <h2 class="StepTitle">Step 4: Administrator Overview</h2>
			
			<div style='padding-left:100px; padding-right:100px;'>
			<h3>Administartor Overview</h3>
			<div id='adminOverview'>
			
			<div class='block'><label><b>Administrator Name:</b></label><span id='summaryAdminName'></span></div><br>
			<div class='block'><label><b>Administrator Description:</b></label><span id='summaryAdminDesc'></span></div><br>
			<div class='block'><label><b>End User Administrator:</b></label><span id='summaryEndUser'></span></div><br>
			<div class='block admin'><label><b>Show Enabled Values:</b></label><span id='summaryEnabledValues'></span></div>
			<div class='block admin'><label><b>Company:</b></label><span id='summaryCompany'></span></div>
			<div class='block admin'><label><b>Default Page:</b></label><span id='summaryDefaultPage'></span></div>
			
			<br>
			<div class='block admin'><label><b>Show Entries :</b></label>
				<table border='1' width='50%' id='summaryShowEntries'>
				<tr><th>Entry</th><th>Add / Delete</th></tr>
				</table>
			</div><br><br>
			
			<div class='block admin'><label><b>Show Rights :</b></label>
				<table border='1' width='60%' id='summaryShowRights'>
				<tr><th>Location</th><th>Read</th><th>Write</th><th>Create</th><th>Delete</th></tr>
				</table>
			</div><br>
			</div>
			
			</div>
			
		</div>                      
  		
		</div>
  		
<!-- End SmartWizard Content -->  	
  		</form>
</td></tr>
</table>  

</div>
	
</div>	

<!--content ends -->


</div>

</div>
</div>	
</body>
</html>
