<?php
session_start();
// v1.4
// PJC 26-JAN-2017 Link Updates
// PJC 15-05-2014 - Updated Wording
// PJC 07-02-2014 - links to name & contact checks
// PJC 22-01-2014 - initial name check
$page_id = "033";
include ".access.php";
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
?>

<html>
<head>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
    "http://www.w3.org/TR/html4/strict.dtd">
<title>Capability Name Check</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<link href="log/alert.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/wiz/extra.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script src="js/wiz/jquery.validate.js" type="text/javascript"></script>
<script src="js/wiz/jquery.validation.functions.js" type="text/javascript"></script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_capabilitynames.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>
<?php
	$script = $_SERVER['SCRIPT_NAME'];
	$agent = (isset($_REQUEST['agent']) && $_REQUEST['agent']==0) ? "*" : "1";
	$link = ($agent=="*") ? "<a href='$script'>Agents Capabilites</a>" :  "<a href='$script?agent=0'>All Capabilities</a>";
?>
<div style="position:absolute; top:30px; right:10px" >
<?php echo $link?>&nbsp;|&nbsp;
<?php link_check("036","<a href='namecheck.php'>Name Check</a>&nbsp|&nbsp", $ma_acl); ?>
<?php link_check("077","<a href='contactscheck.php'>Contacts Name Check</a>", $ma_acl); ?>
</div>
<div id="contain">
<h2><img src='images/settings.png' style="vertical-align:middle;">&nbsp;Capability Name Check</h2>

<?php
if (isset($_SESSION['cap_names'])) {

	$error = $results = 0;
	$bch = array("\"","!","%","^",":","~","#","|","@",".",";","`","\\","/","*","$","\t","\,"); $chars = preg_quote(implode('', $bch));
	echo "This script searches agents and/or users for invalid characters in their capability names. Only entries with invalid entries will be displayed.<br/><br/>";
	echo "Invalid characters being checked for :  <b>" .stripslashes($chars). htmlentities ("<tab>")."</b> and <b>White Space</b> before or after the capability name.<br/><br/>";
	echo ($agent=="*") ? "<h3>Checking All Capabilities</h3>" : "<h3>Checking Agent Capabilities</h3>";

	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}

		$sr = ldap_search($ds,"cn=users","(&(objectclass=user)(agentlicense={$agent}))",array('cn','telephonenumber','guid'));
 	   	$info = ldap_get_entries($ds, $sr); $cn = $telephonenumber = $userguid = array();
		for($n=0; $n<$info['count'];$n++) {
			$cn[] = $info[$n]['cn'][0]; $telephonenumber[] = $info[$n]['telephonenumber'][0]; $userguid[] = $info[$n]['guid'][0];
		}
		@array_multisort($cn,$telephonenumber,$userguid);

		echo "<table width='80%'>";
		foreach ($cn as $userk => $userv) {
	 	   	$sr = ldap_search($ds,"cn=$userv, cn=users","(objectclass=capability)",array('guid','capability','capabilitypercent'));
 	   		$info = ldap_get_entries($ds, $sr);
 	   			for($m=0; $m<$info['count'];$m++) {
		 	   	 $capability = $info[$m]['capability'][0]; $capguid = $info[$m]['guid'][0];

					 if( (preg_match('-['.$chars.']-', $capability)) && ((ltrim($capability) != $capability) || (rtrim($capability) != $capability))){
			 	   	 if ($error==0) echo "<tr colspan='2'><td>User: <b><a href='../manager.cgi?pagename=user&index=$userguid[$userk]' target='_blank'>$userv</a></b> ($telephonenumber[$userk])</td></tr>"; $results=$error=1;
			 	   	 echo "<tr><td width='50%'>$capability</td><td><b><a href='../manager.cgi?pagename=capability&index=$capguid' target='_blank'> *** White Space & Invalid Characters ***</a></b></td></tr>";
			 	   	 } elseif((ltrim($capability) != $capability) || (rtrim($capability) != $capability)){
					 if ($error==0) echo "<tr colspan='2'><td>User: <b><a href='../manager.cgi?pagename=user&index=$userguid[$userk]' target='_blank'>$userv</a></b> ($telephonenumber[$userk])</td></tr>"; $results=$error=1;
			 	   	 echo "<tr><td width='50%'>$capability</td><td><b><a href='../manager.cgi?pagename=capability&index=$capguid' target='_blank'> *** White Space ***</a></b></td></tr>";
			 	   	 } elseif(preg_match('-['.$chars.']-', $capability)){
					 if ($error==0) echo "<tr colspan='2'><td>User: <b><a href='../manager.cgi?pagename=user&index=$userguid[$userk]' target='_blank'>$userv</a></b> ($telephonenumber[$userk])</td></tr>"; $results=$error=1;
			 	   	 echo "<tr><td width='50%'>$capability</td><td><b><a href='../manager.cgi?pagename=capability&index=$capguid' target='_blank'> *** Invalid Characters ***</a></b></td></tr>";
			 	   	 }


	 	   	  	}
   	  	if ($error==1)  echo "<tr colspan='2'><td><br/><br/></td></tr>";$error=0;
 	   	}
 	   	if ($results=='0') echo "<h3>No Errors found</h3>";
 	   	echo "</table>";
	   	}
?>
</div>
</body>
</html>
<div class="overlay" id="overlay" style="display:none;"></div>
        <div class="alert" id="alert">
            <a class="alertclose" id="alertclose"></a>
			<a class="alertOK" id="alertOK"></a>
            <h1>Warning</h1>
            <p>
            Checking Capability Names across multiple Agents or Users uses additional system resources and could cause system instability.<br/><br/>
           	We suggest this is only done out of hours or during quiet periods..<br/><br/>
            Please select the <span style="color:#329C24; font-weight:bold";>Green Tick</span> to proceed, otherwise select the  <span style="color:#605F61; font-weight:bold";>Grey X</span> to return to Manager Assist.</p>
           </p>
</div>

<?php if (!isset($_SESSION['cap_names'])) {?>
<script type="text/javascript">
		$(function() {
			$('#overlay').fadeIn('fast',function(){
            $('#alert').animate({'top':'100px'},500);
        });
        $('#alertclose').click(function(){
           	$('#alert').animate({'top':'-600px'},500,function(){
            $('#overlay').fadeOut('fast');
            document.location.href='assist.php';
        	});
        });
        $('#alertOK').click(function(){
   	    	$.ajax({ url : 'log/reset.php?cap_names=1' });
        	$('#alert').animate({'top':'-600px'},500,function(){
        	$('#overlay').fadeOut('fast');
        	document.location.href='capabilitynames.php';
           	});
        });
		});
</script>
<?php } ?>
