<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<title>Help - VLAN Virtual LAN</title>
<head>
<script type="text/javascript">
	var state = {};
	var title = 'Help';
	var url   = '/manager/assist/help';
	history.pushState(state, title, url);
</script>
<link href="/manager/assist/css/Styles.css" rel="stylesheet" type="text/css">
<script src="/manager/assist/js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script type="text/javascript">
$(function() {
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});

	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
});
</script>
</head>
<body>
<div id="toTop">^ Back to Top</div>
<div id="contain">
<h2><img src='/manager/assist/images/help.png' style="vertical-align:middle;">&nbsp;Help - VLAN Virtual LAN</h2>
<b>VLAN - Virtual LAN</b><br/>
VLAN is a protocol supported by LAN switches. It allows individual ports on a switch to be isolated from others, thus in serviced offices individual offices have their own LAN but one LAN switch can be used for several offices. With a maximiser system it allows voice/calls and general office data to be on separate LAN's so voice/calls may be on VLAN 42 and office data on VLAN 43 for one office and office data on VLAN 44 for the next etc.<br/><br/>
The protocol is quite simple. On a traditional LAN there are 2 bytes in an ethernet packet which say what type of traffic the payload is e.g. IP. These 2 bytes are replaced with a value which says VLAN, the new payload then starts with 2 bytes which identifies the VLAN number i.e. 1 thru 4094, followed by the previous ethernet type and the original payload. Thus multiple VLAN's can be passed between two switches (using normal LAN cable) and the traffic is fully separated.<br/><br/>
Support for VLAN's on the PCS5xx allows the voice/calls to be on one VLAN and the PC port to be on another, thus fitting neatly into serviced offices. PC's don't understand VLAN's and just use traditional LAN's, the PCS5xx will accept traffic on VLAN X and pass it out to the PC port as traditional LAN traffic. VLAN's are separate LAN's so beware of the networking complications if you wish to use PCS60/Navigate soft phones or partners at a VLAN site - you will require something to join and police traffic between the VLAN's. The 5100, 5330 and 5315 also support VLAN's but often the 5100 plugs into a LAN switch which then puts the voice/calls onto the required VLAN.<br/><br/>
LAN switch ports which carry VLAN's are referred to as tagged ports and traditional LAN is referred to as untagged ports. The 5100, 5330, 5315 and PCS5xx can support any mixture of tagged and untagged ports. Alternatively the PCS5xx can get their CPU VLAN from a DHCP server using option 132. <br/><br/>
The PCS100/PCS410 does not support a mixture on its LAN port and untagged only on its PC Port.<br/><br/>
The following maximiser modules support VLAN/Tagging, 5100, 5330, 5315.<br/><br/>
The IP Phone VLAN is set by telnet using the setnet command. The voice/call port is referred to as the CPU and the PC LAN as PC LAN. The setting are stored on the phone and require a reboot to activate them. If you get it wrong you can do an erase config to remove all settings.<br/><br/> 
The 5100 is configured by a web page: <b>http://192.168.0.1/manager/vlan.cgi</b> and similarly the 5330/5315 on <b>http://192.168.0.250/cgi-bin/vlan.cgi</b> changing the IP address as appropriate. These pages are password protected the default ones are Manager/managerpassword or diag/7388. Activating any changes requires a unit reboot. Again if you mess things up you can recover by doing a 1 + 4 button reset to default the configuration.<br/><br/>
The web management pages are reasonably self explanatory, all the setup is done via these pages but only become active after ticking the enable boxes. Note that the CPU port should never be tagged.<br/><br/><br/>
Below is an example for setting up VLAN working:<br/><br/>
A customer wants to put their voice network on a VLAN. They already have LAN switches running VLANs and want the maximiser to be part of the VLAN network.<br/><br/>
The also want a 3x PCS562's powered off the 5100 which also need to be part of the VLAN network therefore the maximiser needs to fully cooperate and not just leave it to the switch network.<br/><br/>
The customer runs his data network on VLAN 101 and wants his voice on VLAN 102. The LAN switches are programmed to provide the data VLAN 101 as untagged traffic on the ports - so staff can simply plug in their PC anywhere without problem.<br/><br/>
We will connect to the LAN switch using our link port on the 5100 and plug the PCS562's into LAN1 LAN2 and LAN3. We will also need to reserve LAN4 to allow us to plug in a PC to manage and maintain the system.<br/><br/><br/>
So how do we configure the 5100:<br/><br/>
Navigate the the Web page <b>http://192.168.0.1/manager/vlan.cgi</b><br/>
Tick the enable<br/>
Set the PVID as follows:<br/>
Link=101 LAN1=101 LAN2=101 LAN3=101 LAN4=102 CPU=102<br/>
Set up 2 VLAN VID's:<br/>
VID=101 LINK=U LAN1=U LAN2=U LAN3=U LAN4=blank CPU= blank<br/>
VID=102 LINK=T LAN1=T LAN2=T LAN3=T LAN4=U CPU=U<br/><br/>
Once you are happy reboot the 5100 and the config will go live (remember a 1 + 4 on the reset switch will wipe it out if you have miss-configured).<br/><br/><br/>
Setup the PCS562:<br/><br/>
Telnet in and use setnet enable VLAN, set CPU to 102, and the PC to 0.<br/><br/>
then reboot. Note that the PCS562/572 can be configured for their VLAN using the DHCP server on the data network which selects in the appropriate VLAN with option 132<br/><br/>
Please note that if you want a PCS60/Navigate to work with your PCS562 you have a problem as your PC and the PCS562 are now on different VLANS and therefore cannot communicate. You will require a 3rd party router/firewall to allow the appropriate ports through.<br/><br/>
</div>
</body>
</html>
