<?php
// 1.8
// PJC 11/03/2015 - update for others
// PJC 09/03/2015
$page_id = "078";
include ".access.php";
include "tzone.php"; // include timezone

	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}
		// module list
		$att =array('cn','guid');
		$sr = ldap_list($ds,"cn=Modules","(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19))",$att);
 	   	$info = ldap_get_entries($ds, $sr);
       		for ($n=0; $n<$info['count']; $n++) {
				$cn = $info[$n]['cn'][0];
				$guid[$cn] = $info[$n]['guid'][0];
				}	
?>	
<html>
<head>
<title>IntraModuleTrunks</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script>
$(document).ready(function() {
	
$(function() {
	
	$("#SiteA").change(function(){
        var selectedItem = $(this).val(); 
        var nextDropdown = $(this).parent("td").next("td").next("td").find("select.SiteBClass");
       
        $(nextDropdown).find("option").attr('disabled', false);
        $(nextDropdown).find("option[value='" + selectedItem + "']").attr('disabled', true);
    })
	
    $('#AddIMT').click(function() {
        var $newRow = $('#TemplateRow').clone(true).removeAttr('id');
        $newRow.find('#SiteA').val('');
        $newRow.find('#SiteB').val('');
        $newRow.find('#SiteCapacity').val('');
        $newRow.find('*').andSelf().removeAttr('id').removeAttr('disabled');

        $('#SiteTable tr:last').before($newRow);
        
        return false;
    });
    
    $('#SiteTable').delegate('.DeleteSite:not(#TemplateRow .DeleteSite)', 'click', function() {
            $(this).closest('tr').remove();
    });
});
	
	 $('#addAll').click(function() {
		 if ($(this).prop('checked')) {
		 	$("#SiteTable").find('input,select').attr('disabled', true);
		 	$("#addOther").attr('disabled', true);
	    	$('.classAll').show();
    	} else {
	    	$("#SiteTable").find('input,select').attr('disabled', false);
	    	$("#addOther").attr('disabled', false);
	    	$('.classAll').hide();
    	}
    });
    
    $('#addOther').click(function() {
		 if ($(this).prop('checked')) {
	    	$('.classOther').show();
    	} else {
	    	$('.classOther').hide();
    	}
    });
    
    $('#deleteAll').click(function() {
		 if ($(this).prop('checked')) {
			 $("#SiteTable").find('input,select').attr('disabled', true);
			 $("#addOther").attr('disabled', true);
			 $("#addAll").attr('disabled', true);
    	} else {
	    	$("#SiteTable").find('input,select').attr('disabled', false);
			$("#addOther").attr('disabled', false);
			$("#addAll").attr('disabled', false);
    	}
    });
   
    
	$("#SaveIMT").click(function(e) {
		var stopFunction = false;	
		
		if ($("#addOther").is(':checked') && $("#otherCapacity").val().length >= 1) {
			if (confirm('Add Other Sites ?')) {
				$('form#sites').submit();
			} else {
    			return false;
			}
		}
				
		if ($("#deleteAll").is(':checked')) {
			if (confirm('Delete All Configured IntraModuleTrunks ?')) {
				$('form#sites').submit();
			} else {
    			return false;
			}
		}
	
		if ($("#addAll").is(':checked') && $("#allCapacity").val().length < 1) { alert ('All Capacity: Value Must Be Set');  return false; }
		if ($("#addAll").is(':checked') &&  !$.isNumeric($("#allCapacity").val())) { alert ('All Capacity: Only Numeric Values'); return false; }
			
		if ($("#addOther").is(':checked') && $("#otherCapacity").val().length < 1) { alert ('Other Capacity: Value Must Be Set'); return false; }
		if ($("#addOther").is(':checked') && !$.isNumeric($("#otherCapacity").val())) { alert ('Other Capacity: Only Numeric Values'); return false; }

			
		$(".SiteAClass").each(function() {
 			if (!$("#addAll").is(':checked') && $(this).val() == '') { alert ('SiteA: Module Must Be Selected'); stopFunction = true; return false; }
		});
		if(stopFunction) return false;

		
		$(".SiteBClass").each(function() {
 			if (!$("#addAll").is(':checked') && $(this).val() == '') { alert ('SiteB: Module Must Be Selected'); stopFunction = true; return false; }
		});
		if(stopFunction) return false;

		
		$(".SiteCapacityClass").each(function() {
 			if (!$("#addAll").is(':checked') && $(this).val().length < 1) {
				alert ('Capacity: Value Must Be Set');
				stopFunction = true; return false;
			}else if (!$("#addAll").is(':checked') && !$.isNumeric(this.value)) {
				alert ('Capacity: Only Numeric Values');
				stopFunction = true; return false;
			}
		});
		if(stopFunction) return false;
		
		
		if (confirm('Create The Selected IntraModuleTrunks ?')) {
			$('form#sites').submit();
		} else {
    		return false;
		}
		e.preventDefault();
	});
	
});
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = ''" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_intramoduletrunks.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>
<div id="contain">
<h2><img src='images/settings.png' style="vertical-align:middle;">&nbsp;IntraModuleTrunks</h2>
This page provides an easy way to configure IntraModule Trunk on your system.<br/>
Please see the help file for full details.<br/><br/>
To view existing IntraModule Trunk configuration, please use the <a href='/manager/imt.php'>IntraModule Trunk Status Page</a>.<br/><br/>
<form id='sites' method='post'>
<table id="SiteTable" >
            <tr>
                <th>IntraModuleTrunk Site A</th>
                <th width ='20px'></th>
                <th>IntraModuleTrunk Site B</th>
                <th>Capacity</th>
                <th>Compression</th>
                <th>Delete</th>
            </tr>
            <tr id="TemplateRow">
                <td>
                    <select class="SiteAClass" name="SiteA[]" id="SiteA">
                    <option value=''></option>
                    <?php
						foreach ($guid as $key => $value) {
							echo "<option value='$key'>$key</option>";
						}
					?>
                    </select>
                </td>
				<td></td>
                <td>
                    <select class="SiteBClass" name="SiteB[]" id="SiteB">
                    <option value=''></option>
                    <?php
						foreach ($guid as $key => $value) {
							echo "<option value='$key'>$key</option>";
						}
					?>
                    </select>
                </td>
                <td>
                    <input class="SiteCapacityClass" name="SiteCapacity[]" type="text" id="SiteCapacity" size='3'/>
                </td>
                
                <td>
                    <select class="SiteCompressionClass" name="SiteCompression[]" id="SiteCompression">
						<option selected value="0">None</option>
						<option value="11">G729a 8K</option>
						<option value="12">Relay</option>
                    </select>
                </td>
                <td>
                    <img src='images/delete.png' class="DeleteSite" name="DeleteSite" title="Delete Row"/>
                </td>
            </tr>
            <td>
            	<input type="submit" name="AddIMT" value="Add IntraModuleTrunk" id="AddIMT" />
            </td>
            
        </table>
        <br/><br/>
        If IntraModule Trunks are configured, then they have to be used across all sites.<br/><br/>
        <strong>Other Sites</strong><br/>
		The 'others' option allows you to apply the same basic settings to a new IntraModule Trunk<br/>called 'others' which is applied to all sites. Without this call routing would be affected between sites.<br/>
		<div class='block'><label><b>Add 'Other Sites' :</b></label><input type="checkbox" name="addOther" id="addOther" value="1"><a href='#' class="tooltip" title="Add IntraModuleTrunks Called Others To All Sites"><img src="images/tooltip.gif"></a></div>
        <div class='classOther' style="display:none;">
			<table>
        	<tr>
        		<th>Capacity</th>
        		<th>Compression</th>
        	</tr>
        	<tr>
        	<td>
				<input class ="otherCapacityClass" name="otherCapacity" type="text" id="otherCapacity" size='3'/>
			</td>
            <td>
				<select class="otherCompressionClass" name="otherCompression" id="otherCompression">
					<option selected value="0">None</option>
					<option value="11">G729a 8K</option>
					<option value="12">Relay</option>
				</select>
			</td>
            </tr>
			</table>                
        	<br/>
        </div>
        
		<br/><strong>All Sites</strong><br/>
		The 'ALL Sites' option allows you to create new IntraModule Trunks between all sites to each other site.<br/>            
        <div class='block'><label><b>Add 'All Sites' :</b></label><input type="checkbox" name="addAll" id="addAll" value="1"><a href='#' class="tooltip" title="Add All Sites To Each Other"><img src="images/tooltip.gif"></a></div>
        <div class='classAll' style="display:none;">
        	<table>
        	<tr>
        		<th>Capacity</th>
        		<th>Compression</th>
        	</tr>
        	<tr>
        	<td>
				<input class ="allCapacityClass" name="allCapacity" type="text" id="allCapacity" size='3'/>
			</td>
            <td>
				<select class="allCompressionClass" name="allCompression" id="allCompression">
					<option selected value="0">None</option>
					<option value="11">G729a 8K</option>
					<option value="12">Relay</option>
				</select>
			</td>
            </tr>
			</table>                
        	<br/>
        </div>
        <br/><br/>
        <div class='block'><label><b>Delete Configured IMT :</b></label><input type="checkbox" name="deleteAll" id="deleteAll" value="1"><a href='#' class="tooltip" title="If Enabled This Option Will Delete ALL  IntraModuleTrunks Configured"><img src="images/tooltip.gif"></a></div>
        
        <div class='block'><label><b>Create System Backup :</b></label><input type='checkbox' name='backup' id='backup' checked /><a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.jpg'></a></div><br/><br/>
        <input type="submit" name="submit" value="Save Configuration" id="SaveIMT" />
</form>        

<?php
if (isset($_REQUEST['submit'])) {
	
	
	if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
		$backup = "Backup ".date('d.m.y His')." - IntraModuleTrunks.txt";
		$ent["dobackupto"][0] = $backup;
		ldap_modify($ds,"cn=Commands", $ent);
		ldap_modify($ds,"cn=Commands", $ent); $ent='';
	}
	
	$compression = array('0'=>'None', '11'=>'G729a 8K', '12'=>'Relay');
	$SiteA = (isset($_REQUEST['SiteA']) && count($_REQUEST['SiteA']) >= 1 && strlen($_REQUEST['SiteA'][0]) > 0) ? $_REQUEST['SiteA'] : NULL;
	$SiteB = (isset($_REQUEST['SiteB']) && count($_REQUEST['SiteB']) >= 1 && strlen($_REQUEST['SiteB'][0]) > 0) ? $_REQUEST['SiteB'] : NULL;	
	$SiteCapacity = (isset($_REQUEST['SiteCapacity']) && count($_REQUEST['SiteCapacity']) >= 1) ? $_REQUEST['SiteCapacity'] : NULL;	
	$SiteCompression = (isset($_REQUEST['SiteCompression']) && count($_REQUEST['SiteCompression']) >= 1) ? $_REQUEST['SiteCompression'] : NULL;	
	$addAll = (isset($_REQUEST['addAll'])) ? '1' : NULL;
	$addOther = (isset($_REQUEST['addOther'])) ? '1' : NULL;
	$deleteAll = (isset($_REQUEST['deleteAll'])) ? '1' : NULL;
	$otherCapacity = (isset($_REQUEST['otherCapacity']) && count($_REQUEST['otherCapacity']) >= 1) ? $_REQUEST['otherCapacity'] : NULL;	
	$otherCompression = (isset($_REQUEST['otherCompression']) && count($_REQUEST['otherCompression']) >= 1) ? $_REQUEST['otherCompression'] : NULL;	
	$allCapacity = (isset($_REQUEST['allCapacity']) && count($_REQUEST['allCapacity']) >= 1) ? $_REQUEST['allCapacity'] : NULL;	
	$allCompression = (isset($_REQUEST['allCompression']) && count($_REQUEST['allCompression']) >= 1) ? $_REQUEST['allCompression'] : NULL;	
	
if (isset($deleteAll) && $deleteAll =='1') {
	$sr = $info = $d = $dn = '';
	echo "Deleting All IntraModuleTrunks..<br/>";
	$sr=ldap_search($ds,"cn=modules","(objectclass=intramoduletrunk)",array('dn'));
		$info = ldap_get_entries($ds, $sr);
        for ($d=0; $d<$info['count']; $d++) {
			$dn = $info[$d]['dn'];
			@ldap_delete($ds, $dn);
		}
	echo "<b>DONE.</b>";
exit;	
}	
	
echo "addAll = $addAll addOther = $addOther";


if ($SiteA && $SiteB) {
	echo "<br/>Adding Selected IntraModuleTrunks..<br/>";	
	$imtatt = array();
	foreach ($SiteA as $key => $value) {
							
			$imtatt = array('objectclass'=>'IntraModuleTrunk','compressiontype'=>$SiteCompression[$key],'capacity'=>$SiteCapacity[$key]);
			
			//Site A IMT -> SiteB
			$sr=ldap_search($ds,"cn=$value, cn=modules","(&(objectclass=member)(member={$guid[$SiteB[$key]]}))",array('dn'));
			$info = ldap_get_entries($ds, $sr); $count = (isset($info['count'])) ? $info['count'] : NULL;
			if (!$count) {
					$dn = "cn=$SiteB[$key],cn=1,cn=$value, cn=modules";
					ldap_add($ds, $dn, $imtatt);	
					
					$imtmemberatt = array('objectclass'=>'member','member'=>$guid[$SiteB[$key]]);
					$dn = "id=1,cn=$SiteB[$key],cn=1,cn=$value, cn=modules";
					ldap_add($ds, $dn, $imtmemberatt);
					echo "Site A: <b>$value</b> Added IMT -> <b>$SiteB[$key]</b><br/>";
					echo "Mode {$compression[$SiteCompression[$key]]} Capacity $SiteCapacity[$key]<br/><br/>";
				} else {
					echo "Warning: Site A: <b>$value</b> already contains IntraModuleTrunk Member : <b>$SiteB[$key]</b><br/>";
				}
					

			
			//Site B IMT -> SiteA
			$sr=ldap_search($ds,"cn=$SiteB[$key], cn=modules","(&(objectclass=member)(member=$guid[$value]))",array('dn'));
			$info = ldap_get_entries($ds, $sr); $count = (isset($info['count'])) ? $info['count'] : NULL;
			if (!$count) {
				$dn = "cn=$value,cn=1,cn=$SiteB[$key], cn=modules";
				ldap_add($ds, $dn, $imtatt);	
			
				$imtmemberatt = array('objectclass'=>'member','member'=>$guid[$value]);
				$dn = "id=1,cn=$value,cn=1,cn=$SiteB[$key], cn=modules";
				ldap_add($ds, $dn, $imtmemberatt);
				echo "Site B: <b>$SiteB[$key]</b> Added IMT -> <b>$value</b><br/>";
				echo "Mode {$compression[$SiteCompression[$key]]} Capacity $SiteCapacity[$key]<br/><br/>";
			} else {
				echo "Warning: Site B: <b>$SiteB[$key]</b> already contains IntraModuleTrunk Member : <b>$value</b><br/>";
			}
	}

} 

if ($addAll) {
 	echo "<br/>Adding All Sites To Each Other..<br/>";
 	$imtatt = array();
	$imtatt = array('objectclass'=>'IntraModuleTrunk','compressiontype'=>$allCompression,'capacity'=>$allCapacity);

 foreach ($guid as $gk => $gv) {
	$current = $gv;
	echo $gk."<br/>";
	foreach ($guid as $guidk => $guidv) {   	
		$sr=ldap_search($ds,"cn=$gk, cn=modules","(&(objectclass=member)(member=$guid[$guidk]))",array('cn'));
		$info = ldap_get_entries($ds, $sr); $count = (isset($info['count'])) ? $info['count'] : NULL;
				
		if (!$count) {
		if ($current != $guidv) {
			$dn = "cn=$guidk,cn=1,guid=$gk, cn=modules";
			ldap_add($ds, $dn, $imtatt);	
			
			$imtmemberatt=array('objectclass'=>'member','member'=>$guid[$guidk]);
			$dn = "id=1,cn=$guidk,cn=1,cn=$gk, cn=modules";
			ldap_add($ds, $dn, $imtmemberatt);
			echo "Added <b>$guidk</b> as an IntraModuleTrunk<br/>";
		}
	 } else {
		 echo "Warning: <b>$guidk</b> aleardy an IntrModuleTrunk<br/>";
	 }
	}
		echo "<br/>";
 }
}

if ($addOther) {
	echo "<br/>Adding 'other' IntraModuleTrunks..<br/>";	
	$imtatt = array();
	$imtatt = array('objectclass'=>'IntraModuleTrunk','compressiontype'=>$otherCompression,'capacity'=>$otherCapacity);
		foreach ($guid as $guidK => $guidV) {
			$sr=ldap_search($ds,"cn=1,guid=$guidV, cn=modules","(&(objectclass=*)(cn=others))",array('dn'));
			$info = ldap_get_entries($ds, $sr); $count = (isset($info['count'])) ? $info['count'] : NULL;
			if (!$count) {
				$dn = "cn=others,cn=1,guid=$guidV, cn=modules";
				ldap_add($ds, $dn, $imtatt);
				echo "Added 'others' to <b>$guidK</b><br/>";
			} else {
				echo "Warning: 'others' aleady exists on <b>$guidK</b><br/>";
			}
		}
		
	}	
	
}
?>
</div>
</body>
</html>
