$(document).ready(function() {
	
	oTable = $('#excodes').dataTable({
		"bJQueryUI": true,
		"sPaginationType": "full_numbers",
		"aLengthMenu": [[10, 25, 50, 100, 250, 500], [10, 25, 50, 100, 250, 500]]
	});
	
	$('#ylfirmware').on('input blur keyup paste', function() {
		$(this).val(function(i, v) {
			return v.replace(/[^a-z0-9(),._-]/ig, '');
		});
	});	

	$('#firmwareset').click(function () { 
		if ($('#ylfirmware').val().length <1)  {
			alert ('No Firmware Version Set');
			return false;
		}
		
		if (!$('[name^="phones"]').is(':checked')) {
			alert ('No Phones Selected');
			return false;
		}
		
		var setphones = [];
		var firmwarerom = $('#ylfirmware').val();
		
		if (confirm("Apply Selected Firmware: " + firmwarerom + " ?") == true) {
		
			$('#excodes tr:not(.header)').each(function(){
				
				if ( $(this).find('td:eq(0)').find("input[type='checkbox']").prop('checked') ) {
					
					firmwarecheck = ($(this).find('td:eq(2)').html().indexOf("_") >= 0) ? $(this).find('td:eq(2)').html().split('_')[0] : $(this).find('td:eq(2)').html();
					console.log ('firmwarecheck ' + firmwarecheck);
					
					var modelcheck = firmwarecheck.replace(/\D/g,'');
					console.log ('model check ' + modelcheck);
					
					if (firmwarerom.indexOf('T' + modelcheck) >= 0 || firmwarerom.indexOf('W' + modelcheck) >= 0 || firmwarerom.indexOf('CP' + modelcheck) >= 0) {

						$(this).find('#firmwareupgrade').val( firmwarerom ).css({'color' : '', 'font-weight' : '' });
						phoneguid = $(this).find('td:eq(0)').find("input[type='checkbox']").val();
						setphones.push(phoneguid);
					} else {
						$(this).find('#firmwareupgrade').val( 'Invalid Rom File' ).css({'color' : '#FF0000', 'font-weight' : '700' }) ;
					}
				}
			});
					
			if (setphones.length > 0) {
				$.ajax({ type: "GET",   
				url: 'ssl_update.php?ylsetrom=1&firmwarerom=' + firmwarerom,   
				data: {'setphones' : setphones },
				async: true,
				cache: false,
					success : function(text) {
						console.log (text)
					}
				});
			}
			
			$('input:checkbox:not(.backup, [name^="phones"])').removeAttr('checked'); // don't deselect phones
			//$('input:checkbox:not(.backup)').removeAttr('checked');
			$('#ylfirmware').val('');
		} else {
			return false
		}
	});
		
	$("#firmwarereset").click(function () { 
		if (!$('[name^="phones"]').is(':checked')) {
			alert ('No Phones Selected');
			return false;
		}
	
		if (confirm("Clear Selected Firmware Files ?") == true) {

			var setphones = [];
			$('#excodes tr:not(.header)').each(function(){
				if ( $(this).find('td:eq(0)').find("input[type='checkbox']").prop('checked') ) {
					phoneguid = $(this).find('td:eq(0)').find("input[type='checkbox']").val();
					setphones.push(phoneguid);
					
					if (setphones.length > 0) {
						$.ajax({ type: "GET",   
						url: 'ssl_update.php?ylclear=1',   
						data: {'setphones' : setphones },
						async: true,
						cache: false,
							success : function(text) {
								console.log (text)
							}
						});
					}
					$(this).find('#firmwareupgrade').val( '' ).prop('disabled', true);
				}
			});
		} else {
			return false;
		}
	});
		
	$("#setyl").click(function () { 
		$.ajax({ 
			url : 'ssl_update.php?ylserver=1&url=' + $("#yl").val() 
		})	 
		.done(function(data) { 
			if (data.toLowerCase().indexOf("warning") >= 0) { 
				sslStatus = "Fail"; color = '#8C0000';  
			} else { 
			sslStatus = "Yealink Server Value Updated"; color = '#006600'; 
			$("#yl").val( $.trim($("#yl").val()) )
		};
		$("#srvStatus").css("color", color).html(sslStatus+data.slice(0, 100)).show().fadeOut(12000); 
		});
	});

	$('#frm').on('submit',function(e) {
		
		if (!$('[name^="phones"]').is(':checked')) { 
			alert('A Phone Must Be Selected'); return false; 
		};
		
		var mode = $("#mode").val();
		console.log (mode);
		var mode_txt = (mode == "update") ? "Amended" : "Removed";
		if (mode == "update") {
			if ($('[name=time]').val() == "") { alert('Time Must Be Set'); return false; };
		}
		

		$.ajax({
		url:'ssl_update.php',
		data:$(this).serialize(),
		type:'POST'	})
		.done(function(data) { 
		console.log (data)
			if (data.toLowerCase().indexOf("warning") >= 0) { 
				phoneStatus = "An Error Has Occured - Please Try Again"; color = '#8C0000';  
			} else { 
				phoneStatus = "All Phones Have Had Their Update Times " + mode_txt; color = '#006600'; 
				$("#Status").css("color", color).html(phoneStatus+data.slice(0, 100)).show(); 
				setTimeout(function (){
					location.reload();
				}, 1000);
			};
		});
		e.preventDefault();
	});
});

checked=false;
function checkedAll (frm) {
	var aa= document.getElementById('frm');
	if (checked == false) {
        checked = true
	} else {
        checked = false
    }
	for (var i =0; i < aa.elements.length; i++) {
	 if (aa.elements[i].getAttribute('class') == 'ignore' )	continue;
	 aa.elements[i].checked = checked;
	}
}

$(function() {
    $('#setUpdateTime').timepicker({ 'timeFormat': 'H:i','scrollDefaultNow': true,'noneOption': [{'label': 'NOW','value': 'now'}] });
    $('#setNow').on('click', function (){
        $('#setUpdateTime').val('now');  return false;
    });
});

var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
	LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
	TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
	settings = 'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
	popupWindow = window.open(url,winName,settings)
}