<?php
// PJC v1.00

session_start();

$page_id = "095";
include ".access.php";
$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
	echo "LDAP connect failure<br>";
} else {
	$r = ldap_bind($ds,"INTERNAL","0123456");
	if ( ! $r) {
		echo "LDAP bind failure<br>";
		$ds = false;
	}
}

include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME']; 	
$url = $_SERVER['SERVER_ADDR'];
$ctx = stream_context_create(array('http'=>
    array(
        'timeout' => 5,  //5 Seconds
    )
));
ini_set('default_socket_timeout', 5); // 5 Seconds

$getIp = NULL;
$getIp = @file_get_contents('http://splicepbx.uk/ip/index.php?mode=ip');
$externalIp = (isset($getIp) && strlen($getIp > 1)) ? trim($getIp) : NULL;

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>Update STUN Server</title>
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<style type="text/css">
	@import "css/codes/codes_page.css";
	@import "css/codes/codes_table.css";
	@import "css/codes/custom.css";
	div.srv {overflow:hidden; }
	div.srv label {width:175px; display:block; float:left; text-align:left; vertical-align:middle; }
	div.srv.input {margin-left:4px; float:left; vertical-align:middle; }
</style>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/codes/jquery.dataTables.min.js" type="text/javascript"></script>
<script src="js/jquery.noty.packaged.js" type="text/javascript"></script>



<script type="text/javascript" charset="utf-8">
	$(document).ready(function() {
		oTable = $('#excodes').dataTable({
			"bJQueryUI": true,
			"sPaginationType": "full_numbers",
			"aLengthMenu": [[10, 25, 50, 100, 250, 500], [10, 25, 50, 100, 250, 500]]
			});
			
			$('#frm').on('submit',function(e) {
				stun = $('#stun').val();
				stunport = $('#stunport').val();
				stunmode = $('#stunmode option:selected').val();
				
				if (!$('[name^="phones[]"]').is(':checked')) { alert('A Phone Must Be Selected'); return false; };
				if (stun.length <1) { alert('STUN Server Must Be Set'); return false; };
				if (stunport.length <1) { alert('STUN Server Port Must Be Set'); return false; };
				

				$.ajax({
				url:'stun_update.php?stun=' + stun + '&stunport=' + stunport + '&stunmode=' + stunmode,
				data:$(this).serialize(),
				type:'POST'	})
				.done(function(data) { 
				console.log(data);
				var n = noty({ type: 'warning', layout: 'center', text: '<b>STUN Settings Saved</b><br><br>Please Note: The SIP Phones will need to be re-provisioned for the updated STUN settings to be applied.<br><br>', dismissQueue: true, theme: 'relax', modal: true }); 
				setTimeout(function (){
					location.reload();
				}, 5000);
					
				});
				e.preventDefault();
				});
		});
</script>
<script type="text/javascript">
checked=false;
function checkedAll (frm) {
	var aa= document.getElementById('frm');
	 if (checked == false)
          {
           checked = true
          }
        else
          {
          checked = false
          }
	for (var i =0; i < aa.elements.length; i++)
	{
	 if (aa.elements[i].getAttribute('id') == 'backup')	continue;
	 aa.elements[i].checked = checked;
	}
      }
</script>

<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings = 'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body id="dt_excodes">
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script ?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_stunupgrade.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<div id="container"><div id="codes">
<h3><img src='images/settings.png' style="vertical-align:middle;">&nbsp;Update STUN Server</h3>

This page allows you to update the STUN Server Address and port being used by SIP Phones.<br>
The STUN Server address defaults to your External IP Address, this can be changed to suit your requirements<br>
The STUN mode can be set to Blank, Enabled or Disabled. If the Blank option is selected no change is made to the mode, if Enabled is selected Use STUN is enabled, if Disabled is selected Use STUN is disabled<br><br>

<b>Please Note:</b><br>
The site's firewall will need to be configured to allow access to the STUN Server on your configured port.<br>
SpliceCom recommends that the firewall be configured to only allow access to the maximiser system from recognised external IP addresses for the ports required.<br>
Please refer to the Protocols and Ports document for port information. All other access should be blocked to minimise the risk of access from undesirable sources.<br><br>

<div class='srv'><label><a href='#' class='tooltip' title='Enter STUN Server Address. eg: <?php echo $externalIp?>'><img src='images/tooltip.jpg'></a>&nbsp;<b>STUN Server:</b></label><img src='images/blank.gif' width='18px'><input type='text' name='stun' id='stun' value='<?php echo $externalIp ?>' size='25'></div>
<div class='srv'><label><a href='#' class='tooltip' title='Enter STUN Server Port. eg: 3478 or 5060'><img src='images/tooltip.jpg'></a>&nbsp;<b>STUN Port:</b></label><img src='images/blank.gif' width='18px'><input type='text' name='stunport' id='stunport' value='3478' size='25'></div>
<div class='srv'><label><a href='#' class='tooltip' title='Use STUN Server'><img src='images/tooltip.jpg'></a>&nbsp;<b>Use STUN Server:</b></label><img src='images/blank.gif' width='18px'><select name='stunmode' id='stunmode'><option></option><option value='0'>Disable</option><option value='1'>Enable</option></select></div>
<br/>
<?php

 	echo "<form method='post' id='frm' action='$script'>";
	echo "<table cellpadding='0' cellspacing='0' border='0' class='display' id='excodes'>
		<thead><tr><th width='5%'><input type='checkbox' name='select' onclick='checkedAll(frm)'><th width='26%'>Phone</th><th width='26%'>Description</th><th width='26%'>STUN Server</th><th width='10%'>STUN Port</th><th width='10%'>Use STUN</th></tr></thead>
		<tfoot><tr><th><input type='checkbox' name='select' onclick='checkedAll(frm)'><th>Phone</th><th>Description</th><th>STUN Server</th><th>STUN Port</th><th>Use STUN</th></tr></tfoot><tbody>";

  			// build phone array
			$sr = ldap_search($ds,"cn=Modules","(&(objectclass=Phone)(typeofphone=3)(cn=SIP*))",array('cn','guid','description'));
			$info = ldap_get_entries($ds, $sr); 
		
       		for ($m=0; $m<$info['count']; $m++) {
	       		$cn[$m] = $info[$m]['cn'][0];
	       		$desc[$m] = $info[$m]['description'][0];
				$guid[$m] = $info[$m]['guid'][0];
       		}
			
			foreach ($cn as $cnk => $cnv) {
				$sr2 = ldap_read($ds,"cn=1,guid=$guid[$cnk],cn-Modules","(objectclass=GenericIPPhone)", array('stunaddr','stunport','usestun')); 
				$info2 = ldap_get_entries($ds,$sr2); 
				$stunaddr = ( strlen($info2[0]['stunaddr'][0]) >=1 ) ? $info2[0]['stunaddr'][0]  : ""; 
				$stunport = ( isset($info2[0]['stunport'][0]) && $info2[0]['stunport'][0] > 1 ) ? $info2[0]['stunport'][0]  : ""; 
				$usestun = ( isset($info2[0]['usestun'][0]) && $info2[0]['usestun'][0] == "1" ) ? "Enabled"  : ""; 
					
				echo "<tr><td><input type='checkbox' id='phones' name='phones[]' value='$guid[$cnk]'></td><td><a href='../manager.cgi?pagename=phone&index=$guid[$cnk]' target='_blank'>$cn[$cnk]</a></td><td>$desc[$cnk]</td><td>$stunaddr</td><td>$stunport</td><td>$usestun</td></tr>";				
			}
   			
?>

	</table>
	<b>Create System Backup :</b> <input type='checkbox' name='backup' id='backup' checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.jpg'></a><br/><br/>
	
	<input type='submit' name='update' id='update' value='Update STUN Server' onclick="return confirm('Update STUN Server ?')" >
	<span id="Status" style="display:none;"></span>
</form>
</body>
</html>