<?php

$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
	echo "LDAP connect failure<br>";
} else {
ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
$r = ldap_bind($ds,"INTERNAL","00112233445566");
if ( ! $r) {
	echo "LDAP bind failure<br>";
	$ds = false;
	}
}

if (file_exists('/SpliceCom/Web/download/tmp_dateexceptions.txt')) {
	$lines = file('/SpliceCom/Web/download/tmp_dateexceptions.txt');
	$today = strtotime(date('Y-m-d 00:00:00', time()));
	$keepExceptions = array();
	
	if (count($lines) >0) {
		foreach ($lines as $line_num => $line) {
			
			$line = trim($line);
			$exception = explode(';',$line);
			$timePlan = $exception[0]; $tmpDate = $exception[1]; $exceptionGuid = $exception[2];
			
			$tmpDate = explode('-', trim($tmpDate));
			$year = $tmpDate[2]; $month = $tmpDate[1]; $day = $tmpDate[0];
			$exceptionTimestamp = strtotime("$year-$month-$day 00:00:00");
			
			if ($today > $exceptionTimestamp) {
				$dn = "GUID=$exceptionGuid,cn=timeplans";
				ldap_delete($ds,$dn);
				warning("Temporary Date Exception $year-$month-$day removed from TimePlan $timePlan");
			} else {
				echo "KEEP $line\n\n";
				$keepExceptions[] = $line;
			}
			
		} 
		
		$fp = fopen('/SpliceCom/Web/download/tmp_dateexceptions.txt', "w+");
		flock($fp, LOCK_EX);
		foreach($keepExceptions as $line) {
			fwrite($fp, "$line\n");
		}
		flock($fp, LOCK_UN);
		fclose($fp);  
	}
}

function warning($s) {
   	global $ds;
   	$item = array ('dowarning'=> $s); ldap_modify($ds,"cn=Commands",$item);
}

?>