<?php
// v2.00
//PJC 16Jan2013
session_start();
$page_id = "031";
include ".access.php";
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
function num_range($str) {
$tmp = explode(',', $str);
$nums = array();
foreach ($tmp as $el)
{
    $a = explode('-', $el);
    if (count($a) == 1)
    {
	    $nums[] = (int)$a[0];
    }
    else
    {
        for ($i = $a[0]; $i <= $a[1]; ++$i)
        {
            $nums[] = (int)$i;
        }
    }
}
return array_unique($nums);
}
function warning($s) {
   global $ds;
   $item = array ('dowarning'=> $s); ldap_modify($ds,"cn=Commands",$item);
}
?>
<html>
<head>
<title>Voicemail Access Codes - Update Users And/Or Departments</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_vmaccess.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>
<div style="position:absolute; top:30px; right:8px" >
<?php link_check("029","<a href='extension_list.php' target='_blank'>Extension List</a>", $ma_acl); ?>
</div>
<div id="contain">
<h2><img src='images/settings.png' style="vertical-align:middle;">&nbsp;Voicemail Access Codes - Update Users And/Or Departments</h2>
This script allows you to bulk update the voicemail access code to a range of users or departments.<br/><br/>
In the '<b>Number Range</b>' field enter the numbers where the voicemail access code is to be updated. Enter either a comma between<br/>
each number or use a hyphen to indicate a range of numbers. For example: 2001,2003,2005,2009,2015,2020 etc or 2001-2050<br/>
To apply the update to All users or departments, enter <b>ALL</b> in the 'Number Range' field.<br/><br/>
Select whether this is a range of users or departments.<br/><br/>
In the Voicemail Access Code field enter the access code you want applying to your number range.<br/>
eg: entering 6677 will apply 6677 as the voicemail access code to your number range.<br/><br/>
Entering '<b>random</b>' will generate a random 4 digit access code for each number in your range.<br/>
You can specify a random digit length of between 2 - 8 digits, by entering random followed by the number of digits.<br/>
eg: random6 will create a random 6 digit access code for each number in your range.<br/><br/><br/>
<table border="1" width="50%" class='display' id='example' cellspacing="0" cellpadding="0" bordercolordark="#000000" bordercolorlight="#000000" style="border-collapse: collapse">
<form>
	<tr>
		<td><thead><th colspan="3" bgcolor="#FFF">Voicemail Access Code</th></thead></td>
	</tr>
	<tr>
		<td width="10%">&nbsp;Number Range :</td>
		<td width="13%"><p align="center"><input type="text" name="numrange" size="35">&nbsp;<a href='#' class='tooltip' title='Enter Extension Number Range'><img src='images/tooltip.gif'></a></td>
		<td width="12%"><p align="center">User <input type="radio" value="user" checked name="type">&nbsp;Department <input type="radio" value="dept" name="type"></td>
	</tr>
	<tr>
		<td width="10%">&nbsp;Voicemail Access Code :</td>
		<td width="13%"><p align="center"><input type="text" name="accesscode" size="35">&nbsp;<a href='#' class='tooltip' title='New Access Code To Be Applied'><img src='images/tooltip.gif'></a></td>
		<td width="12%"><p align="center"><input type="submit" value="Update"></td>
	</tr>
		<td><tfoot><th colspan="3" bgcolor="#FFF">Create System Backup : <input type="checkbox" name="backup" id="backup" checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.gif'></a></th></tfoot></td>
</form>
</table>
<?php
if ((isset($_REQUEST['numrange'])) && (ctype_digit($_REQUEST['accesscode'])  || preg_match('#random[2-9]?#', $_REQUEST['accesscode']))){
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}

$accesscode = $_REQUEST['accesscode'];
$type = $_REQUEST['type'];
//user or department
if (isset($_REQUEST['type']) && $_REQUEST['type'] == "user"){

$cn="Users";$o="User";
} elseif (isset($_REQUEST['type']) && $_REQUEST['type'] == "dept"){
$cn="Departments";$o="Department";
}

if (strtolower($_REQUEST['numrange'])=="all") {
	$sr=@ldap_list($ds,"cn=$cn","(objectclass=$o)",array('telephonenumber'));
	$info=ldap_get_entries($ds,$sr);
		for($n=0; $n<$info['count'];$n++) {
			$range[]=(int)$info[$n]['telephonenumber'][0];
		}
} else {
$range = num_range($_REQUEST['numrange']);
}

if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
$backup = "Backup ".date('d.m.y His')." - Pre".$cn."VMAccessCodeChange.txt"; $ent["dobackupto"][0] = $backup; ldap_modify($ds,"cn=Commands", $ent); ldap_modify($ds,"cn=Commands", $ent); $ent='';
}

echo "<br/><br/><b>".$cn."</b> : <br/>";
foreach ($range as $key => $value) {
	$sr=@ldap_list($ds,"cn=$cn","(&(objectclass=$o)(telephonenumber=$value))",array('cn','telephonenumber'));
	$info=ldap_get_entries($ds,$sr);

	for($n=0; $n<$info['count'];$n++) {
		$count = $info['count'];
		//work out access code.
			if (ctype_digit($accesscode)){
				$p=$accesscode;
			} elseif (preg_match('#random[2-8]#', $accesscode)) {
				$p = mt_rand(13451111, 99999999);
				$p=substr($p,0,substr($accesscode,6));
			} elseif ($accesscode=="random") {
				$p = mt_rand(1345, 9999);
			}

	  $att=array('voicemailaccesscode'=>$p); ldap_modify($ds,$info[$n]['dn'],$att);
	  echo "<b>".$info[$n]['cn'][0]."</b> (".$info[$n]['telephonenumber'][0].") voicemail access code updated to <b>$p</b><br/>";
	  warning ("<b>".$info[$n]['cn'][0]."</b> (".$info[$n]['telephonenumber'][0].") voicemail access code updated to <b>$p</b><br/>");
	   }
	}
	if ($count<1) echo "No matching <b>$o</b> entries found.<br/>";
}
?>
</div>
