<?php
session_start();
// v2.46
// PJC 05-NOV-2018 - SIP Phone
// PJC 18-JAN-2017 - Add DIV Width 450px
// PJC 16-MAY-2016 - Add Voicemail Port count
// PJC 24-MAR-2016 - Add IPUser count
// PJC 05-Jan-2015 - Wording Update
// PJC 19Feb2014 - Help Link
// pjc DEC12
//bobg 10mar08  8aug08 110aug09 1feb11 3nov
header('Content-type: text/html; charset=UTF-8') ;
$page_id = "041";
include "assist/.access.php";
include "assist/tzone.php"; // include timezone
$script=basename($_SERVER['SCRIPT_NAME']);
?>
<html>
<head>
<title>System Licences - View Status</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<META http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link rel="shortcut icon" href="favicon.ico">
<link href="assist/css/Styles.css" rel="stylesheet" type="text/css">
<script src="assist/js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="assist/js/wiz/main.js" type="text/javascript"></script>
<script type="text/javascript">
$(function() {
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});
	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
});
$(document).ready(function(){
	 $("#tbl").sticky();$("#tbl2").sticky();
});
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div id="toTop">^ Back to Top</div>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script?>'" src="assist/images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('assist/help/help_licences.php','help','600','500','yes');return false" src="assist/images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist/assist.php'" src="assist/images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="assist/images/home16.gif" alt="home" title="home" border="0">
</div>
<div style="position:absolute; top:30px; right:10px;width:450px" >
<?php link_check("028","<a href='ul.php' alt='user' title='user'>User Licence Status</a>&nbsp;|&nbsp;", $ma_acl); ?>
<?php link_check("006","<a href='dl.php' alt='department' title='department'>Department Licence Status</a>&nbsp;|&nbsp;", $ma_acl); ?>
<?php link_check("041","<a href='licences.php' alt='system' title='system'>System Licence Status</a>", $ma_acl); ?>
</div>
<div id="contain">
<h2><img src='assist/images/ok.png' style="vertical-align:middle;">&nbsp;System Licences - View Status</h2>
<?php
$ds = @ldap_connect("127.0.0.1",4000) or exit("<p>EXIT: LDAP connect failure</p>");
@ldap_bind($ds,"INTERNAL","0123456") or exit("<p>EXIT: LDAP bind failure</p>");

// find master details as licence count stored there
$sr=ldap_search($ds,"cn=Modules","(&(objectclass=AdministrationModule)(administrationmode=1))");
$info=ldap_get_entries($ds,$sr);
$sa = explode(",",$info[0]['dn']);
$s = substr($sa[1],3);
$publicipaddress=$info[0]['publicipaddress'][0];
$dn="cn=$s,cn=Modules";
$sr=ldap_read($ds,$dn,"objectclass=*");
$info=ldap_get_entries($ds,$sr);
$ipaddress = $info[0]['ipaddress'][0];
$guid=$info[0]['guid'][0];
// find self
$sr = ldap_read($ds,"cn=Self,cn=Modules","objectclass=*");
$info = ldap_get_entries($ds,$sr);
$self = $info[0]['location'][0];
if ($guid == $self) {
   $dsm=$ds;
} else {
   if(!$publicipaddress) $ip=$ipaddress;
   else {
      $sr=ldap_list($ds,"cn=Modules","(&(objectclass=Module)(guid=$self))");
      $info = ldap_get_entries($ds,$sr);
      $dn=$info[0]['dn'];
      $sr=ldap_search($ds,$dn,"(&(objectclass=IntraModuleTrunk)(ipaddress=$ipaddress))");
      $info = ldap_get_entries($ds,$sr);
      if ($info[0]['count']) $ip=$ipaddress;
      else $ip= $publicipaddress;
   }
   $dsm = @ldap_connect($ip,4000) or exit("<p>EXIT: Primary Call Server LDAP connect failure</p>");
   @ldap_bind($dsm,"INTERNAL","001122334455") or exit("<p>EXIT: Primary Call Server LDAP bind failure</p>");
}

$dummy = "A Dummy Licence - Please Ignore";
$dummyatt=array('objectclass'=>'License','qty'=>'0','License'=>$dummy);
ldap_add($ds,"key=$dummy, cn=System",$dummyatt); ldap_delete($ds,"key=$dummy, cn=System");

$sr=@ldap_list($dsm,"cn=System","objectclass=licenserecord");
$info=ldap_get_entries($dsm,$sr);
print "<p>Licence Count:<p><table border=1 id='tbl'><tr><th width='200px'>Licence Type</th><th width='100px'>Available</th><th width='100px'>Used *</th></tr>";
for($n=0; $n<$info['count'];$n++) {
    $title=substr($info[$n]['license'][0],1);
    if ($title=="TotalControl") $title="VisionMobility";
	
	if (strtolower($title) == "ipuser") { 
		print "<tr><td><img onClick=\"centeredPopup('licences_ipuser.php','IPUsers','500','700','yes');return false\" src='assist/images/expand.gif' alt='IPUsers' title='IPUsers' border='0' />&nbsp;Total Users</td><td>".$info[$n]['qty'][0]."</td><td>".$info[$n]['used'][0]."</td></tr>";
	} else if (strtolower($title) == "voicemailport") { 
		print "<tr><td><img onClick=\"centeredPopup('licences_vmport.php','VoicemailPort','400','700','yes');return false\" src='assist/images/expand.gif' alt='VoicemailPort' title='VoicemailPort' border='0' />&nbsp;$title</td><td>".$info[$n]['qty'][0]."</td><td>".$info[$n]['used'][0]."</td></tr>";
	} else if (strtolower($title) == "sipphone") { 
		print "<tr><td><img onClick=\"centeredPopup('licences_sipphone.php','VoicemailPort','430','500','yes');return false\" src='assist/images/expand.gif' alt='SIPLicence' title='SIPLicence' border='0' />&nbsp;$title</td><td>".$info[$n]['qty'][0]."</td><td>".$info[$n]['used'][0]."</td></tr>";
	}
	else {
		print "<tr><td>$title</td><td>".$info[$n]['qty'][0]."</td><td>";
		echo ($title == "ManagedUser" || $title == "iPCS" || $title == "VisionMobility" || $title == "VisionReport") ? "" : $info[$n]['used'][0];
		echo "</td></tr>";
		
	}
}
print "</table><p>* The Primary counts the licences used.<br/><br/>";
print "<b>Please note</b> that when calculating the number of IPUser licences that are in use you need to include all active POTS ports that are available on the following modules<br/><br/>
5100, 5108 and 4140 Call Server<br/>
43xx, 53xx and P308 Phone Modules<br/><br/>
Although these do not have an IPUser licence assigned to them they are included in the count and therefore will be added to the number of actual IPUser licences you have allocated to users with IP Phones.<br/>
If you have Managed IPUser licences within your system these will add to the total number of IPUser Licences available but are not included in the count of licences in use.<br/>";
print "<br/>Note: This script added a dummy licence to trigger a recount.<br/>Your warnings will show : <b>$dummy</b> REJECTED</p>";

// build array of nodes
$sr=@ldap_list($ds,"cn=Modules","(&(objectclass=Module)(modulestatus=0))");
$info=ldap_get_entries($ds,$sr);
//		print "Module count = ".$info['count']."<br/>";
for($n=0; $n<$info['count'];$n++) {
    $n2 = @count($modules['cn']);
    if ($info[$n]['moduletype'][0]==1) $modules['type'][$n2]="4100";
    if ($info[$n]['moduletype'][0]==1 and substr($info[$n]['serialnumber'][0],0,8)!="00-07-d9") $modules['type'][$n2]="XS";
    if ($info[$n]['moduletype'][0]==2) continue; //$modules['type'][$n2]="4200";
    if ($info[$n]['moduletype'][0]==3) $modules['type'][$n2]="4315";
    if ($info[$n]['moduletype'][0]==4) $modules['type'][$n2]="4330";
    if ($info[$n]['moduletype'][0]==7) continue; //$modules['type'][$n2]="VoIP";
    if ($info[$n]['moduletype'][0]==8) continue; //$modules['type'][$n2]="4400";
    if ($info[$n]['moduletype'][0]==10) $modules['type'][$n2]="4140";
    if ($info[$n]['moduletype'][0]==11) $modules['type'][$n2]="5100";
    if ($info[$n]['moduletype'][0]==12) $modules['type'][$n2]="5108";
    if ($info[$n]['moduletype'][0]==13) $modules['type'][$n2]="5330";
    if ($info[$n]['moduletype'][0]==14) $modules['type'][$n2]="5315";
    if ($info[$n]['moduletype'][0]==17) $modules['type'][$n2]="S8000 Linux";
    if ($info[$n]['moduletype'][0]==18) $modules['type'][$n2]="S8000 Apple";
    if ($info[$n]['moduletype'][0]==19) $modules['type'][$n2]="NSG";
    if ($info[$n]['moduletype'][0]==20) continue; //$modules['type'][$n2]="Vision";
    if (!isset($modules['type'][$n2])) $modules['type'][$n2] = $info[$n]['moduletype'][0];

    $modules['cn'][$n2] = $info[$n]['cn'][0];
    $modules['guid'][$n2] = $info[$n]['guid'][0];
    $modules['version'][$n2] = $info[$n]['productversion'][0];
	$modules['ipaddress'][$n2] = $info[$n]['ipaddress'][0];
    $days=floor((time()-$info[$n]['lastseen'][0])/(24*60*60))." days ago @ ";
    $days .=date(" H:i:s l, jS F Y",$info[$n]['lastseen'][0]);
    $modules['lastseen'][$n2] = $days;
}

print "<p>Modules affecting licence count in system:</p><table border=1 id='tbl2'><tr><th>#</th><th>IP Address</th><th>Name</th><th>Type</th><th>Version</th><th>Last Seen</th></tr>";
foreach ($modules['ipaddress'] as $key => $value) {
    print "<tr><td>".($key+1)."</td><td>".$modules['ipaddress'][$key]."</td><td>".$modules['cn'][$key]."</td><td>".$modules['type'][$key]."</td><td>".$modules['version'][$key];
    print "</td><td>".$modules['lastseen'][$key]."</td></tr>";
}

print "</table>";

print "<p>".date(" H:i:s l, jS F Y")."</p>";
?>
</div>
</body>
</html>
