<?php

// PJC - 19-May-2016 v1.1 - added 17/18 SoftPBX
// PJC - 16-MAY-2016 v1.0

header('Content-type: text/html; charset=UTF-8') ;
$page_id = "041";
include "assist/.access.php";
include "assist/tzone.php"; // include timezone
$script=basename($_SERVER['SCRIPT_NAME']);
?>
<html>
<head>
<title>Voicemail Port Licences</title>
<head>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<style>body {  background-image: none;}</style>
<script type="text/javascript">
	var state = {};
	var title = 'IPUsers';
	var url   = '/manager/assist';
	history.pushState(state, title, url);
</script>
</head>
<body style="background-color:#F6F6F6";>
<div id="wrapper" style="text-align: center">    
<div id="yourdiv" style="display: inline-block;">
<?php
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}
	
	$port_count = $licence_count = $callserver = 0;
	$modules_cn = array('1'=>'CallServer 4100', '10'=>'Remote CallServer 4140','11'=>'CallServer 5100','12'=>'CallServer 5108','17'=>'SoftPBX','18'=>'SoftPBX','19'=>'Network Service Gateway');
	$modules_ports = array('1'=>'8','10'=>'4','11'=>'4','12'=>'2','17'=>'0','18'=>'0','19'=>'2');

	$sr = ldap_list($ds,"cn=modules","(&(objectclass=module)(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19)))",array('status','cn','guid','moduletype'));
		$info = ldap_get_entries($ds, $sr);  
		
	echo "<table border ='1' style='border-collapse: collapse'>";
	echo "<thead><th>Name</th><th>Module</th><th>VM Ports</th></thead>";
	
		for ($m=0; $m<$info['count']; $m++) {
			$module_ports = $modules_ports[$info[$m]['moduletype'][0]];
			$module_type = $modules_cn[$info[$m]['moduletype'][0]];
			$module_cn = $info[$m]['cn'][0];
			 $port_count += $module_ports;
			 echo "<tr><td>$module_cn</td><td><i>$module_type</i></td><td>$module_ports</td></tr>";
		}
	
	echo "<tr><td colspan='2'>Total Voicemail Ports:</td><td><b>$port_count</b></td></tr>";
	echo "<tr><td colspan='2'>&nbsp;</td></tr>";
	
	
	$sr = ldap_list($ds,"cn=system","(&(objectclass=license)(license=voicemailport))",array('key','valid','license','qty'));
		$info = ldap_get_entries($ds, $sr);  

	echo "<thead><th colspan='2'>Licence</th><th>Quantity</th></thead>";
	
	
		for ($m=0; $m<$info['count']; $m++) {
			$licence = $info[$m]['license'][0];
			$quantity = $info[$m]['qty'][0];
   		    $licence_count += $quantity;
			echo "<tr><td colspan='2'>$licence</td><td>$quantity</td></tr>";
		}
		
	$total =  $licence_count + $port_count;		
	echo "<tr><td colspan='2'>Total:</td><td><b>$licence_count</b></td></tr>";
	echo "<tr><td colspan='3'>&nbsp;</td></tr>";
	echo "<tr><td colspan='2'>Total Licences:</td><td><b>$total</b></td></tr>";
	echo "</table>";			
?>
</div>
</div>
</body>
</html>