<?php

function print_result($info)
{
    foreach( $info[0] as $key => $value )
    {
        if( is_array($value ) )
        {
            print "$key\n";
            foreach( $value as $subkey => $subvalue )
            {
                print "  $subkey => $subvalue\n";
            }
        }
    }
}

// *************************************
// GENERIC FUNCTIONS

function FindUser($userNameOrExtn)
{
    global $ls;
    $attr=Array("GUID","cn");
    
    if( $userNameOrExtn > 0 )
    {
        $res=ldap_search($ls,"","(GlobalExtnNumber=$userNameOrExtn)",$attr,0,1);
    }
    else
    {
        $res=ldap_read($ls,"cn=$userNameOrExtn,cn=Users","(objectclass=User)",$attr);
    }
    $info=ldap_get_entries($ls,$res);
    if( $info )
    {
        $cn=$info[0]['cn'][0];
        $guid=$info[0]['guid'][0];
//        print "FindUser for $userNameOrExtn cn=$cn guid=$guid\n";
        return $info[0];
    }
    else
    {
        die("FindUser not found for $userNameOrExtn");
    }
}

function FindUserGUID($userNameOrExtn)
{
    $info = FindUser($userNameOrExtn);
    if( $info )
    {
        return $info["guid"][0];
    }
    else
    {
        die("Unable to find user $userNameOrExtn");
    }
}

function FindUserName($userNameOrExtn)
{
    $info = FindUser($userNameOrExtn);
    if( $info )
    {
        return $info["cn"][0];
    }
}

function FindGroupCapability($groupName,$capName)
{
    global $ls;
    $attr=Array("GUID","capability","capabilityPercent");
    $res = ldap_search($ls,"cn=$groupName,cn=Groups","(&(objectclass=Capability)(capability=$capName))",$attr,0,1);
    $info=ldap_get_entries($ls,$res);
    if( $info )
    {
        return $info[0];
    }
    else
    {
        print "FindGroupCapability not found for $groupName $capName\n";
    }
}

function FindUserCapability($userName,$capName)
{
    global $ls;
    $attr=Array("GUID","capability","capabilityPercent");
    $res = ldap_search($ls,"cn=$userName,cn=Users","(&(objectclass=Capability)(capability=$capName))",$attr,0,1);
    $info=ldap_get_entries($ls,$res);
    if( $info )
    {
        return $info[0];
    }
    else
    {
        print "FindUserCapability not found for $userName $capName\n";
    }
}

// *************************************
// USER FUNCTIONS

function SetDoNotDisturb($userNameOrExtn,$value)
{
    global $ls;
    print "SetDoNotDisturb($userNameOrExtn,$value)\n";

    // Find the User first
    $userGUID=FindUserGUID($userNameOrExtn);
    $values['doNotDisturb'] = $value;
    ldap_modify($ls,"guid=$userGUID",$values ) or die("SetDoNotDisturb($userNameOrExtn,$value) failed to set value");
}

function SetOutOfOffice($userNameOrExtn,$mode,$message)
{
    global $ls;
    print "SetOutOfOffice($userNameOrExtn,$mode,$message)\n";
    
    $userGUID=FindUserGUID($userNameOrExtn);
    $values['outOfOffice'] = $mode;
    $values['outOfOfficeMsg'] = $message;
    ldap_modify($ls,"guid=$userGUID",$values ) or die("SetOutOfOffice($userNameOrExtn,$mode,$message) failed to set value");    
}

function SetFollowMeMode($userNameOrExtn,$mode)
{
    global $ls;
    print "SetFollowMeMode($userNameOrExtn,$mode)\n";
    
    $userGUID=FindUserGUID($userNameOrExtn);
    $values['followMe'] = $mode;
    ldap_modify($ls,"guid=$userGUID",$values ) or die("SetFollowMeMode($userNameOrExtn,$mode) failed to set value");
}

function EnableUserCapability($userNameOrExtn,$capName)
{
    global $ls;
    
    $userName = FindUserName($userNameOrExtn);
    
    print "EnableUserCapability($userNameOrExtn,$capName) userName=$userName\n";
    
    $cap=FindUserCapability($userName,$capName);
    if( $cap )
    {
        $capGUID=$cap["guid"][0];
        $capValue = $cap['capabilitypercent'][0];
        if( $capValue < 0 )
        {
            if( $capGUID )
                ldap_delete($ls,"guid=$capGUID") or die("EnableUserCapability($userNameOrExtn,$capName) failed to delete cap");
            $values['objectclass'] = "Capability";
            $values['capabilitypercent'] = abs($capValue);
            ldap_add($ls,"capability=$capName,cn=$userName,cn=Users",$values) or die("EnableUserCapability($userNameOrExtn,$capName) failed to add cap");
        }
        else
        {
            print "EnableUserCapability($userNameOrExtn,$capName) already Enabled\n";
        }
    }
}

function DisableUserCapability($userNameOrExtn,$capName)
{
    global $ls;
    
    $userName = FindUserName($userNameOrExtn);

    print "DisableUserCapability($userNameOrExtn,$capName) userName=$userName\n";
    $cap=FindUserCapability($userName,$capName);
    if( $cap )
    {
        $capGUID=$cap["guid"][0];
        $capValue = $cap['capabilitypercent'][0];
        if( $capValue > 0 )
        {
            if( $capGUID )
                ldap_delete($ls,"guid=$capGUID") or die("DisableGroupCapability($userNameOrExtn,$capName) failed to delete cap");
            
            $values['objectclass'] = "Capability";
            $values['capabilitypercent']= -abs($capValue);
            ldap_add($ls,"capability=$capName,cn=$userName,cn=Users",$values) or die("DisableCapability($userNameOrExtn,$capName) failed to add cap");
        }
        else
        {
            print "DisableUserCapability($userNameOrExtn,$capName) already Disabled $capValue\n";
        }
        
    }
}

// *************************************
// GROUP FUNCTIONS

function SetGroupCapability($groupName,$capName,$capValue)
{
    global $ls;
    print "SetGroupCapability($groupName,$capName,$capValue)\n";
    $cap=FindGroupCapability($groupName,$capName);
    if( $cap )
    {
        $capGUID=$cap["guid"][0];
        if( $capGUID )
            ldap_delete($ls,"guid=$capGUID") or die("SetGroupCapability($groupName,$capName) failed to delete cap");
    }
    $values['objectclass'] = "Capability";
    $values['capabilitypercent']=$capValue;
    ldap_add($ls,"capability=$capName,cn=$groupName,cn=Groups",$values) or die("SetGroupCapability($groupName,$capName,$capValue) failed to add cap");
}


$ls = ldap_connect("127.0.0.1",4000);
ldap_bind($ls,"INTERNAL","001122334455");

include $argv[1];

ldap_close($ls);

?>
