<?php
// 05July16 - Update SIP Phone Licence
// 05Jan15 - Update User / Department Naming.

session_start();
include "assist/tzone.php"; // include timezone
$script=basename($_SERVER['SCRIPT_NAME']);
$ds = @ldap_connect("127.0.0.1",4000) or exit("<p>EXIT: LDAP connect failure</p>");
@ldap_bind($ds,"INTERNAL","0123456") or exit("<p>EXIT: LDAP bind failure</p>");

$cblicences = array('disabled' => 'Disabled', 'messageboxlicense' => 'MessageBox Licence', 'totalcontrollicense' => 'Vision Mobility Licence', 'agentlicense' => 'Vision Agent Licence', 'ocslicense' => 'OCS Licence', 'ipcslicense' => 'iPCS Licence', 'navigatesoftphonelicense' => 'Navigate SoftPhone', 'navigatesfblicense' => 'Navigate Skype for Business Licence', 'siplicense' => 'SIP Phone Licence');
$usertypes = array('0' => 'IP User', '1' => 'Virtual User', '2' => 'Analogue User');
$ocs = array('0' => 'None', '1' => 'Enabled', '2' => 'PCS Partner Only');
$navigate = array('0' => 'None', '1' => 'Enabled', '2' => 'Calendar Disbaled');

$mode = (isset($_REQUEST['mode']) && strlen($_REQUEST['mode']) > 0) ? $_REQUEST['mode'] : NULL;
$dn = (isset($_REQUEST['dn']) && strlen($_REQUEST['dn']) > 0) ? $_REQUEST['dn'] : NULL;

if ($dn) {
	
	if ($mode == 'checkbox') {
		$cb = $_REQUEST['cb'];
		$state = $_REQUEST['state'];
		$att = array ($cb => $state);
		ldap_modify($ds, $dn, $att);
		
		$state = ($state == '1') ? 'Selected' : 'Deselected';
		$extn=(explode(",",$dn));
		$extn=str_replace("cn=","",$extn[0]);
		echo "<b>Database Update</b><br/>Users = $extn<br/>Licence = $cblicences[$cb]<br/>Value = $state";
	}		
	
	if ($mode == 'radio') {
		$selectedUserType = $_REQUEST['selectedUserType'];
		$att = array ('usertype' => $selectedUserType);
		ldap_modify($ds, $dn, $att);
		
		$extn=(explode(",",$dn));
		$extn=str_replace("cn=","",$extn[0]);
		echo "<b>Database Update</b><br/>Users = $extn<br/>Licence = User Type<br/>Value = $usertypes[$selectedUserType]";
	}		
	
	if ($mode == 'select') {
		
		$cb = $_REQUEST['cb'];
		$state = $_REQUEST['state'];
		$att = array ($cb => $state);
		ldap_modify($ds, $dn, $att);
		
		$extn=(explode(",",$dn));
		$extn=str_replace("cn=","",$extn[0]);
		
		if ($cb == 'navigateoutlooklicense') {
			$licence = 'Navigate Outlook';
			$state = $navigate[$state];
		} else {
			$licence = 'Operator Console';
			$state = $ocs[$state];
		}
		echo "<b>Database Update</b><br/>Users = $extn<br/>Licence = $licence<br/>Value = $state";
	}		
	
}
?>