<?php

//PJC v1.7 Updated Subnet Check
//PJC v1.6 added container check
//PJC v1.5 added logingaccesscode, ipaddress, sippnpfilelocation, dnsPrimary
//PJC v1.4 set default SoftPBX Module Name and Description
//PJC v1.3 add validation test
//PJC v1.2 updated to add users based on number of licences
//PJC v1.1 - added select admin portal user

require('../admin/assets/inc/ldapConnect.php');

if (file_exists('/SpliceCom/WebManager/admin/update/container')) {
	ldap_modify($ds,"cn=system", array('welcomedone' => '0'));
	header("Location: /manager/admin/update"); 
	exit();
}	

$sr = ldap_read($ds, "cn=System" ,"objectclass=System",array('welcomedone')); 
$info = ldap_get_entries($ds,$sr);	$welcomedone = $info[0]['welcomedone'][0];

if (isset($welcomedone) && $welcomedone === '0') {
	header("Location: ../admin");	
	exit;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>Welcome</title>
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="../admin/assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="../admin/assets/css/buttons.css" rel="stylesheet" type="text/css">
<link href="../admin/assets/css/smart_wizard.css" rel="stylesheet" type="text/css">
<link href="../admin/assets/css/menu.css" media="screen" rel="stylesheet" type="text/css" />
<link href="welcome.css" rel="stylesheet" type="text/css">

<script src="../admin/assets/js/jquery-min.js" type="text/javascript"></script>
<script src="../admin/assets/js/jquery.smartWizard.js" type="text/javascript"></script>
<script src="../admin/assets/js/jquery.noty.packaged.js" type="text/javascript"></script>
<script src="../admin/assets/js/strength.js" type="text/javascript"></script>
<script src="../admin/assets/js/idle-timer.min.js" type="text/javascript"></script>
<script src="welcome.js" type="text/javascript"></script>
</head>

<?php 
$cmd = "cat /proc/version";
exec($cmd,$a); $a = (count($a) >=1) ? $a[0] : "";
$model = (preg_match('~\b(suse|centos|red)\b~i',$a)) ? "SoftPBX" : "CallServer";

$ports = ($model == "SoftPBX") ? "6900 - 7859" : "6300 - 6699";

	$sr = ldap_read($ds,"cn=self,cn=Modules","objectclass=*"); $info = ldap_get_entries($ds,$sr); $loc = $info[0]['location'][0];
    $sr = ldap_list($ds,"cn=Modules","(&(objectclass=*)(guid=".$loc."))",array('cn','ipaddress','moduletype','productversion','serialnumber','location')); 
    $info = ldap_get_entries($ds,$sr); $dn = $info[0]['dn']; $ip = $info[0]['ipaddress'][0]; $mod = $info[0]['moduletype'][0]; 
	$serial = $info[0]['serialnumber'][0]; $ver = $info[0]['productversion'][0]; $softpbx_name = $info[0]['cn'][0];
	
	$iface = exec("ip r | awk '/^default/{print \$5}'");
    $subnetnum = exec("ip -4 addr show dev $iface | awk '/inet /{print \$2;}'");
    $dhcpBasemask = cidr2NetmaskAddr($subnetnum);
	
	$cmd = "ip route get 8.8.8.8 | awk '/via/ {f=NR} f&&NR-1==f' RS=' '";
	exec($cmd, $dfGateway);
	
	if (isset($dfGateway) && count($dfGateway) >=1) {
		if (count($dfGateway) == "1") {
			$dfGateway = $dfGateway[0];
		}
		elseif (array_unique($dfGateway)) {
			$dfGateway = "Multiple Gateways Set";
		} else {
			$dfGateway = $dfGateway[0];
		}	
	} else {
		$dfGateway = "No Default Gateway Set";
	}
	
	$lines = file('/etc/resolv.conf'); $dns='';
	foreach ($lines as $line_num => $line) {
		if(strstr($line,'nameserver')) $dns .=str_replace("nameserver","",$line);
	} 
	$dns = trim($dns); $dns = explode(" ",$dns);
	$dnsPrimary = isset($dns[0]) ? trim($dns[0]) : 'Not Set';
	$dnsSecondary = isset($dns[1]) ? trim($dns[1]) : 'Not Set';
?>

<body>
<div id="content">

<div class="logo">
<a href="#" tabindex="-1"><img src='../admin/assets/images/clear.png'></img></a>
</div>

<div id="wrap">

<!-- content begins -->
<div id="main">
<div class="wrapper">


<table align="center" border="0" cellpadding="0" cellspacing="0">
<tr><td> 
<form action="save.php" method="post" name="config" id="config">
<!-- Tabs -->
  		<div id="wizard" class="swMain">
  			<ul>
			<li><a href="#step-1">
                <label class="stepNumber">1</label>
                <span class="stepDesc">
                   Welcome<br />
                   <small>to Splicecom SelectVoice</small>
                </span>
            </a></li>
			<li><a href="#step-2">
                <label class="stepNumber">2</label>
                <span class="stepDesc">
                   Network<br />
                   <small>Network Overview</small>
                </span>                   
             </a></li>
  			<li><a href="#step-3">
                <label class="stepNumber">3</label>
                <span class="stepDesc">
                   System<br />
                   <small>System & Licence</small>
                </span>
            </a></li>
  			<li><a href="#step-4">
                <label class="stepNumber">4</label>
                <span class="stepDesc">
                   Security<br />
                   <small>Security & Configuration</small>
                </span>
            </a></li>
  			</ul>


		<div id="step-1">	
		<div class="stepOne">
            <span class="StepTitle">Step 1: Welcome to Splicecom SelectVoice</span>
		</div>
			<img src="../admin/assets/images/welcome.png" height='496px' width='968px'/>		
        </div>
		
		<div id="step-2">
            <h2 class="StepTitle">Step 2: Network Overview</h2>
								
			<div class="colLeft">
			
				<br><strong>Network Overview</strong><br><br>
				Current network configuration overview. If any of these settings are wrong please correct them via the operating system and reload this page.<br><br>
				
				<div class='field network'>
					<label>IP Address</label>
					<span class='summary' id='IPAddress'><?php echo $ip ?></span>
				</div>
				
				<div class='field network'>
					<label>Subnet Mask</label>
					<span class='summary' id='Subnet'><?php echo $dhcpBasemask ?></span>
				</div>
				
				<div class='field network'>
					<label>Default Gateway</label>
					<span class='summary' id='Gateway'><?php echo $dfGateway ?></span>
				</div>
				
				<div class='field network'>
					<label>DNS Server 1</label>
					<span class='summary' id='DNSPrimary'><?php echo $dnsPrimary ?></span>
				</div>
				
				<div class='field network'>
					<label>DNS Server 2</label>
					<span class='summary' id='DNSSecondary'><?php echo $dnsSecondary ?></span>
				</div>
				
			</div> <!-- left -->
			
			<div class="colRight">
												
				<br><strong>Internet Connectivity Test</strong><br><br>
				Testing to see if this system can access the Internet and resolve Domain Names. If either of the below tests fail, please check your network settings before proceeding.<br><br>
				<?php
					function is_connected() {
				    set_time_limit(2);
					$connected = @fsockopen("www.example.com", 80, $errorNo, $errorString, 2);
						if ($connected){
							fclose($connected);       
							return true;
						}
							return false;
					}
		
					$statusCheck = is_connected();
					if ($statusCheck === True) {
						$internet_access =  "Online";
						$internet_access_icon = "success.png";
					} else {
						$internet_access =  "Offline";	
						$internet_access_icon = "fail.png";
					}

				?>
				
				<div class='field internet'>
					<label>Internet Access</label>
					<span class='summary' id='internet_access'><?php echo $internet_access ?>&nbsp;&nbsp;<img src='../admin/assets/images/<?php echo $internet_access_icon ?>'</span>
				</div>
				
				<?php
					$cmd = "curl -k https://validate.splicecom.com";
					$res = strtolower(shell_exec ($cmd));
				
					if (strpos($res, 'connection ok') !== false) {
						$validate_access =  "Success";
						$validate_access_icon = "success.png";
					} else {
						$validate_access =  "Fail";	
						$validate_access_icon = "fail.png";
					}
				?>
				The <b>Validate Server Access</b> field shows whether this wizard has been able to reach the Splicecom Validate server. This does not validate the SoftPBX to the server, it is only an indication of connectivity.<br><br>
				<div class='field internet'>
					<label>Validate Server Access</label>
					<span class='summary' id='validate_connection'><?php echo $validate_access ?>&nbsp;&nbsp;<img src='../admin/assets/images/<?php echo $validate_access_icon ?>'</span>
				</div>
								
				<br><strong>System Security</strong><br><br>
				Splicecom recommends that the firewall be configured to only allow access to the SoftPBX system from recognised external IP addresses for the specific ports required, e.g. the address of the SIP provider and your own IP address for remote access to complete diagnostic and configuration work.<br>
			</div> <!-- right -->
        </div>
		
		
		<div id="step-3">	
            <h2 class="StepTitle">Step 3: System & Licence Configuration</h2>
			
			<div class="colLeft">
			
			<br><strong>System Configuration</strong><br>
            <br>Please enter your System Name and Supplier Details these should be the same as the details sent you in your licensing email.<br><br>
				<div class='field system'>
					<label for="system_name">System Name</label>
					<input type="text" name="system_name" id="system_name" autocomplete="off" tabindex="1" value=''/>
					<span class='information'>SYSTEM NAME</span>
				</div>
				
				<div class='field system'>
					<label for="system_supplier">Supplier Name</label>
					<input type="text" name="system_supplier" id="system_supplier" size="30" autocomplete="off" tabindex="2" value=''>
					<span class='information'>SYSTEM SUPPLIER NAME</span>
				</div>
				
				<div class='field system'>
					<label for="system_description">System Description</label>
					<input type="text" name="system_description" id="system_description" size="30" autocomplete="off" tabindex="3" value=''/>
					<span class='information'>SYSTEM DESCRIPTION</span>
				</div>
				
				<div class='field system'>
					<label for="softpbx_name">SoftPBX Module Name</label>
					<input type="text" name="softpbx_name" id="softpbx_name" size="30" autocomplete="off" tabindex="4" value='<?php echo $softpbx_name ?>'/>
					<span class='information'>NAME TO BE APPLIED TO SOFTPBX MODULE</span>
				</div>
				
				<div class='field system'>
					<label for="softpbx_description">SoftPBX Module Description</label>
					<input type="text" name="softpbx_description" id="softpbx_description" size="30" autocomplete="off" tabindex="4" value='Splicecom SoftPBX'/>
					<span class='information'>DESCRIPTION TO BE APPLIED TO SOFTPBX MODULE</span>
				</div>
			</div> <!-- left -->
			
			<div class="colRight">
			<br><strong>Licence Configuration</strong><br>
			<br>To Retrieve Licence information your SelectVoice system must be connected to the internet with appropriate routing and DNS Settings.<br><br>
			If you do not have internet connectivity you will need to add your licenses manually.<br><br>
			Please enter your Support Forum Credentials:<br><br>
			
				<div class='field system'>
					<label for="uemail">Registered email address</label>
					<input type="text" name="uemail" id="uemail" size="30" autocomplete="off" tabindex="5" value=''/>
					<span class='information'>SUPPORT FORUM REGISTERED EMAIL ADDRESS</span>
				</div>
				
				<div class='field system'>
					<label for="upassword">Registered password</label>
					<input type="password" name="upassword" id="upassword" size="30" autocomplete="off" tabindex="6" value=''/>
					<span class='information'>SUPPORT FORUM REGISTERED PASSWORD</span>
				</div>				
				
				<input type='button' name="get_licences" id="get_licences" value="Get Licences"><span name="licence_status" id="licence_status"></span>&nbsp;<span name="licence_link" id="licence_link" style='display: none'><a href='#' onClick="centeredPopup('licences.php','Licences','650','800','yes');return false" name='view_licence' id='view_licence' title='View Downloaded Licences'>View Licences</a></span><br>
				<div id="licence_msg"></div><br>
			
				<div class='field system' id="softpbx_multiple_licences" id="softpbx_multiple_licences" style="display:none">
					<label for="uemail">Select SoftPBX Licence</label>
					<select id="licence_select" name="licence_select">
					</select>
					<span class='information'>SELECT SOFTPBX LICENCE</span>
				</div>
			
				<input type='hidden' name='licence' id='licence' value=''>
			</div> <!-- right -->
        </div>
  		
		<div id="step-4">
            <h2 class="StepTitle">Step 4: Security & System Configuration</h2>
			
			<div class="colLeft">
			
				<br><strong>Password Configuration</strong>&nbsp;&nbsp;<div class='showhidepassword'><a href='#' id='showPasswords'><span class='icon-notification showpassword'></span> SHOW PASSWORDS</a></div><br><br>
				
				<div class='field password'>
					<label for="password_calllogging">Call Logging Password</label>
					<input type="password" name="password_calllogging" id="password_calllogging" autocomplete="off" tabindex="1" value=''>
					<span class='information passwordSpan'>ACCESS TO CALL LOGGING INFORMATION</span>
				</div>
				
				<div class='field password'>
					<label for="password_diagnostics">Diagnostic Engineering Password</label>
					<input type="password" name="password_diagnostics" id="password_diagnostics" tabindex="2" value=''>
					<span class='information passwordSpan'><span class='icon-notification showpassword'></span> THIS IS YOUR SERVER ROOT PASSWORD <span class='icon-notification showpassword'></span></span>
				</div>

				<div class='field password'>
					<label for="password_web">Web Password</label>
					<input type="password" name="password_web" id="password_web" autocomplete="off" tabindex="3" value=''>
					<span class='information passwordSpan'>ACCESS TO THE INTERNAL WEB SERVER</span>
				</div>
								
				<div class='field password'>
					<label for="password_maintainer">Maintainer Password</label>
					<input type="password" name="password_maintainer" id="password_maintainer" autocomplete="off" tabindex="4" value=''>
					<span class='information passwordSpan'>ACCESS TO THE ADMIN AND VOICEMAIL AREAS</span>
				</div>
				
				<div class='field password selectuser'>
					<label for="password_select">Select User Password</label>
					<input type="password" name="password_select" id="password_select" autocomplete="off" tabindex="5" value=''>
					<span class='information passwordSpan'>ADMIN PORTAL SELECT USER PASSWORD</span>
				</div>
			</div> <!-- left -->
			
			<div class="colRight">
			<span id='defaultConfig'>
			<br><strong>Default Configuration</strong><br>
			This option allows the SoftPBX to be preconfigured with a basic configuration. The number of users added is based on the Users licences being applied to the system, up to a maximum of 1000 users.<br><br>
			
			<strong>Configuration Details:</strong><br>
			<ul class='configList'>
				<li><span id='userCount'>10</span> Users</li>
				<li>10 x Departments</li>
				<li>10 x Groups</li>
				<li>2 x TimePlans</li>
				<li>1 x LCRPlan</li>
				<li>Standard & Voicemail DialPlans</li>
				<li>Single Level AutoAttendant</li>
				<li>Select Admin Portal User</li>
			</ul></span>
			
			<br>
			<span id='nolicenceConfig' style='display:none'>
				<br><strong>No Licences Default Configuration</strong><br><br>
				No system licences have been downloaded.
				<br><br>A default configuration will be created applying the System Name, Supplier Name and the System Passwords provided.<br><br>
			</span>
			
			<div class='field defaultConfig'>
				<label>Create Default Configuration</label>
				<div class='checkbox'><label for="default_config">&nbsp;<div class="switch"><input type="checkbox" name='default_config' id='default_config' value="1" checked  tabindex="6"/><div class="slider"></div></div></label></div>
				<span class='information'>CREATE AND CONFIGURE DEFAULT CONFIGURATION</span>
			</div>	
			
			<div class='field system wide'>
				<label for="extensions">Starting Extension Numbers</label>
				<input class="headerFields smallFields" type="text" value="Users" tabindex="-1" />
				<input class="headerFields smallFields" type="text" value="Departments"  tabindex="-1" />
				<input class="smallFields" type="text" name="base_user_extn" id="base_user_extn" size="30" autocomplete="off" value='2001' tabindex="6"/>
				<input class="smallFields" type="text" name="base_dept_extn" id="base_dept_extn" size="30" autocomplete="off" value='8001' tabindex="7"/>
				<span class='information'>STARTING EXTENSION NUMBERS</span>
			</div>
			
			<div class='field system wide'>
				<label for="recording">Recording Department Extension Numbers</label>
				<input class="headerFields smallFields" type="text" value="InboundRecordings" tabindex="-1" />
				<input class="headerFields smallFields" type="text" value="OutboundRecordings" tabindex="-1" />
				<input class="smallFields" type="text" name="inboundrecording" id="inboundrecording" size="30" autocomplete="off" value='9000' tabindex="8"/>
				<input class="smallFields" type="text" name="outboundrecording" id="outboundrecording" size="30" autocomplete="off" value='9500' tabindex="9"/>
				<span class='information'>RECORDING DEPARTMENT EXTENSION NUMBERS</span>
			</div>
			</div> <!-- right -->

        </div>                      
  		
		</div>
  		
<!-- End SmartWizard Content -->  	
		<input type='hidden' name='ipaddress' value='<?php echo $ip ?>' />
		<input type='hidden' name='dnsPrimary' value='<?php echo $dnsPrimary ?>' />
  		</form>
</td></tr>
</table>  

</div>
	
</div>	

<!--content ends -->


<!--footer begins -->
<?php
	require('../admin/assets/inc/footer.php');
	ldap_close($ds);
?>
<!-- footer ends-->
</div>

</div>
</body>
</html>


<?php
function GetServerStatus($site, $port) {
$status = array("OFFLINE", "ONLINE");
$fp = @fsockopen($site, $port, $errno, $errstr, 2);
if (!$fp) {
    return $status[0];
} else  { 
     return $status[1];}
}

  function cidr2NetmaskAddr ($cidr) {

    $ta = substr ($cidr, strpos ($cidr, '/') + 1) * 1;
    $netmask = str_split (str_pad (str_pad ('', $ta, '1'), 32, '0'), 8);

    foreach ($netmask as &$element)
      $element = bindec ($element);

    return join ('.', $netmask);

  }

   function createNetmaskAddr ($bitcount) {

    $netmask = str_split (str_pad (str_pad ('', $bitcount, '1'), 32, '0'), 8);

    foreach ($netmask as &$element)
      $element = bindec ($element);

    return join ('.', $netmask);

  }
?>
