<!DOCTYPE html>
<html>
<head>
	<title>Yealink Firmware</title>
</head>
<body>
Yealink firmware is hosted by SpliceCom but may also be hosted on the local platform.<br>
1) Press "Refresh Cloud Index" to update the list of available firmware<br>
2) Press "Disable Cloud Index" to prevent phones using the remote store<br>
3) Press "Enable Local Files" to download the firmware to the local platform<br>
4) Press "Disable Local Files" to prevent phones using the local store<br>
<br>
<form action="YealinkFW.php" method="post" enctype="multipart/form-data">
	<input type="submit" value="Refresh Cloud Index" name="refreshcloud">
	<input type="submit" value="Enable Local Files" name="refreshlocal">
	<br><br>
	<input type="submit" value="Disable Cloud Index" name="disablecloud">
	<input type="submit" value="Disable Local Files" name="disablelocal">
</form>
<br>
<?php
header('Cache-Control: no-cache');

	$localIndex = "index.txt";
	$cloudIndex = "webIndex.txt";
	$cloudurl = "http://max.splicecom.com/Yealink/firmware/";

	if (isset($_POST["refreshcloud"]))
	{
		//download web index
		if (($index=file_get_contents($cloudurl.$cloudIndex))!==FALSE)
		{
			if (file_exists($cloudIndex))
				rename($cloudIndex, $cloudIndex.".old");
			file_put_contents($cloudIndex, $index);
		}
	}
	else if (isset($_POST["refreshlocal"]))
	{
		//download web index
		if (($index=file_get_contents($cloudurl.$cloudIndex))!==FALSE)
		{
			if (file_exists($localIndex))
				rename($localIndex, $localIndex.".old");
			$newindex="";
			$lastGoodDownload="";
			$lines=str_getcsv($index, "\n");
			foreach ($lines as $line)
			{
				$data = str_getcsv($line);
				if (count($data) > 1 && strncmp(ltrim($data[0]),"#",1)!=0)
				{
					if (strcmp($data[1],$lastGoodDownload)==0)
					{
						//done this already
						$newindex .= "$data[0],$data[1]\n";
					}
					else
					{
						$lastGoodDownload="";
						echo "Downloading $data[1]<br>";
						ob_flush();
						flush();
						set_time_limit(300);
						if (file_put_contents($data[1], fopen($cloudurl.$data[1], "r"))!==FALSE)
						{
							$newindex .= "$data[0],$data[1]\n";
							$lastGoodDownload=$data[1];
						}
					}
				}
			}
			file_put_contents($localIndex, $newindex);
		}
	}
	else if (isset($_POST["disablecloud"]))
	{
		if (file_exists($cloudIndex))
			rename($cloudIndex, $cloudIndex.".old");
	}
	else if (isset($_POST["disablelocal"]))
	{
		if (file_exists($localIndex))
			rename($localIndex, $localIndex.".old");
	}

	if (file_exists($cloudIndex) && (($file=fopen($cloudIndex, "r"))!==FALSE))
	{
		echo '<br>Cloud index contains:<br>';
		echo '<table border="1">';
		while (($data = fgetcsv($file, 500, ",")) !== FALSE)
		{
			if (count($data) > 1 && strncmp(ltrim($data[0]),"#",1)!=0)
			{
				echo "<tr><td>$data[0]</td><td>$data[1]</td></tr>";
			}
		}
		echo '</table><br>';
		fclose($file);
	}
	if (file_exists($localIndex) && (($file=fopen($localIndex, "r"))!==FALSE))
	{
		echo '<br>Local index contains:<br>';
		echo '<table border="1">';
		while (($data = fgetcsv($file, 500, ",")) !== FALSE)
		{
			if (count($data) > 1 && strncmp(ltrim($data[0]),"#",1)!=0)
			{
				echo "<tr><td>$data[0]</td><td>$data[1]</td></tr>";
			}
		}
		echo '</table>';
		fclose($file);
	}
?>
</body>
</html>

