<?php
require('tzone.php');

$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
	}
}

$adminUser = $_SERVER['PHP_AUTH_USER'];
$sr = ldap_read($ds,"cn=$adminUser,cn=System","objectclass=Administrator"); $info = ldap_get_entries($ds,$sr); $adminCompany = $info[0]['company'][0];
$adminCompany = ($adminCompany === '00000000-0000-0000-0000-000000000000') ? '00000000-0000-0000-0000-000000000000' : $adminCompany;

function audit ($timestamp, $msg, $values) {
	$logFile = "/SpliceCom/logs/portalLogs/portalAudit.log";
	$ipAddress = $_SERVER['REMOTE_ADDR'];
	$endUser = $_SERVER['PHP_AUTH_USER'];
	$data = '';
	
	$fh = fopen($logFile, 'a+') or die("can't open file");
	fwrite($fh, "$timestamp, $ipAddress, $endUser, $msg\n");
	
	if ( is_array($values) ) {
		foreach ( $values as $key => $value ) {
			
			if (isGUID($value)) $value = ldapLookup($value);	
			$data .= "$key=$value,";
		}
	} else {
		
		if (isGUID($values)) $values = ldapLookup($values);	
		$data .= "$values";
	}
	$data = rtrim($data, ',');
	fwrite($fh, "$timestamp, $data\n");
	
	fclose($fh);
}

function isGUID($guid) {
	$res = (preg_match("/^[a-f\d]{8}(-[a-f\d]{4}){4}[a-f\d]{8}$/i", $guid)) ? true : false;
	return $res;
}

function ldapLookup ($entry) {
	global $ds;
	if ($entry == '00000000-0000-0000-0000-000000000000') return;
	$sr = ldap_read($ds,"guid=$entry","(objectclass=*)", array('cn'));
	$info = ldap_get_entries($ds,$sr);
	return $info[0]['cn'][0];

}

?>