$(document).ready(function() {
	
	var emptyRow = "<tr id='empty'><td colspan='3' align='center'>DDI Entry results are shown as you search</td></tr>";
	$('#header').last().after(emptyRow);


	// highlight table entries //
	$('#ddiResults').on( 'click', 'tr', function () {
		thisName = $(this).prop('id');
		if (thisName == 'empty') return false;
		
        if ( $(this).hasClass('selected') ) {
            $(this).removeClass('selected');
        }
        else {
            $('tr.selected').removeClass('selected');
            $(this).addClass('selected');
			selectedDdiGuid = $('#ddiResults tr.selected').attr('id');
			selectedDdiOrderId = $('#ddiResults tr.selected').find('td:first').text();
			selectedDdiNumberMatch = $('#ddiResults tr.selected').find('td:nth-child(1)').text();
			currentDDIPlan = $('#ddiplan').val();
        }
    });
	
	
	// search DDI entries //
	$('body').on('keyup', '#text_content', function(){
		$('table#ddiResults tr#empty').remove();

		var search = $(this).val();
		if (search.length <=0) {
			$('#header').last().after(emptyRow);
		}
		
		ddiplan = $("#ddiplan option:selected").text();
		company = ($("#company option:selected").text().length >0) ? $("#company option:selected").val() : $("#company").val();
				
		$.ajax({ type: "GET",   
		url: "ddiActions.php?mode=search&search=" + escape(search) + "&ddiplan=" + encodeURIComponent(ddiplan) + "&company=" + encodeURIComponent(company),   
		async: true,
        success : function(text) {
            response = text;
			$('#output_div').html(response)
			var rowCount = $('#ddiResults tr').not('#empty').length - 3; 
			$('#result_count').text(rowCount);
			}
		});	
	});	
	
	
	// submit select DDI form //
	$('#ddiplan').on('change', function() {
		$('#frm1').submit();
	});
		
		
	$('body').on('change', '#company', function(){
		$('#output_div').html('');
		if ($('#empty').length  < 1) $('#header').last().after(emptyRow);
		$('#result_count').text('0');
		$('#text_content').val('');
		
	})
	
	// add new range //
	$("#btn_range").click(function() {
		currentDDIPlan = $('#ddiplan').val();
		selectedDdiOrderId = selectedDdiGuid = selectedDdiNumberMatch = closeDdi = '';
		$('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
			loadUrl: 'ddiRangeForm.php?ddiplan=' + encodeURIComponent(currentDDIPlan),
			loadCallback: function(){ 	    
				originalFormData = $('#new_ddi').serialize();
			}
		}); 
	});
	
	
	// add new DDI //
	$("#btn_add").click(function() {
		currentDDIPlan = $('#ddiplan').val();
		selectedDdiOrderId = selectedDdiGuid = selectedDdiNumberMatch = closeDdi = '';
		$('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
			loadUrl: 'ddiForm.php?ddiMode=addDdi',
			loadCallback: function(){ 	    
				originalFormData = $('#new_ddi').serialize();
			}
		}); 
	});
	
	
	// delete selected ddi //
	$("#btn_delete").click(function() {
		var timestamp = Math.floor(Date.now() / 1000); 
		if (typeof selectedDdiGuid != "undefined" && selectedDdiGuid.length > 3)
		var n = noty({
        type: 'warning', layout: 'center', text: 'Delete DDI Entry: <b>' + selectedDdiNumberMatch + '</b> from DDIPlan: <b>' + currentDDIPlan + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({ url : 'ddiActions.php?mode=deleteDdi&ddiGuid=' + encodeURIComponent(selectedDdiGuid) + '&ddiPlan=' + encodeURIComponent(currentDDIPlan) + '&timestamp=' + timestamp});
					$('#ddiResults tr.selected').remove()
					res_count = parseInt($('#result_count').text());
					--res_count;
					$('#result_count').text(res_count);
					selectedDdiOrderId = selectedDdiGuid = selectedDdiNumberMatch = closeDdi = '';
					$noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });	
	});

	
	// edit selected ddi //
	$("#btn_edit").click(function(e) {
		closeDdi = $('#ddiResults tr.selected').find('td:first').text();
		if (typeof selectedDdiGuid == "undefined" || selectedDdiGuid.length < 1 ) return false;
		var timestamp = Math.floor(Date.now() / 1000); 
		
		$.ajaxSetup({ cache: false });					
		
        $('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
            loadUrl: 'ddiForm.php?ddiMode=editDdi&ddiGuid=' + encodeURIComponent(selectedDdiGuid) + '&ddiPlan=' + encodeURIComponent(currentDDIPlan) + '&ddiNumberMatch=' + encodeURIComponent(selectedDdiNumberMatch) + '&timestamp=' + timestamp,
			loadCallback: function(){ 	    
				originalFormData = $('#new_ddi').serialize();
			}
        });
	});
	
	
	
	// close DDI //
	$("body").on('click', '#close', function() {
		var type = ($('#bulkrange').val() === '1') ? 'Range' : 'Entry';
		var msg = (originalFormData !== $('#new_ddi').serialize()) ? '<b>Changes haven\'t been saved.</b><br>' : ''
		var n = noty({
        type: 'warning', layout: 'center', text: msg + 'Close DDI ' + type + ' : <b>' + closeDdi + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
					parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });
	});
	
	// save range //
	$("body").on('click', '#saverange', function(){
		var basenumber = $('#basenumber').val();
		var baseextn = $('#baseextn').val();
		var number = $('#number').val();

		if (basenumber.length < 1 || baseextn.length < 1 || number.length < 1) {
			var n = noty({ type: 'error', layout: 'center', text: 'The following range values must be set.<br><br>Incoming Base Number, Base of Internal Extension,<br>Number of DDIs to be created and TimePlan.<br><br><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
			return false;
		}
		
		var numbermatch = +basenumber + +number-1;
		var translateto = +baseextn + +number-1;
		
		var n = noty({
        type: 'warning', layout: 'center', text: 'Create DDI Range ?<br><br><b>Number Match:</b> ' + basenumber + ' - ' + numbermatch + '<br><b>Routing To:</b> ' + baseextn + ' - ' + translateto, dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				var formData = $('#new_ddi').serializeArray();
				$.ajax({ type: "GET",   
					url: "ddiActions.php?mode=range",   
					type: "POST",  cache: false, data: formData,
					success : function(data) {
						console.log(data)
					}
				});
				$noty.close(); 
				var n = noty({ type: 'warning', layout: 'center', text: 'DDI Range has been applied<br><br><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout: 1500 })
				parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });
	
	})
	
	// save updates //
	$("body").on('click', '#save', function(){
	var saveDDI = $('#numbermatch').val();
	var saveTrans = $('#translateto').val();
	var saveTimePlan = $('#timeplan').val();
	var match = $("#match").prop("checked") ? '1' : '0';
	
	if (match === '1') {
		var transName = $('#translateto option:selected').text();
		var newName = transName.replace("(" + saveTrans + ")","").trim();
		saveTrans = newName;
	}

	// check if numbermatch is set
	if (saveDDI < 1) {
		var n = noty({ type: 'error', layout: 'center', text: 'DDI Entry Number Match is blank.<br>Please ensure this is correct before saving.<br><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
	}
	
	// check if translateto is set
	if (saveTrans < 1) {
		var n = noty({ type: 'error', layout: 'center', text: 'Translate To value must be set<br><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
		return false;
	}
	

	// check for identical match, then submit
	$.ajax({
		type: "POST", cache: false,
		url: "ddiActions.php?mode=checkEntry&ddiPlan=" + encodeURIComponent(currentDDIPlan) + '&saveDDI=' + encodeURIComponent(saveDDI) + '&saveTrans=' + encodeURIComponent(saveTrans) + '&saveTimePlan=' + encodeURIComponent(saveTimePlan), 	
		success: function(data) {
		if (data >= '1' && selectedDdiGuid.length < 1){
			var n = noty({ type: 'error', layout: 'center', text: 'DDIPlan contains exact entry match<br><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
			return false;
		} else {
				
		// save entry 
		var n = noty({
        type: 'information', layout: 'center', text: 'Save DDIPlan Number Match: <b>' + saveDDI + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				var timestamp = Math.floor(Date.now() / 1000); 
				var ddiMode = $('#ddiMode').attr('value');
				var formData = $('#new_ddi').serializeArray();
			    $.each(formData, function(key, data) {
				if (this.name == "translateto") 
					this.value= saveTrans;
				});

				console.log (formData);
				$.ajax({
					type: "POST",  cache: false, data: formData,
					url: "ddiActions.php?mode=saveDdi&ddiPlan=" + encodeURIComponent(currentDDIPlan) + '&currentDDIGuid=' + encodeURIComponent(selectedDdiGuid) + '&timestamp=' + timestamp, 	
					success: function(data) {
						res = data.split(",");
						var ddiMode = res[0];
						guid = (ddiMode == 'editDdi') ? selectedDdiGuid : res[1];
						var numbermatch = res[2];  var translateto = res[3];  var description = res[4];
						var ret = ddiMode + ',' + guid + ',' + numbermatch + ',' + translateto + ',' + description;
						parent.UpdateCode(ret);
				}
				});

				parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
				$noty.close();
				return false; 
			}
            },
			{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); }
			}
            ]
        });
		// save entry 
		}
		}
	});
	// check before submit
	});
	
	// Number Match Check //
	$('body').on('keyup', '#new_ddi input[name=numbermatch]', function(){
		var numbermatch = $(this).val(); 
		var response = '';
		$.ajax({ type: "GET",   
         url: "ddiActions.php?mode=numberMatch&numbermatch=" + encodeURIComponent(numbermatch) + '&currentDDIPlan=' + encodeURIComponent(currentDDIPlan),   
         async: true,
         success : function(text) {
             response = text;
			if (response >= 1) {
				$('#msg').html('Please Note: Number match already exits. Entry will still be added.'); 
				$("#msg_wrap").css({ 'border': '2pt solid #2626ff', 'color': '#2626ff'});
			} else {
				$('#msg').html(''); 
				$("#msg_wrap").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
			}
         }
		});
	});
	
	// TranslateTo Select //
	$("body").on('change', '#translatetoselect', function() {
		var selected = $(this).val();
		var currentCompany = $('#ddiCompany').val();
		
		if (selected === 'users' || selected === 'departments'){
			$('#translateSelector').css('height','60px');
			$('#transMatch').show();
		} else {
			$('#translateSelector').css('height','38px');
			$('#match').prop('checked',false);
			$('#transMatch').hide();
			
		}
		
		if (selected === 'autoattendant'){
			$('#translateto').replaceWith('<input name="translateto" id="translateto" class="smallFields" value="Auto Attendant" readonly>');
			return false;
			
		} else if (selected === 'other') {
			$('#translateto').replaceWith('<input name="translateto" id="translateto" class="smallFields" value="" >');
			return false;
			
		} else {
			$('#translateto').replaceWith("<select id='translateto' name='translateto'><option></option></select>");
			$.ajax({
				type: "POST", cache: false,
				url: "ddiActions.php?mode=translateto&selected=" + encodeURIComponent(selected) + '&currentCompany=' + encodeURIComponent(currentCompany), 	
				success: function(data) {
					var $el = $("#translateto"); $el.empty();
					var values = data.split(',');
					if (selected == 'conference') {
						$el.append($("<option></option>").attr("value", 'Join').text('Join') );						
					} else {
						$el.append($("<option></option>").attr("value", '').text('') );
					}
					

					$.each(values, function(key, value) {
						var select = value.split(':')
						$el.append($("<option></option>").attr("value", select[0]).text(select[1]) );
					});
				}
			});
		}
	});
	
	
	$("body").on('change', '#translateto', function(){
		$('#translatespan').removeClass('unknown').addClass('information').html('TRANSLATE DDI ENTRY TO');
	})

	
	$("body").on('click', '#contactlookup', function(){
		if ($(this).is(":checked")) {
			$('#contactlookupname').css('display', 'inline');
		} else {
			$('#contactlookupname').css('display', 'none');
		}
	});
	
	// numeric values only
	$('body').on('blur', '#new_ddi input[name=id]', function(){
		thisVal = ( $(this).val() )
		if(!$.isNumeric(thisVal)) {
			$('#msg').html('Numeric Value Only'); 
			$("#msg_wrap").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			$(this).css({ 'border': '2pt solid #D00', 'color': '#D00'});
			$("#save").prop("disabled",true);
		} else {
			$('#msg').html(''); 
			$("#msg_wrap").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
			$(this).css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
			$("#save").prop("disabled",false);
		}				
	});
	
	
	
	
});

	// save and/or edit return values to update table
	function UpdateCode(ret) {  
		var ret = ret.split(',');
		var ddiMode = ret[0];
		var guid = ret[1]; 
		var numbermatch = ret[2]; 
		var translateto = ret[3];
		var description = ret[4];
		
        var new_row = '<tr id=' + guid + '><td>' + numbermatch + '</td><td>' + translateto + '</td><td>' + description + '</td></tr>';
		$('#ddiResults tr').removeClass("selected");
	
	if (ddiMode == 'editDdi') {
		$('#' + guid).replaceWith(new_row);
	
	} else if (ddiMode == 'addDdi') {
		$('table tbody').append(new_row);
		res_count = parseInt($('#result_count').text());
		++res_count;
		$('#result_count').text(res_count);
		}
		
		selectedDdiGuid = guid;
	}
	
	function drReadOnly() {
		$('input[type=checkbox], select').prop('disabled','true');
		$("input:not('#close')").prop('disabled', true);
	}
