<?php 

$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
	}
}

$mode = $argv[1];
$company = $argv[2];

//export &/or delete contacts
if ($mode === 'deleteContacts' || $mode === 'exportContacts') {
	$query =  ($company === "00000000-0000-0000-0000-000000000000") ? "cn=contacts" : "cn=contacts, guid=$company, cn=companies";
	
	$fields = array ('cn' => 'name','o' => 'company','telephonenumber' => 'phone','facsimiletelephonenumber' => 'fax','mobiletelephonenumber' => 'mobile','hometelephonenumber' => 'home','spare1telephonenumber' => 'spare1','spare2telephonenumber' => 'spare2','ambiguoustelephonenumber' => 'ambiguous' ,'mail' => 'mail','givenname'=>'firstname','sn' => 'lastname','description' => 'description','ou' => 'department','title' => 'job','street' => 'street','l' => 'city','st' => 'county','postalcode' => 'postcode','c' => 'country','ouraccount'=>'ouraccount','theiraccount' => 'theiraccount','url' => 'url','autourl' => 'autourl','directrouteto' =>'directrouteto','priorityboost'=>'priorityboost','exdirectory'=>'exdirectory');
	
	$file = "/SpliceCom/ftp/contacts.out.txt";
	if ($company != "00000000-0000-0000-0000-000000000000") {
		$sr = ldap_list($ds,"cn=companies","(&(objectclass=company)(guid=$company))",array('cn')); 
		$info = ldap_get_entries($ds,$sr);	$companyName = $info[0]['cn'][0];
		$file = "/SpliceCom/ftp/contacts.out.$companyName.txt";
	} 
		
	$list = array();
	$result = ldap_search($ds, $query, "(cn=*)", array('cn'), 0, 0);
	$entry = ldap_first_entry($ds, $result);
	if ($entry) {
		do {
			$list[] = ldap_get_dn($ds, $entry);
		} while ($entry = ldap_next_entry($ds, $entry)); 
	}

	$fp = fopen ($file, "w");
	if ($fp) {

	$titles = implode(",",$fields)."\n";
	fputs($fp,$titles);
	$n = 0;

	foreach ($list as $listKey => $listValue) {
		$sr=ldap_read($ds,$listValue,"objectclass=contact");
		$info=ldap_get_entries($ds,$sr); 
		for($n=0; $n<$info['count'];$n++) {  
			$contact = '"';
			foreach ($fields as $key => $value) {
				$row = $info[$n][$key][0];
				$contact = $contact.$row.'","';
			}
			$contact = $contact.'\n';
			$contact = str_replace(',"\n','',$contact);
			fputs($fp, "$contact\n");
			$cn = $info[$n]['cn'][0];
			echo "$cn EXPORTED<br>";
			@ob_flush();
			@flush();

			
			if ($mode === 'deleteContacts')	{
				ldap_delete($ds, $listValue);
				echo "$cn DELETED<br>";
			}
		}
	}
	echo "<br>Done...<br>";
	fclose($fp);
	}
}

//upload file
if ($mode === 'uploadFile') {
	$company = $_REQUEST['company'];
	$uploadFile = "contacts.txt";

if ($company != "00000000-0000-0000-0000-000000000000") {
	$sr = ldap_list($ds,"cn=companies","(&(objectclass=company)(guid=$company))",array('cn')); 
	$info = ldap_get_entries($ds,$sr);	$companyName = $info[0]['cn'][0];
	$uploadFile = "contacts.$companyName.txt";
} 


	$result = 0;
	$filePath = '/SpliceCom/ftp/';
	$tmp_file = $_FILES['myfile']['tmp_name'];
	$filename = $uploadFile;
	
	$target_path = $filePath . $filename;
	$result = move_uploaded_file($tmp_file, $target_path);
	
    echo "<script language='javascript' type='text/javascript'>window.top.window.stopUpload(\"$result\",\"$filename\")</script>";
}

//import contacts
if ($mode === 'importContacts') {
	$query =  ($company === "00000000-0000-0000-0000-000000000000") ? "cn=contacts" : "cn=contacts, guid=$company, cn=companies";
	
	$file = "/SpliceCom/ftp/contacts.txt";
	if ($company != "00000000-0000-0000-0000-000000000000") {
		$sr = ldap_list($ds,"cn=companies","(&(objectclass=company)(guid=$company))",array('cn')); 
		$info = ldap_get_entries($ds,$sr);	$companyName = $info[0]['cn'][0];
		$file = "/SpliceCom/ftp/contacts.$companyName.txt";
	} 
	
	if ($file) { 
    $handle = fopen($file,"r"); 
    $n=1;
	
    do {  $n++;
        if (@$data[0]) { 
		
		$cn = $data[0];	
		if ($cn === 'name') continue;
		
		$cn = str_replace('"','',$cn);
		if (strlen($cn) < 1 && strlen($data[1]) >=1) $cn = $data[1];
		
		if (isset($cn) && strlen($cn) > 0) {
			$check = str_replace("(","\(",$cn); 
			$check = str_replace(")","\)",$check);
			
			$count = array();
			$result = @ldap_search($ds, $query, "(cn=$check*)", array('cn'), 0, 0);
			$entry = @ldap_first_entry($ds, $result);
			if ($entry) {
				do {
					$count[] = @ldap_get_dn($ds, $entry);
				} while ($entry = @ldap_next_entry($ds, $entry)); 
			}
			$res = count($count);
			if ( $res >= 1 ) {
				$cn = $cn."(".$res.")";
			}
		}
		
		$contact = array (
        'objectclass' => 'Contact',
        'o' => $data[1],
        'cn' => $cn,
        'facsimiletelephonenumber' => ref_number($data[3]),
        'mobiletelephonenumber' => ref_number($data[4]),
        'hometelephonenumber' => ref_number($data[5]),
        'spare1telephonenumber' => ref_number($data[6]),
        'spare2telephonenumber' => ref_number($data[7]),
        'ambiguoustelephonenumber' => ref_number($data[8]),
        'mail' => $data[9],
        'givenname'=> $data[10],
        'sn' => $data[11],
        'description' => $data[12],
        'ou' => $data[13],
        'title' => $data[14],
        'street' => $data[15],
        'l' => $data[16],
        'st' => $data[17],
        'postalcode' => $data[18],
        'c' => $data[19],
        'ouraccount'=>$data[20],
        'theiraccount' => $data[21],
        'url' => $data[22],
        'autourl' => $data[23],
        'directrouteto' => $data[24]
		);
            
		$dn = "telephonenumber=".ref_number($data[2]).", $query";
		
		@ob_flush();
		@flush();  
		echo "$cn ADDED<br>";
		@ob_flush();
		@flush();
		
		ldap_add($ds,"$dn",$contact); 
        } 
    } while ($data = fgetcsv($handle,1000,",","'")); 
    	echo "<br>Done...<br>";
	}
}


function ref_number($number) {
	$number = "zczc".str_replace(" ","",$number);
	$number = str_replace("+44(0","0",$number);
	$number = str_replace("0044(0","0",$number);
	$number = str_replace("44(0","0",$number);
	$number = str_replace("44(","0",$number);
	$number = str_replace("+","00",$number);
	$number = str_replace("zczc0044","zczc0",$number);
	$number = str_replace("(0)","",$number);
	$number = str_replace("(","",$number);
	$number = str_replace(")","",$number);
	$number = str_replace("-","",$number);
	$number = str_replace("zczc","",$number);
	return($number);
}
?>

