<?php
header('Content-type: text/html; charset=UTF-8') ;
require('../assets/inc/ldapConnect.php');
?>
<html>
<head>
<title>Voicemail Port Licences</title>
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />
<link href="../assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="licences.css" rel="stylesheet" type="text/css" media="screen" />
<script type="text/javascript">
	var state = {};
	var title = 'Voicemail Port';
	var url   = '/manager/admin/licencestatus/';
	history.pushState(state, title, url);
</script>
</head>
<body>
<div id="wrapper" class='popup'>    
<h2>Voicemail Port Licences</h2>
<?php
	
	$port_count = $licence_count = $callserver = 0;
	$modules_cn = array('1'=>'CallServer 4100', '10'=>'Remote CallServer 4140','11'=>'CallServer 5100','12'=>'CallServer 5108','17'=>'SoftPBX','18'=>'SoftPBX','19'=>'Network Service Gateway');
	$modules_ports = array('1'=>'8','10'=>'4','11'=>'4','12'=>'2','17'=>'0','18'=>'0','19'=>'2');
	
	$SV1000001 = array('VoicemailPort'=>'240');
	$SV1000SC = array('VoicemailPort'=>'30');
	$SV1000MAP = array('VoicemailPort'=>'90');
	$SV1000MAPS = array('VoicemailPort'=>'15');
	$SV1000VMAP = array('VoicemailPort'=>'90');
	$SV1000NSG = array('VoicemailPort'=>'90');
	$SV1000OFF01 = array('VoicemailPort'=>'90');
	$SV1000020 = array('VoicemailPort'=>'15');
	
	$sr=ldap_read($ds,"cn=Self,cn=Modules","objectclass=*");
	$info=ldap_get_entries($ds,$sr); $self = $info[0]['location'][0];	
	
	$sr=ldap_search($ds,"guid=$self, cn=Modules", "(objectclass=administrationmodule)", array('modulelicenseguid'));
	$info=ldap_get_entries($ds,$sr); $SVLicenceGuid = $info[0]['modulelicenseguid'][0];
	
	$sr=ldap_search($ds,"cn=System","(&(objectclass=license)(guid=$SVLicenceGuid))", array('license'));
	$info=ldap_get_entries($ds,$sr); $SVLicence = $info[0]['license'][0];

	$SVType = str_replace('-','', $SVLicence);
	
	$SVvoicemailPortCapacity = (strpos($SVType, 'SV1000') !== false) ? ${$SVType}['VoicemailPort'] : '0';

	$sr = ldap_list($ds,"cn=modules","(&(objectclass=module)(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19)))",array('status','cn','guid','moduletype'));
		$info = ldap_get_entries($ds, $sr);  
		
	echo "<table border ='1' style='border-collapse: collapse; width: 450px'>";
	echo "<thead><th>Name</th><th>Module</th><th>VM Ports</th></thead>";
	
		for ($m=0; $m<$info['count']; $m++) {
			$module_ports = $modules_ports[$info[$m]['moduletype'][0]];
			$module_type = $modules_cn[$info[$m]['moduletype'][0]];
			$module_cn = $info[$m]['cn'][0];
			$port_count += $module_ports;
			echo "<tr class='licencetr'><td>$module_cn</td><td><i>$module_type</i></td><td>$module_ports</td></tr>";
		}
	
	echo "<tr><td colspan='2'>Total Voicemail Ports:</td><td><b>$port_count</b></td></tr>";
	echo "<tr><td colspan='3'>&nbsp;</td></tr>";
	
	
	$sr = ldap_list($ds,"cn=system","(&(objectclass=license)(license=voicemailport))",array('key','valid','license','qty'));
	$info = ldap_get_entries($ds, $sr);  

	echo "<thead><th colspan='2'>Licence</th><th>Quantity</th></thead>";
	
	
		for ($m=0; $m<$info['count']; $m++) {
			$licence = $info[$m]['license'][0];
			$quantity = $info[$m]['qty'][0];
   		    $licence_count += $quantity;
			echo "<tr class='licencetr'><td colspan='2'>$licence</td><td>$quantity</td></tr>";
		}

	if (strpos($SVLicence, 'SV1000') !== false) {
		echo "<tr class='licencetr'><td colspan='2'>$SVLicence</td><td>$SVvoicemailPortCapacity</td></tr>";	
	    $licence_count += $SVvoicemailPortCapacity;
	} 
	
	$total =  $licence_count + $port_count;		
	echo "<tr><td colspan='2'>Total:</td><td><b>$licence_count</b></td></tr>";
	echo "<tr><td colspan='3'>&nbsp;</td></tr>";
	echo "<tr><td colspan='2'>Total Licences:</td><td><b>$total</b></td></tr>";
	echo "</table>";			
?>
</div>

</body>
</html>