<?php

$container = (isset($_REQUEST['container']) && strlen($_REQUEST['container']) >=1) ? $_REQUEST['container'] : NULL;
$timestamp = (isset($_REQUEST['timestamp']) && strlen($_REQUEST['timestamp']) >=1 ) ? $_REQUEST['timestamp'] : NULL;

if ($container) {
	$ds = ldap_connect("127.0.0.1",4000);
		if ( ! $ds) {
			echo "LDAP connect failure<br>";
		} else {
			ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
			$r = ldap_bind($ds,"INTERNAL","0123456");
			if ( ! $r) {
				echo "LDAP bind failure<br>";
				$ds = false;
		}
	}
	
} else {
	require('../assets/inc/ldapConnect.php');
}
	
	$actionMode = (isset($_REQUEST['actionMode']) && strlen($_REQUEST['actionMode']) >=1 ) ? $_REQUEST['actionMode'] : NULL;
	$selectedSystemName = (isset($_REQUEST['selectedSystemName']) && strlen($_REQUEST['selectedSystemName']) >=1 ) ? $_REQUEST['selectedSystemName'] : NULL;
	$selectedSystemGuid = (isset($_REQUEST['selectedSystemGuid']) && strlen($_REQUEST['selectedSystemGuid']) >=1 ) ? $_REQUEST['selectedSystemGuid'] : NULL;
	
	//$phoneType = array('','POTS Phone','Proactive Communication Station','Generic Phone');
	$phoneType = array('','Splicecom Analogue Port','Proactive Communication Station','Generic SIP Device');

	
if ($actionMode === 'addEndPoint') {
	
	$selectphone = (isset($_REQUEST['selectphone']) && strlen($_REQUEST['selectphone']) >=1 ) ? $_REQUEST['selectphone'] : NULL;
	$assignUserName = (isset($_REQUEST['assignUserName']) && strlen($_REQUEST['assignUserName']) >=1 ) ? $_REQUEST['assignUserName'] : '';
	
	$currenthome = (isset($_REQUEST['currenthome']) && strlen($_REQUEST['currenthome']) >=1 ) ? strtolower($_REQUEST['currenthome']) : NULL;
	$assignUserOn = (isset($_REQUEST['assignUserOn']) && strlen($_REQUEST['assignUserOn']) >=1 ) ? $_REQUEST['assignUserOn'] : NULL;
	$assignUser = (isset($_REQUEST['assignUser']) && strlen($_REQUEST['assignUser']) >=1 ) ? $_REQUEST['assignUser'] : NULL;
	
	
	if ($selectphone === '2') { //PCS
		
		$pcsMac = (isset($_REQUEST['pcsMac']) && strlen($_REQUEST['pcsMac']) >=1 ) ? "00-07-d9-".strtolower($_REQUEST['pcsMac']) : NULL;
		$pcsName = (isset($_REQUEST['pcsName']) && strlen($_REQUEST['pcsName']) >=1 ) ? $_REQUEST['pcsName'] : 'PCS 00-07-D9-'.$pcsMac;
		$pcsPlc = (isset($_REQUEST['pcsPlc']) && strlen($_REQUEST['pcsPlc']) >=1 ) ? $_REQUEST['pcsPlc'] : '1234';
		$description = (isset($_REQUEST['description']) && strlen($_REQUEST['description']) >=1 ) ? $_REQUEST['description'] : 'Proactive Communication Station';
		
	// Create Phone Object
		$att=array('objectclass'=>'Phone','typeOfPhone'=>'2','description'=>$description,'location'=>$currenthome);
		$dn = "cn=PCS $pcsMac,cn=$currenthome, cn=modules";
		ldap_add($ds, "$dn", $att);

	// Add cn=1 to phone object
		$att=array('objectclass'=>'SplicePhone','serialnumber'=>$pcsMac,'partnerlogincode'=>$pcsPlc);
		$dn = "cn=1,cn=PCS $pcsMac,cn=$currenthome, cn=modules";
		ldap_add($ds, "$dn", $att);

	//find phones GUID
	   $sr = ldap_read($ds,"cn=PCS $pcsMac, cn=$currenthome,cn=modules","objectclass=Phone"); 
	   $info = ldap_get_entries($ds,$sr);
	   $guid = $info[0]['guid'][0];
	   
	// assign to user
	if (isset($assignUserOn) && $assignUserOn === '1') {
	// find user dn and GUID
		$sr = ldap_read($ds,"cn=$assignUser, cn=users","objectclass=user"); 
		$info = ldap_get_entries($ds,$sr);
		$userDn = $info[0]['dn']; 
  		$setInitial = array('initialphone' => $guid);
		ldap_modify($ds,$userDn,$setInitial); unset($setInitial);
	}

	if (!$container) {
	   echo "add:$guid:$pcsName:$assignUserName:$selectphone:$description:::PCS";
	   audit ($timestamp, "[PCSPhone] [$actionMode] $pcsName, $description", $att);
	}
	
	} else if ($selectphone === '3') { //SIP
		$sipType = (isset($_REQUEST['sipType']) && strlen($_REQUEST['sipType']) >=1 ) ? $_REQUEST['sipType'] : NULL;
		$sipName = (isset($_REQUEST['sipName']) && strlen($_REQUEST['sipName']) >=1 ) ? strtolower($_REQUEST['sipName']) : NULL;
		$sipIPAddress = (isset($_REQUEST['sipIPAddress']) && strlen($_REQUEST['sipIPAddress']) >=1 ) ? $_REQUEST['sipIPAddress'] : NULL;
		$sipMACAddress = (isset($_REQUEST['sipMACAddress']) && strlen($_REQUEST['sipMACAddress']) >=1 ) ? strtolower($_REQUEST['sipMACAddress']) : NULL;
		$description = (isset($_REQUEST['description']) && strlen($_REQUEST['description']) >=1 ) ? $_REQUEST['description'] : 'Generic Phone';
		$siplicense = (isset($_REQUEST['siplicense']) && $_REQUEST['siplicense']  === '1' ) ? $_REQUEST['siplicense'] : NULL;
		
		$pnpvendor = (isset($_REQUEST['pnpvendor']) && strlen($_REQUEST['pnpvendor']) >=1 ) ? $_REQUEST['pnpvendor'] : NULL;
		$usestun = (isset($_REQUEST['usestun']) && $_REQUEST['usestun'] === '1' ) ? $_REQUEST['usestun'] : NULL;
		$stunaddr = (isset($_REQUEST['stunaddr']) && strlen($_REQUEST['stunaddr']) >=1 ) ? $_REQUEST['stunaddr'] : NULL;
		$stunport = (isset($_REQUEST['stunport']) && strlen($_REQUEST['stunport']) >=1 ) ? $_REQUEST['stunport'] : NULL;
		
		if (isset($_REQUEST['pnpmodel']) && strlen($_REQUEST['pnpmodel']) >=1 ) {
			 $pnpmodel = (substr($_REQUEST['pnpmodel'], 0, 1) === 'T') ? "SIP-" . $_REQUEST['pnpmodel'] : $_REQUEST['pnpmodel'];
		} else {
			$pnpmodel = NULL;
		} 
		
		
	// Create Phone Object
		$sipcn = ($sipType === '1') ? "SIP $sipName" : $sipName;
		$att=array('objectclass'=>'Phone','typeOfPhone'=>'3','description'=>$description,'location'=>$currenthome);
		$dn = "cn=$sipcn, cn=$currenthome, cn=modules";
		ldap_add($ds, "$dn", $att);

	// Add cn=1 to phone object
		$att=array('objectclass'=>'GenericIPPhone','compressionType'=>'0');
		if ($sipType === '1') {
			$att['serialNumber'] = $sipMACAddress;
			$att['pnpvendor'] = $pnpvendor;
			$att['pnpmodel'] = $pnpmodel;
			$att['usestun'] = $usestun;
			$att['stunaddr'] = $stunaddr;
			$att['stunport'] = $stunport;
			$att['siplicense'] = $siplicense;
		} else {
			$att['ipAddress'] = $sipIPAddress;
		}
		$dn = "cn=1, cn=$sipcn, cn=$currenthome, cn=modules";
		ldap_add($ds, "$dn",$att);

	//find phones GUID.
	   $sr = ldap_read($ds,"cn=$sipcn, cn=$currenthome,cn=modules","objectclass=Phone"); 
	   $info = ldap_get_entries($ds,$sr);
	   $guid = $info[0]['guid'][0];
	   
	// assign to user
	if (isset($assignUserOn) && $assignUserOn === '1') {
	// find user dn and GUID
		$sr = ldap_read($ds,"cn=$assignUser, cn=users","objectclass=user"); 
		$info = ldap_get_entries($ds,$sr);
		$userDn = $info[0]['dn']; 
  		$setInitial = array('initialphone' => $guid);
		ldap_modify($ds,$userDn,$setInitial); unset($setInitial);
	}
	
	$dontvalidateipaddress = $publicipaddress = '';
	if ($usestun === '1') {
		$sr=ldap_read($ds,"cn=Self,cn=Modules","objectclass=*"); $info=ldap_get_entries($ds,$sr); 
		$self = $info[0]['location'][0];	
		
		$sr=ldap_read($ds,"cn=1, guid=$self,cn=Modules","objectclass=*"); $info=ldap_get_entries($ds,$sr); 
		$dontvalidateipaddress = $info[0]['dontvalidateipaddress'][0];	
		$publicipaddress = $info[0]['publicipaddress'][0];	
		
		if ($dontvalidateipaddress != '1' || strlen($publicipaddress) < 7){
			ldap_modify($ds,"cn=1,guid=$self,cn=Modules",array('dontvalidateipaddress' => '1'));
			//$publicIP = (@file_get_contents("http://splicepbx.uk/ip.php")) ? @file_get_contents("http://splicepbx.uk/ip.php") : NULL;
			$publicIP = (@file_get_contents("https://api.ipify.org")) ? @file_get_contents("https://api.ipify.org") : @file_get_contents("http://ipecho.net/plain");
			if ($publicIP) {
				ldap_modify($ds,"cn=1,guid=$self,cn=Modules",array('publicipaddress' => $publicIP));
			} else {
				echo $publicipaddress = '2'; //error
			}
		}
		
	}
		
		if (isset($pnpmodel)) $pnpmodel = str_replace('SIP-', '', $pnpmodel);
        $pnpmodel = (file_exists("../assets/images/phones/$pnpmodel.jpg")) ? $pnpmodel.".jpg" : $pnpmodel;
		
		if (!$container) { 
			echo "add:$guid:$sipcn:$assignUserName:$selectphone:$description:$dontvalidateipaddress:$publicipaddress:$pnpmodel";
			audit ($timestamp, "[SIPPhone] [$actionMode] $sipcn", $att);
		}
	}
	
}


if ($actionMode === 'editEndpoint') {
	$ent = array();
	$usestun = $pnpmodel = NULL;
	
	$selectedSystemName = (isset($_REQUEST['selectedSystemName']) && strlen($_REQUEST['selectedSystemName']) >=1 ) ? $_REQUEST['selectedSystemName'] : NULL;
	$selectedType = (isset($_REQUEST['selectedType']) && strlen($_REQUEST['selectedType']) >=1 ) ? $_REQUEST['selectedType'] : NULL;
	$selectedGuid = (isset($_REQUEST['selectedGuid']) && strlen($_REQUEST['selectedGuid']) >=1 ) ? $_REQUEST['selectedGuid'] : NULL;
	$selectedName = (isset($_REQUEST['selectedName']) && strlen($_REQUEST['selectedName']) >=1 ) ? $_REQUEST['selectedName'] : NULL;
	$sipType = (isset($_REQUEST['sipType']) && strlen($_REQUEST['sipType']) >=1 ) ? $_REQUEST['sipType'] : NULL;
	
	$cn = (isset($_REQUEST['phoneName']) && strlen($_REQUEST['phoneName']) >=1 ) ? $_REQUEST['phoneName'] : NULL;
	$description = (isset($_REQUEST['description']) && strlen($_REQUEST['description']) >=1 ) ? $_REQUEST['description'] : NULL;
	
	error_log ("C: $cn S: $selectedName");

	if ($selectedType === '2') {// PCS
	$serialnumber = (isset($_REQUEST['pcsSerial']) && strlen($_REQUEST['pcsSerial']) >=1 ) ? $_REQUEST['pcsSerial'] : NULL;
	$partnerlogincode = (isset($_REQUEST['pcsPlc']) && strlen($_REQUEST['pcsPlc']) >=1 ) ? $_REQUEST['pcsPlc'] : NULL;
	$update = (isset($_REQUEST['pcsUpgrade']) && strlen($_REQUEST['pcsUpgrade']) >=1 ) ? $_REQUEST['pcsUpgrade'] : NULL;
	$remotepstn = (isset($_REQUEST['pcsExtnAnyWhere']) && strlen($_REQUEST['pcsExtnAnyWhere']) >=1 ) ? $_REQUEST['pcsExtnAnyWhere'] : NULL;
	
	$update = str_replace(' : ','',trim($update));
	
	$att['serialnumber'] = $serialnumber;
	$att['partnerlogincode'] = $partnerlogincode;
	$att['update'] = $update;
	$att['remotepstn'] = $remotepstn;
	
	} else if ($selectedType === '3') { // Generic
	$sipMACAddress = (isset($_REQUEST['sipMACAddress']) && strlen($_REQUEST['sipMACAddress']) >=1 ) ? strtolower($_REQUEST['sipMACAddress']) : NULL;
	
	$phoneIPAddress = (isset($_REQUEST['phoneIPAddress']) && strlen($_REQUEST['phoneIPAddress']) >=1 ) ? $_REQUEST['phoneIPAddress'] : NULL;
	$pnpmodel = (isset($_REQUEST['pnpmodel']) && strlen($_REQUEST['pnpmodel']) >=1 ) ? $_REQUEST['pnpmodel'] : NULL;
	$pnpvendor = (isset($_REQUEST['pnpvendor']) && strlen($_REQUEST['pnpvendor']) >=1 ) ? $_REQUEST['pnpvendor'] : NULL;
	$usestun = (isset($_REQUEST['usestun']) && $_REQUEST['usestun'] === '1' ) ? $_REQUEST['usestun'] : NULL;
	$stunaddr = (isset($_REQUEST['stunaddr']) && strlen($_REQUEST['stunaddr']) >=1 ) ? $_REQUEST['stunaddr'] : NULL;
	$stunport = (isset($_REQUEST['stunport']) && strlen($_REQUEST['stunport']) >=1 ) ? $_REQUEST['stunport'] : NULL;
	$siplicense = (isset($_REQUEST['siplicense']) && $_REQUEST['siplicense'] === '1' ) ? $_REQUEST['siplicense'] : NULL;
	
	$att['serialnumber'] = $sipMACAddress;
	$att['ipaddress'] = $phoneIPAddress;
	$att['pnpmodel'] = $pnpmodel;
	$att['pnpvendor'] = $pnpvendor;
	$att['usestun'] = $usestun;
	$att['stunaddr'] = $stunaddr;
	$att['stunport'] = $stunport;
	$att['siplicense'] = $siplicense;
	
	
	} else if ($selectedType === '1') { // POTS
	$potCallerDisplayType = (isset($_REQUEST['potCallerDisplayType']) && strlen($_REQUEST['potCallerDisplayType']) >=1 ) ? $_REQUEST['potCallerDisplayType'] : NULL;
	$potCallerDisplayLength = (isset($_REQUEST['potCallerDisplayLength']) && strlen($_REQUEST['potCallerDisplayLength']) >=1 ) ? $_REQUEST['potCallerDisplayLength'] : NULL;
	$partnerlogincode = (isset($_REQUEST['potPlc']) && strlen($_REQUEST['potPlc']) >=1 ) ? $_REQUEST['potPlc'] : NULL;
	$potsDTMF = (isset($_REQUEST['potsDTMF']) && strlen($_REQUEST['potsDTMF']) >=1 ) ? $_REQUEST['potsDTMF'] : NULL;
	$potExtnAnyWhere = (isset($_REQUEST['potExtnAnyWhere']) && strlen($_REQUEST['potExtnAnyWhere']) >=1 ) ? $_REQUEST['potExtnAnyWhere'] : NULL;
	
	$att['callerdisplaytype'] = $potCallerDisplayType;
	$att['callerdisplaylen'] = $potCallerDisplayLength;
	$att['partnerlogincode'] = $partnerlogincode;
	$att['suppressdtmf'] =   $potsDTMF;
	$att['remotepstn'] = $potExtnAnyWhere;
	}
	
	
	$ent['description'] = $description;
	$dn = "cn=$selectedName, cn=$selectedSystemName, cn=modules";
	ldap_modify($ds, $dn, $ent);
	
	$dn = "cn=1, cn=$selectedName, cn=$selectedSystemName, cn=modules";
	ldap_modify($ds, $dn, $att);
	
	$user = '';
	
	$name = ($sipType === 'Yealink') ? "SIP $cn" : $cn;
	if ($selectedName != $cn)
		ldap_rename($ds,"cn=$selectedName,cn=$selectedSystemName, cn=modules","cn=$name","cn=modules",true);
	
	$dontvalidateipaddress = $publicipaddress = '';
	if ($usestun === '1') {
		$sr=ldap_read($ds,"cn=Self,cn=Modules","objectclass=*"); $info=ldap_get_entries($ds,$sr); 
		$self = $info[0]['location'][0];	
		
		$sr=ldap_read($ds,"cn=1, guid=$self,cn=Modules","objectclass=*"); $info=ldap_get_entries($ds,$sr); 
		$dontvalidateipaddress = $info[0]['dontvalidateipaddress'][0];	
		$publicipaddress = $info[0]['publicipaddress'][0];	
		
		if ($dontvalidateipaddress != '1' || strlen($publicipaddress) < 7){
			ldap_modify($ds,"cn=1,guid=$self,cn=Modules",array('dontvalidateipaddress' => '1'));
			//$publicIP = (@file_get_contents("http://splicepbx.uk/ip.php")) ? @file_get_contents("http://splicepbx.uk/ip.php") : NULL;
			$publicIP = (@file_get_contents("https://api.ipify.org")) ? @file_get_contents("https://api.ipify.org") : @file_get_contents("http://ipecho.net/plain");
			if ($publicIP) {
				ldap_modify($ds,"cn=1,guid=$self,cn=Modules",array('publicipaddress' => $publicIP));
			} else {
				echo $publicipaddress = '2'; //error
			}
		}
		
	}
	
	if (isset($pnpmodel)) $pnpmodel = str_replace('SIP-', '', $pnpmodel);
    $pnpmodel = (file_exists("../assets/images/phones/$pnpmodel.jpg")) ? $pnpmodel.".jpg" : $pnpmodel;
	
	echo "edit:$selectedGuid:$name:$selectedType:$description:$dontvalidateipaddress:$publicipaddress:$pnpmodel:$user";
	audit ($timestamp, "[$phoneType[$selectedType]] [$actionMode] $cn", $att);
}



if ($actionMode === 'delete') {
	$selectedGuid = (isset($_REQUEST['selectedGuid']) && strlen($_REQUEST['selectedGuid']) >=1 ) ? $_REQUEST['selectedGuid'] : NULL;
	$dn="guid=$selectedGuid, cn=modules";
	$sr = ldap_read($ds,$dn,"objectclass=Phone"); 
	$info = ldap_get_entries($ds,$sr); $cn = $info[0]['cn'][0];
	ldap_delete($ds, "$dn");
	audit ($timestamp, "[Phone] [Delete] $cn", "Deleted Phone $cn");
}


if ($actionMode === 'restartModule') {
	$sr = ldap_read($ds,"cn=System","objectclass=system",array('diagnosticengineeringpassword')); 
	$info = ldap_get_entries($ds,$sr);
	$password = $info[0]['diagnosticengineeringpassword'][0];
	
	$ent["dobackup"] = "1";  	
	ldap_modify($ds,"cn=Commands",$ent);
	
	$msg = "Module Restarted by AdminPortal on ". date(DATE_RFC2822);
	$cmd = "echo  $msg >> /SpliceCom/WebManager/warnings.txt";
    exec ($cmd, $res);
    ldap_close ($ds);

	$cmd = "echo $password | sudo -S systemctl restart adminmodule && echo $password | sudo -S systemctl restart compressor && echo $password | sudo -S systemctl restart voicemail";
	system($cmd,$rv);
	echo $rv;
	audit ($timestamp, "[ManagePhones] [Restart] Module", "AdminModule restart");
}


if ($actionMode === 'updatesippnp') {
	
	if ($container) {
		$publicIP = (isset($_REQUEST['publicip']) && strlen($_REQUEST['publicip']) >1) ? $_REQUEST['publicip'] : NULL;
	} else {
		//$publicIP = (@file_get_contents("http://splicepbx.uk/ip.php")) ? @file_get_contents("http://splicepbx.uk/ip.php") : NULL;
		$publicIP = (@file_get_contents("https://api.ipify.org")) ? @file_get_contents("https://api.ipify.org") : @file_get_contents("http://ipecho.net/plain");
	}
		
	error_log("publicIP = $publicIP");
	
	$sr=ldap_read($ds,"cn=Self,cn=Modules","objectclass=*");
	$info=ldap_get_entries($ds,$sr); $self = $info[0]['location'][0];	
	
	$ent['sippnpfileloc']="http://$publicIP/prov";
	$ent['dontvalidateipaddress']="1";
	$ent['publicipaddress']=$publicIP;
	
	ldap_modify($ds,"cn=1,guid=$self,cn=Modules",$ent);
	//sleep(1);
	$ent["dobackup"] = "1";
	ldap_modify($ds,"cn=Commands",$ent);
}


if ($actionMode === 'licenceCheck') {
	$licenceCheck = (isset($_REQUEST['licence']) && strlen($_REQUEST['licence']) >= 1) ? $_REQUEST['licence'] : NULL;
	$qty = $used = '';
	
	
	if (stripos($licenceCheck, 'license') !== false) $licenceCheck = str_replace('license','', $licenceCheck);
	
	if ($licenceCheck === 'sip') $licenceCheck = 'SIPPhone';
	
	if ($licenceCheck) {
		$sr = ldap_list($ds,"cn=system","(&(objectclass=licenserecord)(license=_$licenceCheck))",array('qty','used')); 
		$info = ldap_get_entries($ds,$sr);
		for ($m=0; $m<$info['count']; $m++) {				
			$qty = $info[$m]['qty'][0];
			$used = $info[$m]['used'][0];
		}
	
	echo trim($qty - $used);
	}	
}
?>