$(document).ready(function() {
	
	selectedSystemName = encodeURIComponent($('#system option:selected').text());
	selectedSystemGuid = encodeURIComponent($('#system').val());
	
	// Select System //
	$('#system').change(function(){
		$('#frm1').submit();
	});
	
	// load table //
	 oTable = $('#endpoints').dataTable({
		"bJQueryUI": true, "sPaginationType": "full_numbers",
		"aLengthMenu": [[15, 25, 50, 100, 250, 500], [15, 25, 50, 100, 250, 500]]
	});
	
	
	// highlight table entries //
	$('#endpoints').on( 'click', 'tr', function () {
		if ( $(this).hasClass('odd') || $(this).hasClass('even') || $(this).hasClass('new') ) {
        if ( $(this).hasClass('selected') ) {
            $(this).removeClass('selected');
			selectedGuid = selectedName = '';
        } else {
            oTable.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
			selectedGuid = encodeURIComponent($('#endpoints tr.selected').attr('id'));
			selectedName = encodeURIComponent($('#endpoints tr.selected').find('td:first').text());
        }
	}
    });
	
	
	// change tabs //
	$("body").on('click', '#element_to_pop_up ul#tabs li', function(){
		$("ul#tabs li").removeClass("active");
		$(this).addClass("active");
	
		var i = $(this).index();
		$("ul#tab li.active").removeClass("active");
		$("ul#tab li").eq(i).addClass("active");
	});
	
	
	// add new //
	$("#btn_add").click(function() {
		 selectedName = '';
		$('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
			loadUrl: 'popupAdd.php?selectedSystemName=' + selectedSystemName + '&selectedSystemGuid=' + selectedSystemGuid,
			loadCallback: function(){ 	    
				originalFormData = $('#popup').serialize();
			}
		}); 
	});

	
	// delete selected //
	$("#btn_delete").click(function() {
		if (typeof selectedGuid == "undefined" || selectedGuid.length < 1 ) return false;
		var timestamp = Math.floor(Date.now() / 1000); 
			
		var typeofphone = $('#endpoints tr.selected').children(':eq(3)').text();

		if (typeofphone.toLowerCase().indexOf("analogue") >= 0) {
			var n = noty({ type: 'error', layout: 'center', text: 'You can\'t delete Splicecom Analogue Ports', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout:1500 });	
			return false;
		}
			
		var n = noty({
        type: 'warning', layout: 'center', text: 'Delete Selected Phone : <b>' + decodeURIComponent(selectedName) + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'Yes', onClick: function ($noty) {
				$.ajax({ url : 'actions.php?actionMode=delete&selectedGuid=' + selectedGuid + '&timestamp=' + timestamp});
					oTable.fnDeleteRow( oTable.$('#' + selectedGuid)[0] );
					selectedGuid = selectedName = '';
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'No', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });	
	});

	
	// edit //
	$("#btn_edit").click(function(e) {
		var typeofphone = encodeURIComponent($('#endpoints tr.selected').children(':eq(3)').text());

		if (typeof selectedGuid == "undefined" || selectedGuid.length < 1 ) return false;
		$.ajaxSetup({ cache: false });							
		$('#loadMode').val('edit');
		$('#guid').val(selectedGuid);
		
        $('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
			loadUrl: 'popupEdit.php?selectedName=' + selectedName + '&selectedGuid=' + selectedGuid + '&selectedSystemName=' + selectedSystemName + '&selectedSystemGuid=' + selectedSystemGuid + '&typeofphone=' + typeofphone,
			loadCallback: function(){ 	    
				originalFormData = $('#popup').serialize();
				var pcsUpgradeTime = $('#pcsUpgradeTime').val();
				pcsUpgradeTime = ("0000" + pcsUpgradeTime).slice(-4)
				pcsUpgradeTime = pcsUpgradeTime.substr(0,2) + ":" + pcsUpgradeTime.substr(2);
				$("#pcsUpgrade").wickedpicker({twentyFour: true, now: pcsUpgradeTime});
			}
        });
	});
	
	
	// close //
	$("body").on('click', '#close', function(){
		var msg = (originalFormData !== $('#popup').serialize()) ? '<b>Changes haven\'t been saved.</b><br/>' : ''
		var n = noty({
        type: 'warning', layout: 'center', text: msg + 'Close Phone: <b>' + decodeURIComponent(selectedName) + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'Yes', onClick: function ($noty) {
					parent.$("#element_to_pop_up").html('').bPopup().close();
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'No', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });
	});
	
	
	// save add EndPoint //
	$("body").on('click', '#addEndPoint', function(){
	var newEndPoint = ($('#selectphone').val() === '2') ? '00-07-D9-' + $('#pcsMac').val() : $('#sipName').val();
	var assignUserName = ($('#assignUserOn').is(':checked')) ? $('#assignUser option:selected').text() : '';
	var timestamp = Math.floor(Date.now() / 1000); 
	 
	 if ($('#selectphone').val() === '3' && $('#sipType').val() === '1') {
		if ($('#sipMACAddress').val().length < 12) {
			var n = noty({ type: 'error', layout: 'center', text: 'Device MAC Address Must Be Set', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout:1500 });	
			return false
		}
	 }
	
	 if ($('#selectphone').val() === '3' && $('#sipType').val() === '2') {
		if ($('#sipIPAddress').val().length < 7) {
			var n = noty({ type: 'error', layout: 'center', text: 'Device IP Address Must Be Set', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout:1500 });	
			return false
		}
	 }
	 
	 
		var n = noty({
        type: 'information', layout: 'center', text: 'Save New Phone: <b>' + newEndPoint + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				data = $('#popup').serializeArray(),
				data.push({name: 'assignUserName', value: assignUserName});
				data.push({name: 'timestamp', value: timestamp});

				$.ajax({
					type: "POST", 
					cache: false,
					data: data,
					url: "actions.php?actionMode=addEndPoint", 	
				success: function(data) {
					console.log (data)
					res = data.split(":");
					var mode = res[0]; var guid = res[1]; var pcsName = res[2]; var assignUserName = res[3]; var typeofphone = res[4]; var desc = res[5]; var dontvalidate = res[6]; var publicip = res[7]; var pnpmodel = res[8];
					var ret = mode + ':' + guid + ':' + pcsName + ':' + assignUserName + ':' + pnpmodel + ':' + typeofphone + ':' + desc;
					parent.UpdateCode(ret);
					
					if (dontvalidate === '0' || publicip === '0'){
						var n = noty({ type: 'error', layout: 'center', text: '<b>Warning:</b><br/>STUN Settings have been applied.<br><br>The SoftPBX will need to be restarted for these settings to go live<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });	
						$('#restart').css('display','block');
					}
					
					if (publicip === '2'){
						var n = noty({ type: 'error', layout: 'center', text: '<b>Warning:</b><br/>STUN Settings have been applied.<br><br>An error has occured when setting the Public IP Address, please check this setting</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });	
					}
				}
				});

				parent.$("#element_to_pop_up").html('').bPopup().close();
				$noty.close();
				return false; 
			}
            },
			{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); }
			}
            ]
        });
	});
	
	// save Edit EndPoint
	$("body").on('click', '#editEndpoint', function(){
	 var editEndPoint = $('#phoneName').val();
	 var timestamp = Math.floor(Date.now() / 1000); 
	 
		var n = noty({
        type: 'information', layout: 'center', text: 'Save Phone: <b>' + editEndPoint + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({
					type: "POST", 
					cache: false,
					data: $('#popup').serializeArray(),	
					url: "actions.php?actionMode=editEndpoint&timestamp=" + timestamp, 	
				success: function(data) {
					console.log(data)
					res = data.split(":");
					var mode = res[0];  var guid = res[1]; var phoneName = res[2]; var typeofphone = res[3]; var desc = res[4]; var dontvalidate = res[5]; var publicip = res[6]; var pnpmodel = res[7]
					var assignedUser = encodeURIComponent($('#endpoints tr.selected').children(':eq(1)').text());
					var ret = mode + ':' + guid + ':' + phoneName + ':' + assignedUser + ':' + pnpmodel + ':' + typeofphone + ':' + desc;
					parent.UpdateCode(ret);
					
					if (dontvalidate === '0' || publicip === '0'){
						var n = noty({ type: 'error', layout: 'center', text: '<b>Warning:</b><br/>STUN Settings have been applied.<br><br>The SoftPBX will need to be restarted for these settings to go live<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });	
						$('#restart').css('display','block');
					}
					
					if (publicip === '2'){
						var n = noty({ type: 'error', layout: 'center', text: '<b>Warning:</b><br/>STUN Settings have been applied.<br><br>An error has occured when setting the Public IP Address, please check this setting</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });	
					}
					
				}
				});

				parent.$("#element_to_pop_up").html('').bPopup().close();
				$noty.close();
				return false; 
			}
            },
			{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); }
			}
            ]
        });
		
	
	});
	
	// check SIP licensing
	$("body").on('change', '#siplicense', function() {
		var licenceCheck = $(this).attr('id')
		
		if ( window[licenceCheck] > 0 ) {
			console.log (' licence was already set ');
			return false;
		}
		
		
		var licenceArray = {'siplicense': 'SIP Phone'};
		if (document.getElementById(licenceCheck).checked) {
			$.ajax({ type: "GET",   
			url: "actions.php?actionMode=licenceCheck&licence=" + encodeURIComponent(licenceCheck),   
			async: true,
			success : function(text) {
				console.log(text)
				if (text <= '0') {
					var n = noty({ type: 'error', layout: 'center', text: licenceArray[licenceCheck] + '<br/>Insufficient licences available<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
					$('#' + licenceCheck).prop('checked', false);
				}
			}	
			});
		}
	});
	
	
	
	$('body').on('change', '#popup input[name=pcsExtnAnyWhere]', function(){
		if ($(this).length > 0 && $(this).val() > '0') {
		var n = noty({
        type: 'warning', layout: 'center', text: 'The number entered in the Extension Anywhere will go live as soon<br>as the phones settings are saved.<br><br>Are you sure you want to continue ?<br><br><i>(click to close)</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
					$('#pcsExtnAnyWhere').val('');
                    $noty.close(); }
                }
            ]
        });	
		} 
	});
	
	$("body").on('change', '#selectphone', function(){
		var phoneType = $(this).val();
		if (phoneType === '3') {
			$('#provisionTab').css('display', 'inline');
		} else {
			$('#provisionTab').css('display', 'none');
		}
	});
	
	$("body").on('change', '#sipType', function(){
		var phoneType = $(this).val();
		if (phoneType === '1') {
			$('#provisionTab').css('display', 'inline');
			$('#sipphonelicence').show();
		} else {
			$('#provisionTab').css('display', 'none');
			$('#sipphonelicence').hide();
		}
	});
	
	
	// ADD PHONES //
	
	// add select Phone
	$("body").on('change', '#selectphone', function(){

			$('#assignUserOn').prop('checked', false);
			$('#msg').html(''); 
			$("#msg_wrap").attr('style', '');
			$('#renameAssigned').prop({'disabled': true, 'checked': false});
			$('#description').val(''); 
		
		if ($(this).val() == '2' ) {
			$('.pcsPhone, .commonValues').show();
			$(".pcsPhone").children().prop("disabled", false);
			$('.genericPhone').hide();
			$(".genericPhone").children().prop("disabled", true);
			
		} else if ($(this).val() == '3' ) {
			$('.genericPhone, .commonValues').show();
			$(".genericPhone").children().prop("disabled", false);
			$('.pcsPhone').hide();
			$(".pcsPhone").children().prop("disabled", true);
			
		} else {
			$('.pcsPhone, .genericPhone, .commonValues').hide();
		}
		
	});
	
	
	// PCS IPPhone Phone Name
	$('body').on('keyup', '#popup input[name=pcsMac]', function(){
		var str = 'PCS 00-07-D9-' + $.trim( $(this).val() );
		$('#pcsName').val(str);
	});
	
	//assign phone to user
	$("body").on('change', '#assignUserOn', function(){
		if (document.getElementById('assignUserOn').checked) {
			var n = noty({ type: 'warning', layout: 'center', text: '<b>Warning:</b><br/>Assigning the phone to a user will overwrite an existing initial phone, logging out the user. It may also stop partner software from working<br/><br/>Users with a Vision agent licences are not available for selection<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });	
			$('#assignUser').show();
			$('#assignuserDiv').css("height","67px");
			$('#msg').html('Assigning the phone to a user will overwrite any existing initial phone'); 
			$("#msg_wrap").css({ 'border': '2pt solid #16439C', 'color': '#16439C'});
			$('#renameAssigned').prop('disabled', false);
		} else {
			$('#assignUser').hide();
			$('#assignuserDiv').css("height","38px");
			$('#msg').html(''); 
			$("#msg_wrap").attr('style', '');
			$('#renameAssigned').prop({'disabled': true, 'checked': false});
		}
	});
	
	// format MAC Address
	$("body").on('keyup', '#pcsMac', function(e){
		
		if ($(this).val().match(/[^a-fA-F0-9-]/) != null) {
			$('#msg').html('Invalid MAC Address'); 
			$("#msg_wrap, #pcsMac").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			$("#addEndPoint").prop("disabled",true);
			return false
		} else {
			$('#msg').html(''); 
			$("#msg_wrap, #pcsMac").prop('style', '');
			$("#addEndPoint").prop("disabled",false);
		}
			if (e.keyCode != 8) {
				if (this.value.indexOf("-") == this.value.length - 1) $(this).val($(this).val().slice(0, -1));
				if ($(this).val().length == 2 || $(this).val().length == 5) $(this).val($(this).val() + "-");
				if ($(this).val().split("-").length > 3) $(this).val($(this).val().replace($(this).val(),''));
			}
		// MAC Address check	
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?macAddress=" + encodeURIComponent($(this).val()),   
         async: true,
         success : function(text) {
			 if (text >= '1'){
				$('#msg').html('MAC Address is already in the system'); 
				$("#msg_wrap, #pcsMac, #pcsName").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#addEndPoint").prop("disabled",true);
				return false
			} else {
				$('#msg').html(''); 
				$("#msg_wrap, #pcsMac, #pcsName").prop('style', '');
				$("#addEndPoint").prop("disabled",false);
			} 
		}
		});
	});
	
	//  device name check
	$("body").on('keyup', '#pcsName, #sipMACAddress', function(){
		var deviceName =  $(this).prop('id');
		var thisVal = $(this).val();
		var type = $('#sipType').val();
		var regex = /^([0-9A-Fa-f]{2}){6}$/;
		
		if ( type === 'Yealink' ) type = '1'

		if ( type === '1' ) {
			cleanmac = thisVal.replace(/[^0-9a-fA-F]/g, '');
			$('#sipMACAddress, #sipName').val( cleanmac.toLowerCase() )
		}
		
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?deviceName=" + encodeURIComponent(thisVal),   
         async: true,
         success : function(text) {
			 if (text >= '1'){
				$('#msg').html('Device name is already in the system'); 
				$("#msg_wrap, #" + deviceName).css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#addEndPoint").attr("disabled",true);
				return false
			} else if (type === '1' && (thisVal === "" || regex.test(thisVal) === false)) { 
				$('#msg').html('Invalid MAC Address'); 
				$("#msg_wrap, #sipMACAddress").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#addEndPoint").attr("disabled",true);
				return false
			} else {
				$('#msg').html(''); 
				$("#msg_wrap, #" + deviceName).attr('style', '');
				$("#addEndPoint").attr("disabled",false);
			} 
		}
		});
	});
	
	$("body").on('change', '#usestun', function(){
		if ($(this).val() === '1') {
			
			stunserver = $('#wanIP').val();
			$('#stunaddr').val(stunserver).prop('disabled', false);
			$('#stunport').val('5060').prop('disabled', false);
		} else {
			
			$('#stunaddr').prop('disabled', true);
			$('#stunport').prop('disabled', true);
		}
	});
	
	// Add Endpoint IP Address Check
	$("body").on('blur', '#sipIPAddress', function(){
		var ipcheck = /^([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])$/;
    	if ($(this).val() != "" && !$(this).val().match(ipcheck)) { 
			$('#msg').html('Invalid IP Address'); 
			$("#msg_wrap, #sipIPAddress").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			$("#addEndPoint").prop("disabled",true);
			return false 
		} else {
			$('#msg').html(''); 
			$("#msg_wrap, #sipIPAddress").prop('style', '');
			$("#addEndPoint").prop("disabled",false);
		}
	})
	
	// Edit Endpoint IP Address Check
	$("body").on('blur', '#phoneIPAddress', function(){
		var ipcheck = /^([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])$/;
    	if ($(this).val() != "" && !$(this).val().match(ipcheck)) { 
			$('#msg').html('Invalid IP Address'); 
			$("#msg_wrap, #phoneIPAddress").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			$("#editEndpoint").prop("disabled",true);
			return false 
		} else {
			$('#msg').html(''); 
			$("#msg_wrap, #phoneIPAddress").prop('style', '');
			$("#editEndpoint").prop("disabled",false);
		}
	})
	
	// numeric values only
	$('body').on('keyup', '[name=pcsPlc], [name=pcsUpgrade], [name=pcsExtnAnyWhere]', function(){
		thisVal = ( $(this).val() )
		if(thisVal.length >= 1 && !$.isNumeric(thisVal)) {
			$(this).addClass('error');
			$('#msg').html('Numeric Value Only'); 
			$('#msg_wrap').addClass('error');
			$("#save").prop("disabled",true);
		} else {
			$('#msg').html(''); 
			$(this).removeClass('error');
			$('#msg_wrap').removeClass('error');
			$("#save").prop("disabled",false);
		}
	});
	
	// sip model
	$("body").on('change', '#sipType', function(){
		var type = ( $(this).val() );
		if (type==='1') {
			$('#genericIPAddress').hide();
			$('#yealinkMACAddress').show();
			$('#sipName').removeClass('otherDevice').addClass('yealinkDevice').attr('maxlength','17').prop('readonly', true);
;
		} else {
			$('#genericIPAddress').show();
			$('#yealinkMACAddress').hide();
			$('#sipName').removeClass('yealinkDevice').addClass('otherDevice').attr('maxlength','64').prop('readonly', false);
		}
	});
	
	// Edit Phone Model
	$("body").on('change', '#phoneName', function(){
		if (selectedName)
		var text = $('#FormText').text();
		if (text.indexOf("Yealink") >= 0) var type = '1';
		var currentDevice = selectedName.replace('SIP%20', '');
		var thisVal = $(this).val();
		var regex = /^([0-9A-Fa-f]{2}){6}$/;

		if (type === '1')
			$('#sipMACAddress').val($(this).val().toLowerCase())
		
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?deviceName=" + encodeURIComponent(thisVal),   
         async: true,
         success : function(text) {
			 if (currentDevice === thisVal) {
				$('#msg').html(''); 
				$("#msg_wrap, #phoneName").prop('style', '');
				$("#editEndpoint").prop("disabled",false);
				return false;
			 }
				 
			 if (text >= '1' ){
				$('#msg').html('Device name is already in the system'); 
				$("#msg_wrap, #phoneName").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#editEndpoint").prop("disabled",true);
				return false
			} else if (type === '1' && (thisVal === "" || regex.test(thisVal) === false)) { 
				$('#msg').html('Invalid MAC Address'); 
				$("#msg_wrap, #phoneName").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#editEndpoint").prop("disabled",true);
				return false
			} else {
				$('#msg').html(''); 
				$("#msg_wrap, #phoneName").prop('style', '');
				$("#editEndpoint").prop("disabled",false);
			} 
		}
		});
	});
	
	// restart SoftPBX
	$("body").on('click', '#restartAdmin', function(){
		var timestamp = Math.floor(Date.now() / 1000); 
		var n = noty({
        type: 'error', layout: 'center', text: 'Restarting the SoftPBX will disconnect live calls and log out phones<br>The system will be unavailable for a few minutes whilst this happens<br><br>Do you want to continue ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({
					type: "POST", 
					cache: false,
					url: "actions.php?actionMode=restartModule&timestamp=" + timestamp, 	
				success: function(data) {
					$('#restartAdmin').hide();
					console.log(data)
					if (data === '0') {
						var n = noty({ type: 'success', layout: 'center', text: 'SoftPBX Restarted', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout:2500 });	
					} else {
						var n = noty({ type: 'error', layout: 'center', text: 'An Error Has Occured Restarting The SoftPBX.', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout:2500 });	
					}
					
					$noty.close(); 
				}
				});
			}
            },
            {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                $noty.close(); }
                }
            ]
        });	
	});
	
	$("body").on('click', '.tooltip', function() {
		extnlist = ( $(this).data('list') )
		console.log  (extnlist)
		$('#extensions_pop_up').bPopup({
			escClose: true, modalClose: true,
			onOpen: function() { 	    
				$('#extensions').html(extnlist)
			}
		}); 
	})
		
	
});

	// save and/or edit return values to update table
	function UpdateCode(ret) {  
	console.log (ret)
	var ret = ret.split(':');
	var mode = ret[0]; 
	var guid = ret[1]; 
	var phoneName = ret[2]; 
	var assignUserName = ret[3];
	var pnpmodel = ret[4];
	var pnptext = pnpmodel.replace('.jpg','');
	
	var pnpRow = (pnpmodel.indexOf('jpg') >= 0) ?  "<a href='#' class='model'><div class='hover-img'><span><img src='../assets/images/phones/" + pnpmodel + "' alt='image' height='100' /></span></div>" + pnptext + "</a>" : "<a href='#' class='model'>" + pnptext + "</a>";
	
	if (ret[5] == '1') {
		var typeofphone = 'Splicecom Analogue Port';
	} else if (ret[5] == '2') {
		var typeofphone = 'Splicecom PCS IP Phone';
	} else if (ret[5] == '3') {
		var typeofphone = 'SIP Phone';
	}
	var desc = ret[6];
	
	
	if (mode == 'add') {
		var addRow = $('#endpoints').dataTable().fnAddData( [phoneName, assignUserName, pnpRow, typeofphone, desc ]);
		var newRow = $('#endpoints').dataTable().fnSettings().aoData[addRow[0]].nTr;
		$('#endpoints tr').removeClass("selected");
		newRow.setAttribute('id',guid);
		newRow.setAttribute('class','new selected');
	} else {
		$('#endpoints').dataTable().fnUpdate([phoneName] ,$('tr#' + guid)[0], 0, false );
		$('#endpoints').dataTable().fnUpdate([assignUserName] ,$('tr#' + guid)[0], 1, false );
		$('#endpoints').dataTable().fnUpdate([pnpRow] ,$('tr#' + guid)[0], 2, false );
		$('#endpoints').dataTable().fnUpdate([typeofphone] ,$('tr#' + guid)[0], 3, false );
		$('#endpoints').dataTable().fnUpdate([desc] ,$('tr#' + guid)[0], 4, false );
	}
	
	selectedName = encodeURIComponent(phoneName);
	selectedGuid = guid;
	}
