<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Manage Phones</title>
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="../assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="../assets/css/menu.css" media="screen" rel="stylesheet" type="text/css" />
<link href="../assets/css/select.dataTables.css" media="screen" rel="stylesheet" type="text/css" />
<link href="../assets/css/table_layout.css" media="screen" rel="stylesheet" type="text/css" />
<link href="../assets/css/table_custom.css" media="screen" rel="stylesheet" type="text/css" />
<link href="../assets/css/bPopup.css" media="screen" rel="stylesheet" type="text/css" />
<link href="../assets/css/buttons.css" rel="stylesheet" type="text/css">
<link href="../assets/css/tabForm.css" rel="stylesheet" type="text/css">
<link href="../assets/css/jquery-ui.css" rel="stylesheet" type="text/css">
<link href="../assets/css/wickedpicker.min.css" rel="stylesheet" type="text/css">
<link href="index.css" rel="stylesheet" type="text/css">

<script src="../assets/js/jquery-min.js" type="text/javascript"></script>
<script src="../assets/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script src="../assets/js/jquery.noty.packaged.js" type="text/javascript"></script>
<script src="../assets/js/bPopup.js" type="text/javascript"></script>
<script src="../assets/js/jquery-ui.min.js"></script>
<script src="../assets/js/wickedpicker.min.js" type="text/javascript" ></script>
<script src="index.js" type="text/javascript"></script>
</head>
<body>
<?php

//require('../assets/inc/ldapConnect.php');

$system = (isset($_REQUEST['system']) && strlen($_REQUEST['system']) > 1) ? $_REQUEST['system'] : NULL;
?>
<div id="content">

<div class="logo">
<a href="#"><img src='../assets/images/logo.png'/></a>
</div>

<div id="wrap">


<!-- header begins -->
<div class="menu-wrap">
<?php
	require('../assets/inc/header.php');
	if ($adminCompany != '00000000-0000-0000-0000-000000000000') {  header("Location: ../"); exit(); }
?>	
</div>
<!-- header ends -->


<!-- content begins -->
<div id="main">
<div class="wrapper">
<h3><span class="icon-phone greyicon"></span> Manage Phones</h3>


<?php 
	$sr=ldap_list($ds,"cn=Users","(objectclass=User)", array('cn','initialphone'));
	$info = ldap_get_entries($ds, $sr);
	$usrinitialPhone = array();
	$deviceCount = array();
	for ($m=0; $m<$info['count']; $m++) {
		$usrinitialPhone[$info[$m]['initialphone'][0]] = $info[$m]['cn'][0];
		$deviceCount[] = $info[$m]['initialphone'][0];
	}
	$uniqueCount = (array_count_values($deviceCount));
?>


 	<form id="frm1" method="post" action="<?php echo $_SERVER['PHP_SELF']?>">
	<div class='field'>
		<label for="system">Select system</label>
		<select name='system' id='system'>
		<option></option>
		<?php
			$sr=ldap_list($ds,"cn=Modules","(&(objectclass=Module)(modulestatus=0)(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19)))");
			$info = ldap_get_entries($ds, $sr);
			if ($info['count'] == '1') $system = $info[0]['guid'][0];
			for ($m=0; $m<$info['count']; $m++) {
				$systemCN = $info[$m]['cn'][0]; $systemGUID = $info[$m]['guid'][0];
				$selected = ($systemGUID == $system) ? 'selected' : '';
				echo "<option value='$systemGUID' $selected>$systemCN</option>";	
			}
		?>
		</select>
		<span class='information'>SELECT SYSTEM</span>
	</div>
	</form><br>

<?php
	if (isset($system)) {
?>

<div style="float:right; padding-right: 10px;">
	<button id='btn_add' class='formBtn'><span id="add" class="icon-plus"></span><br>Add</button>&nbsp;&nbsp;
	<button id='btn_edit' class='formBtn'><span id="edit" class="icon-pencil2"></span><br>Edit</button>&nbsp;&nbsp;
	<button id='btn_delete' class='formBtn'><span id="delete" class="icon-minus"></span><br>Delete</button>
</div>
	<form method='post' id='frm'>
	<table cellpadding='0' cellspacing='0' border='0' class='display' id='endpoints' width='100%'>
	<thead><tr><th>Phone</th><th>User</th><th>Model</th><th>Type</th><th>Description</th></tr></thead>
	<tbody>
	
<?php  
$typesofphone = array('1'=>'Splicecom Analogue Port','2'=>'Splicecom PCS IP Phone','3'=>'SIP Phone','4'=>'iPCS');
$sr = ldap_search($ds,"guid=$system, cn=modules","objectclass=Phone",array('cn','description','guid','typeofphone'));
$info = ldap_get_entries($ds, $sr);
for ($m=0; $m<$info['count']; $m++) {
	$dn[$m] = $info[$m]['dn']; $cn[$m] = $info[$m]['cn'][0];
	$guid[$m] = $info[$m]['guid'][0]; $description[$m] = $info[$m]['description'][0];
	$typeofphone[$m] = $info[$m]['typeofphone'][0];
	$phonemodel[$m] = $typesofphone[$info[$m]['typeofphone'][0]];
}

$pnp = array();
$sr2 = ldap_search($ds,"guid=$system, cn=modules","(|(objectclass=GenericIPPhone)(objectclass=SplicePhone))",array('cn','pnpmodel', 'serialnumber'));
$info2 = ldap_get_entries($ds, $sr2);
for ($m=0; $m<$info2['count']; $m++) {
	$pnp[ $info2[$m]['serialnumber'][0] ] = $info2[$m]['pnpmodel'][0];
}			

if ( $info['count'] > '0' ) {
	foreach($cn as $k => $v) {
		$entryGuid = $guid[$k];
		$model = str_replace( array('SIP ','PCS '), array('',''), $cn[$k] ); // strip 'SIP ' or 'PCS ' 
		$pnpmodel = (isset($pnp[ $model ])) ? str_replace('SIP-', '', $pnp[ $model ]) : ''; // strip 'SIP-'

		echo "<tr id='$entryGuid'>";
		echo "<td>$cn[$k]</td>";
		if (isset($uniqueCount[$entryGuid]) && $uniqueCount[$entryGuid] > 1) {
			$extns = '';
			$sr = ldap_list($ds,"cn=Users","(&(objectclass=User)(initialphone=$entryGuid))",array('cn','initalphone'));
			$users = ldap_get_entries($ds, $sr);
       		for ($u=0; $u<$users['count']; $u++) {
	       		$extns .= $users[$u]['cn'][0] . '<br/>';
			}
			echo "<td><span class='tooltip' href='#' title='click for details' data-list='$extns'><b>Shared Device</b></span></td>";
			
		} else {
			echo "<td>"; if (array_key_exists($entryGuid, $usrinitialPhone)) echo $usrinitialPhone[$entryGuid]; echo "</td>";
		}
		
		
		if (file_exists("../assets/images/phones/$pnpmodel.jpg")) {
			echo "<td><a href='#' class='model'><div class='hover-img'><span><img src='../assets/images/phones/$pnpmodel.jpg' alt='image' height='100' /></span></div>$pnpmodel</a></td>";
		} else {
			echo "<td>$pnpmodel</td>";
		}
		
		echo "<td>$phonemodel[$k]</td>";
		echo "<td>$description[$k]</td>";
		echo "</tr>";
	} 
}
?>
</tbody>
</table>
</form>

<?php 
	} 
?>

<div id='restart' style='text-align:center; display:none'>
	<button id='restartAdmin'>Restart SoftPBX</button>
</div>

</div>
</div>	


<!--content ends -->
<div id="element_to_pop_up"></div>

<div id="extensions_pop_up">
	<b>Extension List:</b><br/><br/>
	<div id='extensions'></div>
</div>



<br>
<!--footer begins -->
<?php
	require('../assets/inc/footer.php');
?>
<!-- footer ends-->
</div>
</div>
</body>
</html>