<?php
// v3.26
//PJC 07-DEC-2018 - Update spelling and user/department setting
//PJC 26-JAN-2017 Link Updates
//PJC 28-SEPT-15 - Updated results output
//PJC 25-SEPT-15 - Added Voicemail to email for users with email address set
//PJC 08-Aug-14 - Added support for Users and Departments
//PJC 23-April-14 - Added support for selecting multiple departments and adding bulk contacts.
//PJC 19Feb2014 - Help Link
//PJC 23Jan2013
session_start();
$page_id = "002";
include ".access.php";
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : NULL;

?>
<html>
<head>
<title>Bulk Add Voicemail Contacts</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script language="javascript">
function addRowToTable()
{
  var tbl = document.getElementById('tblvm');
  var lastRow = tbl.rows.length;
  // if there's no header row in the table, then iteration = lastRow + 1
  var iteration = lastRow;
  var row = tbl.insertRow(lastRow);

  // left cell
  var cellLeft = row.insertCell(0);
  var textNode = document.createTextNode(iteration);
  cellLeft.appendChild(textNode);

  // right cell
  var cellRight = row.insertCell(1);
  var el = document.createElement('input');
  el.type = 'text';
  el.name = 'telephone[]';
  //el.id = 'txtRow' + iteration;
  el.size = 15;

  cellRight.appendChild(el);

  var cellRightSel = row.insertCell(2);
  var sel = document.createElement('select');
  sel.name = 'type[]';
  sel.options[0] = new Option('Telephone', '1');
  sel.options[1] = new Option('Email', '2');
  sel.options[2] = new Option('SMS', '3');
  sel.options[3] = new Option('Lamp', '4');
  sel.options[4] = new Option('Archive', '5');
  sel.options[5] = new Option('Archive Email', '6');
  sel.options[6] = new Option('SMS Web', '7');
  sel.options[7] = new Option('Custom Email', '8');
  sel.options[8] = new Option('Missed Call Email', '11');
  cellRightSel.appendChild(sel);
  var cellRightSel1 = row.insertCell(3);
  var sel1 = document.createElement('select');
  sel1.name = 'method[]';
  sel1.options[0] = new Option('None', '0');
  sel1.options[1] = new Option('Alert', '1');
  sel1.options[2] = new Option('Delivery', '2');
  sel1.options[3] = new Option('Copy', '3');
  sel1.options[4] = new Option('Access', '4');
  sel1.options[5] = new Option('Prompt', '5');
  sel1.options[6] = new Option('Deliver and Delete', '6');
  sel1.options[7] = new Option('Deliver New', '7');
  sel1.options[8] = new Option('Deliver Link', '8');
  sel1.options[4].selected=true;
  cellRightSel1.appendChild(sel1);
}
function removeRowFromTable()
{
  var tbl = document.getElementById('tblvm');
  var lastRow = tbl.rows.length;
  if (lastRow > 2) tbl.deleteRow(lastRow - 1);
}
</script>
<script language="javascript">
$(document).ready(function () {
	var action = "<?php echo $action; ?>";
	
	$("#submit").click(function() {
		if ( $("#select").val() == null && action == 1) { alert('No Departments Selected'); return false; }
		if ( $("#select").val() == null && action == 2) { alert('No Users Selected'); return false; }
		if ( $("#extn_range").val().length == 0 && action == 3) { alert('No Extension Range Selected'); return false; }
	});
});

var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
function formSubmit() {
	document.getElementById("frm1").submit();
}
</script>
</head>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_vmcontacts.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>
<?php
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}
	$sr = ldap_read($ds,"cn=self,cn=Modules","objectclass=*"); $info = ldap_get_entries($ds,$sr);
    $sr = ldap_search($ds,"cn=Modules","(&(objectclass=*)(guid=".$info[0]['location'][0]."))"); $info = ldap_get_entries($ds,$sr);
	$dn="cn=1,".$info[0]['dn'];$selfguid = $info[0]['guid'][0];

	$sr=@ldap_read($ds,$dn,"objectclass=*",array("smtpserver")); $info=ldap_get_entries($ds,$sr);
  	$smtp = (strlen($info[0]['smtpserver'][0])>1) ? $info[0]['smtpserver'][0] : "Not Set";

?>
<div id="contain">
<h2><img src='images/settings.png' style="vertical-align:middle;">&nbsp;Bulk Add Voicemail Contacts</h2>
This script allows you to bulk add voicemail contacts to a user(s) or department(s).<br/><br/>
<form id="frm1" method="post" action="<?php echo $_SERVER['PHP_SELF']?>">
<select onchange="formSubmit()" name="action">
<option value="" > </option>
<option value="1" <?php if ($action == '1') echo 'selected'; ?> >Departments</option>
<option value="2" <?php if ($action == '2') echo 'selected'; ?> >Users</option>
<option value="3" <?php if ($action == '3') echo 'selected'; ?> >Users Voicemail to Email</option>
</select>&nbsp;<a href='#' class='tooltip' title='Select The Action To Perform'><img src='images/tooltip.gif'></a>
</form>

<?php
if (isset($_REQUEST['action']) && $_REQUEST['action'] <= 2) {
		if ($_REQUEST['action']==1) { $mode = "Department"; $modes = "Departments"; }
		if ($_REQUEST['action']==2) { $mode = "User"; $modes = "Users"; }
	
		echo "<h2> $mode </h2>
		<b>Individual $mode:</b><br/>Select the $mode to add the contact to, then enter the contact details in the form below.<br/><br/>
		<b>Mutliple $modes:</b><br/> To select multiple $modes, press and hold CTRL and then click on each $mode. (If using a MAC press and hold Command)<br/>
		To select all $modes, select the first, press and hold SHIFT, then select the last $mode.<br/>";
?>

Then enter the contact details in the form below.<br/><br/>
Clicking 'Add Row' adds additional contact rows.<br/>
Clicking 'Remove row' removes the last contact row added.<br/>
Clicking "Submit' applies the new voicemail contacts to your selected department.<br/><br/>
Using a contact type of 'Missed Call Email' requires the setting of 'SMTP Server Address' on the <a href="../manager.cgi?pagename=module&index=<?php echo $selfguid ?>&tab=1" target="_blank">CallServer</a> in Modules<br/>
The SMTP Server Address for this CallServer is currently : <b><?php echo $smtp ?></b><br/><br/>
A consolidated database backup is automatically performed before this is applied.<br/>
<form method="post" action="<?php echo $script;?>">
<?php

 	   $sr=ldap_list($ds, "cn=$modes", "(objectclass=$mode)", array("cn","guid"));
 	   $info = ldap_get_entries($ds, $sr);
	   echo "<br><b>Select $mode : </b>&nbsp;<a href='#' class='tooltip' title='Select $mode'><img src='images/tooltip.gif'></a><br/><select name='{$mode}[]' id='select' size=6 multiple style='min-width: 175px'>";
 	         for ($n=0; $n<$info['count']; $n++) {
			 $cn = $info[$n]['cn'][0];
			   echo "<option value='$cn'>$cn</option>";
				}
?>
</select><br/>
Create System Backup : <input type="checkbox" name="backup" id="backup" checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.gif'></a><br/>
<br/>Delete all existing voicemail contacts from <?php echo $modes ?> : <input type="checkbox" name="del" id="del" />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Delete All Existing Voicemail Contacts  From This $mode'><img src='images/tooltip.gif'></a><br/><br/>
<p><input type="button" value="Add Row" onclick="addRowToTable();" />
<input type="button" value="Remove Row" onclick="removeRowFromTable();" /></p><br/>
<table border="1" id="tblvm">
  <tr>
    <th colspan="2">Telephone Number&nbsp;<a href='#' class='tooltip' title='Enter Telephone Number, Email Address Or Name'><img src='images/tooltip.gif'></a></th>
    <th colspan="1">Type&nbsp;<a href='#' class='tooltip' title='Select Contact Type'><img src='images/tooltip.gif'></a></th>
    <th colspan="1">Method&nbsp;<a href='#' class='tooltip' title='Select Contact Method'><img src='images/tooltip.gif'></a></th>
  </tr>
  <tr>
    <td>1</td>
    <td><input type="text" name="telephone[]" id="txtRow1" size="15" /></td>
    <td>
    <select name="type[]">
	<option selected value="1">Telephone</option>
	<option  value="2">Email</option>
	<option  value="3">SMS</option>
	<option  value="4">Lamp</option>
	<option  value="5">Archive</option>
	<option  value="6">Archive Email</option>
	<option  value="7">SMS Web</option>
	<option  value="8">Custom Email</option>
	<option  value="11">Missed Call Email</option>
    </select>
    </td>
  <td>
    <select name="method[]">
	<option  value="0">None</option>
	<option  value="1">Alert</option>
	<option  value="2">Deliver</option>
	<option  value="3">Copy</option>
	<option selected value="4">Access</option>
	<option  value="5">Prompt</option>
	<option  value="6">Deliver and Delete</option>
	<option  value="7">Deliver New</option>
	<option  value="8">Deliver Link</option>
    </select>
    </td>
  </tr>
</table>
<input type="hidden" name="add" value="add">
<input type="hidden" name="mode" value=<?php echo $mode?>>
<p><input type="submit" id="submit" value="Submit" /></p>
</form>
</body>
</html>
<?php
} // action 1 / 2


if (isset($_REQUEST['action']) && $_REQUEST['action'] == 3) {
	echo "<h2> Users - Voicemail to Email </h2>";
?>	
Bulk add a Voicemail to email contact to a range of users who have an existing email address configured.<br/><br/>
In the 'Extension Range' field enter the extension numbers where the voicemail contact is to be applied. Enter either a comma between<br/>
each extension number or use a hyphen to indicate a range of extensions. For example: 2001,2003,2005,2009,2015,2020 etc or 2001-2050<br/>
To apply the voicemail contact to All users, enter ALL in the 'Extension Range' field.<br/><br/>
<b>Please Note:</b>&nbsp; This page will add a voicemail contact to a user(s), using there exsiting configured email address.</br></br>
	<form method="post" action="<?php echo $script;?>">
	<b>Extension Range :</b>&nbsp;<input type="text" name="extn_range" id="extn_range" size="60"/>&nbsp;<a href='#' class='tooltip' title='Enter Extension Number Range'><img src='images/tooltip.gif'></a></br></br>
			
	<table border="1" id="tblvm">
  <tr>
    <th colspan="1">Type&nbsp;<a href='#' class='tooltip' title='Select Contact Type'><img src='images/tooltip.gif'></a></th>
    <th colspan="1">Method&nbsp;<a href='#' class='tooltip' title='Select Contact Method'><img src='images/tooltip.gif'></a></th>
  </tr>
  <tr>
    <td>
    <select name="type">
	<option  value="2">Email</option>
	<option  value="6">Archive Email</option>
	<option  value="8">Custom Email</option>
	<option  value="11">Missed Call Email</option>
    </select>
    </td>
  <td>
    <select name="method">
	<option  value="2">Deliver</option>
	<option  value="3">Copy</option>
	<option  value="6">Deliver and Delete</option>
	<option  value="8">Deliver Link</option>
    </select>
    </td>
  </tr>
</table>

</br></br>Create System Backup : <input type="checkbox" name="backup" id="backup" checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.gif'></a><br/><br/>
<input type="hidden" name="addvmemail" value="addvmemail">
<input type="hidden" name="mode" value="vmtoemail">
<p><input type="submit" id="submit" value="Submit" /></p>
</form>
<?php
} // action 3

if (!empty($_REQUEST['add']) && $_REQUEST['add']=="add") {
$mode = $_REQUEST['mode']; $modes = "{$mode}s";
$select = ($mode === "Department") ? $_REQUEST['Department'] : $_REQUEST['User'];

	if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
	$backup = "Backup ".date('d.m.y His')." - Pre{$mode}VMContactAdd.txt";
	$ent["dobackupto"][0] = $backup;
	ldap_modify($ds,"cn=Commands", $ent);
	ldap_modify($ds,"cn=Commands", $ent); $ent='';
	} else {
		echo "<script>$('#backup').prop('checked', false);</script>";
	}

	if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") echo "<br/><br/>A Backup named <b>".$backup."</b> was created in /SpliceCom/ftp prior to this update<br/>";
	
	$telephone = $_REQUEST['telephone'];
	$type = $_REQUEST['type']; 	$method = $_REQUEST['method']; $del = isset($_REQUEST['del']) ? $_REQUEST['del'] : '';
	$tp = array("","Telephone","Email","SMS","Lamp","Archive","Archive Email","SMS Web","Custom Email");
	$mt = array("None","Alert","Deliver","Copy","Access","Prompt","Deliver and Delete","Deliver New","Deliver Link");
	
	foreach ($select as $key => $value) {
		echo "<br/>$mode Selected : <b>".$value."</b><br/>";

	if ($del) {
            $sr=ldap_search($ds,"cn=$value,cn=$modes","(objectclass=voicemailcontact)",array('guid'));
				$vm = ldap_get_entries($ds, $sr);
                 for ($d=0; $d<$vm['count']; $d++) {
	     			$dn = "guid=".$vm[$d]['guid'][0].", cn=$value, cn=$modes";
					ldap_delete($ds, "$dn");
			}
		}

	for ($n=0; !empty($telephone[$n]) && isset($type[$n]) && isset($method[$n]); $n++) {

	$ent = array(); $ent["type"] = $type[$n]; $ent["method"] = $method[$n]; $ent["objectclass"]= "voicemailcontact";

	$dn = "telephonenumber=".$telephone[$n].",cn=".$value.", cn=$modes";
	ldap_add($ds, $dn, $ent);
	echo "Telephone Number: <b>".$telephone[$n]."</b> Type: <b>".$tp[$type[$n]]."</b> Method: <b>".$mt[$method[$n]]."</b> - Voicemail Contact Added<br/>";
	}
	if ($del) echo "All Old Voicemail Contacts Have Been Deleted.</br>";
	}
}


if (!empty($_REQUEST['addvmemail']) && $_REQUEST['addvmemail']=="addvmemail") {
	$type = $_REQUEST['type']; 	$method = $_REQUEST['method']; 
	$tp = array("","Telephone","Email","SMS","Lamp","Archive","Archive Email","SMS Web","Custom Email");
	$mt = array("None","Alert","Deliver","Copy","Access","Prompt","Deliver and Delete","Deliver New","Deliver Link");
	
	echo "<h2> Users - Voicemail to Email </h2>";
	echo "Voicemail Contact Type: <b>$tp[$type]</b></br>";
	echo "Voicemail Contact Method: <b>$mt[$method]</b></br></br>";
	
if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
	$backup = "Backup ".date('d.m.y His')." - Pre{$mode}VMContactAdd.txt";
	$ent["dobackupto"][0] = $backup;
	ldap_modify($ds,"cn=Commands", $ent);
	ldap_modify($ds,"cn=Commands", $ent); $ent='';
	} else {
		echo "<script>$('#backup').prop('checked', false);</script>";
	}

if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") echo "<br/><br/>A Backup named <b>".$backup."</b> was created in /SpliceCom/ftp prior to this update<br/>";	
	
	
function numrange($str) {
	$tmp = explode(',', $str);
	$nums = array();
foreach ($tmp as $el)
{
    $a = explode('-', $el);
    if (count($a) == 1)
    {
	    $nums[] = (int)$a[0];
    }
    else
    {
        for ($i = $a[0]; $i <= $a[1]; ++$i)
        {
            $nums[] = (int)$i;
        }
    }
}
return array_unique($nums);
}
	
if (strtolower($_REQUEST['extn_range'])== "all") {
	$sr=@ldap_list($ds,"cn=Users","(objectclass=user)",array('telephonenumber'));
	$info=ldap_get_entries($ds,$sr);
		for($n=0; $n<$info['count'];$n++) {
			$range[]=(int)$info[$n]['telephonenumber'][0];
		}
} else {
	$range = numrange($_REQUEST['extn_range']);
}

	
	foreach ($range as $key => $extn) {
	$sr = ldap_search($ds,"cn=users","(&(objectclass=*)(telephonenumber=$extn))",array('cn','mail'));
   		$info = ldap_get_entries($ds, $sr); 
 	   		for ($m=0; $m<$info['count']; $m++) {
				$cn = $info[$m]['cn'][0];
				$email = $info[$m]['mail'][0];
				if (strlen($info[$m]['mail'][0])>0) {
					$ent = array(); $ent["objectclass"]= "voicemailcontact";
					$ent["type"] = $type; $ent["method"] = $method;
					$dn = "telephonenumber=$email,cn=$cn, cn=Users";
					ldap_add($ds, $dn, $ent);
					echo "<b>$cn</b> - Email Address: <b>$email</b> - Voicemail Contact Added<br/>";
				} else {
					if (isset($cn)) echo "<b>$cn</b> - Skipped No Email Address Set<br/>";
				}
			}
	}
		
}
?>
</div>
