<?php
session_start();
// v2.65
//PJC 11DEC2018 Update to preg_replace
//PJC 01MAY2018 Update MAC Address Search for Yealink
//PJC 07DEC2017 Update MAC Address Search
//PJC 23MAY2017 Update MAC Address Search
//PJC 26-JAN-2017 Link Updates
//PJC 09-Sept-2014 - arrays.
//PJC 02-Sept-2014 - expanded search to include modules.
//PJC 16Jan2013
$page_id = "010";
include ".access.php";
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
$type = 'mac';

if ($_REQUEST['type'] == "ip")  { 
	$search = $_REQUEST['search']; 
	$type = 'ip'; 
}
if ($_REQUEST['type'] == "mac") { 
	$input = $_REQUEST['search'];
	$search = preg_replace("/[^A-Fa-f0-9]/", "", $_REQUEST['search']);
	$search = (substr($search, 0, 6) === '001565' || substr($search, 0, 3) === '805') ? $search  : wordwrap($search,2 , "-",1); 
	$type = 'mac'; 
}
?>
<html>
<head>
<title>IP Or MAC Address - Search Config</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_addresssearch.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>
<div style="position:absolute; top:30px; right:8px" >
<?php link_check("029","<a href='extension_list.php' target='_blank'>Extension List</a>", $ma_acl); ?>
</div>
<div id="contain">
<h2><img src='images/settings.png' style="vertical-align:middle;">&nbsp;IP Or MAC Address - Search Config</h2>
This script allows you to find either a MAC or IP Address Addresses with in the CallServer Config.<br><br>
It will accept MAC Addresses in the following formats : <br>
xxxxxxxxxxxx<br>
xx-xx-xx-xx-xx-xx<br>
xx:xx:xx:xx:xx:xx<br>
Or any partial match. eg: entering 00-07-d9 will find any Phone that has a MAC Address containing 00-07-d9<br><br>
You can search for full or partial IP Address matches. eg : 192.168 will search for any Phone that has an IP Address containing 192.168<br><br>
Each result links to the relevant entry in the Manager interface.<br><br>
<table border="1" width="450" class='display' id='example' cellspacing="0" cellpadding="0" bordercolordark="#000000" bordercolorlight="#000000" style="border-collapse: collapse">
<form method="post">
		<thead><th colspan="2">Address Search</th></thead>
	</tr>
	<tr>
		<td width="75%"><p align="center"><input type="text" name="search" size="35" value="<?php if (isset($input)) echo $input ?>"></td>
		<td width="25%"><p align="center">IP 
		<input type="radio" value="ip" name="type" <?php if (isset($type) && $type === 'ip') echo 'checked' ?>>
		&nbsp;MAC <input type="radio" value="mac" name="type"  <?php if (isset($type) && $type === 'mac') echo 'checked' ?>></td>
	</tr>
		<tr colspan="2">
		<td colspan="2"><p align="center"><input type="submit" value="Search"></td>
	</tr>
</form>
</table><br><br>
<?php
if (isset($_REQUEST['search'])){
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}
	

$find = array("cn=1,", ",cn=Modules", "cn=", "Modules.", "Users.", "SerialNumber=" );
$replace = array("", "", " ", "", "", "");
if (strlen($search) > 1 ) {
		$sr=@ldap_list($ds,"cn=Modules","(&(objectclass=Module)(modulestatus=0)(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19)))",array('cn','guid'));
   		$info=ldap_get_entries($ds,$sr);
   		for($n=0; $n<$info['count'];$n++) {
			$units[$info[$n]['guid'][0]] = $info[$n]['cn'][0];
   		}
		
	   $sr = ldap_search($ds,"cn=Registrations","(&(objectclass=*)(|(|(hardwareid=*".$search."*)(serialnumber=*".$search."*)(ipaddress=*".$search."*))))");
 	   $info = ldap_get_entries($ds, $sr);  $page="";
 	   if ($info['count'] >0) {
       		echo "<br><u>Registrations Matching</u> : <b>".$search."</b><br>";
 	   		for ($m=0; $m<$info['count']; $m++) {
	 	   		$object = $info[$m]['object'][0]; $cn = $info[$m]['cn'][0]; $ip = $info[$m]['ipaddress'][0]; $prod = $info[$m]['productversion'][0];

	 	   		if (strstr($cn,"BRI") || strstr($cn,"PRI") ) { $page = "trunk"; }
	 	   		elseif (strstr($cn,"User")) { $page = "user"; }
	 	   		elseif (strstr($cn,"Voice")) { $page = "voicemailport"; }
	 	   		else $page = "module";
				$dn = str_replace($find, $replace, $info[$m]['dn']);

				if (strstr($dn,",")) {
					$parts = (explode(",",$dn));
					echo "<li><a href='../manager.cgi?pagename=$page&index=$object' target='_blank' alt='$ip - $prod' title='$ip - $prod'>".$parts[0]."</a><br>";
				} else {
					echo "<li><a href='../manager.cgi?pagename=$page&index=$object' target='_blank' alt='$ip - $prod' title='$ip - $prod'>".$dn."</a><br>";
				}

			}
		echo "<br>";
	}

	 $sr=@ldap_search($ds,"cn=Modules","(objectclass=phone)",array('cn','guid','location','productversion'));
   		$info=ldap_get_entries($ds,$sr); $dn=$phoneguid=$loc=$cn=$prod=array();
   		for($n=0; $n<$info['count'];$n++) {
	   		$dn[] = $info[$n]['dn']; $phoneguid[] = $info[$n]['guid'][0];
			$loc[] = $info[$n]['location'][0]; $cn[] = $info[$n]['cn'][0]; 
			$prod[] = $info[$n]['productversion'][0];
   		}
   	echo "<br><u>IP Phones Matching</u> : <b>$input</b><br>";
	
   	foreach ($dn as $phonek => $phonev) {
		$sr = ldap_search($ds,"$phonev","(&(objectclass=*)(|(|(|(|(|(hardwareid=*$search*)(serialnumber=*$search*)(cn=*$search*)(hardwareid=*$input*)(serialnumber=*$input*)(hardwareid=*$input*)))))))");
 	 	$info = ldap_get_entries($ds, $sr);

    if ($info['count'] >0) {
	   		echo "<li><a href='../manager.cgi?pagename=phone&index=$phoneguid[$phonek]' target='_blank' alt='{$prod[$phonek]}' title='{$prod[$phonek]}'>{$cn[$phonek]}</a> - {$units[$loc[$phonek]]}<br>";
			}
	  }
	  
       $sr = ldap_search($ds,"cn=Unassignedphones","(&(objectclass=*)(|(hardwareid=*".$search."*)(serialnumber=*".$search."*)))");
 	   $info = ldap_get_entries($ds, $sr);  $page="";

 	   if ($info['count'] >0) {
 	   	    echo "<br><u>Unassigned Phones Matching</u> : <b>".$search."</b><br><br>";
 	   		for ($m=0; $m<$info['count']; $m++) {
	 	   		$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
	 	   		$serialnumber = $info[$m]['serialnumber'][0];
	 	   		echo "<li><a href='../manager.cgi?pagename=uphone&index=$guid' target='_blank' alt='$cn' title='$cn'>".$serialnumber."</a><br>";
			}
		echo "<br>";
		}	  
	  
	   $sr=@ldap_search($ds,"cn=Modules","(&(objectclass=module)(|(|(ipaddress=*$search*)(serialnumber=*$search*)(cn=*$search*))))",array('cn','guid','location','productversion','serialnumber','ipaddress'));
   	   $info=ldap_get_entries($ds,$sr);
			
   	   	if ($info['count'] >0) {
	   	   	echo "<br><u>Modules Matching</u> : <b>".$search."</b><br>";
   	   
   		for($n=0; $n<$info['count'];$n++) {
	   		$modguid = $info[$n]['guid'][0]; $cn = $info[$n]['cn'][0];
	   		$prod = $info[$n]['productversion'][0]; $serial = $info[$n]['serialnumber'][0]; 
	   		$loc = ($info[$n]['location'][0] == "00000000-0000-0000-0000-000000000000") ? "Not Set" : $units[$info[$n]['location'][0]];

	   		echo "<li><a href='../manager.cgi?pagename=module&index=$modguid' target='_blank' alt='{$prod}' title='{$prod}'>{$cn}</a> - {$loc}<br>";
		}
	  }
	}// search
}
?>
</div>
</body>
</html>
