<?php 
session_start();
include "../.access.php"; 
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<title>Help - File Import / Export</title>
<head>
<script type="text/javascript">
	var state = {};
	var title = 'Help';
	var url   = '/manager/assist/help';
	history.pushState(state, title, url);
</script>
<link href="/manager/assist/css/Styles.css" rel="stylesheet" type="text/css">
<script src="/manager/assist/js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script type="text/javascript">
$(function() {
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});

	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
});
</script>
</head>
<body>
<div id="toTop">^ Back to Top</div>
<div id="contain">
<h2><img src='/manager/assist/images/help.png' style="vertical-align:middle;">&nbsp;Help - File Import / Export</h2>
<b>File Import / Export</b><br/>
This page provides a simple method to import and export various settings to and from the system.<br/><br/>
All files are imported or exported to /SpliceCom/ftp<br/><br/>

<?php 
if ($manager_user == "Manager") {
	$import_list = "Area Codes, Contacts, Dial Plan, DDIPlan, LCR Plan and Users";
} else {
	$arr = array();
		if (strpos($ma_acl,'061a') !== false) $arr[] =  'Area Codes';
		if (strpos($ma_acl,'061b') !== false) $arr[] =  'Contacts';
		if (strpos($ma_acl,'061c') !== false) $arr[] =  'Dial Plan';
		if (strpos($ma_acl,'061d') !== false) $arr[] =  'DDIPlan';
		if (strpos($ma_acl,'061e') !== false) $arr[] =  'LCR Plan';
		if (strpos($ma_acl,'061f') !== false) $arr[] =  'Users';
		$last = array_pop($arr);
		$import_list = count($arr) ? implode(", ", $arr) . ' and ' . $last : $last;
	}
?>

The supported entries for importing and exporting are: <?php echo $import_list ?>.<br/><br/>


Where applicable the following configuration options are available and can be selectively enabled.<br/><br/>
Text Field - 'Use this Plan'.  This field can be used to specify which entity to import or export to and from.<br/><br/>
When using the import function there are some fields that, due to the nature of an LDAP database, will not import without some extra options being enabled, these are:-<br/><br/>
<b>Import option:</b><br/>
If file being imported came from recent export taken from this Call Server the extra fields will import fine<br/><br/>

If the file being imported is from a different Call Server there needs to be an existing entry in the table and this option will copy the extra fields from that entry to all the entries being imported.<br/><br/>
<b>Export option:</b><br/>
This option is used when exporting the table and will reformat telephone numbers so that Excel can be used for editing the file without losing any of the leading zeros from telephone numbers.<br/><br/>

<b>Import</b><br/>
Imports the selected values from a comma seperated variable (csv) file. The file needs to be located in /SpliceCom/ftp and needs to named as follows.<br/>

<?php 
if ($manager_user == "Manager") {
	$import_ma = "<b>Area Codes:</b> areacodes.txt<br/><b>Contacts:</b> contacts.txt<br/><b>Dial Plan:</b> dialplan.txt<br/><b>DDIPlan:</b> ddiplan.txt<br/><b>LCR Plan:</b> lcrplan.txt<br/>";
} else {
	$arr = array();
		if (strpos($ma_acl,'061a') !== false) $arr[] =  '<b>Area Codes:</b> areacodes.txt<br/>';
		if (strpos($ma_acl,'061b') !== false) $arr[] =  '<b>Contacts:</b> contacts.txt<br/>';
		if (strpos($ma_acl,'061c') !== false) $arr[] =  '<b>Dial Plan:</b> dialplan.txt<br/>';
		if (strpos($ma_acl,'061d') !== false) $arr[] =  '<b>DDIPlan:</b> ddiplan.txt<br/>';
		if (strpos($ma_acl,'061e') !== false) $arr[] =  '<b>LCR Plan:</b> lcrplan.txt<br/>';
		$last = array_pop($arr);
		$import_ma = count($arr) ? implode("", $arr) . $last : $last;
	}
echo $import_ma."<br/>";
?>

<b>Remove</b><br/>
Undo the last import removing any entries listed in the import file. This can be useful if you imported the list twice for example.<br/><br/>

<b>Export</b><br/>
Export all entries to a comma seperated variable (csv) file located in /SpliceCom/ftp  The previous contents of this file will be lost. The files creates are: <br/>
<?php 
if ($manager_user == "Manager") {
	$export_ma = "<b>Area Codes:</b> areacodes.out.txt<br/><b>Contacts:</b> contacts.out.txt<br/><b>Dial Plan:</b> dialplan.out.txt<br/><b>DDIPlan:</b> ddiplan.out.txt<br/><b>LCR Plan:</b> lcrplan.out.txt<br/><b>Users:</b> users.out.txt<br/>";
} else {
	$arr = array();
		if (strpos($ma_acl,'061a') !== false) $arr[] =  '<b>Area Codes:</b> areacodes.out.txt<br/>';
		if (strpos($ma_acl,'061b') !== false) $arr[] =  '<b>Contacts:</b> contacts.out.txt<br/>';
		if (strpos($ma_acl,'061c') !== false) $arr[] =  '<b>Dial Plan:</b> dialplan.out.txt<br/>';
		if (strpos($ma_acl,'061d') !== false) $arr[] =  '<b>DDIPlan:</b> ddiplan.out.txt<br/>';
		if (strpos($ma_acl,'061e') !== false) $arr[] =  '<b>LCR Plan:</b> lcrplan.out.txt<br/>';
		if (strpos($ma_acl,'061f') !== false) $arr[] =  '<b>Users:</b> users.out.txt<br/>';
		$last = array_pop($arr);
		$export_ma = count($arr) ? implode("", $arr) . $last : $last;
	}
echo $export_ma."<br/>";
?>

<b>Export & Delete</b><br/>
As export but the selected values will be also be deleted from the system.<br/><br/>

</div>
</body>
</html>