<?php
// v2.8
// PJC 20-AUG-2018 Added Yealink Support
// PJC 26-JAN-2017 Link Updates
// PJC 20/02/2015 Update for Alternate MAC Address Formatting.
// PJC 06/02/2015 Added support for Alternate MAC Address Formatting. 0007d9001234, 00-07-d9-00-12-34, 00:07:d9:00:12:34 etc
// PJC 29/08/2014 Added system backup and add checking against new entries in form
// PJC 04/06/2014 Updated Array creation - mac address lowercase
// PJC 15-05-2014 updated phone serial number
// PJC 18-03-2014 added closing DIV
// PJC 11-02-2014 fixed MAC Address field size
// PJC 11-02-2014 fixed CSV detection in Safari
session_start();
$page_id = "062";
include ".access.php";
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
<title>Import Members</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<link href="log/alert.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/wiz/extra.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script src="js/wiz/jquery.validate.js" type="text/javascript"></script>
<script src="js/wiz/jquery.validation.functions.js" type="text/javascript"></script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
<script type="text/javascript">
$(document).ready(function() {
	$('input[class="name"]').focusout(function () {
		var check = ($(this)).val(); var checkid = $(this).attr('id');
		$('.name').not($(this)).each(function (index) {
			var test = $(this).val();
			if (check === test) { $('#' + checkid).focus(); $('#' + checkid).css('background-color', '#FF4040'); }
		});
    });
    $('input[class="extn"]').focusout(function () {
		var check = ($(this)).val(); var checkid = $(this).attr('id');
		$('.extn').not($(this)).each(function (index) {
			var test = $(this).val();
			if (check === test) { $('#' + checkid).focus(); $('#' + checkid).css('background-color', '#FF4040'); }
		});
    });
});
</script>
</head>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_importmembers.php','help','700','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<div id="contain">
<h2><img src='images/settings.png' style='vertical-align:middle;'>&nbsp;Import Members</h2>
This script is used to load a CSV file for the bulk creating of Devices and/or Users. The script is not case sensitive for MAC Addresses or Username entires.<br/><br/>
The entries from the file will be displayed in a form below. Any usernames or extensions that are currently in use on the system will be highlighted in RED.<br/><br/>
If the model is a PCS device and the first 6 characters of the MAC address are NOT 00-07-d9 the script will automatically correct them and highlight the field YELLOW to show this has been changed. The last 6 characters of the MAC address can be entered into the form. If any invalid characters are entered the field will turn RED.<br/><br/>
If a DialPlan or Company name does not exist in the CallServers configuration the values will be as default. (DialPlan = Standard, Company = Blank). If the UserName field is empty then no user will be created and only the device will be added.<br/><br/>
<?php
$script=$_SERVER['SCRIPT_NAME'];

	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}


//list of existing items
$sr = ldap_list($ds,"cn=Users","(objectclass=user)",array('cn','telephonenumber'));
$info = ldap_get_entries($ds,$sr); for ($n=0; $n<$info['count']; $n++) { $existingusers[]=strtolower($info[$n]['cn'][0]); $existingextn[]=$info[$n]['telephonenumber'][0]; }

$sr = ldap_list($ds,"cn=Departments","(objectclass=department)",array('cn','telephonenumber'));
$info = ldap_get_entries($ds,$sr); for ($n=0; $n<$info['count']; $n++) { $existingusers[]=strtolower($info[$n]['cn'][0]); $existingextn[]=$info[$n]['telephonenumber'][0]; }

$sr = ldap_list($ds,"cn=DialPlans","(objectclass=dialplan)",array('cn','guid'));
$info = ldap_get_entries($ds,$sr); for ($n=0; $n<$info['count']; $n++) { $existingdialplans[$info[$n]['cn'][0]] = $info[$n]['guid'][0]; }

$sr = ldap_list($ds,"cn=Modules","(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19))",array('cn','guid'));
$info = ldap_get_entries($ds,$sr); for ($n=0; $n<$info['count']; $n++) { $existinghome[$info[$n]['cn'][0]] = $info[$n]['guid'][0]; }

$sr = ldap_list($ds,"cn=Companies","(objectclass=company)",array('cn','guid'));
$info = ldap_get_entries($ds,$sr); for ($n=0; $n<$info['count']; $n++) { $existingcompanies[$info[$n]['cn'][0]] = $info[$n]['guid'][0]; }


echo "<form method='post' enctype='multipart/form-data' action='$script'>";
echo "<label for='file'>Filename: </label>";
echo "<input type='file' style='font-size: 10pt; font-family: Tahoma' name='file' id='file' accept='.csv, text/plain, application/txt, text/csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel' size='50'/> <input type='submit' name='upload' value='Upload' />&nbsp;<a href='#' class='tooltip' title='Select The CSV File |To Be Uploaded'><img src='images/tooltip.jpg'></a></form><br/>";
echo "</form>";

if (isset($_REQUEST["upload"])) {
if ($_FILES["file"]["error"] > 0) {
$file_errors = array("There is no error, the file uploaded with success","The uploaded file exceeds the upload_max_filesize directive in php.ini","The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form","The uploaded file was only partially uploaded","No file was uploaded","Missing a temporary folder","Failed to write file to disk","A PHP extension stopped the file upload");
echo "Sorry there has been an error.<br />";
echo "Return Code: <b>" . $file_errors[$_FILES["file"]["error"]] . "</b><br />";
exit; }

// open file if it exisits
$file = fopen($_FILES["file"]["tmp_name"], 'r');
if (!$file) exit("<b>No File Found</b>");

// check file layout
$line = trim(fgets($file));
if ($line != "MACADDRESS,USERNAME,EXTENSION,HOME,DIALPLAN,COMPANY,PARTNERLOGINCODE,MODEL,STUN") {
	echo "<b>Sorry This File Is Not In The Correct Format</b><br/>";
	echo "The file has to be a CSV file in the following format including the column headsers.";
	echo "<p>
			MACADDRESS,USERNAME,EXTENSION,HOME,DIALPLAN,COMPANY,PARTNERLOGINCODE,MODEL,STUN<br/>
			00-07-d9-00-12-34,John Smith,2001,CS5100,Standard,,1234,,<br/>
			00-07-d9-00-12-35,Sara Brown,2002,CS8000,DayTime,SupportCompany,1234,,<br/>
			001565121212,Mike Green,2003,CS8000,DayTime,SupportCompany,,T46G,1<br/>
		  </p>";
	exit();
}

// create arrays from csv values
$mac = $name = $extn = $home = $dialplan = $company = $plc = $model = $stun = array();
while (($line = fgetcsv($file,1024)) !== FALSE) {
  if (in_array("MACADDRESS",$line)) continue;
  list($mac[], $name[], $extn[], $home[], $dialplan[], $company[], $plc[], $model[], $stun[]) = $line;
}
fclose($file);


echo "<form id='frm1' method='post' action='$script' >";
echo "<div class='statictable'>";
echo "<table cellspacing='0'><th>MAC Address</th><th>User Name</th><th>Extension</th><th>HOME</th><th>DialPlan</th><th>Company</th><th>PartnerLoginCode</th><th>model</th><th>STUN</th>";
foreach($mac as $k => $mac) {
	
	
	$mac = preg_replace("/[^a-zA-Z0-9]/", "", $mac);
	$checkmac = substr($mac, 0, 6);
	$checktype = ($checkmac == '0007d9') ? 'PCS' : 'yealink';
	
	if (!in_array($checkmac, array('0007d9', '001565', '805ec0'))) continue;
		
 	if (strlen($mac) >=12) { 
		if ($checktype == 'PCS') {
			$mac = chunk_split($mac, 2, '-');
			$mac = rtrim($mac, "-");
		}
	} 
	
	if ($checktype == 'PCS') {
		$val = substr($mac, -8);
		echo "<tr><td>00-07-d9 <input type='text' name='mac2[]' size='8'"; if(substr(strtolower($mac),0,8)!="00-07-d9") echo "background-color:#FF4040"; echo "' maxlength='8' value='$val'></td>";
	} else {
		echo "<tr><td>Yealink <input type='text' name='mac2[]' size='9' maxlength='8' value='$mac'></td>";
	}

	echo "<td><input type='text' name='name[]' id='name$k' class='name' placeholder='Extn 1234' size='8' value='$name[$k]' onkeyup=\"username(this)\""; if (in_array(strtolower($name[$k]), $existingusers)) echo "style='background-color:#FF4040'"; echo "</td>";
	echo "<td><input type='text' name='extn[]' id='extn$k' class='extn' placeholder='1234' size='8' value='$extn[$k]' onkeyup=\"userextn(this)\""; if (in_array($extn[$k], $existingextn)) echo "style='background-color:#FF4040'"; echo "</td>";

	echo "<td><select name='home[]' id='home'>";
		foreach ($existinghome as $hmk => $hmv){
			echo "<option value='{$hmv}' "; if ($home[$k]===$hmk) echo 'selected'; echo ">{$hmk}</option>";
	   		} 	echo "</select></td>";

	echo "<td><select name='dialplan[]' id='dialplan'>";
		foreach ($existingdialplans as $dpk => $dpv){
			echo "<option value='{$dpv}' "; if (!array_key_exists($dialplan[$k], $existingdialplans)) $dialplan[$k] = 'Standard'; if ($dialplan[$k]===$dpk) echo 'selected'; echo ">{$dpk}</option>";
	   		} 	echo "</select></td>";

	echo "<td><select name='company[]' id='company'><option></option>";
		foreach ($existingcompanies as $cpk => $cpv){
			echo "<option value='{$cpv}' "; if ($company[$k]===$cpk) echo 'selected'; echo ">{$cpk}</option>";
	   		} 	echo "</select></td>";

	if ($checktype == 'PCS') {
		echo "<td><input type='text' name='plc[]' id='plc' value='$plc[$k]' placeholder='1234' size='8'/></td>";
	} else {
		echo "<td><input type='text' name='plc[]' id='plc' value='' placeholder='not used' size='8' readonly /></td>";
	}
	
	echo "<td><input type='text' name='model[]' id='model' value='$model[$k]' placeholder='' size='8'/><input type='hidden' name='type[]' id='type' value='$checktype'/></td>";
	
	if ($checktype == 'PCS') {
		echo "<td><input type='text' name='stun[]' id='stun' value='' placeholder='not used' size='8' readonly /></td>";
	} else {
		echo "<td><select name='stun[]' style='width:95px'>";
			echo "<option value='0'>No</option>";
			echo "<option value='1' "; if ($stun[$k] == '1') echo 'selected>'; echo "Yes</option>";
		echo "</select></td>";
	}
	
}
echo "</div></table>";
	echo "<br/>Create System Backup : <input type='checkbox' name='backup' id='backup' checked />";
	echo "<br/><br/><input type='submit' name='submit' id='submit' value='Make Member' onClick=\"return confirm('Add Selected Phones ?')\">";
	echo "<input type='hidden' name='add' value='add'></form>";

} // close file upload
?>
</div>
</body>
</html>

<?php
if (isset($_REQUEST['add']) && strlen($_REQUEST['add'])>=1 ) {
	
	if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
	$backup = "Backup ".date('d.m.y His')." - PreImportMembers.txt";
	$ent["dobackupto"][0] = $backup;
	ldap_modify($ds,"cn=Commands", $ent);
	ldap_modify($ds,"cn=Commands", $ent); $ent='';
	}

echo "<div id='contain'><h3>ADDING</h3>";
$mac2 = $_REQUEST['mac2']; $name = $_REQUEST['name']; $extn = $_REQUEST['extn']; $home = $_REQUEST['home'];
$dialplan = $_REQUEST['dialplan']; $company = $_REQUEST['company']; $plc = $_REQUEST['plc']; 
$model = $_REQUEST['model']; $type = $_REQUEST['type']; $stun = $_REQUEST['stun'];


foreach ($mac2 as $mk => $mv) {

	// Create Phone Object
		$homeloc = array_search($home[$mk], $existinghome);
		
		$att=array('objectclass'=>'Phone','location'=>$home[$mk]);
		
		if ($type[$mk] == 'PCS') {
			echo "PCS ";
			$att['typeOfPhone'] = '2';
			$att['description'] = 'Proactive Communication Station';
			$dn = "cn=PCS 00-07-d9-".strtolower($mv).",cn=$homeloc, cn=modules";
		} else {
			echo "Yealink ";
			$att['typeOfPhone'] = '3';
			$att['description'] = 'SIP Device';
			$dn = "cn=SIP ".strtolower($mv).",cn=$homeloc, cn=modules";
		}

		ldap_add($ds, "$dn",$att);

	// Add cn=1 to phone object
	
		if ($type[$mk] == 'PCS') {
			$att=array('objectclass'=>'SplicePhone','serialnumber'=>"00-07-d9-".strtolower($mv),'partnerlogincode'=>$plc[$mk], 'pnpmodel'=>$model[$mk]);
			$dn = "cn=1,cn=PCS 00-07-d9-".strtolower($mv).",cn=$homeloc, cn=modules";
		} else {
			$pnpmodel = strtoupper($model[$mk]);
			$pnpmodel = str_replace( array('SIP', ''), array('-', ''), $pnpmodel );
			$pnpmodel = "SIP-$pnpmodel";
			$att=array('objectclass'=>'GenericIPPhone','serialnumber'=>strtolower($mv), 'pnpvendor'=>'yealink', 'pnpmodel'=>$pnpmodel);
			
			if ($stun[$mk] == '1') {
				$att['usestun'] = '1';
				$att['stunaddr'] = 'stun.splicecom.com';
				$att['stunport'] = '3478';
			}
			
			$dn = "cn=1,cn=SIP ".strtolower($mv).",cn=$homeloc, cn=modules";
		}
		
		ldap_add($ds, "$dn",$att);

	//find phones GUID.
		if ($type[$mk] == 'PCS') {
			$sr = ldap_read($ds,"cn=PCS 00-07-d9-".strtolower($mv).", cn=$homeloc,cn=modules","objectclass=Phone"); 
		} else {
			$sr = ldap_read($ds,"cn=SIP ".strtolower($mv).", cn=$homeloc,cn=modules","objectclass=Phone"); 
		}
	   $info = ldap_get_entries($ds,$sr);
	   $guid = $info[0]['guid'][0];


if (strlen($name[$mk])>=1) {
	// home IP Address
		$sr = ldap_search($ds,"cn=Modules","(&(objectclass=*)(guid=$home[$mk]))"); $info = ldap_get_entries($ds,$sr); $homeip = $info[0]['ipaddress'][0];

	// create user
		$newuser = array('objectclass'=>'user','noanswertime'=>'20','loginidletime'=>'18000','description'=>'Users Description',
						 'company'=>$company[$mk],'telephonenumber'=>$extn[$mk],'initialphone'=>$guid,'dialplan'=>$dialplan[$mk],'homepage'=>"http://{$homeip}/index.php?u=%u&e=%e&p=%p",'currenthome'=>$home[$mk]);
		ldap_add($ds,"cn=$name[$mk],cn=users",$newuser); $newuser="";

	// find userguid
		$sr = ldap_list($ds,"cn=users","(&(objectclass=user)(telephonenumber=$extn[$mk]))"); $info = ldap_get_entries($ds,$sr);
	    $userguid = $info[0]['guid'][0];
		}

		
if (strlen($name[$mk])>=1) {
		$link = ($type[$mk] == 'PCS') ? "PCS 00-07-d9-".strtolower($mv) : "SIP ".strtolower($mv);
			echo "Device Added: <a href='../manager.cgi?pagename=phone&index=$guid' target='_blank'>$link</a> Username: <a href='../manager.cgi?pagename=user&index=$userguid' target='_blank'>$name[$mk]</a> / Extension: <b>$extn[$mk]</b><br/>";
		  	} else {
			echo "Device Added: <a href='../manager.cgi?pagename=phone&index=$guid' target='_blank'>$link</a><br/>";
		}
	}
			echo "<br/><br/>Licences can be applied to the users via the <a href='../ul.php' target='_blank'>System Licences - View User Status Page</a>.<br/>";
}
?>
</div>
<script>
$(function(){
$("input[name='mac2[]']").bind("change keyup", function() {
var color = ($(this).val().match(/[^a-fA-F0-9-]/)!=null) ? "#FF4040" : "#FFFFFF";
$(this).css("background-color", color);
if (this.value.indexOf("-") == this.value.length - 1) $(this).val($(this).val().slice(0, -1));
if ($(this).val().length == 2 || $(this).val().length == 5) $(this).val($(this).val()+"-");
if ($(this).val().match(/-/g).length >2) $(this).val($(this).val().replace($(this).val(),''));
	});
});
</script>
<div class="overlay" id="overlay" style="display:none;"></div>
        <div class="alert" id="alert">
            <a class="alertclose" id="alertclose"></a>
			<a class="alertOK" id="alertOK"></a>
            <h1>Warning</h1>
            <p>
            Importing a large number of devices and users, uses additional system resources and could cause system instability.<br/><br/>
           	We suggest uploading is only done out of hours or during quiet periods..<br/><br/>
            Please select the <span style="color:#329C24; font-weight:bold";>Green Tick</span> to proceed, otherwise select the  <span style="color:#605F61; font-weight:bold";>Grey X</span> to return to Manager Assist.</p>
           </p>
</div>

<?php if (!isset($_SESSION['import_member'])) {?>
<script type="text/javascript">
		$(function() {
			$('#overlay').fadeIn('fast',function(){
            $('#alert').animate({'top':'100px'},500);
        });
        $('#alertclose').click(function(){
           	$('#alert').animate({'top':'-600px'},500,function(){
            $('#overlay').fadeOut('fast');
            document.location.href='assist.php';
        	});
        });
        $('#alertOK').click(function(){
   	    	$.ajax({ url : 'log/reset.php?import_member=1' });
        	$('#alert').animate({'top':'-600px'},500,function(){
        	$('#overlay').fadeOut('fast');
           	});
        });
		});
</script>
<?php 
 }
?>
