$(document).ready(function() {
	
	customNames = []; 
	customNumbers = [];
	customDesc = [];
	existingArray = [];
	
	$.ajax({
		url: "bulksave.php?mode=existingmembers",
		cache: false,
        async: false,
		success: function(data){
			existingArray = JSON.parse(data)
		}
	});	
	console.log(existingArray)
	$("#dept_no").slider({
		value: 1, 
		min: 1,
		max: 250,
		step: 1,
		range: "min",
		slide: function( event, ui ) {
			$( "#amount" ).val( ui.value );
			$(this).find('.ui-slider-handle').text(ui.value);
		},
		change: function( event, ui ) {
			sliderTableCreate(ui.value);
		},
		create: function(event, ui) {
			var v=$(this).slider('value');
			$(this).find('.ui-slider-handle').text(v);
			sliderTableCreate(v);
		}
	});
	
	function sliderTableCreate(str) {
		currentRows = ($("#customTb > tr").length )
		newRows = str;
		baseName = $('#dept_name').val();
		baseNumber = $('#dept_number').val();
		baseDesc = $('#dept_desc').val();
		console.log ('current: ' + currentRows + ' new: ' + newRows)
		
		if (currentRows < newRows) {
			diff = newRows - currentRows;
			console.log ('more diff: ' + diff)
			
			count = currentRows + 1;
			for (var i = count; i <= newRows; ++i) {
				name = baseName + '_' + pad(i, 3);
				number = ($.isNumeric(baseNumber)) ? parseInt(baseNumber) + parseInt(i) : '';
				
				new_row = "<tr id='" + i + "'>" +
					"<td><input type='text' class='name' id='custom_name" + i + "' name=custom_name[]' value='" + name + "'></td>" +
					"<td><input type='text' class='number' id='custom_num" + i + "'  name=custom_num[]' value='" + number + "'></td>" + 
					"<td><input type='text' class='description' id='custom_desc" + i + "' name=custom_desc[]' value='" + baseDesc + "'></td>" +
				"</tr>";
				$('#custom tbody').append(new_row);
			}
		}
		
		if (currentRows > newRows) {
			diff = currentRows - newRows;
			console.log ('less  diff: ' + diff)
			for (var i = 1; i <= diff; ++i) {
				lastId = ($('#custom tr:last').attr('id'))
				
				if (jQuery.inArray("custom_name" + lastId, customNames) !== -1) {
					var index = customNames.indexOf("custom_name" + lastId);
					if (index > -1) customNames.splice(index, 1);
				}
				
				if (jQuery.inArray("custom_num" + lastId, customNumbers) !== -1) {
					var index = customNumbers.indexOf("custom_num" + lastId);
					if (index > -1) customNumbers.splice(index, 1);
				}
				
				if (jQuery.inArray("custom_desc" + lastId, customDesc) !== -1) {
					var index = customDesc.indexOf("custom_desc" + lastId);
					if (index > -1) customDesc.splice(index, 1);
				}
			    $('#custom tr:last').remove();
				
			}
		}
	}
	
	$('#dept_name').on('change', function(e) {
		e.preventDefault();
		$('.name').each(function(i, obj) {
			if ($.inArray(this.id, customNames) == -1)	{
				newName = $('#dept_name').val() + '_' + pad(i+1 ,3);
				$(this).val(newName)
			}
		})
	})
	
	$('#dept_number').on('change', function(e) {
		e.preventDefault();
		$('.number').each(function(i, obj) {
			if ($.inArray(this.id, customNumbers) == -1)	{
				newNumber = ($.isNumeric($('#dept_number').val())) ? parseInt($('#dept_number').val()) + parseInt(i+1) : '';
				$(this).val(newNumber)
			}
		})
	})
	
	$('#dept_name').on('blur', function(e) {
		var thisBaseName = this.value;
		var thisBaseNameLower = this.value.toLowerCase();
		var no = $('#dept_no').slider("option", "value") +1;

		for(i = 001; i < no; i++) { 
		i = pad(i,3);
		console.log(thisBaseNameLower + '_' + i)
			if ($.inArray(thisBaseNameLower + '_' + i, existingArray) !== -1){
				var n = noty({ type: 'error', layout: 'center', text: 'Department Name <b>' + thisBaseName + '_' + i + '</b> Already Exisits<br><br><i>(Click to Close)</i>', dismissQueue: true, theme: 'relax', modal: true }); 
				$('#create').prop('disabled', true);
				return false
			}
			$('#create').prop('disabled', false);
		}
	})
	
	$('#dept_number').on('blur', function(e) {
		var thisBaseNumber = parseInt(this.value) +1;	
		var no = $('#dept_no').slider("option", "value");
		
		for(i = thisBaseNumber; i < thisBaseNumber + no; i++) { 
		console.log(i)
			if ($.inArray(i, existingArray) !== -1){
				var n = noty({ type: 'error', layout: 'center', text: 'Extension Number <b>' + i + '</b> Already Exisits<br><br><i>(Click to Close)</i>', dismissQueue: true, theme: 'relax', modal: true }); 
				$('#create').prop('disabled', true);
				return false
			}
			$('#create').prop('disabled', false);
		}
	})
	
	$('#dept_desc').on('change', function(e) {
		e.preventDefault();
		$('.description').each(function(i, obj) {
			if ($.inArray(this.id, customDesc) == -1)	{
				newDesc = $('#dept_desc').val();
				$(this).val(newDesc)
			}
		})
	})
	
	
	$('#customTb').on('change', '.name', function(e) {
		if (e.originalEvent) {
			if ($.inArray(this.id, customNames) == -1) customNames.push(this.id) 
		}	
	})
	
	$('#customTb').on('change', '.number', function(e) {
		if (e.originalEvent) {
			if ($.inArray(this.id, customNumbers) == -1) customNumbers.push(this.id) 
		} 
	})
	
	$('#customTb').on('change', '.description', function(e) {
		console.log('description')
		if (e.originalEvent) {
			if ($.inArray(this.id, customDesc) == -1) customDesc.push(this.id) 
		}
	})
	
		
	// show / hide custom table
	$(".bulknames").click(function(e){
		e.preventDefault();
		$('.custom').toggle();
    });
	
	// show / hide alternate distribution
	$(".toggler").click(function(e){
        e.preventDefault();
        $('.alt').toggle();
		$(this).find('img').toggle();
		if ($('#mode').val() === '1') $('#altPri, #altPri2').hide();
		
    });
	
	// show / hide Voicemail
	$(".vmtoggler").click(function(e){
        e.preventDefault();
        $('.vmail').toggle();
		$(this).find('img').toggle();
    });
	
	// enable VM add messagebox licence
	 $('#dept_vmenabled').change(function() {
        if($(this).is(":checked")) {
			console.log ('checked')
            $('#dept_vmbox').prop('checked', true);
        } else {
			$('#dept_vmbox').prop('checked', false);
		}
    });
	
	// update alt distribution two when alternate distribution changes
	$('#dept_altdist_group').on('change', function() {
		selected = $(this).val();
		$('#dept_altdist_group_two').val(selected)
	})
	// update alt distribution two mode when alternate distribution mode changes
	$('#dept_altdist_mode').on('change', function() {
		selected = $(this).val();
		$('#dept_altdist_mode_two').val(selected)
	})
	
	// change from department / queue
	var mode = 'Department';
	$('#mode').on('change', function() {
		$('#dept_dist_group').val('');
		$('#dept_altdist_group,  #dept_altdist_mode, #dept_altdist_group_two, #dept_altdist_mode_two').val('');
		
		if ($(this).val() === '1') {
			mode = 'Department'
			$("#dept_dist_mode option[value*='5']").prop('disabled',true);
			$("#dept_altdist_mode option[value*='5']").prop('disabled',true);
			$("#dept_altdist_mode_two option[value*='5']").prop('disabled',true);
			$("#ooh_dist_mode option[value*='5']").prop('disabled',true);
			$('.department').show();
			$('.queue').hide();		
			$('.alt, #altPri, #altPri2').hide();			
			$('#dept_dist_mode').val('0');
			$('#create').val('Create Departments');
			$(".modename").each(function() {
			    $(this).html($(this).html().replace("Queue", "Department"));
				$(this).html($(this).html().replace("QUEUE", "DEPARTMENT"));
				$(this).html($(this).html().replace("queues", "departments"));
			})
			
		} else {
			mode = 'Queue'
			$("#dept_dist_mode option[value*='5']").prop('disabled',false);
			$("#dept_altdist_mode option[value*='5']").prop('disabled',false);
			$("#dept_altdist_mode_two option[value*='5']").prop('disabled',false);
			$("#ooh_dist_mode option[value*='5']").prop('disabled',false);
			$('.queue').show();	
			$('.department').hide();
			$('.alt').hide();
			$('#dept_dist_mode').val('5');
			$('#create').val('Create Queues');
			$(".modename").each(function() {
			    $(this).html($(this).html().replace("Department", "Queue"));
				$(this).html($(this).html().replace("DEPARTMENT", "QUEUE"));
				$(this).html($(this).html().replace("departments", "queues"));
			})
		}
	});
	
	// show vision annoucement modes
	$('#queue_announcementmode').on('change', function() {
		if ( $(this).val() > 0) {
			$('#queue_announcementMedia').css('display', 'inline-block');
		} else {
			$('#queue_announcementMedia').css('display', 'none');
		}
	});
	
	// restrict dept_number to be numeric only
	$('#dept_number').keypress(function(e) {
		if(isNaN(this.value+""+String.fromCharCode(e.charCode))) return false;
	})
	.on("cut copy paste",function(e){
		e.preventDefault();
	});
	
	// update MySQL server IP with Vision Server IP
	$('#queue_visionip').on('keyup blur', function() {
		$('#queue_mysqlip').val( this.value );
	});
	
	
	// create departments / queues
	$("#create").on('click', function(){
		
		// validation checking
		if (!validateForm('name')) { 
		var n = noty({ type: 'warning', layout: 'center', text: mode + ' All Custom Names Must Be Set<br><br><i>(Click to Close)</i>', dismissQueue: true, theme: 'relax', modal: true }); 
			return false; 
		};
		
		if (!validateForm('number')) { 
		var n = noty({ type: 'warning', layout: 'center', text: mode + ' All Custom Numbers Must Be Set<br><br><i>(Click to Close)</i>', dismissQueue: true, theme: 'relax', modal: true }); 
			return false; 
		};
		
		if ($('[name=dept_name]').val() == "") { 
			var n = noty({ type: 'warning', layout: 'center', text: mode + ' Base Name Must Be Set<br><br><i>(Click to Close)</i>', dismissQueue: true, theme: 'relax', modal: true }); 
			return false; 
		};
		if ($('[name=dept_number]').val() == "") { 
			var n = noty({ type: 'warning', layout: 'center', text: mode + ' Base Number Must Be Set<br><br><i>(Click to Close)</i>', dismissQueue: true, theme: 'relax', modal: true }); 
			return false; 
		};
		if ($('[name=dept_dist_group]').val() == "0") { 
			var n = noty({ type: 'warning', layout: 'center', text: mode + ' Distribution Group Must Be Set<br><br><i>(Click to Close)</i>', dismissQueue: true, theme: 'relax', modal: true }); 
			return false; 
		};
		if ($('[name=dept_dist_mode]').val() == "0") { 
			var n = noty({ type: 'warning', layout: 'center', text: mode + ' Distribution Mode Must Be Set<br><br><i>(Click to Close)</i>', dismissQueue: true, theme: 'relax', modal: true }); 
			return false; 
		};
		
		type = ($('#mode').val() === '1') ? 'Department' : 'Queue';
		no = $('#dept_no').slider("option", "value");
		plural = (no >1) ? 's' : '';
		
	var n = noty({
		type: 'warning', layout: 'center', text: "Create Multiple ( " + no + " ) " + mode + "(s) ?", dismissQueue: true, theme: 'relax', modal: true,
        buttons     : [
		{addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
		$noty.close(); 
                
		name = $('[name=dept_name]').val();
		base = $('[name=dept_number]').val();
		
		firstId = ($('#custom tr:first').attr('id'))
		lastId = ($('#custom tr:last').attr('id'))

		firstName = $('#custom_name' + firstId).val();
		firstNum = $('#custom_num' + firstId).val();
		lastName = $('#custom_name' + lastId).val();
		lastNum = $('#custom_num' + lastId).val();
				
		$('#progress').css('display', 'inline-block');
		
		jQuery.colorbox ({ width:"300px", fixed: true, 
			html:"<div id='results' style='text-align:center'><span id='res'>Processing <b>" + type + plural + "</b><br><br>Please Wait<br><img src='images/loader.gif'/><br><br></span><span id='progress'></span><br></div>", 
			closeButton:false,
			onComplete : function() { 
				$.fn.colorbox.resize(); 
			}    
		});
			
		var bulkData =  $('#bulk, #bulkCustom, #bulkConfig').serializeArray();
				
		$.ajax({
			type: "POST", cache: false,
			data: bulkData,
			url: "bulksave.php?mode=" + mode,
		    chunking: true,
			success: function(data) {
				console.log(data)
				
				if (data.toLowerCase().indexOf("error") >= 0) {
					$.colorbox.close();
					var error_msg = data + '<br><br><i>(Click to Close)</i>';
					var n = noty({ type: 'error', layout: 'center', text: error_msg, dismissQueue: true, theme: 'relax', modal: true });
					return false;
				}

				$('#res').css('display', 'none');
								
				end = (firstName != lastName && firstNum != lastNum) ? 'Last ' + type + ': <b>' + lastName + '</b><br>Extension Number: <b>' + lastNum + '</b>' : '';
				vmcodes = ($('#dept_vmenabled').is(":checked")) ? '<br><br>Voicemail Access Codes Can Be Checked Here: <a target="_blank" href="codes.php?action=4">Codes</a>' : '';
				msg = '<b>' + no + '</b> ' + type + plural + ' Created<br><br>First ' + type + ': <b>' + firstName + '</b><br> Extension Number: <b>' + firstNum + '</b><br><br>' + end + vmcodes + '<br><br><i>(Click to Close Window)<br><br><br>';
				
				////////////////////
				for(i = 1; i < no; i++) { 
					insertBaseNumber =  parseInt(base) + parseInt(i);
					i = pad(i,3);
					insertBaseName = name + '_' + i;
					existingArray.push(insertBaseName);
					existingArray.push(insertBaseNumber);
				}
				////////////////////
				
				$('#results').append(msg);
				$.fn.colorbox.resize(); 

				$('#progress').css('display', 'none');
				$('form').each(function() { this.reset() });
				$('#dept_no').slider('value', '1')
				$('#dept_no').find('.ui-slider-handle').text('1');

				console.log(existingArray)
				
			}
			})
			.progress(function(e, part) {
				if (part && part.length) {
					console.log (part)
					if (part.toLowerCase().indexOf("error") >= 0) {
						$('#progress').html('Error : ' + part);
						} else { 
						$('#progress').html('Created ' + type + ':<br>' + part);
					}
				}
			})
		}	
		},
		{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
			$noty.close(); 
			return false;
			}
		},
            ]
        });
			
    });
	
	// pad numbers to 3 zeros
	function pad (str, max) {
		str = str.toString();
		return str.length < max ? pad("0" + str, max) : str;
	}	
	
	function validateForm(str) {
		var isValid = true;
		$('.' + str).each(function() {
		if ( $(this).val() === '' )
			isValid = false;
		});
		return isValid;
	}
	
}); 
