<?php
// SFTP Backup 

// SFTP Server Configuration 
$sftp_host = ""; 									// SFTP server
$sftp_port = "22"; 									// SFTP port
$sftp_path = ""; 									// SFTP port

$sftp_user = "";	 								// SFTP username
$sftp_pass = ""; 									// SFTP password
					
$sftp_key = ""; 									// SFTP PPK Key - Only set if using key authentication 
$sftp_passphrase = "";								// SFTP PPK Key PassPhrase - only set if using key authentication and the key needs a passphrase

// Manager Access
$manager = "Manager";								// Manager username
$managerpassword = "managerpassword";				// Manager password

// Backup Configuration
$remove_backup = "1"; 								// 0 = Off 1 = On 	- delete tar.gz backup if upload is successful - CallServer path /voicemail/  S8000 path /SpliceCom/Web/download/
$logging = "1";			 							// 0 = Off 1 = On  	- log written to /SpliceCom/Web/download/ftpbackup.log
$warnings = "1";									// 0 = Off 1 = On	- write upload state to warnings
$logfile = "/SpliceCom/Web/download/ftpbackup.log";

/*************************************************************************
						nothing to change below
**************************************************************************/

// Load required files
include('includes/Net/SFTP.php');
include "/SpliceCom/WebManager/assist/tzone.php";
$sftp = new NET_SFTP($sftp_host, $sftp_port);

// key or password 
if ( strlen ( $sftp_key ) > 0 ) { 
	include('includes/Crypt/RSA.php');

	$sftp_pass = new CRYPT_RSA();
	
	if ( isset($sftp_passphrase) && strlen($sftp_passphrase) > 0 ) {
		$sftp->setPassword('passphrase');
	}
	
	$sftp_pass->loadKey(file_get_contents($sftp_key));

}

// Test SFTP Connection 
if (!$sftp->login($sftp_user, $sftp_pass)) {
    exit('Login Failed');
}

$action = (isset($argv[1])) ? $argv[1] : NULL;
if ($action == 'full') {
	$full = "1";
} elseif ( $action == "fullexcludearchive") {	
	$full = "2";
} else {
	$full = NULL;
}


if (isset($full) && $full >= "1") {

	$available = ( disk_free_space("/")/1024) ;
	$voicemail = explode("/",exec("du -s /home/voicemail"));
	$voicemail = trim($voicemail[0]);
	
	$web = explode("/",exec("du -s /SpliceCom/Web"));
	$web = trim($web[0]);
	
	$required_space = ($voicemail + $web)*2.75;	
		
	echo "Required Space $required_space\n";
	echo "Available Space $available\n\n";
	
	if ( $required_space > $available) { 
		echo "Sorry insufficient disk space to proceed\n\n"; exit; 
	}

}


$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
	exit ("LDAP connect failure<br>");
} else {
	$r = ldap_bind($ds,$manager,$managerpassword);
	ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
if ( ! $r) {
		$ds = false;
		exit ("LDAP bind failure<br>");
	}
}

echo "Backing Up Database\n\n";
$sr = ldap_read($ds,"cn=System","objectclass=*"); $info = ldap_get_entries($ds,$sr);
$sysname=str_replace(' ','',(substr($info[0]['administrationdomain'][0],0,10))); 

$backup = $sysname."-Backup-".date('d.m.y-His');
$ent["dobackupto"] = "../ftp/$backup.txt"; 
ldap_modify($ds,"cn=Commands",$ent);


$fs = (filesize("/SpliceCom/Database.txt"));
sleep(ceil(($fs/(1024 * 1024))));

$local_filename  = "/SpliceCom/ftp/$backup.txt";
$remote_filename = $backup;

if ($full) 	{
	
	echo ($full == "1") ? "Performing Full Backup\nPlease wait this can take a while...\n" : "Performing Full Backup excluding Archive\nPlease wait this can take a while...\n";
	echo "Backup Path: /SpliceCom/Web/download/\n\n";
	
	$fullcmd = ($full == "2") ? "--exclude=voicemail/Archive" : "";
	exec ("cd /home; nice -10 tar $fullcmd -cvPf /SpliceCom/Web/download/voicemail.tar0 voice*;");
	echo "voicemail... done\n\n";
	
	exec ("cd /SpliceCom/Web; nice -10 tar --exclude=download -cvPf /SpliceCom/ftp/web.tar *;");
	echo "web... done\n\n";
	
	echo "Creating tar.gz file...\n";
	exec("nice -10 tar -cvzPf /SpliceCom/Web/download/$backup.full.tar.gz /SpliceCom/ftp/web.tar /SpliceCom/Web/download/voicemail.tar0 /SpliceCom/ftp/$backup.txt",$output);	
	echo "done\n\n";
	
	$local_filename  = "/SpliceCom/Web/download/$backup.full.tar.gz";
	unlink ("/SpliceCom/Web/download/voicemail.tar0"); unlink ("/SpliceCom/ftp/web.tar");

	$remote_filename = "$backup.full.tar.gz";
	
} else {
	
	echo "gzip'ing Backup File\n\n";
	
	exec("cd /SpliceCom/ftp; nice -10 tar -cvzPf /SpliceCom/Web/download/$backup.tar.gz $backup.txt",$output);
	$local_filename  = "/SpliceCom/Web/download/$backup".".tar.gz";
	$remote_filename = "$backup.tar.gz";
}

// Set local file
$localfile = fopen($local_filename, 'r');

// Set path
if ( isset($sftp_path) && strlen($sftp_path) > 0 ) {
	$sftp->chdir($sftp_path);
	echo "Path: " . $sftp->pwd() . "\n";
}

// Check if file exists on remote server
$filecheck = $sftp->stat($remote_filename);
if ( isset($filecheck['size']) && strlen($filecheck['size']) > 0 ) {
	echo "$remote_filename File Exists";
	exit;
}

// Upload File
echo "Uploading File\n";
$file_size = formatSizeUnits(filesize($local_filename));
echo "File Size to upload: $file_size\n\n";

if ($sftp->put($remote_filename, $localfile)) {
	
	echo "$local_filename has been uploaded to $sftp_host as $remote_filename\n\n";
	if (isset($remove_backup) && $remove_backup == "1") unlink ($local_filename);
	
	if (isset($logging) && $logging == "1") {
		$fh = fopen($logfile, 'a') or die("can't open log file - check permissions");
		$msg = $local_filename." has been uploaded to $sftp_host as ".$remote_filename." Filesize: $file_size\n";
		fwrite($fh, $msg); fclose($fh);
		if (isset($compress) && $compress == "1") unlink ($local_filename);
	}
	if (isset($warnings) && $warnings == "1") warning ("$local_filename has been uploaded to <b>$sftp_host</b> as $remote_filename Filesize: $file_size");

} else {
	
	if (isset($warnings) && $warnings == "1") warning ("$local_filename - Error!!");
	$fatalerror = $sftp->getLastSFTPError();
	echo "$fatalerror\n\n";
	die("$local_filename - Upload Error!!\n");
}

$sftp->disconnect();


function warning($s) {
	global $manager, $managerpassword; 
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		exit ("LDAP connect failure<br>");
	} else {
		$r = ldap_bind($ds,$manager,$managerpassword);
		ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
	if ( ! $r) {
			$ds = false;
			exit ("LDAP bind failure<br>");
		}
	}
	$ent["doWarning"] = $s; ldap_modify($ds,"cn=Commands",$ent);
	ldap_close($ds);
}

function formatSizeUnits($bytes) {
        if ($bytes >= 1073741824) {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        } elseif ($bytes >= 1048576) {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        } elseif ($bytes >= 1024) {
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        } elseif ($bytes > 1) {
            $bytes = $bytes . ' bytes';
        } elseif ($bytes == 1) {
            $bytes = $bytes . ' byte';
        } else {
            $bytes = '0 bytes';
        }

        return $bytes;
}

?>